/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents.inlinemessages;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Handler;
import android.widget.TextView;
import androidx.annotation.NonNull;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.uicomponents.inlinemessages.IInlineMessage;
import com.liveperson.infra.utils.DateUtils;
import java.lang.ref.WeakReference;

public class OffHours
implements IInlineMessage {
    private static final String TAG = OffHours.class.getSimpleName();
    private final String mOffHoursMessageDate;
    private final String mOffHoursMessageToday;
    private final String mOffHoursMessageTomorrow;
    private final String mOffHoursTimeFormat;
    private final String mOffHoursDateFormat;
    private final String mOffHoursTimeZone;
    private final WeakReference<TextView> mMessageTextViewRef;
    private final Handler mHandler;
    private Runnable mDismissRunnable = null;

    public OffHours(Resources res, TextView view) {
        this.mOffHoursMessageDate = res.getString(R.string.lp_ttr_message_off_hours_message);
        this.mOffHoursMessageToday = res.getString(R.string.lp_ttr_message_off_hours_message_today);
        this.mOffHoursMessageTomorrow = res.getString(R.string.lp_ttr_message_off_hours_message_tomorrow);
        this.mOffHoursTimeZone = res.getString(R.string.lp_ttr_message_off_hours_time_zone_id);
        this.mOffHoursTimeFormat = res.getString(R.string.lp_time_format);
        this.mOffHoursDateFormat = res.getString(R.string.lp_date_format);
        this.mMessageTextViewRef = new WeakReference<TextView>(view);
        this.mHandler = new Handler();
    }

    @Override
    public void show(Context context, Intent intent) {
        long delayTillWhen = intent.getLongExtra("DELAY_TILL_WHEN", -1L);
        boolean dateChanged = intent.getBooleanExtra("DELAY_TILL_WHEN_CHANGED", false);
        this.showOffHours(delayTillWhen, dateChanged);
    }

    @Override
    public void hide() {
        this.mHandler.removeCallbacks(this.getRunnable());
        TextView messageTextView = (TextView)this.mMessageTextViewRef.get();
        if (messageTextView != null) {
            messageTextView.setVisibility(8);
        }
    }

    private void showOffHours(long timestamp, boolean reShow) {
        TextView messageTextView = (TextView)this.mMessageTextViewRef.get();
        if (messageTextView == null) {
            return;
        }
        if (timestamp == -1L) {
            if (messageTextView.getVisibility() == 0) {
                messageTextView.setVisibility(8);
            }
        } else {
            if (messageTextView.getVisibility() == 0 && !reShow) {
                return;
            }
            String message = this.prepareMessage(timestamp);
            LPLog.INSTANCE.d(TAG, "show off hours message: " + message + ", reShow = " + reShow);
            long duration = timestamp - System.currentTimeMillis();
            long timeTillOffHoursExpire = duration > Integer.MAX_VALUE ? -2L : duration;
            messageTextView.setText((CharSequence)message);
            messageTextView.setVisibility(0);
            this.mHandler.postDelayed(this.getRunnable(), timeTillOffHoursExpire);
        }
    }

    private Runnable getRunnable() {
        if (this.mDismissRunnable == null) {
            this.mDismissRunnable = () -> {
                TextView messageTextView = (TextView)this.mMessageTextViewRef.get();
                if (messageTextView != null) {
                    messageTextView.setVisibility(8);
                }
            };
        }
        return this.mDismissRunnable;
    }

    @NonNull
    private String prepareMessage(long timestamp) {
        if (DateUtils.isToday((long)timestamp)) {
            String time = DateUtils.getFormattedTime((String)this.mOffHoursTimeFormat, (int)3, (long)timestamp, (String)this.mOffHoursTimeZone);
            return String.format(this.mOffHoursMessageToday, time);
        }
        if (DateUtils.isTomorrow((long)timestamp)) {
            String time = DateUtils.getFormattedTime((String)this.mOffHoursTimeFormat, (int)3, (long)timestamp, (String)this.mOffHoursTimeZone);
            return String.format(this.mOffHoursMessageTomorrow, time);
        }
        String date = DateUtils.getFormattedDate((String)this.mOffHoursDateFormat, (int)1, (long)timestamp);
        String time = DateUtils.getFormattedTime((String)this.mOffHoursTimeFormat, (int)3, (long)timestamp, (String)this.mOffHoursTimeZone);
        return String.format(this.mOffHoursMessageDate, date, time);
    }
}

