/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents.inlinemessages;

import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;
import com.google.android.material.R;
import com.google.android.material.snackbar.Snackbar;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.uicomponents.inlinemessages.IInlineMessage;
import com.liveperson.infra.utils.AccessibilityChecker;
import com.liveperson.messaging.model.TimeBundle;
import java.lang.ref.WeakReference;

public class TTRSnackBar
implements IInlineMessage {
    private static final String TAG = "TTRSnackBar";
    private String mMessage;
    private Snackbar mSnackBar;
    private WeakReference<View> mViewContainerSnackBar;
    private static final int SNACK_BAR_MAX_LINES = 100;
    private TTRMode mTTRMode;

    public TTRSnackBar(Resources res, View viewContainerSnackBar) {
        this.mViewContainerSnackBar = new WeakReference<View>(viewContainerSnackBar);
        boolean mShowTimestamp = Configuration.getBoolean((int)R.bool.show_timestamp_in_ttr_notification);
        if (mShowTimestamp) {
            this.mTTRMode = TTRMode.TIMESTAMP;
            this.mMessage = res.getString(R.string.lp_ttr_message_with_timestamp);
        } else {
            this.mTTRMode = TTRMode.SHORTLY;
            this.mMessage = res.getString(R.string.lp_ttr_message_no_timestamp);
        }
    }

    @Override
    public void show(Context context, Intent intent) {
        String snackBarMessage;
        if (this.mTTRMode == TTRMode.SHORTLY) {
            snackBarMessage = this.mMessage;
        } else {
            TimeBundle timeBundle = (TimeBundle)intent.getParcelableExtra("CONVERSATION_TTR_TIME");
            snackBarMessage = this.buildTTRMessage(context, timeBundle);
        }
        if (!TextUtils.isEmpty((CharSequence)snackBarMessage)) {
            this.showSnackBar(context, snackBarMessage);
        }
    }

    @Override
    public void hide() {
        if (this.mSnackBar != null && this.mSnackBar.isShown()) {
            this.mSnackBar.dismiss();
        }
    }

    private String buildTTRMessage(Context context, TimeBundle timeBundle) {
        String ttrMessage = null;
        if (timeBundle != null) {
            boolean showNotification = false;
            StringBuilder date = new StringBuilder();
            if (timeBundle.diffDays > 0) {
                date.append(context.getResources().getQuantityString(R.plurals.lp_ttr_message_days, timeBundle.diffDays, new Object[]{timeBundle.diffDays}));
                showNotification = true;
            }
            if (timeBundle.diffHours > 0) {
                date.append(context.getResources().getQuantityString(R.plurals.lp_ttr_message_hours, timeBundle.diffHours, new Object[]{timeBundle.diffHours}));
                showNotification = true;
            }
            if (timeBundle.diffMinutes > 0) {
                date.append(context.getResources().getQuantityString(R.plurals.lp_ttr_message_minutes, timeBundle.diffMinutes, new Object[]{timeBundle.diffMinutes}));
                showNotification = true;
            }
            if (showNotification) {
                ttrMessage = String.format(this.mMessage, date);
            }
        }
        return ttrMessage;
    }

    private void showSnackBar(Context context, String snackBarMessage) {
        View container;
        int snackbarDuration = Configuration.getInteger((int)R.integer.ttr_duration);
        if (AccessibilityChecker.exploreByTouchEnabled((Context)context)) {
            snackbarDuration = Configuration.getInteger((int)R.integer.snackbar_duration_for_accessibility);
        }
        if ((container = (View)this.mViewContainerSnackBar.get()) == null) {
            return;
        }
        LPLog.INSTANCE.d(TAG, "show TTR with message " + snackBarMessage);
        this.mSnackBar = Snackbar.make((View)container, (CharSequence)snackBarMessage, (int)snackbarDuration);
        this.changeSnackbarFont(context);
        View snackBarView = this.mSnackBar.getView();
        TextView snackTextView = (TextView)snackBarView.findViewById(R.id.snackbar_text);
        snackTextView.setMaxLines(100);
        if (!this.mSnackBar.isShown()) {
            this.mSnackBar.show();
        }
    }

    private void changeSnackbarFont(Context context) {
        String fontName = Configuration.getString((int)R.string.custom_font_name_non_conversation_feed);
        if (!TextUtils.isEmpty((CharSequence)fontName)) {
            TextView tv = (TextView)this.mSnackBar.getView().findViewById(R.id.snackbar_text);
            try {
                Typeface typeFace = fontName.toLowerCase().contains(".") ? Typeface.createFromAsset((AssetManager)context.getAssets(), (String)fontName) : Typeface.create((String)fontName, (int)0);
                tv.setTypeface(typeFace);
            }
            catch (Exception e) {
                LPLog.INSTANCE.w(TAG, "applyCustomFont: Error setting custom font: " + fontName, (Throwable)e);
            }
        }
    }

    private static enum TTRMode {
        TIMESTAMP,
        SHORTLY;

    }
}

