/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents.list;

import android.content.Context;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.widget.Toast;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.annotation.VisibleForTesting;
import androidx.recyclerview.widget.RecyclerView;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.FlowTags;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.accessibility.AccessibilityAnnouncer;
import com.liveperson.infra.messaging_ui.fragment.ConversationViewCallback;
import com.liveperson.infra.messaging_ui.uicomponents.list.ChatMessageBgFgListener;
import com.liveperson.infra.messaging_ui.uicomponents.list.ChatMessageListRecyclerView;
import com.liveperson.infra.messaging_ui.uicomponents.list.header.DateHeaderHelper;
import com.liveperson.infra.messaging_ui.utils.markdownlink.HyperLinkUtils;
import com.liveperson.infra.model.LPWelcomeMessage;
import com.liveperson.infra.utils.DateUtils;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.AmsMessagesLoaderProvider;
import com.liveperson.messaging.model.ConversationUtils;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.model.QuickRepliesMessageHolder;
import com.liveperson.messaging.offline.OfflineMessagingManager;
import com.liveperson.messaging.wm.WelcomeMessageManager;
import java.lang.ref.WeakReference;
import java.text.DateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;

public class MessagesAsListLoader
implements ChatMessageBgFgListener,
DateHeaderHelper.OnDateHeaderChangedListener {
    private static final String TAG = "MessagesAsListLoader";
    private static final String TAG_MERGE = "MessagesAsListLoader_MERGER";
    private static final String TAG_LOAD = "MessagesAsListLoader_LOAD";
    private static final int MESSAGES_CHUNK_LIMIT = 20;
    private static final int MESSAGES_RANGE_LOAD_MORE = 10;
    private AmsMessagesLoaderProvider mAmsMessages;
    private final ConversationUtils mConversationUtils;
    private OnListUpdated mListener;
    private String mBrandId;
    private WeakReference<ChatMessageListRecyclerView> mRecyclerView;
    private ConversationViewCallback conversationViewCallback;
    private ArrayList<FullMessageRow> mDataSet = new ArrayList();
    private FullMessageRow mQuickRepliesMessage;
    private FullMessageRow mUnreadMessagesMessage;
    private QuickRepliesMessageHolder mQuickRepliesMessageHolder;
    private Map<String, String> mAgentUrlsMap = new HashMap<String, String>();
    private boolean loading = false;
    private boolean noMoreOldMessages = false;
    private boolean isNewMessageRead;
    private boolean isScrollDownIndicatorVisible;
    private int numOfUnreadAgentMessages = 0;
    private int indexNumOfUnreadAgentMessage = -1;
    private LoadingMessagesHandler loadingMessagesHandler = new LoadingMessagesHandler();
    private boolean isUnreadEnable;
    private boolean isConnectionAvailable = true;
    private boolean isAddingMessagesToDataSet = false;
    private boolean isAddingListenerToMessages = false;
    private final DateHeaderHelper mDateHeaderHelper;

    public MessagesAsListLoader(ChatMessageListRecyclerView recyclerView, OnListUpdated listListener, String brandId) {
        this.mRecyclerView = new WeakReference<ChatMessageListRecyclerView>(recyclerView);
        this.mAmsMessages = MessagingFactory.getInstance().getController().amsMessages;
        this.mListener = listListener;
        this.mBrandId = brandId;
        this.isUnreadEnable = Configuration.getBoolean((int)R.bool.unread_indicator_bubble_enable);
        this.mConversationUtils = new ConversationUtils(MessagingFactory.getInstance().getController());
        this.mDateHeaderHelper = new DateHeaderHelper(recyclerView.getContext());
    }

    private void addListenerToMessages() {
        if (this.mAmsMessages.hasListener()) {
            return;
        }
        this.isAddingListenerToMessages = true;
        this.mAmsMessages.addOnUpdateListener(new AmsMessages.MessagesListener(){

            public void initMessages(ArrayList<FullMessageRow> searchedMessageList) {
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "initMessages num of items:" + (searchedMessageList == null ? "null" : "size = " + searchedMessageList.size()));
                MessagesAsListLoader.this.isAddingListenerToMessages = false;
                if (MessagingFactory.getInstance().getController().mConnectionController.isSocketReady(MessagesAsListLoader.this.mBrandId)) {
                    MessagesAsListLoader.this.onConnectionAvailable();
                }
                MessagesAsListLoader.this.addOldMultiItem(searchedMessageList);
                if (searchedMessageList != null && !searchedMessageList.isEmpty()) {
                    MessagesAsListLoader.this.mAmsMessages.clearPusherUnreadBadgeCount(MessagesAsListLoader.this.mBrandId);
                }
            }

            public void onNewMessage(final FullMessageRow message) {
                if (message == null) {
                    return;
                }
                MessagesAsListLoader.this.executeOnUI(new Runnable(){

                    @Override
                    public void run() {
                        int onlyNewMessages;
                        if (message.getMessagingChatMessage().getServerSequence() == -4 && (MessagesAsListLoader.this.lastMessageWelcomeMessage() || MessagesAsListLoader.this.lastMessageQuickReplyFromWelcomeMessage())) {
                            return;
                        }
                        MessagingChatMessage chatMessage = message.getMessagingChatMessage();
                        int n = onlyNewMessages = MessagesAsListLoader.this.mDataSet.isEmpty() ? 1 : message.newerThan((FullMessageRow)MessagesAsListLoader.this.mDataSet.get(MessagesAsListLoader.this.mDataSet.size() - 1));
                        if (onlyNewMessages == 1) {
                            int oldLastItem = MessagesAsListLoader.this.mDataSet.size();
                            int agentMessageCounter = 0;
                            LPLog.INSTANCE.d(MessagesAsListLoader.TAG_MERGE, "On new Message - 1 message after our current data set. " + oldLastItem + " - " + MessagesAsListLoader.this.mDataSet.size());
                            agentMessageCounter = MessagesAsListLoader.this.addItem(message, oldLastItem, true, agentMessageCounter);
                            if (agentMessageCounter == 0 && MessagesAsListLoader.this.indexNumOfUnreadAgentMessage > -1 && message.getMessagingChatMessage().isSystemMessageFromAgent(MessagesAsListLoader.this.mAmsMessages.getMyUserId(MessagesAsListLoader.this.mBrandId))) {
                                LPLog.INSTANCE.d(MessagesAsListLoader.TAG_MERGE, "On new Message - adding system message not from me. ignoring existed unread message indicator. ");
                            } else if (!MessagesAsListLoader.this.isControllerOrCobrowseMessage(message)) {
                                boolean isUiNotFocusedOnItem = !MessagesAsListLoader.this.isItemAtPositionVisible(oldLastItem);
                                MessagesAsListLoader.this.handleUnreadMessages(1, false, agentMessageCounter, oldLastItem, isUiNotFocusedOnItem);
                            }
                            if (message.getMessagingChatMessage().getMessageType() != MessagingChatMessage.MessageType.SYSTEM_RESOLVED) {
                                LPWelcomeMessage lpWelcomeMessage = MessagesAsListLoader.this.getWelcomeMessage();
                                if (message.getMessagingChatMessage().getServerSequence() == -4 && lpWelcomeMessage.getMessageFrequency() == LPWelcomeMessage.MessageFrequency.EVERY_CONVERSATION) {
                                    QuickRepliesMessageHolder.updateQuickReplies((String)MessagesAsListLoader.this.mBrandId, (String)lpWelcomeMessage.getQuickReplies(MessagesAsListLoader.this.isConnectionAvailable));
                                    MessagesAsListLoader.this.mAmsMessages.resetQuickRepliesMessageHolder();
                                }
                                MessagesAsListLoader.this.addQuickRepliesMessage(false);
                            } else if (MessagesAsListLoader.this.mQuickRepliesMessageHolder != null) {
                                MessagesAsListLoader.this.mAmsMessages.resetQuickRepliesMessageHolder();
                                QuickRepliesMessageHolder.deleteFromSharedPreferences((String)MessagesAsListLoader.this.mBrandId);
                                MessagesAsListLoader.this.mQuickRepliesMessageHolder = null;
                            }
                            MessagesAsListLoader.this.setupDateHeaders();
                        } else {
                            ArrayList<FullMessageRow> newItems = new ArrayList<FullMessageRow>();
                            newItems.add(message);
                            MessagesAsListLoader.this.merge(newItems, true);
                        }
                    }
                });
            }

            public void onNewWelcomeMessage(@NonNull FullMessageRow row, @NonNull LPWelcomeMessage welcomeMessage, @NonNull AmsMessages.MessagesListener.OnWelcomeMessageShownCallback callback) {
                MessagesAsListLoader.this.executeOnUI(() -> {
                    if (row.getMessagingChatMessage().getServerSequence() == -4 && MessagesAsListLoader.this.lastMessageOutboundCampaignMessage()) {
                        callback.onOutboundMessageShown();
                        return;
                    }
                    MessagesAsListLoader.this.addWelcomeMessageToDataSet(row, welcomeMessage, callback);
                });
            }

            public void onUpdateMessage(FullMessageRow message) {
                if (message == null) {
                    return;
                }
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "onUpdateMessage");
                ArrayList<FullMessageRow> newItems = new ArrayList<FullMessageRow>();
                newItems.add(message);
                MessagesAsListLoader.this.executeOnUI(() -> MessagesAsListLoader.this.merge(newItems, false));
            }

            public void onUpdateFileMessage(String eventId, long localId, FileMessage fullMessageRow) {
                Runnable runnable = () -> {
                    FullMessageRow currentMessage = MessagesAsListLoader.this.getMessageByEventId(eventId);
                    if (currentMessage != null) {
                        currentMessage.setFileMessage(fullMessageRow);
                        currentMessage.getMessagingChatMessage().setLocalId(localId);
                        MessagesAsListLoader.this.mListener.onMessageUpdated(MessagesAsListLoader.this.mDataSet.indexOf(currentMessage), new Bundle());
                    }
                };
                MessagesAsListLoader.this.executeOnUI(runnable);
            }

            public void onInitialMessagesReceived(List<FullMessageRow> rows) {
                if (rows.isEmpty()) {
                    return;
                }
                MessagesAsListLoader.this.addItems(new ArrayList<FullMessageRow>(rows));
            }

            public void removeMessageByEventId(String eventId) {
                MessagesAsListLoader.this.executeOnUI(() -> MessagesAsListLoader.this.removeMessageByEventId(eventId));
            }

            public void removeAllClosedConversations(String targetId) {
                if (targetId.equals(MessagesAsListLoader.this.mBrandId)) {
                    boolean hideWelcomeMsg = Configuration.getBoolean((int)R.bool.lp_hide_welcome_message_on_clear_history);
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "removeAllClosedConversations -> hideWelcomeMsg = " + hideWelcomeMsg);
                    MessagesAsListLoader.this.removeAllMessages(!hideWelcomeMsg);
                    this.loadCurrentOrNewMessages(-1L, -1L, false);
                }
            }

            public void clearAllMessages(String targetId) {
                if (targetId.equals(MessagesAsListLoader.this.mBrandId)) {
                    MessagesAsListLoader.this.removeAllMessages(false);
                    this.loadCurrentOrNewMessages(-1L, -1L, false);
                }
            }

            public void onHistoryFetched() {
                MessagesAsListLoader.this.executeOnUI(() -> {
                    MessagesAsListLoader.this.loadingMessagesHandler.removeLoadingForNewMessages();
                    MessagesAsListLoader.this.resetHistoryLoading();
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "onHistoryFetched - checking load more from db.");
                    MessagesAsListLoader.this.noMoreOldMessages = false;
                    MessagesAsListLoader.this.loadAccordingToUI(MessagesAsListLoader.this.mListener.getFirstVisibleItemPosition());
                });
            }

            public void onHistoryFetchedFailed() {
                MessagesAsListLoader.this.executeOnUI(() -> {
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "onHistoryFetchedFailed - resetting loading/ marking as failed");
                    MessagesAsListLoader.this.noMoreOldMessages = true;
                    MessagesAsListLoader.this.resetHistoryLoading();
                });
            }

            public void addFirstWelcomeMessage() {
                MessagesAsListLoader.this.addFirstMessage();
            }

            public void onAgentReceived(MessagingUserProfile userProfile) {
                MessagesAsListLoader.this.putAgentUrl(userProfile.getOriginatorId(), userProfile.getAvatarUrl());
            }

            public void onExConversationHandled(boolean emptyNotification) {
                Messaging controller = MessagingFactory.getInstance().getController();
                if (emptyNotification) {
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "onExConversationHandled - emptyNotification. removing loading new messages indicator ");
                    if (MessagesAsListLoader.this.isFinishedUpdatingWithFilter(controller) && (MessagesAsListLoader.this.mDataSet.isEmpty() || MessagesAsListLoader.this.dataSetHasOnlyLoadingMessageOrDateHeaders())) {
                        if (MessagesAsListLoader.this.shouldAddWelcomeMessageWhenFilterOn(controller)) {
                            MessagesAsListLoader.this.resetHistoryLoading();
                            MessagesAsListLoader.this.addWelcomeMessage();
                        } else {
                            MessagesAsListLoader.this.setEmptyState();
                        }
                    } else if (controller.mConnectionController.isUpdated(MessagesAsListLoader.this.mBrandId) && !MessagesAsListLoader.this.isAddingMessagesToDataSet && !MessagesAsListLoader.this.isAddingListenerToMessages && MessagesAsListLoader.this.shouldAddWelcomeMessageInFirstTimeConvo(controller) && (MessagesAsListLoader.this.mDataSet.isEmpty() || MessagesAsListLoader.this.dataSetHasOnlyLoadingMessageOrDateHeaders())) {
                        MessagesAsListLoader.this.resetHistoryLoading();
                        MessagesAsListLoader.this.addFirstMessage();
                        LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "onExConversationHandled. no data! add welcome msg");
                    } else if (MessagesAsListLoader.this.shouldAddWelcomeMessageForEveryConversation(controller)) {
                        MessagesAsListLoader.this.performAddWelcomeMessageForEmptyCloseConvo();
                    }
                } else {
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "onExConversationHandled - not emptyNotification. removing loading new messages indicator ");
                }
                MessagesAsListLoader.this.loadingMessagesHandler.removeLoadingForNewMessages();
            }

            public void onQueryMessagesResult(long oldestMsgTime, long newestMsgTime) {
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "onQueryMessagesResult oldestMsgTime = " + oldestMsgTime + " newestMsgTime = " + newestMsgTime);
                this.checkIfResultsInRange(oldestMsgTime, newestMsgTime, true);
            }

            public void onUpdateMessages(long oldestMsgTime, long newestMsgTime) {
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "onUpdateMessages oldestMsgTime = " + oldestMsgTime + " newestMsgTime = " + newestMsgTime);
                this.checkIfResultsInRange(oldestMsgTime, newestMsgTime, false);
            }

            private void checkIfResultsInRange(long oldestMsgTime, long newestMsgTime, boolean isNewMessages) {
                MessagesAsListLoader.this.executeOnUI(() -> {
                    long currentOldestMsgTime = MessagesAsListLoader.this.getFirstConversationMessageTimeStamp();
                    long currentNewestMsgTime = MessagesAsListLoader.this.getLastMessageTimeStamp();
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "Got query results: currentOldestMsgTime = " + currentOldestMsgTime + " oldestMsgTime = " + oldestMsgTime + " newestMsgTime = " + newestMsgTime);
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "Order. Remote oldest " + oldestMsgTime);
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "Order. Remote newest " + newestMsgTime);
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "Order. Current oldest " + currentOldestMsgTime);
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "Order. Current newest " + currentNewestMsgTime);
                    if (newestMsgTime > currentOldestMsgTime) {
                        if (oldestMsgTime < currentOldestMsgTime) {
                            long from = currentOldestMsgTime;
                            long to = newestMsgTime;
                            LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "Got query results that *starts before our range time* and ending after our newest message or within dataSet range.");
                            this.loadCurrentOrNewMessages(from, to, false);
                            MessagesAsListLoader.this.resetHistoryLoading();
                            MessagesAsListLoader.this.loadingMessagesHandler.removeLoadingForNewMessages();
                            this.checkLoadMoreAfterQuery();
                        } else {
                            MessagesAsListLoader.this.loadingMessagesHandler.removeLoadingForNewMessages();
                            long from = oldestMsgTime;
                            long to = newestMsgTime;
                            if (newestMsgTime > currentNewestMsgTime) {
                                LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "Got query results that are *new or starts in our range time* and ending after our newest message.");
                                this.loadCurrentOrNewMessages(from, to, isNewMessages);
                            } else {
                                LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "Got query results that are *new or starts in our range time* and ending within dataSet range.");
                                this.loadCurrentOrNewMessages(from, to, isNewMessages);
                            }
                        }
                    } else {
                        LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "Got query results that are from history");
                        MessagesAsListLoader.this.resetHistoryLoading();
                        this.checkLoadMoreAfterQuery();
                    }
                });
            }

            public int getLoadLimit() {
                return MessagesAsListLoader.this.mListener.getLoadLimit();
            }

            public void showErrorToast(int messageRes) {
                MessagesAsListLoader.this.executeOnUI(() -> {
                    ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)MessagesAsListLoader.this.mRecyclerView.get();
                    if (recyclerView != null) {
                        Toast.makeText((Context)recyclerView.getContext(), (int)messageRes, (int)0).show();
                    }
                });
            }

            public void updateWelcomeMessageForDialogId(String dialogId, FullMessageRow welcomeMessageRow) {
                MessagesAsListLoader.this.updateWelcomeMessageForDialogId(dialogId, welcomeMessageRow);
            }

            public void updateTempWelcomeMessage(FullMessageRow welcomeMessageRow) {
                MessagesAsListLoader.this.updateTemporalWelcomeMessage(welcomeMessageRow);
            }

            public void updateMessageTimestampByEventId(String eventId, long timestamp) {
                MessagesAsListLoader.this.executeOnUI(() -> MessagesAsListLoader.this.reorderMessage(eventId, timestamp));
            }

            private void loadCurrentOrNewMessages(long from, long to, boolean containsNewMessages) {
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "loadCurrentOrNewMessages - containsNewMessages = " + containsNewMessages + " from: " + from + ", to : " + to);
                MessagesAsListLoader.this.mAmsMessages.loadMessages(AmsMessages.MessagesSortedBy.TargetId, MessagesAsListLoader.this.mBrandId, -1, to, from).setPostQueryOnBackground(data -> {
                    if (containsNewMessages) {
                        MessagesAsListLoader.this.addNewMultiItem(data);
                    } else {
                        MessagesAsListLoader.this.updateMessages(data);
                    }
                }).execute();
            }

            private void checkLoadMoreAfterQuery() {
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "checkLoadMoreAfterQuery");
                MessagesAsListLoader.this.noMoreOldMessages = false;
                MessagesAsListLoader.this.onScroll(MessagesAsListLoader.this.mListener.getFirstVisibleItemPosition());
            }
        }, AmsMessages.MessagesSortedBy.TargetId, this.mBrandId);
    }

    int getTotalMessagesWithPositiveSequence(int threshold) {
        int counter = 0;
        for (FullMessageRow fullMessageRow : this.mDataSet) {
            if (fullMessageRow.getMessagingChatMessage().getServerSequence() >= 0) {
                ++counter;
            }
            if (counter <= threshold) continue;
            break;
        }
        return counter;
    }

    private void removeMessageByEventId(String eventId) {
        int position = -1;
        ListIterator<FullMessageRow> rowIterator = this.mDataSet.listIterator();
        int index = 0;
        while (rowIterator.hasNext()) {
            MessagingChatMessage message = rowIterator.next().getMessagingChatMessage();
            if (message.getEventId().equals(eventId)) {
                rowIterator.remove();
                position = index;
                break;
            }
            ++index;
        }
        if (position != -1 && this.mListener != null) {
            this.mListener.onItemRemoved(position);
        }
    }

    private void setEmptyState() {
        LPLog.INSTANCE.d(TAG_LOAD, "empty state!");
        this.resetHistoryLoading();
        this.resetLoading();
        this.executeOnUI(() -> {
            if (this.conversationViewCallback != null) {
                this.conversationViewCallback.showEmptyView();
            }
        });
    }

    private void removeEmptyState() {
        this.executeOnUI(() -> {
            LPLog.INSTANCE.d(TAG_LOAD, "removing empty state!");
            if (this.conversationViewCallback != null) {
                this.conversationViewCallback.hideEmptyView();
            }
        });
    }

    public void removeListener() {
        if (!this.mAmsMessages.hasListener()) {
            return;
        }
        this.mAmsMessages.removeOnUpdateListener();
    }

    public void setConversationViewCallback(ConversationViewCallback conversationViewCallback) {
        this.conversationViewCallback = conversationViewCallback;
    }

    private long getMessageTimestamp(@Nullable FullMessageRow row) {
        if (row == null) {
            return 0L;
        }
        return row.getMessagingChatMessage().getTimeStamp();
    }

    private MessagingChatMessage.MessageType getMessageType(@Nullable FullMessageRow row) {
        if (row == null) {
            return MessagingChatMessage.MessageType.DATE_HEADER;
        }
        return row.getMessagingChatMessage().getMessageType();
    }

    @VisibleForTesting
    public long getTimestampByPosition(int position) {
        int size = this.mDataSet.size();
        if (position >= 0 && position < size) {
            FullMessageRow row = this.mDataSet.get(position);
            return this.getMessageTimestamp(row);
        }
        return 0L;
    }

    private long getFirstConversationMessageTimeStamp() {
        int size = this.mDataSet.size();
        for (int position = 0; position < size; ++position) {
            FullMessageRow row = this.mDataSet.get(position);
            MessagingChatMessage.MessageType type = this.getMessageType(this.mDataSet.get(position));
            boolean isAppropriate = type.equals((Object)MessagingChatMessage.MessageType.DATE_HEADER);
            isAppropriate |= type.equals((Object)MessagingChatMessage.MessageType.LOADING);
            isAppropriate |= type.equals((Object)MessagingChatMessage.MessageType.UNREAD_INDICATOR);
            isAppropriate |= type.equals((Object)MessagingChatMessage.MessageType.AGENT_IS_TYPING_INDICATOR);
            isAppropriate |= type.equals((Object)MessagingChatMessage.MessageType.SYSTEM_DIALOG_RESOLVED);
            if (isAppropriate |= type.equals((Object)MessagingChatMessage.MessageType.SYSTEM_RESOLVED)) continue;
            return this.getMessageTimestamp(row);
        }
        return 0L;
    }

    private long getLastMessageTimeStamp() {
        int lastIndex = this.mDataSet.size() - 1;
        return this.getTimestampByPosition(lastIndex);
    }

    public void onConnectionAvailable() {
        this.isConnectionAvailable = true;
        this.noMoreOldMessages = false;
        LPLog.INSTANCE.d(TAG_LOAD, "onConnectionAvailable");
        Messaging controller = MessagingFactory.getInstance().getController();
        if (this.mDataSet.isEmpty()) {
            if (this.isFinishedUpdatingWithFilter(controller) && !this.isAddingMessagesToDataSet && !this.isAddingListenerToMessages) {
                if (this.shouldAddWelcomeMessageWhenFilterOn(controller)) {
                    this.resetHistoryLoading();
                    this.addWelcomeMessage();
                } else {
                    this.setEmptyState();
                }
            } else if (controller.mConnectionController.isUpdated(this.mBrandId) && !this.isAddingMessagesToDataSet && !this.isAddingListenerToMessages && this.shouldAddWelcomeMessageInFirstTimeConvo(controller)) {
                this.resetHistoryLoading();
                this.performAddWelcomeMessageForEmptyCloseConvo();
            } else {
                LPLog.INSTANCE.d(TAG_LOAD, "no data! showing history loading til we know whats our status");
                this.loadingMessagesHandler.showLoadingForHistory();
            }
        } else if (!controller.mConnectionController.isUpdated(this.mBrandId)) {
            LPLog.INSTANCE.d(TAG_LOAD, "data exists! showing new messages loading til we gets an update");
            this.loadingMessagesHandler.showLoadingForNewMessages();
            LPLog.INSTANCE.d(TAG_LOAD, "data exists! checking if we need to load history according to ui position.");
            this.onScroll(this.mListener.getFirstVisibleItemPosition());
            this.executeOnUI(this::updateWelcomeMessageQuickReply);
        } else {
            LPLog.INSTANCE.d(TAG_LOAD, "data exists! already updated. ");
        }
    }

    private FullMessageRow getMessageByEventId(String eventId) {
        for (FullMessageRow row : this.mDataSet) {
            MessagingChatMessage chatMessage = row.getMessagingChatMessage();
            if (chatMessage == null || !Objects.equals(chatMessage.getEventId(), eventId)) continue;
            return row;
        }
        return null;
    }

    public synchronized String getAgentUrl(String originatorId) {
        String avatarUrl = this.mAgentUrlsMap.get(originatorId);
        if (TextUtils.isEmpty((CharSequence)avatarUrl)) {
            MessagingUserProfile userProfile = this.mAmsMessages.loadMessagingUserProfile(originatorId);
            avatarUrl = userProfile == null ? "" : userProfile.getAvatarUrl();
        }
        return avatarUrl;
    }

    private void putAgentUrl(String originatorId, String url) {
        this.executeOnUI(() -> {
            if (TextUtils.isEmpty((CharSequence)url)) {
                return;
            }
            this.mAgentUrlsMap.put(originatorId, url);
            RecyclerView recyclerView = (RecyclerView)this.mRecyclerView.get();
            if (recyclerView == null) {
                return;
            }
            RecyclerView.Adapter adapter = recyclerView.getAdapter();
            for (int i = 0; i < this.mDataSet.size(); ++i) {
                FullMessageRow row = this.mDataSet.get(i);
                MessagingChatMessage message = row.getMessagingChatMessage();
                if (!TextUtils.equals((CharSequence)message.getOriginatorId(), (CharSequence)originatorId)) continue;
                row.setAgentAvatar(url);
                Bundle bundle = new Bundle();
                bundle.putString("EXTRA_AGENT_AVATAR", url);
                if (adapter == null) continue;
                adapter.notifyItemChanged(i, (Object)bundle);
            }
        });
    }

    private boolean isFinishedUpdatingWithFilter(Messaging controller) {
        boolean filterOn = controller.getConversationViewParams().isFilterOn();
        boolean updated = controller.mConnectionController.isUpdated(this.mBrandId);
        LPLog.INSTANCE.d(TAG_LOAD, "isFinishedUpdatingWithFilter - filterOn = " + filterOn + ", updated = " + updated);
        return filterOn && updated;
    }

    public void onConnectionLost() {
        LPLog.INSTANCE.d(TAG_LOAD, "onConnectionLost - removing loading old messages indicator");
        this.isConnectionAvailable = false;
        this.noMoreOldMessages = true;
        this.loadingMessagesHandler.restoreHistoryLoadingIndexIfPresent();
        this.resetHistoryLoading();
        this.loadingMessagesHandler.removeLoadingForNewMessages();
        this.executeOnUI(this::updateWelcomeMessageQuickReply);
    }

    private void updateWelcomeMessageQuickReply() {
        if (this.lastMessageQuickReplyFromWelcomeMessage()) {
            FullMessageRow messageRow = this.getLastMessage();
            LPWelcomeMessage lpWelcomeMessage = this.getWelcomeMessage();
            QuickRepliesMessageHolder.updateQuickReplies((String)this.mBrandId, (String)lpWelcomeMessage.getQuickReplies(this.isConnectionAvailable));
            this.mAmsMessages.resetQuickRepliesMessageHolder();
            this.mQuickRepliesMessageHolder = this.mAmsMessages.getQuickRepliesMessageHolder(this.mBrandId);
            this.mQuickRepliesMessage = FullMessageRow.generateAgentQuickReplyMessage((String)this.mQuickRepliesMessageHolder.getQuickRepliesString(), (long)messageRow.getMessagingChatMessage().getTimeStamp(), (String)messageRow.getMessagingChatMessage().getDialogId());
            this.mDataSet.set(this.mDataSet.size() - 1, this.mQuickRepliesMessage);
            this.mListener.onMessageUpdated(this.mDataSet.size() - 1, null);
        }
    }

    public void removeQuickRepliesMessageOfDialog(String dialogId) {
        MessagingFactory.getInstance().getController().amsDialogs.queryActiveDialog(this.mBrandId).setPostQueryOnUI(dialog -> {
            if (dialog != null) {
                if (dialog.getDialogId().equals(dialogId)) {
                    this.deleteQuickRepliesFromSharedPreference();
                }
            } else {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F9, "Error: No active dialog", (Throwable)new RuntimeException());
                this.deleteQuickRepliesFromSharedPreference();
            }
        }).execute();
    }

    public void removeQuickRepliesMessageOfConversation(String conversationId) {
        MessagingFactory.getInstance().getController().amsDialogs.queryOpenDialogsOfConversation(conversationId).setPostQueryOnUI(data -> {
            if (data.size() == 0) {
                LPLog.INSTANCE.d(TAG, "No open dialogs found for conversation ID: " + conversationId);
            } else if (data.size() == 1) {
                if (((Dialog)data.get(0)).getConversationId().equals(conversationId)) {
                    this.deleteQuickRepliesFromSharedPreference();
                }
            } else {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000FA, "There are more than one open dialogs (" + data.size() + ") of conversation! Conversation ID: " + conversationId);
                this.deleteQuickRepliesFromSharedPreference();
            }
        }).execute();
    }

    void setNewMessageRead(boolean newMessageRead) {
        this.isNewMessageRead = newMessageRead;
    }

    public boolean isScrollDownIndicatorVisible() {
        return this.isScrollDownIndicatorVisible;
    }

    void setScrollDownIndicatorVisible(boolean scrollDownIndicatorVisible) {
        this.isScrollDownIndicatorVisible = scrollDownIndicatorVisible;
    }

    @Override
    public void onDateHeaderRemoved(int position) {
        FullMessageRow row = this.getItem(position);
        MessagingChatMessage.MessageType type = this.getMessageType(row);
        if (type == MessagingChatMessage.MessageType.DATE_HEADER) {
            this.removeItemFromDataSet(position, "onDateHeaderRemoved");
            this.mListener.onItemRemoved(position);
        }
    }

    @Override
    public void onDateHeaderAdded(int position, @NonNull FullMessageRow messageRow) {
        if (this.isInsertionPositionCorrect(position)) {
            this.mDataSet.add(position, messageRow);
            this.mListener.onItemAdded(position);
        }
    }

    @Override
    public void onDateHeaderMoved(int oldPosition, int newPosition) {
        FullMessageRow row;
        MessagingChatMessage.MessageType type;
        if (oldPosition < this.mDataSet.size() - 1 && oldPosition > 0 && (type = this.getMessageType(row = this.mDataSet.get(oldPosition))) == MessagingChatMessage.MessageType.DATE_HEADER) {
            this.mDataSet.remove(oldPosition);
            if (this.isInsertionPositionCorrect(newPosition)) {
                this.mDataSet.add(newPosition, row);
                this.mListener.onItemMoved(oldPosition, newPosition);
            }
        }
    }

    private boolean isInsertionPositionCorrect(int position) {
        return position >= 0 && position <= this.mDataSet.size();
    }

    public void onScroll(int mFirstUIItemPosition) {
        if (!this.noMoreOldMessages && !this.loading) {
            this.removeEmptyState();
            this.loadAccordingToUI(mFirstUIItemPosition);
        }
    }

    private void loadAccordingToUI(int mFirstUIItemPosition) {
        LPLog.INSTANCE.d(TAG_LOAD, "loadAccordingToUI " + mFirstUIItemPosition);
        if (mFirstUIItemPosition < 10) {
            LPLog.INSTANCE.d(TAG_LOAD, "loadAccordingToUI - need to load more items");
            this.loading = true;
            long oldestMessageTimestamp = this.getFirstConversationMessageTimeStamp();
            this.loadingMessagesHandler.showLoadingForHistory();
            this.mAmsMessages.loadMessages(AmsMessages.MessagesSortedBy.TargetId, this.mBrandId, this.mListener.getLoadLimit(), oldestMessageTimestamp - 1L, -1L).setPostQueryOnBackground((DataBaseCommand.QueryCallback)new DataBaseCommand.QueryCallback<ArrayList<FullMessageRow>>(){

                public void onResult(ArrayList<FullMessageRow> data) {
                    MessagesAsListLoader.this.loadingMessagesHandler.removeLoadingForHistory();
                    if (data == null || data.isEmpty()) {
                        if (!MessagingFactory.getInstance().getController().mConnectionController.isSocketReady(MessagesAsListLoader.this.mBrandId)) {
                            LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "onScroll - no more messages to load, but we are not connected!!");
                            MessagesAsListLoader.this.onConnectionLost();
                            return;
                        }
                        if (null != MessagingFactory.getInstance().getController().mConnectionController.getConnection(MessagesAsListLoader.this.mBrandId) && MessagingFactory.getInstance().getController().mConnectionController.getConnection(MessagesAsListLoader.this.mBrandId).isLastUpdateTimeExists()) {
                            LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "onScroll - no more messages to load, connected but never got the first ExConversationsNotification. waiting...");
                            return;
                        }
                        boolean wasErrorOccurred = MessagingFactory.getInstance().getController().amsConversations.isFailedToFetchConversationFirstTime(MessagesAsListLoader.this.mBrandId);
                        LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "onScroll - no more messages to load!");
                        if (MessagingFactory.getInstance().getController().amsDialogs.areMoreMessagesAvailableToFetch(MessagesAsListLoader.this.mBrandId)) {
                            Dialog dialog;
                            LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "More conversation to fetch - showing loading history..");
                            MessagesAsListLoader.this.loadingMessagesHandler.showLoadingForHistory();
                            try {
                                dialog = (Dialog)MessagingFactory.getInstance().getController().amsDialogs.fetchPreviousDialog(MessagesAsListLoader.this.mBrandId).executeSynchronously();
                            }
                            catch (Throwable throwable) {
                                LPLog.INSTANCE.v(MessagesAsListLoader.TAG_LOAD, "Could not load previous dialog", throwable);
                                dialog = null;
                            }
                            if (dialog == null) {
                                MessagesAsListLoader.this.executeIfNotBusyFetching(() -> {
                                    if (!wasErrorOccurred) {
                                        MessagesAsListLoader.this.hideFetchingHistoryLoader();
                                    }
                                });
                            } else {
                                boolean shouldStopFetching;
                                Dialog activeDialog = MessagingFactory.getInstance().getController().amsDialogs.getActiveDialog();
                                boolean bl = shouldStopFetching = activeDialog != null && TextUtils.equals((CharSequence)activeDialog.getConversationId(), (CharSequence)dialog.getConversationId());
                                if (shouldStopFetching) {
                                    MessagesAsListLoader.this.executeOnUI(() -> {
                                        if (!wasErrorOccurred) {
                                            MessagesAsListLoader.this.hideFetchingHistoryLoader();
                                        }
                                    });
                                }
                            }
                        } else {
                            MessagesAsListLoader.this.executeIfNotBusyFetching(() -> {
                                boolean shouldStopFetching = MessagesAsListLoader.this.mDataSet.isEmpty() || MessagesAsListLoader.this.getMessageType((FullMessageRow)MessagesAsListLoader.this.mDataSet.get(0)) == MessagingChatMessage.MessageType.LOADING;
                                if (shouldStopFetching &= !wasErrorOccurred) {
                                    MessagesAsListLoader.this.hideFetchingHistoryLoader();
                                }
                            });
                        }
                    } else {
                        LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "loadMessages : " + data.size() + " messages to load!");
                        MessagesAsListLoader.this.addOldMultiItem(data);
                    }
                }
            }).execute();
        }
    }

    private void executeIfNotBusyFetching(Runnable runnable) {
        boolean isStillBusy = MessagingFactory.getInstance().getController().isStillBusyFetching();
        if (isStillBusy) {
            LPLog.INSTANCE.d(TAG_LOAD, "Still fetching history...");
        } else {
            this.executeOnUI(runnable);
        }
    }

    @MainThread
    private void hideFetchingHistoryLoader() {
        LPLog.INSTANCE.d(TAG, "finished fetching all history for this conversation");
        this.noMoreOldMessages = true;
        this.addFirstMessage();
        this.resetHistoryLoading();
    }

    private void addFirstMessage() {
        if (MessagingFactory.getInstance().getController().getClearHistoryFlag(this.mBrandId) && Configuration.getBoolean((int)R.bool.lp_hide_welcome_message_on_clear_history)) {
            LPLog.INSTANCE.d(TAG_LOAD, "not add first message after cleared history");
            return;
        }
        Messaging controller = MessagingFactory.getInstance().getController();
        ConversationViewParams conversationViewParams = controller.getConversationViewParams();
        LPWelcomeMessage welcomeMessage = this.getWelcomeMessage();
        if (conversationViewParams.isFilterOn() && welcomeMessage.getMessageFrequency() != LPWelcomeMessage.MessageFrequency.EVERY_CONVERSATION) {
            LPLog.INSTANCE.d(TAG_LOAD, "No more messages to fetch. filter is on. not showing first message");
            if (this.mDataSet.isEmpty() || this.dataSetHasOnlyLoadingMessageOrDateHeaders()) {
                this.setEmptyState();
            }
        } else if (controller.isConversationEmptyOrClose(this.mBrandId) && (this.dataSetHasOnlyLoadingMessageOrDateHeaders() || this.mDataSet.isEmpty())) {
            LPLog.INSTANCE.d(TAG_LOAD, "No more messages to fetch. showing first message");
            this.mConversationUtils.showInitialWelcomeMessage(this.mBrandId, welcomeMessage);
        }
        this.setupDateHeaders();
    }

    public boolean addWelcomeMessage() {
        if (this.getWelcomeMessageFrequency() == LPWelcomeMessage.MessageFrequency.EVERY_CONVERSATION) {
            return this.performAddWelcomeMessageForEmptyCloseConvo();
        }
        return false;
    }

    private boolean performAddWelcomeMessageForEmptyCloseConvo() {
        Messaging controller = MessagingFactory.getInstance().getController();
        boolean added = false;
        if (controller.isConversationEmptyOrClose(this.mBrandId) && controller.isSocketOpen(this.mBrandId)) {
            LPWelcomeMessage lpWelcomeMessage = this.getWelcomeMessage();
            QuickRepliesMessageHolder.updateQuickReplies((String)this.mBrandId, (String)lpWelcomeMessage.getQuickReplies(this.isConnectionAvailable));
            this.mAmsMessages.resetQuickRepliesMessageHolder();
            this.mQuickRepliesMessageHolder = null;
            this.mConversationUtils.addWelcomeMessageRequest(this.mBrandId);
            added = true;
        }
        LPLog.INSTANCE.d(TAG, "performAddWelcomeMessage().added = " + added);
        return added;
    }

    public int size() {
        return this.mDataSet.size();
    }

    private boolean dataSetHasOnlyLoadingMessageOrDateHeaders() {
        ArrayList<FullMessageRow> dataSet = this.mDataSet;
        if (dataSet.size() == 1) {
            MessagingChatMessage message = this.getItem(0).getMessagingChatMessage();
            return message.getMessageType() == MessagingChatMessage.MessageType.LOADING || message.getMessageType() == MessagingChatMessage.MessageType.DATE_HEADER;
        }
        return false;
    }

    @VisibleForTesting
    public ArrayList<FullMessageRow> getMDataSet() {
        return new ArrayList<FullMessageRow>(this.mDataSet);
    }

    @VisibleForTesting
    public LoadingMessagesHandler getLoadingMessagesHandler() {
        return this.loadingMessagesHandler;
    }

    @Nullable
    public FullMessageRow getItem(int position) {
        if (position < 0 || position >= this.mDataSet.size()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000FC, "IndexOutOfBoundsException at: " + position + " when getting item. Data set size: " + this.mDataSet.size());
            return null;
        }
        return this.mDataSet.get(position);
    }

    @Override
    public void onBackground() {
        this.executeOnUI(() -> {
            if (this.isItemAtPositionVisible(this.mDataSet.size() - 1)) {
                this.removeUnreadMessages();
            }
            this.removeFirstOutboundMessage();
            this.removeWelcomeMessage();
            this.clearListForUnAuthMode();
        });
    }

    private void clearListForUnAuthMode() {
        if (this.isUnauthMode()) {
            this.removeAllMessages(false);
        }
    }

    public void removeFirstOutboundMessage() {
        if (this.lastMessageOutboundCampaignMessage()) {
            LPLog.INSTANCE.d(TAG, "removeFirstOutboundMessage: Removing outbound welcome message");
            this.removeItemFromDataSet(this.mDataSet.size() - 1, "removeFirstOutboundMessage");
            this.mListener.onItemRemoved(this.mDataSet.size());
            this.setupDateHeaders();
        }
    }

    private void removeWelcomeMessage() {
        if (this.lastMessageQuickReplyFromWelcomeMessage()) {
            LPLog.INSTANCE.d(TAG, "removeWelcomeMessage: Removing welcome message quick replies");
            this.removeItemFromDataSet(this.mDataSet.size() - 1, "removeWelcomeMessage");
            this.mListener.onItemRemoved(this.mDataSet.size());
        }
        if (this.lastMessageWelcomeMessage()) {
            LPLog.INSTANCE.d(TAG, "removeWelcomeMessage: Removing welcome message");
            this.removeItemFromDataSet(this.mDataSet.size() - 1, "removeWelcomeMessage");
            this.mListener.onItemRemoved(this.mDataSet.size());
            this.mConversationUtils.cancelWelcomeMessageTimeoutTasks();
        }
        this.setupDateHeaders();
    }

    private boolean isUnauthMode() {
        return MessagingFactory.getInstance().getController().mAccountsController.isInUnAuthMode(this.mBrandId);
    }

    @Override
    public void onForeground() {
        this.addListenerToMessages();
    }

    public int getUnreadPosition() {
        return this.indexNumOfUnreadAgentMessage;
    }

    private void addOldItems(ArrayList<FullMessageRow> items, boolean containsNew) {
        if (items == null || items.isEmpty()) {
            LPLog.INSTANCE.d(TAG, "MessagesAsListLoader addOldMultiItem no messages.");
            return;
        }
        this.removeEmptyState();
        this.resetHistoryLoading();
        this.isAddingMessagesToDataSet = true;
        this.executeOnUI(() -> {
            this.isAddingMessagesToDataSet = false;
            this.merge(items, containsNew);
        });
    }

    private void addItems(ArrayList<FullMessageRow> items) {
        if (items == null || items.isEmpty()) {
            LPLog.INSTANCE.d(TAG, "MessagesAsListLoader addOldMultiItem no messages.");
            return;
        }
        this.removeEmptyState();
        this.resetHistoryLoading();
        this.isAddingMessagesToDataSet = true;
        this.executeOnUI(() -> {
            this.isAddingMessagesToDataSet = false;
            if (this.mDataSet.isEmpty()) {
                this.addNewMessagesToList(items, false, false);
            } else {
                FullMessageRow lastReceivedItem = (FullMessageRow)items.get(items.size() - 1);
                FullMessageRow dataSetFirstItem = this.mDataSet.get(0);
                FullMessageRow firstReceivedItem = (FullMessageRow)items.get(0);
                FullMessageRow dataSetLastItem = this.mDataSet.get(this.mDataSet.size() - 1);
                int onlyOldMessages = dataSetFirstItem.newerThan(lastReceivedItem);
                int onlyNewMessages = firstReceivedItem.newerThan(dataSetLastItem);
                if (onlyOldMessages == 1) {
                    this.addOldItems(items, false);
                } else if (onlyNewMessages == 1) {
                    this.addNewMessagesToList(items, false, false);
                } else {
                    this.updateMessages(items);
                }
            }
        });
    }

    private void addOldMultiItem(ArrayList<FullMessageRow> searchedMessageList) {
        this.addOldMultiItem(searchedMessageList, true);
    }

    private void addOldMultiItem(final ArrayList<FullMessageRow> searchedMessageList, final boolean shouldUpdateUi) {
        if (searchedMessageList == null || searchedMessageList.isEmpty()) {
            LPLog.INSTANCE.d(TAG, "MessagesAsListLoader addOldMultiItem no messages.");
            return;
        }
        this.removeEmptyState();
        this.resetHistoryLoading();
        this.isAddingMessagesToDataSet = true;
        this.executeOnUI(new Runnable(){

            @Override
            public void run() {
                int onlyOldMessages;
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "MessagesAsListLoader addOldMultiItem: " + MessagesAsListLoader.this.mRecyclerView.hashCode());
                MessagesAsListLoader.this.isAddingMessagesToDataSet = false;
                ArrayList filteredSearchedMessageList = (ArrayList)MessagesAsListLoader.this.removeIfResolvedMessagesIsDisabled(searchedMessageList);
                if (filteredSearchedMessageList.isEmpty()) {
                    return;
                }
                boolean firstLoad = MessagesAsListLoader.this.mDataSet.isEmpty();
                int n = onlyOldMessages = firstLoad ? 1 : ((FullMessageRow)MessagesAsListLoader.this.mDataSet.get(0)).newerThan((FullMessageRow)filteredSearchedMessageList.get(filteredSearchedMessageList.size() - 1));
                if (onlyOldMessages == 1) {
                    MessagesAsListLoader.this.addMultiMessageToDataSet(0, filteredSearchedMessageList, "addOldMultiItem");
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG_MERGE, "On history loaded - all before our current data set. 0 - " + filteredSearchedMessageList.size());
                    int tempUnreadAgentMessages = MessagesAsListLoader.this.checkIfAllMessagesAreFromAgent(filteredSearchedMessageList);
                    if (tempUnreadAgentMessages > 0 && (firstLoad || MessagesAsListLoader.this.indexNumOfUnreadAgentMessage != -1) && shouldUpdateUi) {
                        boolean isUiNotFocusedOnItem = !MessagesAsListLoader.this.isItemAtPositionVisible(filteredSearchedMessageList.size());
                        MessagesAsListLoader.this.mListener.onHistoryLoaded(0, filteredSearchedMessageList.size(), firstLoad);
                        MessagesAsListLoader.this.handleUnreadMessages(filteredSearchedMessageList.size(), true, tempUnreadAgentMessages, filteredSearchedMessageList.size() - tempUnreadAgentMessages, isUiNotFocusedOnItem);
                    } else {
                        MessagesAsListLoader.this.mListener.onHistoryLoaded(0, filteredSearchedMessageList.size(), firstLoad);
                        MessagesAsListLoader.this.moveIndexUnreadMessage(filteredSearchedMessageList.size(), filteredSearchedMessageList.size());
                    }
                    if (!MessagesAsListLoader.this.lastMessageWelcomeMessage() && !MessagesAsListLoader.this.lastMessageQuickReply() && MessagingFactory.getInstance().getController().isConversationEmptyOrClose(MessagesAsListLoader.this.mBrandId)) {
                        MessagesAsListLoader.this.addWelcomeMessage();
                    }
                } else {
                    MessagesAsListLoader.this.merge(filteredSearchedMessageList, true);
                }
                MessagesAsListLoader.this.addQuickRepliesMessage(firstLoad);
                MessagesAsListLoader.this.setupDateHeaders();
            }
        });
    }

    private boolean lastMessageWelcomeMessage() {
        return this.getLastMessage() != null && this.getLastMessage().getMessagingChatMessage().getServerSequence() == -4;
    }

    private boolean lastMessageOutboundCampaignMessage() {
        if (!this.mDataSet.isEmpty()) {
            return this.mDataSet.get(this.mDataSet.size() - 1).getMessagingChatMessage().getServerSequence() == -5;
        }
        LPLog.INSTANCE.d(TAG, "lastMessageOutboundCampaignMessage: false");
        return false;
    }

    private boolean lastMessageQuickReply() {
        return this.isMessageQuickReply(this.getLastMessage());
    }

    public boolean isMessageQuickReply(FullMessageRow message) {
        return message != null && message.getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES;
    }

    private boolean lastMessageQuickReplyFromWelcomeMessage() {
        if (this.mDataSet.size() > 1) {
            MessagingChatMessage secondLastMessage = this.mDataSet.get(this.mDataSet.size() - 2).getMessagingChatMessage();
            MessagingChatMessage lastMessage = this.getLastMessage().getMessagingChatMessage();
            return lastMessage.getMessageType() == MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES && secondLastMessage.getServerSequence() == -4;
        }
        return false;
    }

    public FullMessageRow getLastMessage() {
        if (this.mDataSet.isEmpty()) {
            return null;
        }
        int lastItemIndex = this.mDataSet.size() - 1;
        return this.mDataSet.get(lastItemIndex);
    }

    private boolean shouldAddWelcomeMessageWhenFilterOn(Messaging controller) {
        return controller.getConversationViewParams().getHistoryConversationsStateToDisplay() == LPConversationsHistoryStateToDisplay.OPEN && this.getWelcomeMessageFrequency() == LPWelcomeMessage.MessageFrequency.EVERY_CONVERSATION && controller.isConversationEmptyOrClose(this.mBrandId) && !this.lastMessageWelcomeMessage();
    }

    private boolean shouldAddWelcomeMessageInFirstTimeConvo(Messaging controller) {
        return this.getWelcomeMessageFrequency() == LPWelcomeMessage.MessageFrequency.FIRST_TIME_CONVERSATION && controller.isConversationEmptyOrClose(this.mBrandId) && !this.lastMessageWelcomeMessage();
    }

    private boolean shouldAddWelcomeMessageForEveryConversation(Messaging controller) {
        return this.getWelcomeMessageFrequency() == LPWelcomeMessage.MessageFrequency.EVERY_CONVERSATION && controller.isConversationEmptyOrClose(this.mBrandId) && !this.lastMessageWelcomeMessage();
    }

    private void resetHistoryLoading() {
        this.resetLoading();
        this.loadingMessagesHandler.removeLoadingForHistory();
    }

    private void resetLoading() {
        if (this.loading) {
            LPLog.INSTANCE.d(TAG_LOAD, "Resetting history loading");
            this.loading = false;
        }
    }

    private void addNewMultiItem(ArrayList<FullMessageRow> newMessages) {
        if (newMessages == null || newMessages.isEmpty()) {
            return;
        }
        LPLog.INSTANCE.d(TAG, "addNewMultiItem num of items:" + newMessages.size());
        this.executeOnUI(() -> {
            int onlyNewMessages;
            int n = onlyNewMessages = this.mDataSet.isEmpty() ? 1 : ((FullMessageRow)newMessages.get(0)).newerThan(this.mDataSet.get(this.mDataSet.size() - 1));
            if (onlyNewMessages == 1) {
                this.addNewMessagesToList(newMessages, true);
            } else {
                this.merge(newMessages, true);
            }
        });
    }

    private void updateMessages(ArrayList<FullMessageRow> searchedMessageList) {
        if (searchedMessageList == null || searchedMessageList.isEmpty()) {
            return;
        }
        LPLog.INSTANCE.d(TAG, "updateMessages num of items:" + searchedMessageList.size());
        this.executeOnUI(() -> this.merge(searchedMessageList, false));
    }

    private void merge(ArrayList<FullMessageRow> newMessages, boolean mightContainNewMessages) {
        if (newMessages == null || newMessages.isEmpty()) {
            return;
        }
        boolean firstLoad = this.mDataSet.isEmpty();
        if (firstLoad) {
            this.addNewMessagesToList(newMessages, mightContainNewMessages);
            LPLog.INSTANCE.d(TAG_MERGE, "On history loaded for the first time. 0 - " + newMessages.size());
            this.mListener.onHistoryLoaded(0, newMessages.size(), firstLoad);
            return;
        }
        int tempAgentMsgCount = 0;
        int firstUnreadAgentMsgPosition = -1;
        int newMsgCount = 0;
        int oldLastItem = this.mDataSet.size();
        int index1 = this.getPositionMergeStarts(newMessages.get(0));
        LPLog.INSTANCE.d(TAG_MERGE, "getPositionMergeStarts = " + index1);
        int index2 = 0;
        while (index2 < newMessages.size()) {
            FullMessageRow fullMessageRowNew;
            if (index1 == this.mDataSet.size()) {
                ArrayList<FullMessageRow> restNewMessages = new ArrayList<FullMessageRow>(newMessages.subList(index2, newMessages.size()));
                this.addNewMessagesToList(restNewMessages, mightContainNewMessages);
                return;
            }
            if (index1 < 0 || index1 >= this.mDataSet.size()) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000FE, "IndexOutOfBoundsException at: " + index1 + " when getting index1. Data set size: " + this.mDataSet.size());
                return;
            }
            FullMessageRow fullMessageRowOriginal = this.mDataSet.get(index1);
            int newerThan = fullMessageRowOriginal.newerThan(fullMessageRowNew = newMessages.get(index2));
            if (newerThan == 0) {
                Bundle changes = this.mDataSet.get(index1).update(newMessages.get(index2));
                ++index2;
                if (changes != null && !changes.isEmpty()) {
                    this.mListener.onMessageUpdated(index1, changes);
                }
                if (index2 == newMessages.size() && this.mQuickRepliesMessage != null) {
                    this.addQuickRepliesMessage(false);
                }
            } else if (newerThan == 1 && fullMessageRowOriginal.getMessagingChatMessage().getMessageType() != MessagingChatMessage.MessageType.UNREAD_INDICATOR && fullMessageRowOriginal.getMessagingChatMessage().getMessageType() != MessagingChatMessage.MessageType.AGENT_IS_TYPING_INDICATOR) {
                FullMessageRow msg;
                if ((tempAgentMsgCount = this.addItem(msg = newMessages.get(index2++), index1, mightContainNewMessages, tempAgentMsgCount)) == 0) {
                    firstUnreadAgentMsgPosition = -1;
                } else if (tempAgentMsgCount == 1 && firstUnreadAgentMsgPosition == -1) {
                    firstUnreadAgentMsgPosition = index1;
                }
                ++newMsgCount;
                this.moveIndexUnreadMessage(index1, 1);
            }
            ++index1;
        }
        if (mightContainNewMessages && newMsgCount > 0) {
            if (newMessages.size() == 1 && newMessages.get(0).getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.CONTROLLER_SYSTEM) {
                LPLog.INSTANCE.i(TAG, "Skipping unread messages count changes to prevent unread messages banner disappearing when controller messages received.");
            } else {
                boolean isUiNotFocusedOnItem = !this.isItemAtPositionVisible(oldLastItem);
                this.handleUnreadMessages(newMsgCount, mightContainNewMessages, tempAgentMsgCount, firstUnreadAgentMsgPosition, isUiNotFocusedOnItem);
            }
        }
        this.setupDateHeaders();
    }

    public int getPositionMergeStarts(FullMessageRow newMessage) {
        int start = 0;
        int end = this.mDataSet.size() - 1;
        while (start < end) {
            int middle = (start + end) / 2;
            int newerThan = newMessage.newerThan(this.mDataSet.get(middle));
            if (newerThan == 1) {
                start = middle + 1;
                continue;
            }
            if (newerThan == -1) {
                end = middle;
                continue;
            }
            if (newerThan != 0) continue;
            LPLog.INSTANCE.d(TAG, "The same! returning position middle = " + middle);
            return middle;
        }
        LPLog.INSTANCE.d(TAG, "Returning start = " + start);
        return start;
    }

    private void addQuickRepliesMessage(boolean firstLoad) {
        this.mQuickRepliesMessageHolder = this.mAmsMessages.getQuickRepliesMessageHolder(this.mBrandId);
        if (this.mQuickRepliesMessageHolder == null || !this.mQuickRepliesMessageHolder.isValid()) {
            LPLog.INSTANCE.d(TAG, FlowTags.QUICK_REPLIES, "addQuickRepliesMessage: QuickReplies is null or not valid. Hiding current QR message");
            this.hideQuickRepliesMessage();
            return;
        }
        Messaging controller = MessagingFactory.getInstance().getController();
        for (int i = this.mDataSet.size() - 1; i >= 0; --i) {
            FullMessageRow fullMessageRow = this.mDataSet.get(i);
            MessagingChatMessage.MessageType messageType = fullMessageRow.getMessagingChatMessage().getMessageType();
            if (this.shouldAddQuickReply(fullMessageRow) && this.mQuickRepliesMessageHolder.isQuickReplyActionsPresented()) {
                int requiredIndex = i + 1;
                int itemsToScroll = 2;
                int quickRepliesMessageIndex = this.mDataSet.indexOf(this.mQuickRepliesMessage);
                if (quickRepliesMessageIndex > -1) {
                    LPLog.INSTANCE.d(TAG, "removing QuickReplies from index: " + quickRepliesMessageIndex);
                    this.removeItemFromDataSet(quickRepliesMessageIndex, "addQuickRepliesMessage");
                    this.mListener.onItemRemoved(quickRepliesMessageIndex);
                    this.mQuickRepliesMessage = null;
                    --requiredIndex;
                    --itemsToScroll;
                }
                Dialog dialog = controller.amsDialogs.getActiveDialog();
                String dialogId = "";
                if (dialog == null || dialog.getDialogType() == DialogType.POST_SURVEY) {
                    dialogId = fullMessageRow.getMessagingChatMessage().getDialogId();
                }
                if (this.lastMessageQuickReplyFromWelcomeMessage() || this.lastMessageWelcomeMessage()) {
                    LPWelcomeMessage welcomeMessage = this.getWelcomeMessage();
                    QuickRepliesMessageHolder.updateQuickReplies((String)this.mBrandId, (String)welcomeMessage.getQuickReplies(this.isConnectionAvailable));
                    this.mAmsMessages.resetQuickRepliesMessageHolder();
                    this.mQuickRepliesMessageHolder = this.mAmsMessages.getQuickRepliesMessageHolder(this.mBrandId);
                }
                LPLog.INSTANCE.d(TAG, "addQuickRepliesMessage: generate and add QuickReplies message to dateSet");
                this.mQuickRepliesMessage = FullMessageRow.generateAgentQuickReplyMessage((String)this.mQuickRepliesMessageHolder.getQuickRepliesString(), (long)fullMessageRow.getMessagingChatMessage().getTimeStamp(), (String)dialogId);
                this.addMessageToDataSet(this.mQuickRepliesMessage, requiredIndex, "addQuickRepliesMessage");
                if (firstLoad) {
                    this.mListener.onHistoryLoaded(0, this.mDataSet.size(), firstLoad);
                } else {
                    this.mListener.onNewMessagesLoaded(i, itemsToScroll, 0);
                }
                return;
            }
            if (messageType == MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES) {
                LPLog.INSTANCE.d(TAG, "addQuickRepliesMessage: last message is QuickReplies. Leave it as is.");
                return;
            }
            if (messageType != MessagingChatMessage.MessageType.SYSTEM_MASKED && messageType != MessagingChatMessage.MessageType.CONTROLLER_SYSTEM && messageType != MessagingChatMessage.MessageType.SYSTEM_RESOLVED) {
                if (MessagingChatMessage.MessageType.isAgent((MessagingChatMessage.MessageType)messageType)) {
                    this.hideShowQuickRepliesFlagInSharedPreference();
                    return;
                }
                LPLog.INSTANCE.d(TAG, "addQuickRepliesMessage: last message is not agent nor system. Not adding quick replies and removing any displayed one");
                if (this.mQuickRepliesMessageHolder.getSequence() != -4 || MessagingChatMessage.MessageType.isConsumer((MessagingChatMessage.MessageType)messageType)) {
                    this.hideShowQuickRepliesFlagInSharedPreference();
                }
                return;
            }
            LPLog.INSTANCE.d(TAG, "addQuickRepliesMessage: last message is system, continue to the previous one");
        }
    }

    private boolean shouldAddQuickReply(FullMessageRow fullMessageRow) {
        MessagingChatMessage.MessageType messageType = fullMessageRow.getMessagingChatMessage().getMessageType();
        int serverSequence = fullMessageRow.getMessagingChatMessage().getServerSequence();
        return (messageType == MessagingChatMessage.MessageType.AGENT || messageType == MessagingChatMessage.MessageType.AGENT_STRUCTURED_CONTENT || messageType == MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES || messageType == MessagingChatMessage.MessageType.AGENT_URL || serverSequence == -4) && serverSequence == this.mQuickRepliesMessageHolder.getSequence();
    }

    private void deleteQuickRepliesFromSharedPreference() {
        if (this.getWelcomeMessageFrequency() != LPWelcomeMessage.MessageFrequency.EVERY_CONVERSATION) {
            if (this.mQuickRepliesMessageHolder != null) {
                QuickRepliesMessageHolder.deleteFromSharedPreferences((String)this.mBrandId);
                this.mAmsMessages.resetQuickRepliesMessageHolder();
                this.mQuickRepliesMessageHolder = null;
            }
            this.hideQuickRepliesMessage();
        }
    }

    public void hideShowQuickRepliesFlagInSharedPreference() {
        int quickRepliesMessageIndex = this.mDataSet.indexOf(this.mQuickRepliesMessage);
        if (this.mQuickRepliesMessageHolder != null && quickRepliesMessageIndex > -1) {
            MessagingChatMessage message = this.mQuickRepliesMessage.getMessagingChatMessage();
            this.mQuickRepliesMessageHolder.setShow(this.shouldShowQuickReplies(message));
        }
        this.hideQuickRepliesMessage();
    }

    private void hideQuickRepliesMessage() {
        int quickRepliesMessageIndex = this.mDataSet.indexOf(this.mQuickRepliesMessage);
        if (quickRepliesMessageIndex > -1) {
            LPLog.INSTANCE.d(TAG, "removing QuickReplies from index: " + quickRepliesMessageIndex);
            this.removeItemFromDataSet(quickRepliesMessageIndex, "hideQuickRepliesMessage");
            this.mListener.onItemRemoved(quickRepliesMessageIndex);
            MessagingChatMessage message = this.mQuickRepliesMessage.getMessagingChatMessage();
            if (this.shouldShowQuickReplies(message)) {
                LPLog.INSTANCE.d(TAG, "Should not clear quick replies message from memory");
            } else {
                this.mQuickRepliesMessage = null;
            }
        }
    }

    public void hideCoBrowsMessage(String dialogId) {
        int coBrowsIndex = -1;
        LPLog.INSTANCE.d(TAG, "hideCoBrowsMessage: Check If needs to remove coBrowse message from view");
        for (int i = this.mDataSet.size() - 1; i >= 0; --i) {
            MessagingChatMessage message = this.mDataSet.get(i).getMessagingChatMessage();
            if (!message.getMessageType().equals((Object)MessagingChatMessage.MessageType.COBROWSE) || !message.getMessage().equals(dialogId)) continue;
            coBrowsIndex = i;
            break;
        }
        if (coBrowsIndex > -1) {
            LPLog.INSTANCE.d(TAG, "hideCoBrowsMessage: removing coBrowse message from view");
            this.removeItemFromDataSet(coBrowsIndex, "hideCoBrowsMessage");
            this.mListener.onItemRemoved(coBrowsIndex);
            this.mAmsMessages.removeCoBrowseMessage();
            if (coBrowsIndex < this.indexNumOfUnreadAgentMessage) {
                --this.indexNumOfUnreadAgentMessage;
            }
        }
    }

    public List<FullMessageRow> removeIfResolvedMessagesIsDisabled(List<FullMessageRow> messagesList) {
        boolean hideAutoCloseSeparator;
        boolean hideResolveMessage = !Configuration.getBoolean((int)R.bool.enable_conversation_resolved_message);
        boolean hideResolveSeparator = !Configuration.getBoolean((int)R.bool.enable_conversation_resolved_separator);
        boolean bl = hideAutoCloseSeparator = !Configuration.getBoolean((int)R.bool.lp_enable_conversation_resolved_separator_on_auto_close);
        if (hideResolveSeparator && hideResolveMessage) {
            ArrayList<FullMessageRow> filteredMessages = new ArrayList<FullMessageRow>(messagesList.size());
            for (FullMessageRow fullMessageRow : messagesList) {
                if (MessagingChatMessage.MessageType.isSystemResolved((MessagingChatMessage.MessageType)fullMessageRow.getMessagingChatMessage().getMessageType())) continue;
                filteredMessages.add(fullMessageRow);
            }
            return filteredMessages;
        }
        if (hideAutoCloseSeparator) {
            ArrayList<FullMessageRow> filteredMessages = new ArrayList<FullMessageRow>(messagesList.size());
            for (FullMessageRow fullMessageRow : messagesList) {
                MessagingChatMessage message = fullMessageRow.getMessagingChatMessage();
                if (message.getServerSequence() == -8) continue;
                filteredMessages.add(fullMessageRow);
            }
            return filteredMessages;
        }
        return messagesList;
    }

    private void addNewMessagesToList(List<FullMessageRow> newMessages, boolean messagesFromQuery, boolean shouldMarkUnreadMessages) {
        boolean onlyControllerMessages;
        ArrayList filteredNewMessages = (ArrayList)this.removeIfResolvedMessagesIsDisabled(newMessages);
        if (filteredNewMessages.isEmpty()) {
            return;
        }
        int oldLastItem = this.mDataSet.size();
        this.addMultiMessageToDataSet(this.mDataSet.size(), filteredNewMessages, "addNewMessagesToList");
        int tempUnreadAgentMessages = shouldMarkUnreadMessages ? this.checkIfAllMessagesAreFromAgent(filteredNewMessages) : 0;
        LPLog.INSTANCE.d(TAG_MERGE, "On new Message - all after our current data set. " + oldLastItem + " - " + this.mDataSet.size() + " tempUnreadAgentMessages = " + tempUnreadAgentMessages);
        boolean isUiNotFocusedOnItem = !this.isItemAtPositionVisible(oldLastItem);
        int fromPosition = this.mDataSet.size() - filteredNewMessages.size();
        FullMessageRow newMessage = (FullMessageRow)filteredNewMessages.get(0);
        if (filteredNewMessages.size() == 1 && MessagingChatMessage.MessageType.isAgent((MessagingChatMessage.MessageType)newMessage.getMessagingChatMessage().getMessageType())) {
            this.mListener.onNewAgentMessageReceived(fromPosition, newMessage);
        } else {
            this.mListener.onNewMessagesLoaded(fromPosition, filteredNewMessages.size(), tempUnreadAgentMessages);
        }
        if (oldLastItem != 0 && this.mDataSet.get(oldLastItem - 1).getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES) {
            --oldLastItem;
        }
        LPLog.INSTANCE.d(TAG, FlowTags.QUICK_REPLIES, "addNewMessagesToList: adding QuickReplies message to view");
        this.addQuickRepliesMessage(false);
        if (this.lastMessageQuickReply()) {
            this.mListener.onQuickRepliesMessageReceived();
        }
        boolean bl = onlyControllerMessages = newMessages.size() == 1 && newMessages.get(0).getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.CONTROLLER_SYSTEM;
        if (tempUnreadAgentMessages != 0 || !onlyControllerMessages) {
            this.handleUnreadMessages(filteredNewMessages.size(), messagesFromQuery, tempUnreadAgentMessages, oldLastItem, isUiNotFocusedOnItem);
        }
        this.setupDateHeaders();
    }

    private void addNewMessagesToList(List<FullMessageRow> newMessages, boolean messagesFromQuery) {
        this.addNewMessagesToList(newMessages, messagesFromQuery, true);
    }

    private void handleUnreadMessages(int newMsgCount, boolean newMessagesFromQuery, int tempAgentMsgCount, int positionOfFirstAgentItemInserted, boolean isUINotFocusOnLastItem) {
        if (!this.isUnreadEnable) {
            return;
        }
        boolean wasLastMessageRead = this.isNewMessageRead;
        if (this.isNewMessageRead && this.indexNumOfUnreadAgentMessage > -1) {
            this.isNewMessageRead = false;
            this.numOfUnreadAgentMessages = 0;
            if (this.isScrollDownIndicatorVisible) {
                this.changeUnreadMessagePosition(this.mDataSet.size() - newMsgCount);
            } else {
                this.removeUnreadMessages();
            }
        }
        if (this.indexNumOfUnreadAgentMessage > -1) {
            if (this.indexNumOfUnreadAgentMessage < positionOfFirstAgentItemInserted) {
                LPLog.INSTANCE.d(TAG_MERGE, "handle unread messages. adding new agent messages after exists unread message : " + tempAgentMsgCount + ". positionOfFirstAgentItemInserted = " + positionOfFirstAgentItemInserted);
                if (tempAgentMsgCount == newMsgCount) {
                    this.updateUnreadMessage(tempAgentMsgCount, wasLastMessageRead);
                } else if (tempAgentMsgCount > 0) {
                    this.numOfUnreadAgentMessages = tempAgentMsgCount;
                    this.changeUnreadMessagePosition(this.mDataSet.size() - tempAgentMsgCount);
                } else if (tempAgentMsgCount == 0) {
                    this.removeUnreadMessages();
                }
            } else {
                LPLog.INSTANCE.d(TAG_MERGE, "handle unread messages. adding new agent messages *before* exists unread message : " + tempAgentMsgCount + ". positionOfFirstAgentItemInserted = " + positionOfFirstAgentItemInserted);
                if (tempAgentMsgCount > 0) {
                    this.updateUnreadMessage(tempAgentMsgCount, wasLastMessageRead);
                    this.changeUnreadMessagePosition(positionOfFirstAgentItemInserted);
                } else if (tempAgentMsgCount == 0) {
                    int positionOfCheck = this.mDataSet.size() - 1 - this.numOfUnreadAgentMessages;
                    LPLog.INSTANCE.d(TAG, "we want to check if we have a system resolved in spot:" + positionOfCheck);
                    if (positionOfCheck < 0 || positionOfCheck >= this.mDataSet.size()) {
                        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000FF, "IndexOutOfBoundsException at: " + positionOfCheck + " when getting positionOfCheck. Data set size: " + this.mDataSet.size());
                        return;
                    }
                    if (this.mDataSet.get(positionOfCheck).getMessagingChatMessage().getMessageType().equals((Object)MessagingChatMessage.MessageType.SYSTEM_RESOLVED)) {
                        LPLog.INSTANCE.d(TAG, "we do have the system resolved at " + positionOfCheck + ". So, we move the unreadIndicator to sequence " + (positionOfCheck + 1));
                        this.changeUnreadMessagePosition(positionOfCheck + 1);
                    }
                }
            }
        } else {
            if (tempAgentMsgCount == 1 && (!isUINotFocusOnLastItem || this.mDataSet.size() == 2) && newMessagesFromQuery) {
                int offset = this.lastMessageQuickReply() ? 1 : 0;
                int indexOfMessageBeforeUnread = this.mDataSet.size() - 1 - offset - tempAgentMsgCount;
                FullMessageRow row = this.getItem(indexOfMessageBeforeUnread);
                if (row != null && MessagingChatMessage.MessageType.isSystemResolved((MessagingChatMessage.MessageType)row.getMessagingChatMessage().getMessageType())) {
                    LPLog.INSTANCE.d(TAG, "exNotification after resolve so is not counted as unread");
                    this.mListener.onNewMessagesLoaded(indexOfMessageBeforeUnread + 1, offset + tempAgentMsgCount, 0);
                    return;
                }
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000100, "recyclerView data set is empty");
            }
            LPLog.INSTANCE.d(TAG_MERGE, "No unread message exists checking if need to create one tempAgentMsgCount= " + tempAgentMsgCount + " newMsgCount= " + newMsgCount + " isUINotFocusOnLastItem = " + isUINotFocusOnLastItem + " newMessagesFromQuery = " + newMessagesFromQuery);
            if (tempAgentMsgCount > 0 && (newMessagesFromQuery || isUINotFocusOnLastItem)) {
                if (positionOfFirstAgentItemInserted < this.mDataSet.size()) {
                    this.addUnreadMessage(tempAgentMsgCount, positionOfFirstAgentItemInserted);
                } else {
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000101, "Preventing an 'index out of bounds exception': index " + positionOfFirstAgentItemInserted + ", size " + this.mDataSet.size());
                }
            }
        }
    }

    private void moveIndexUnreadMessage(int position, int offset) {
        if (this.indexNumOfUnreadAgentMessage >= position) {
            this.indexNumOfUnreadAgentMessage += offset;
            LPLog.INSTANCE.d(TAG_MERGE, "move Index Unread Message by: " + offset + " new value: " + this.indexNumOfUnreadAgentMessage);
        }
    }

    private void changeUnreadMessagePosition(int firstUnreadAgentItemPosition) {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerView.get();
        if (recyclerView == null) {
            return;
        }
        if (this.numOfUnreadAgentMessages == 0) {
            LPLog.INSTANCE.d(TAG, "changeUnreadMessagePosition: numOfUnreadAgentMessages = 0");
            return;
        }
        this.removeItemFromDataSet(this.indexNumOfUnreadAgentMessage, "changeUnreadMessagePosition");
        if (--firstUnreadAgentItemPosition < 0 || firstUnreadAgentItemPosition >= this.mDataSet.size()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000102, "IndexOutOfBoundsException at: " + firstUnreadAgentItemPosition + " when getting firstUnreadAgentItemPosition. Data set size: " + this.mDataSet.size());
            return;
        }
        this.mUnreadMessagesMessage = FullMessageRow.generateUnreadIndicatorMessage((Context)recyclerView.getContext(), (int)this.numOfUnreadAgentMessages, (long)this.mDataSet.get(firstUnreadAgentItemPosition).getMessagingChatMessage().getTimeStamp());
        this.addMessageToDataSet(this.mUnreadMessagesMessage, firstUnreadAgentItemPosition, "changeUnreadMessagePosition");
        this.mListener.onItemMoved(this.indexNumOfUnreadAgentMessage, firstUnreadAgentItemPosition);
        LPLog.INSTANCE.d(TAG_MERGE, "moving already existed message from position - " + this.indexNumOfUnreadAgentMessage + " to position: " + firstUnreadAgentItemPosition + " with new value: " + this.numOfUnreadAgentMessages);
        this.indexNumOfUnreadAgentMessage = firstUnreadAgentItemPosition;
        this.mListener.onMessageUpdated(this.indexNumOfUnreadAgentMessage, FullMessageRow.getUnreadIndicatorMessageDiff((FullMessageRow)this.mUnreadMessagesMessage));
        this.notifyUnreadMessageChanges();
    }

    private void notifyUnreadMessageChanges() {
        String message = null;
        if (this.numOfUnreadAgentMessages != -1) {
            int lastAgentMessagePosition;
            for (lastAgentMessagePosition = this.mDataSet.size() - 1; lastAgentMessagePosition >= 0 && this.mDataSet.get(lastAgentMessagePosition).getMessagingChatMessage().isSystemMessageFromAgent(this.mAmsMessages.getMyUserId(this.mBrandId)); --lastAgentMessagePosition) {
            }
            if (lastAgentMessagePosition < 0) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000103, "IndexOutOfBoundsException at: " + lastAgentMessagePosition + " when getting lastAgentMessagePosition. Data set size: " + this.mDataSet.size());
                return;
            }
            FullMessageRow lastAgentItem = this.mDataSet.get(lastAgentMessagePosition);
            message = lastAgentItem.getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.AGENT_MARKDOWN_HYPERLINK ? HyperLinkUtils.INSTANCE.buildMessageString(lastAgentItem.getMessagingChatMessage().getMessage()) : (lastAgentItem.getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.COBROWSE ? this.mDataSet.get(lastAgentMessagePosition - 1).getMessagingChatMessage().getFormalMessage() : (lastAgentItem.getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES && lastAgentMessagePosition - 1 > 0 ? this.mDataSet.get(lastAgentMessagePosition - 1).getMessagingChatMessage().getFormalMessage() : lastAgentItem.getMessagingChatMessage().getFormalMessage()));
        }
        this.isNewMessageRead = false;
        this.mListener.notifyUnreadMessagesChanged(this.numOfUnreadAgentMessages, message, this.indexNumOfUnreadAgentMessage);
    }

    private void removeUnreadMessages() {
        LPLog.INSTANCE.d(TAG, "removeUnreadMessages: indexNumOfUnreadAgentMessage = " + this.indexNumOfUnreadAgentMessage);
        if (this.indexNumOfUnreadAgentMessage == -1) {
            return;
        }
        this.executeOnUI(new Runnable(){

            @Override
            public void run() {
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "removeUnreadMessages (in post): indexNumOfUnreadAgentMessage = " + MessagesAsListLoader.this.indexNumOfUnreadAgentMessage);
                if (MessagesAsListLoader.this.indexNumOfUnreadAgentMessage == -1) {
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG, "removeUnreadMessages (in post): indexNumOfUnreadAgentMessage already is -1");
                    return;
                }
                int indexToRemove = MessagesAsListLoader.this.mDataSet.indexOf(MessagesAsListLoader.this.mUnreadMessagesMessage);
                if (indexToRemove > -1) {
                    MessagesAsListLoader.this.removeItemFromDataSet(indexToRemove, "removeUnreadMessages");
                    MessagesAsListLoader.this.mListener.onItemRemoved(indexToRemove);
                    MessagesAsListLoader.this.indexNumOfUnreadAgentMessage = -1;
                    MessagesAsListLoader.this.mUnreadMessagesMessage = null;
                    MessagesAsListLoader.this.numOfUnreadAgentMessages = 0;
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG_MERGE, "Removing unread message");
                    MessagesAsListLoader.this.notifyUnreadMessageChanges();
                }
            }
        });
    }

    private void updateUnreadMessage(int tempAgentMsgCount, boolean wasLastMessageRead) {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerView.get();
        if (recyclerView == null) {
            return;
        }
        this.numOfUnreadAgentMessages += tempAgentMsgCount;
        if (this.indexNumOfUnreadAgentMessage < 0 || this.indexNumOfUnreadAgentMessage >= this.mDataSet.size()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000104, "IndexOutOfBoundsException at: " + this.indexNumOfUnreadAgentMessage + " when getting indexNumOfUnreadAgentMessage. Data set size: " + this.mDataSet.size());
            return;
        }
        boolean oldBannerRemoved = false;
        if (this.mDataSet.size() - (this.indexNumOfUnreadAgentMessage + this.numOfUnreadAgentMessages) > 1) {
            int numberOfSystemMessages = 0;
            for (int start = this.indexNumOfUnreadAgentMessage; start < this.mDataSet.size(); ++start) {
                if (this.mDataSet.get(start).getMessagingChatMessage().getMessageType().equals((Object)MessagingChatMessage.MessageType.UNREAD_INDICATOR)) {
                    LPLog.INSTANCE.d(TAG, "updateUnreadMessage: removing unread banner at position: " + start);
                    this.removeItemFromDataSet(start, "updateUnreadMessage");
                    this.mListener.onItemRemoved(start);
                    oldBannerRemoved = true;
                    continue;
                }
                if (!this.isControllerOrCobrowseMessage(this.mDataSet.get(start))) continue;
                ++numberOfSystemMessages;
            }
            this.indexNumOfUnreadAgentMessage = this.mDataSet.size() - this.numOfUnreadAgentMessages;
            if (!wasLastMessageRead) {
                this.indexNumOfUnreadAgentMessage -= numberOfSystemMessages;
            }
            if (this.lastMessageQuickReply()) {
                --this.indexNumOfUnreadAgentMessage;
            }
        }
        this.mUnreadMessagesMessage = FullMessageRow.generateUnreadIndicatorMessage((Context)recyclerView.getContext(), (int)this.numOfUnreadAgentMessages, (long)this.mDataSet.get(this.indexNumOfUnreadAgentMessage).getMessagingChatMessage().getTimeStamp());
        if (!oldBannerRemoved) {
            this.mDataSet.set(this.indexNumOfUnreadAgentMessage, this.mUnreadMessagesMessage);
            this.mListener.onMessageUpdated(this.indexNumOfUnreadAgentMessage, FullMessageRow.getUnreadIndicatorMessageDiff((FullMessageRow)this.mUnreadMessagesMessage));
            LPLog.INSTANCE.d(TAG_MERGE, "updating already existed unread message at position - " + this.indexNumOfUnreadAgentMessage + " with new value: " + this.numOfUnreadAgentMessages);
        } else {
            this.addMessageToDataSet(this.mUnreadMessagesMessage, this.indexNumOfUnreadAgentMessage, "addUnreadMessage");
            this.mListener.onNewUnreadMessages(this.indexNumOfUnreadAgentMessage, this.numOfUnreadAgentMessages);
            LPLog.INSTANCE.d(TAG_MERGE, "Adding new unread message at position - " + this.indexNumOfUnreadAgentMessage + " with value: " + this.numOfUnreadAgentMessages);
        }
        this.notifyUnreadMessageChanges();
    }

    private boolean isControllerOrCobrowseMessage(FullMessageRow row) {
        MessagingChatMessage message = row.getMessagingChatMessage();
        return message != null && (message.getMessageType().equals((Object)MessagingChatMessage.MessageType.CONTROLLER_SYSTEM) || message.getMessageType().equals((Object)MessagingChatMessage.MessageType.COBROWSE));
    }

    public boolean isItemAtPositionVisible(int itemPosition) {
        int firstVisibleItemPosition = this.mListener.getFirstVisibleItemPosition();
        int lastVisibleItemPosition = this.mListener.getLastVisibleItemPosition();
        LPLog.INSTANCE.d(TAG_MERGE, "isItemAtPositionVisible - firstVisibleItemPosition: " + firstVisibleItemPosition + " , lastVisibleItemPosition: " + lastVisibleItemPosition + " itemPosition: " + itemPosition);
        return lastVisibleItemPosition + 2 > itemPosition && firstVisibleItemPosition + 1 < itemPosition;
    }

    public boolean hasVisibleItems() {
        int firstVisibleItemPosition = this.mListener.getFirstVisibleItemPosition();
        int lastVisibleItemPosition = this.mListener.getLastVisibleItemPosition();
        return firstVisibleItemPosition > -1 && lastVisibleItemPosition > -1;
    }

    private void addUnreadMessage(int tempAgentMsgCount, int desiredIndex) {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerView.get();
        if (recyclerView == null) {
            return;
        }
        this.numOfUnreadAgentMessages = tempAgentMsgCount;
        this.indexNumOfUnreadAgentMessage = desiredIndex;
        if (this.indexNumOfUnreadAgentMessage < 0 || this.indexNumOfUnreadAgentMessage >= this.mDataSet.size()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000105, "IndexOutOfBoundsException at: " + this.indexNumOfUnreadAgentMessage + " when getting indexNumOfUnreadAgentMessage. Data set size: " + this.mDataSet.size());
            return;
        }
        this.mUnreadMessagesMessage = FullMessageRow.generateUnreadIndicatorMessage((Context)recyclerView.getContext(), (int)this.numOfUnreadAgentMessages, (long)this.mDataSet.get(this.indexNumOfUnreadAgentMessage).getMessagingChatMessage().getTimeStamp());
        this.addMessageToDataSet(this.mUnreadMessagesMessage, this.indexNumOfUnreadAgentMessage, "addUnreadMessage");
        this.mListener.onNewUnreadMessages(this.indexNumOfUnreadAgentMessage, this.numOfUnreadAgentMessages);
        LPLog.INSTANCE.d(TAG_MERGE, "Creating new unread message at position - " + this.indexNumOfUnreadAgentMessage + " with new value: " + this.numOfUnreadAgentMessages);
        this.notifyUnreadMessageChanges();
    }

    private int checkIfAllMessagesAreFromAgent(List<FullMessageRow> newMessages) {
        int tempUnreadAgentMessages = 0;
        String myUserId = this.mAmsMessages.getMyUserId(this.mBrandId);
        for (FullMessageRow message : newMessages) {
            if (MessagingChatMessage.MessageType.isAgent((MessagingChatMessage.MessageType)message.getMessagingChatMessage().getMessageType())) {
                boolean shouldIncreaseUnreadMessagesCount = message.getMessagingChatMessage().getMessageState().isReceivedMessageNotRead();
                if (shouldIncreaseUnreadMessagesCount &= message.getMessagingChatMessage().getServerSequence() != -5) {
                    LPLog.INSTANCE.d(TAG_MERGE, "checkIfAllMessagesAreFromAgent, item is NOT read. counter set to " + ++tempUnreadAgentMessages);
                    continue;
                }
                if (message.getMessagingChatMessage().isSystemMessageFromAgent(myUserId)) {
                    LPLog.INSTANCE.d(TAG_MERGE, "checkIfAllMessagesAreFromAgent, isSystemMessageFromAgent. keeping counter");
                    continue;
                }
                tempUnreadAgentMessages = 0;
                continue;
            }
            if (message.getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.CONTROLLER_SYSTEM) continue;
            tempUnreadAgentMessages = 0;
        }
        return tempUnreadAgentMessages;
    }

    private int addItem(FullMessageRow element, int index, boolean isNewMessageInDataSet, int tempAgentMsgCount) {
        if (MessagingChatMessage.MessageType.isAgent((MessagingChatMessage.MessageType)element.getMessagingChatMessage().getMessageType())) {
            LPLog.INSTANCE.d(TAG_MERGE, "add agent item at position " + index);
            this.addMessageToDataSet(element, index, "addItem");
            this.mListener.onNewAgentMessageReceived(index, element);
            if (isNewMessageInDataSet) {
                if (element.getMessagingChatMessage().getMessageState() == MessagingChatMessage.MessageState.READ) {
                    LPLog.INSTANCE.d(TAG_MERGE, "DO NOT Increase tempAgentMsgCount- cause message status is already read. ");
                } else {
                    LPLog.INSTANCE.d(TAG_MERGE, "Increasing tempAgentMsgCount = " + ++tempAgentMsgCount + " element.status = " + element.getMessagingChatMessage().getMessageState());
                }
            }
        } else {
            LPLog.INSTANCE.d(TAG_MERGE, "add item at position " + index);
            MessagingChatMessage.MessageType type = element.getMessagingChatMessage().getMessageType();
            OnMessageReadyCallback callback = type == MessagingChatMessage.MessageType.SYSTEM_RESOLVED ? row -> this.mListener.onAnnounceDialogResolvedMessage(row) : null;
            this.addMessageToDataSet(element, index, "addItem", callback);
            if (MessagingChatMessage.MessageType.isSystem((MessagingChatMessage.MessageType)element.getMessagingChatMessage().getMessageType())) {
                this.mListener.onNewSystemMessageAdded(index, element);
            } else if (MessagingChatMessage.MessageType.isConsumer((MessagingChatMessage.MessageType)element.getMessagingChatMessage().getMessageType())) {
                this.mListener.onNewUserMessageAdded(index);
            }
            if (isNewMessageInDataSet && tempAgentMsgCount > 0) {
                tempAgentMsgCount = 0;
                LPLog.INSTANCE.d(TAG_MERGE, "resetting tempAgentMsgCount = " + tempAgentMsgCount);
            }
        }
        return tempAgentMsgCount;
    }

    private void addMessageToDataSet(FullMessageRow message, int index, String methodName, @Nullable OnMessageReadyCallback callback) {
        this.resetResolveMessage(message, callback);
        if (this.isInsertionPositionCorrect(index)) {
            String originatorId = message.getMessagingChatMessage().getOriginatorId();
            String agentAvatarUrl = this.mAgentUrlsMap.get(originatorId);
            if (agentAvatarUrl != null) {
                message.setAgentAvatar(agentAvatarUrl);
            }
            this.mDataSet.add(index, message);
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000106, "IndexOutOfBoundsException at: " + index + " when adding an item. Data set size: " + this.mDataSet.size() + ". Method name: " + methodName);
        }
    }

    private void addMessageToDataSet(FullMessageRow message, int index, String methodName) {
        this.addMessageToDataSet(message, index, methodName, null);
    }

    private void addMultiMessageToDataSet(int index, List<FullMessageRow> collection, String methodName) {
        for (FullMessageRow newMessage : collection) {
            String originatorId = newMessage.getMessagingChatMessage().getOriginatorId();
            String agentAvatarUrl = this.mAgentUrlsMap.get(originatorId);
            if (agentAvatarUrl != null) {
                newMessage.setAgentAvatar(agentAvatarUrl);
            }
            this.resetResolveMessage(newMessage, null);
        }
        if (this.isInsertionPositionCorrect(index)) {
            this.mDataSet.addAll(index, collection);
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000107, "IndexOutOfBoundsException at: " + index + " when adding items. Data set size: " + this.mDataSet.size() + ". Method name: " + methodName);
        }
    }

    private void resetResolveMessage(FullMessageRow message, @Nullable OnMessageReadyCallback callback) {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerView.get();
        if (recyclerView == null) {
            return;
        }
        if (message.getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.SYSTEM_RESOLVED) {
            String dialogId = message.getMessagingChatMessage().getDialogId();
            MessagingFactory.getInstance().getController().amsDialogs.queryDialogById(dialogId).setPostQueryOnUI(data -> {
                if (data == null) {
                    return;
                }
                CloseReason closeReason = data.getCloseReason();
                String resolvedMsg = message.getMessagingChatMessage().getMessage();
                if (closeReason == CloseReason.CONSUMER) {
                    String resolvedByName = recyclerView.getContext().getString(R.string.lp_conversation_ended_by_you);
                    resolvedMsg = this.getResolveTextMessage(resolvedByName, message.getMessagingChatMessage().getTimeStamp(), null);
                } else if (closeReason == CloseReason.AGENT) {
                    resolvedMsg = !TextUtils.isEmpty((CharSequence)message.getAgentNickName()) ? recyclerView.getContext().getString(R.string.lp_conversation_ended_by_agent_with_name) : recyclerView.getContext().getString(R.string.lp_conversation_ended_by_agent_no_name);
                    resolvedMsg = this.getResolveTextMessage(resolvedMsg, message.getMessagingChatMessage().getTimeStamp(), message.getAgentNickName());
                }
                message.getMessagingChatMessage().setMessage(resolvedMsg);
                for (int i = 0; i < this.mDataSet.size(); ++i) {
                    if (this.mDataSet.get(i).getMessagingChatMessage().getMessageType() != MessagingChatMessage.MessageType.SYSTEM_RESOLVED) continue;
                    this.mListener.onMessageUpdated(i, null);
                }
                if (callback != null) {
                    callback.onMessageReady(message);
                }
            }).execute();
        }
    }

    private String getResolveTextMessage(String message, long timestamp, String agentName) {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerView.get();
        if (recyclerView == null) {
            return "";
        }
        String customFormat = recyclerView.getContext().getString(R.string.lp_date_time_format);
        DateFormat mFormatter = DateUtils.getDateFormat((String)customFormat, (int)3, (int)3);
        String time = mFormatter.format(new Date(timestamp));
        if (!TextUtils.isEmpty((CharSequence)agentName)) {
            return String.format(message, agentName, time);
        }
        return String.format(message, time);
    }

    private LPWelcomeMessage getWelcomeMessage() {
        Messaging controller = MessagingFactory.getInstance().getController();
        WelcomeMessageManager welcomeMessageManager = controller.getWelcomeMessageManager();
        if (welcomeMessageManager == null) {
            return controller.getConversationViewParams().getLpWelcomeMessage();
        }
        return welcomeMessageManager.getWelcomeMessage(this.mBrandId);
    }

    private void addWelcomeMessageToDataSet(FullMessageRow row, LPWelcomeMessage welcomeMessage, AmsMessages.MessagesListener.OnWelcomeMessageShownCallback callback) {
        int index;
        if (row.getMessagingChatMessage().getMessageState() == MessagingChatMessage.MessageState.OFFLINE && !this.lastMessageQuickReplyFromWelcomeMessage() && !this.lastMessageWelcomeMessage()) {
            this.addWelcomeMessageToIndex(this.mDataSet.size(), row, welcomeMessage);
            callback.onWelcomeMessageShown(true);
            return;
        }
        int itemsToRemove = 0;
        int indexToInsert = 0;
        for (index = this.mDataSet.size() - 1; index > 0; --index) {
            MessagingChatMessage message = this.mDataSet.get(index).getMessagingChatMessage();
            if (message.getMessageType().equals((Object)MessagingChatMessage.MessageType.LOADING) || message.getMessageType().equals((Object)MessagingChatMessage.MessageType.DATE_HEADER)) continue;
            if (message.getMessageType().equals((Object)MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES)) {
                MessagingChatMessage previousMessage = this.mDataSet.get(index - 1).getMessagingChatMessage();
                if (previousMessage.getServerSequence() == -4) {
                    itemsToRemove = 2;
                    indexToInsert = index - 1;
                    break;
                }
                return;
            }
            if (message.getServerSequence() == -4) {
                itemsToRemove = 1;
                indexToInsert = index;
                break;
            }
            itemsToRemove = 0;
            indexToInsert = index + 1;
            break;
        }
        for (index = 0; index < itemsToRemove; ++index) {
            this.mDataSet.remove(indexToInsert);
            this.mListener.onItemRemoved(indexToInsert);
        }
        if (welcomeMessage.getMessageFrequency() == LPWelcomeMessage.MessageFrequency.EVERY_CONVERSATION) {
            this.addWelcomeMessageToIndex(indexToInsert, row, welcomeMessage);
            callback.onWelcomeMessageShown(true);
        } else if (this.isDataSetHasOnlyWelcomeMessageOrEmpty()) {
            FullMessageRow currentRow = this.getItem(indexToInsert);
            if (currentRow != null && currentRow.getMessagingChatMessage().getMessageType().equals((Object)MessagingChatMessage.MessageType.DATE_HEADER)) {
                ++indexToInsert;
            }
            this.addWelcomeMessageToIndex(indexToInsert, row, welcomeMessage);
            callback.onWelcomeMessageShown(true);
        } else {
            callback.onWelcomeMessageShown(false);
        }
    }

    private void addWelcomeMessageToIndex(int index, FullMessageRow row, LPWelcomeMessage welcomeMessage) {
        this.addItem(row, index, true, 0);
        QuickRepliesMessageHolder.updateQuickReplies((String)this.mBrandId, (String)welcomeMessage.getQuickReplies(this.isConnectionAvailable));
        this.mAmsMessages.resetQuickRepliesMessageHolder();
        this.addQuickRepliesMessage(false);
        this.setupDateHeaders();
    }

    private boolean isDataSetHasOnlyWelcomeMessageOrEmpty() {
        ArrayList<FullMessageRow> rows = this.mDataSet;
        for (int i = rows.size() - 1; i > 0; --i) {
            FullMessageRow row = (FullMessageRow)rows.get(i);
            MessagingChatMessage.MessageType type = row.getMessagingChatMessage().getMessageType();
            if (type == MessagingChatMessage.MessageType.LOADING || !MessagingChatMessage.MessageType.isAgent((MessagingChatMessage.MessageType)type) && !MessagingChatMessage.MessageType.isConsumer((MessagingChatMessage.MessageType)type)) continue;
            return false;
        }
        return true;
    }

    private LPWelcomeMessage.MessageFrequency getWelcomeMessageFrequency() {
        Messaging controller = MessagingFactory.getInstance().getController();
        WelcomeMessageManager welcomeMessageManager = controller.getWelcomeMessageManager();
        if (welcomeMessageManager == null) {
            return controller.getConversationViewParams().getLpWelcomeMessage().getMessageFrequency();
        }
        return welcomeMessageManager.getWelcomeMessageFrequency(this.mBrandId);
    }

    public void removeItemFromDataSet(int index, String methodName) {
        if (index < this.mDataSet.size() && index >= 0) {
            FullMessageRow fullMessageRow = this.mDataSet.remove(index);
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000108, "IndexOutOfBoundsException at: " + index + " when removing item. Data set size: " + this.mDataSet.size() + ". Method name: " + methodName);
        }
    }

    private void removeAllMessages(boolean addFirstMessage) {
        this.executeOnUI(() -> {
            int itemCount = this.mDataSet.size();
            this.mDataSet.clear();
            this.mDateHeaderHelper.clearDateHeaders();
            this.indexNumOfUnreadAgentMessage = -1;
            this.numOfUnreadAgentMessages = 0;
            this.mListener.onClearAllMessages(0, itemCount);
            if (addFirstMessage) {
                this.addFirstMessage();
            }
        });
    }

    private synchronized void setupDateHeaders() {
        this.mDateHeaderHelper.observeHeaderChanging(this.mDataSet, this);
    }

    private void executeOnUI(Runnable runnable) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            RecyclerView recyclerView = (RecyclerView)this.mRecyclerView.get();
            if (recyclerView == null) {
                LPLog.INSTANCE.d(TAG, "Can not execute runnable, reference to recycle view was cleared");
            } else {
                recyclerView.post(runnable);
            }
        }
    }

    private void announce(@NonNull ChatMessageListRecyclerView recyclerView, @StringRes int resourceId) {
        this.announce(recyclerView, recyclerView.getResources().getString(resourceId));
    }

    private void announce(@NonNull ChatMessageListRecyclerView recyclerView, CharSequence message) {
        AccessibilityAnnouncer announcer = recyclerView.getAnnouncer();
        if (announcer != null) {
            announcer.announce(message);
        }
    }

    private void updateWelcomeMessageForDialogId(String dialogId, FullMessageRow welcomeMessageRow) {
        MessagingChatMessage welcomeMessage = welcomeMessageRow.getMessagingChatMessage();
        this.executeOnUI(() -> {
            MessagingChatMessage message;
            int index;
            for (index = 0; index < this.mDataSet.size() && !TextUtils.equals((CharSequence)(message = this.mDataSet.get(index).getMessagingChatMessage()).getDialogId(), (CharSequence)dialogId); ++index) {
            }
            if (index - 1 >= 0) {
                this.tryUpdateLocalWelcomeMessageByIndex(index - 1, welcomeMessage, false);
            } else if (index - 2 >= 0) {
                this.tryUpdateLocalWelcomeMessageByIndex(index - 2, welcomeMessage, false);
            }
        });
    }

    private void updateTemporalWelcomeMessage(FullMessageRow welcomeMessageRow) {
        this.executeOnUI(() -> {
            for (int index = this.mDataSet.size() - 1; index > 0; --index) {
                MessagingChatMessage message = this.mDataSet.get(index).getMessagingChatMessage();
                if (!message.getDialogId().equals("KEY_WELCOME_DIALOG_ID") || message.getServerSequence() != -4) continue;
                this.tryUpdateLocalWelcomeMessageByIndex(index, welcomeMessageRow.getMessagingChatMessage(), true);
                break;
            }
        });
    }

    private void tryUpdateLocalWelcomeMessageByIndex(int index, MessagingChatMessage welcomeMessage, boolean forceUpdate) {
        FullMessageRow row = this.mDataSet.get(index);
        MessagingChatMessage message = row.getMessagingChatMessage();
        if (message.getServerSequence() == -4) {
            if (TextUtils.equals((CharSequence)message.getMessage(), (CharSequence)welcomeMessage.getMessage())) {
                message.setDialogId(welcomeMessage.getDialogId());
                message.setTimeStamp(welcomeMessage.getTimeStamp());
            } else if (forceUpdate) {
                message.setMessage(welcomeMessage.getMessage());
                message.setDialogId(welcomeMessage.getDialogId());
                message.setTimeStamp(welcomeMessage.getTimeStamp());
                Bundle changes = new Bundle();
                changes.putString("EXTRA_MESSAGE_TEXT", welcomeMessage.getMessage());
                this.mListener.onMessageUpdated(index, new Bundle());
            }
            if (index + 1 <= this.mDataSet.size() - 1 && (message = this.mDataSet.get(index + 1).getMessagingChatMessage()).getMessageType() == MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES) {
                message.setTimeStamp(welcomeMessage.getTimeStamp() + 1L);
            }
        }
    }

    private int getPositionByEventId(String eventId) {
        for (int i = this.mDataSet.size() - 1; i > 0; --i) {
            MessagingChatMessage message = this.mDataSet.get(i).getMessagingChatMessage();
            if (!message.getEventId().equals(eventId)) continue;
            return i;
        }
        return -1;
    }

    private int getPositionToInsert(long timestamp) {
        int start = 0;
        int end = this.mDataSet.size() - 1;
        while (start < end) {
            int middle = (start + end) / 2;
            MessagingChatMessage message = this.mDataSet.get(middle).getMessagingChatMessage();
            int newerThan = Long.compare(timestamp, message.getTimeStamp());
            if (newerThan == 1) {
                start = middle + 1;
                continue;
            }
            if (newerThan == -1) {
                end = middle;
                continue;
            }
            if (newerThan != 0) continue;
            LPLog.INSTANCE.d(TAG, "The same! returning position middle = " + middle);
            return middle;
        }
        LPLog.INSTANCE.d(TAG, "Returning start = " + start);
        return start;
    }

    private void reorderMessage(String eventId, long timestamp) {
        this.executeOnUI(() -> {
            RecyclerView recyclerView = (RecyclerView)this.mRecyclerView.get();
            if (recyclerView == null) {
                return;
            }
            int oldPosition = this.getPositionByEventId(eventId);
            if (oldPosition != -1) {
                FullMessageRow row = this.mDataSet.remove(oldPosition);
                MessagingChatMessage message = row.getMessagingChatMessage();
                ArrayList<FullMessageRow> rows = new ArrayList<FullMessageRow>();
                if (message.getServerSequence() == -4) {
                    MessagingChatMessage nextChatMessage;
                    message.setTimeStamp(timestamp);
                    FullMessageRow nextMessage = this.getItem(oldPosition);
                    if (nextMessage != null && (nextChatMessage = nextMessage.getMessagingChatMessage()).getMessageType().equals((Object)MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES)) {
                        nextChatMessage.setTimeStamp(timestamp + 1L);
                    }
                    this.mListener.onItemRemoved(oldPosition);
                    rows.add(row);
                } else if (MessagingChatMessage.MessageType.isConsumerMaskedMessage((MessagingChatMessage.MessageType)message.getMessageType())) {
                    message.setTimeStamp(timestamp);
                    FullMessageRow maskedMessageRow = this.mDataSet.remove(oldPosition);
                    MessagingChatMessage maskedMessage = maskedMessageRow.getMessagingChatMessage();
                    maskedMessage.setTimeStamp(timestamp + 1L);
                    this.mListener.onItemRemoved(oldPosition);
                    this.mListener.onItemRemoved(oldPosition);
                    rows.add(row);
                    rows.add(maskedMessageRow);
                } else if (timestamp > message.getTimeStamp()) {
                    message.setTimeStamp(timestamp);
                    this.mListener.onItemRemoved(oldPosition);
                    rows.add(row);
                } else {
                    this.mDataSet.add(oldPosition, row);
                    return;
                }
                this.merge(rows, false);
            }
        });
    }

    private boolean shouldShowQuickReplies(MessagingChatMessage message) {
        if (message == null) {
            return false;
        }
        Messaging controller = MessagingFactory.getInstance().getController();
        if (controller == null) {
            return false;
        }
        OfflineMessagingManager offlineMessagingManager = controller.getOfflineManager();
        if (offlineMessagingManager == null) {
            return false;
        }
        AmsDialogs amsDialogs = controller.amsDialogs;
        if (amsDialogs == null) {
            return false;
        }
        Dialog dialog = amsDialogs.getActiveDialog();
        if (dialog == null) {
            return false;
        }
        return !offlineMessagingManager.isSubscribedToActiveDialog() && offlineMessagingManager.isOfflineModeEnabled() && offlineMessagingManager.shouldShowPCSOptions() && dialog.getDialogType() == DialogType.POST_SURVEY && message.getDialogId().equals(dialog.getDialogId());
    }

    public static interface OnListUpdated {
        public void onNewAgentMessageReceived(int var1, FullMessageRow var2);

        public void onQuickRepliesMessageReceived();

        public void onNewUserMessageAdded(int var1);

        public void onNewSystemMessageAdded(int var1, FullMessageRow var2);

        public void onHistoryLoaded(int var1, int var2, boolean var3);

        public void onNewMessagesLoaded(int var1, int var2, int var3);

        public void onMessageUpdated(int var1, Bundle var2);

        public void onClearAllMessages(int var1, int var2);

        public void onItemAdded(int var1);

        public void onAnnounceDialogResolvedMessage(FullMessageRow var1);

        public void onItemRemoved(int var1);

        public void onItemMoved(int var1, int var2);

        public int getFirstVisibleItemPosition();

        public int getLastVisibleItemPosition();

        public void notifyUnreadMessagesChanged(int var1, String var2, int var3);

        public void onNewUnreadMessages(int var1, int var2);

        public int getLoadLimit();
    }

    public class LoadingMessagesHandler {
        public static final int SECOND_PHASE_DELAY_MILLIS = 10000;
        public static final int FIRST_PHASE_DELAY_MILLIS = 1000;
        private int indexLoadingNewMessages = -1;
        private int indexLoadingHistory = -1;
        private ArrayDeque<FullMessageRow> activeHistoryLoadings = new ArrayDeque();
        private ArrayDeque<FullMessageRow> activeNewMessagesLoadings = new ArrayDeque();
        private Runnable loadNewMessages1 = null;
        private Runnable loadNewMessages2 = null;

        int getNumOfLoadingShown() {
            return this.activeHistoryLoadings.size() + this.activeNewMessagesLoadings.size();
        }

        private void showLoadingForNewMessages() {
            MessagesAsListLoader.this.removeEmptyState();
            if (Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled)) {
                return;
            }
            ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)MessagesAsListLoader.this.mRecyclerView.get();
            if (this.loadNewMessages1 == null && this.activeHistoryLoadings.isEmpty() && recyclerView != null) {
                this.loadNewMessages1 = new LoadingNewMessagesRunnableFirstPhase();
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "show loading for NewMessages- setting timer for 1 second.");
                recyclerView.postDelayed(this.loadNewMessages1, 1000L);
            }
        }

        private void removeLoadingForNewMessages() {
            ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)MessagesAsListLoader.this.mRecyclerView.get();
            if (this.loadNewMessages1 != null) {
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "cancelling loading for NewMessages- before timer expired.");
                if (recyclerView != null) {
                    recyclerView.removeCallbacks(this.loadNewMessages1);
                }
                this.loadNewMessages1 = null;
            }
            if (this.loadNewMessages2 != null) {
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "cancelling loading for NewMessages- before timer expired.");
                if (recyclerView != null) {
                    recyclerView.removeCallbacks(this.loadNewMessages2);
                }
                if (MessagesAsListLoader.this.mDataSet.size() == this.indexLoadingNewMessages) {
                    LPLog.INSTANCE.w(MessagesAsListLoader.TAG, "Prevented issue LE-94391");
                }
                this.loadNewMessages2 = null;
            }
            MessagesAsListLoader.this.executeOnUI(() -> {
                if (this.indexLoadingNewMessages > -1) {
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "remove loading for NewMessages");
                    this.activeNewMessagesLoadings.remove();
                    MessagesAsListLoader.this.removeItemFromDataSet(this.indexLoadingNewMessages, "removeLoadingForNewMessages");
                    if (recyclerView != null) {
                        MessagesAsListLoader.this.announce(recyclerView, R.string.lp_accessibility_loaded_messages);
                    }
                    MessagesAsListLoader.this.mListener.onItemRemoved(this.indexLoadingNewMessages);
                    this.indexLoadingNewMessages = -1;
                }
            });
        }

        private void showLoadingForHistory() {
            MessagesAsListLoader.this.removeEmptyState();
            MessagesAsListLoader.this.executeOnUI(() -> {
                ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)MessagesAsListLoader.this.mRecyclerView.get();
                if (this.indexLoadingHistory == -1 && recyclerView != null) {
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "show loading for history");
                    long timeStamp = MessagesAsListLoader.this.mDataSet.isEmpty() ? System.currentTimeMillis() : ((FullMessageRow)MessagesAsListLoader.this.mDataSet.get(0)).getMessagingChatMessage().getTimeStamp() - 1L;
                    String message = recyclerView.getContext().getString(R.string.lp_still_loading_message);
                    FullMessageRow loadingMessage = FullMessageRow.getLoadingHistoryIndicatorMessage((long)timeStamp, (String)message);
                    this.activeHistoryLoadings.add(loadingMessage);
                    if (MessagesAsListLoader.this.mDataSet.size() > 1 || !Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled)) {
                        this.indexLoadingHistory = 0;
                        MessagesAsListLoader.this.addMessageToDataSet(loadingMessage, this.indexLoadingHistory, "showLoadingForHistory");
                        MessagesAsListLoader.this.mListener.onNewMessagesLoaded(this.indexLoadingHistory, 1, 0);
                    }
                    MessagesAsListLoader.this.moveIndexUnreadMessage(0, 1);
                    MessagesAsListLoader.this.announce(recyclerView, R.string.lp_accessibility_still_loading_messages);
                }
            });
        }

        private void restoreHistoryLoadingIndexIfPresent() {
            for (FullMessageRow fullMessageRow : MessagesAsListLoader.this.mDataSet) {
                if (fullMessageRow.getMessagingChatMessage().getMessageType() != MessagingChatMessage.MessageType.LOADING) continue;
                this.indexLoadingHistory = MessagesAsListLoader.this.mDataSet.indexOf(fullMessageRow);
                break;
            }
        }

        private void removeLoadingForHistory() {
            MessagesAsListLoader.this.executeOnUI(() -> {
                LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "remove loading for history =  indexLoadingHistory = " + this.indexLoadingHistory);
                if (MessagesAsListLoader.this.mDataSet.size() > this.indexLoadingHistory && this.indexLoadingHistory > -1 || this.activeHistoryLoadings.size() > 0) {
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "remove loading for history");
                    int index = MessagesAsListLoader.this.mDataSet.indexOf(this.activeHistoryLoadings.peek());
                    if (index == -1) {
                        if (!MessagesAsListLoader.this.mDataSet.isEmpty() && MessagesAsListLoader.this.getMessageType((FullMessageRow)MessagesAsListLoader.this.mDataSet.get(0)) == MessagingChatMessage.MessageType.LOADING) {
                            index = 0;
                        } else {
                            return;
                        }
                    }
                    this.forceRemoveLoadingForHistory(index);
                }
            });
        }

        private void forceRemoveLoadingForHistory(int index) {
            ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)MessagesAsListLoader.this.mRecyclerView.get();
            LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "remove loading for history activeHistoryLoadings.size() = " + this.activeHistoryLoadings.size());
            this.activeHistoryLoadings.poll();
            MessagesAsListLoader.this.removeItemFromDataSet(index, "forceRemoveLoadingHistory");
            if (recyclerView != null) {
                MessagesAsListLoader.this.announce(recyclerView, R.string.lp_accessibility_loaded_messages);
            }
            MessagesAsListLoader.this.mListener.onItemRemoved(index);
            this.indexLoadingHistory = -1;
            MessagesAsListLoader.this.moveIndexUnreadMessage(0, -1);
        }

        private class LoadingNewMessagesRunnableFirstPhase
        implements Runnable {
            private LoadingNewMessagesRunnableFirstPhase() {
            }

            @Override
            public void run() {
                ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)MessagesAsListLoader.this.mRecyclerView.get();
                if (recyclerView == null) {
                    return;
                }
                if (LoadingMessagesHandler.this.indexLoadingNewMessages == -1 && LoadingMessagesHandler.this.loadNewMessages1 == this) {
                    LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "show loading for NewMessages- first phase. timers expired.");
                    long timeStamp = MessagesAsListLoader.this.mDataSet.isEmpty() ? System.currentTimeMillis() : ((FullMessageRow)MessagesAsListLoader.this.mDataSet.get(MessagesAsListLoader.this.mDataSet.size() - 1)).getMessagingChatMessage().getTimeStamp() + 1L;
                    FullMessageRow loadingMessage = FullMessageRow.getLoadingIndicatorMessage((Context)recyclerView.getContext(), (long)timeStamp, (boolean)false);
                    LoadingMessagesHandler.this.activeNewMessagesLoadings.add(loadingMessage);
                    LoadingMessagesHandler.this.indexLoadingNewMessages = MessagesAsListLoader.this.mDataSet.size();
                    if (LoadingMessagesHandler.this.indexLoadingNewMessages > 1 || !Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled)) {
                        MessagesAsListLoader.this.addMessageToDataSet(loadingMessage, LoadingMessagesHandler.this.indexLoadingNewMessages, "showLoadingForNewMessages");
                        MessagesAsListLoader.this.announce(recyclerView, R.string.lp_accessibility_loading_messages);
                        MessagesAsListLoader.this.mListener.onNewMessagesLoaded(LoadingMessagesHandler.this.indexLoadingNewMessages, 1, 0);
                        LoadingMessagesHandler.this.loadNewMessages2 = new LoadingNewMessagesRunnableSecondPhase();
                        LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "show loading for NewMessages- setting timer for 10 second.");
                        recyclerView.postDelayed(LoadingMessagesHandler.this.loadNewMessages2, 10000L);
                    }
                }
            }
        }

        private class LoadingNewMessagesRunnableSecondPhase
        implements Runnable {
            private LoadingNewMessagesRunnableSecondPhase() {
            }

            @Override
            public void run() {
                ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)MessagesAsListLoader.this.mRecyclerView.get();
                if (recyclerView == null) {
                    return;
                }
                if (LoadingMessagesHandler.this.indexLoadingNewMessages != -1 && LoadingMessagesHandler.this.loadNewMessages2 == this) {
                    if (LoadingMessagesHandler.this.indexLoadingNewMessages >= 1 && LoadingMessagesHandler.this.indexLoadingNewMessages < MessagesAsListLoader.this.mDataSet.size()) {
                        LPLog.INSTANCE.d(MessagesAsListLoader.TAG_LOAD, "show loading for NewMessages- second phase. showing text with loading. timers expired.");
                        long originalLoadingMessageTimestamp = ((FullMessageRow)MessagesAsListLoader.this.mDataSet.get(LoadingMessagesHandler.this.indexLoadingNewMessages)).getMessagingChatMessage().getTimeStamp();
                        FullMessageRow loadingMessage = FullMessageRow.getLoadingIndicatorMessage((Context)recyclerView.getContext(), (long)originalLoadingMessageTimestamp, (boolean)true);
                        LoadingMessagesHandler.this.activeNewMessagesLoadings.remove();
                        LoadingMessagesHandler.this.activeNewMessagesLoadings.add(loadingMessage);
                        MessagesAsListLoader.this.mDataSet.set(LoadingMessagesHandler.this.indexLoadingNewMessages, loadingMessage);
                        MessagesAsListLoader.this.announce(recyclerView, R.string.lp_accessibility_still_loading_messages);
                        MessagesAsListLoader.this.mListener.onMessageUpdated(LoadingMessagesHandler.this.indexLoadingNewMessages, FullMessageRow.getLoadingIndicatorMessageDiff((Context)recyclerView.getContext()));
                        LoadingMessagesHandler.this.loadNewMessages2 = null;
                    } else {
                        LPLog.INSTANCE.e(MessagesAsListLoader.TAG, ErrorCode.ERR_000000FB, "IndexOutOfBoundsException at: " + LoadingMessagesHandler.this.indexLoadingNewMessages + " when getting item. Data set size: " + MessagesAsListLoader.this.mDataSet.size());
                    }
                }
            }
        }
    }

    private static interface OnMessageReadyCallback {
        public void onMessageReady(FullMessageRow var1);
    }
}

