/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils;

import android.content.Context;
import android.os.Build;
import android.view.View;
import androidx.core.view.ViewCompat;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.lp_structured_content.utils.StructuredContentAccessibilityUtilsKt;
import com.liveperson.messaging.model.MessagingChatMessage;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u001a\u0010\u0002\u001a\u00020\u0001*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"TAG", "", "getAccessibilityMessage", "Lcom/liveperson/messaging/model/MessagingChatMessage;", "accessibilityText", "context", "Landroid/content/Context;", "markAsAccessibilityHeading", "", "Landroid/view/View;", "isHeading", "", "messaging_ui_release"})
public final class AccessbilityUtilsKt {
    @NotNull
    private static final String TAG = "AccessibilityUtils";

    @NotNull
    public static final String getAccessibilityMessage(@NotNull MessagingChatMessage $this$getAccessibilityMessage, @NotNull String accessibilityText, @NotNull Context context) {
        String accessibilityMessage;
        String string2;
        String string3;
        Intrinsics.checkNotNullParameter((Object)$this$getAccessibilityMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)accessibilityText, (String)"accessibilityText");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MessagingChatMessage.MessageType messageType = $this$getAccessibilityMessage.getMessageType();
        switch (messageType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
            case 1: {
                Object $this$getAccessibilityMessage_u24lambda_u2d0;
                Object object2 = $this$getAccessibilityMessage;
                try {
                    $this$getAccessibilityMessage_u24lambda_u2d0 = object2;
                    boolean bl = false;
                    $this$getAccessibilityMessage_u24lambda_u2d0 = Result.constructor-impl((Object)(new JSONObject($this$getAccessibilityMessage_u24lambda_u2d0.getMessage()).getString("title") + ". " + accessibilityText));
                }
                catch (Throwable bl) {
                    $this$getAccessibilityMessage_u24lambda_u2d0 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = $this$getAccessibilityMessage_u24lambda_u2d0;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Object it = $this$getAccessibilityMessage_u24lambda_u2d0 = throwable;
                    boolean bl = false;
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000A2, "JSONException while unpacking Agent Form.", (Throwable)it);
                }
                string3 = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
                break;
            }
            case 2: {
                Object object;
                Object object2 = $this$getAccessibilityMessage;
                try {
                    MessagingChatMessage $this$getAccessibilityMessage_u24lambda_u2d2 = object2;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)StructuredContentAccessibilityUtilsKt.getSCAccessibilityAnnounce((JSONObject)new JSONObject($this$getAccessibilityMessage_u24lambda_u2d2.getMessage()), (Context)context));
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Object it = object = throwable;
                    boolean bl = false;
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000A2, "JSONException while unpacking Structure content.", (Throwable)it);
                }
                string3 = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
                break;
            }
            case 3: {
                string3 = $this$getAccessibilityMessage.getMessage() + ". " + accessibilityText;
                break;
            }
            case 4: {
                string3 = accessibilityText;
                break;
            }
            default: {
                string3 = $this$getAccessibilityMessage.getMessage();
            }
        }
        if ((string2 = (accessibilityMessage = string3)) == null) {
            string2 = "";
        }
        return string2;
    }

    public static final void markAsAccessibilityHeading(@NotNull View $this$markAsAccessibilityHeading, boolean isHeading) {
        Intrinsics.checkNotNullParameter((Object)$this$markAsAccessibilityHeading, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 28) {
            $this$markAsAccessibilityHeading.setAccessibilityHeading(isHeading);
        } else {
            ViewCompat.setAccessibilityHeading((View)$this$markAsAccessibilityHeading, (boolean)isHeading);
        }
    }

    public static /* synthetic */ void markAsAccessibilityHeading$default(View view, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        AccessbilityUtilsKt.markAsAccessibilityHeading(view, bl);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessagingChatMessage.MessageType.values().length];
            nArray[MessagingChatMessage.MessageType.AGENT_FORM.ordinal()] = 1;
            nArray[MessagingChatMessage.MessageType.AGENT_STRUCTURED_CONTENT.ordinal()] = 2;
            nArray[MessagingChatMessage.MessageType.AGENT_URL.ordinal()] = 3;
            nArray[MessagingChatMessage.MessageType.AGENT_MARKDOWN_HYPERLINK.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

