/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils;

import android.content.Context;
import android.text.TextUtils;
import android.widget.ImageView;
import android.widget.Toast;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.ConversationViewCallback;
import com.liveperson.infra.messaging_ui.utils.StringUtils;
import com.liveperson.infra.ui.view.utils.picasso.CircleTransform;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.lpappointmentscheduler.AppointmentSchedulerOperations;
import com.liveperson.lpappointmentscheduler.LPAppointmentScheduler;
import com.liveperson.lpappointmentscheduler.logger.AppointmentSchedulerLog;
import com.liveperson.lpappointmentscheduler.logger.LogLevel;
import com.liveperson.lpappointmentscheduler.models.AppointmentSlot;
import com.liveperson.lpappointmentscheduler.models.LPAppointmentInfo;
import com.liveperson.messaging.MessagingFactory;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Transformation;
import java.lang.ref.WeakReference;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u001a\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u001f\u001a\u00020\u0014H\u0002J\u0006\u0010 \u001a\u00020\u0014R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00030\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006!"}, d2={"Lcom/liveperson/infra/messaging_ui/utils/LPAppointmentSchedulerHandler;", "Lcom/liveperson/lpappointmentscheduler/AppointmentSchedulerOperations;", "context", "Landroid/content/Context;", "brandId", "", "(Landroid/content/Context;Ljava/lang/String;)V", "TAG", "appointmentSchedulerLog", "Lcom/liveperson/lpappointmentscheduler/logger/AppointmentSchedulerLog;", "contextRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "conversationViewCallback", "Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;", "getConversationViewCallback", "()Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;", "setConversationViewCallback", "(Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;)V", "initializeAppointmentScheduler", "", "data", "Lorg/json/JSONObject;", "onAppointmentConfirmed", "appointment", "Lcom/liveperson/lpappointmentscheduler/models/AppointmentSlot;", "onAppointmentSchedulerClosed", "startImageLoading", "imageView", "Landroid/widget/ImageView;", "imageUrl", "subscribeToAppointmentLogs", "unSubscribeToAppointmentLogs", "messaging_ui_release"})
public final class LPAppointmentSchedulerHandler
implements AppointmentSchedulerOperations {
    @NotNull
    private final String brandId;
    @NotNull
    private final String TAG;
    @NotNull
    private final AppointmentSchedulerLog appointmentSchedulerLog;
    @NotNull
    private final WeakReference<Context> contextRef;
    @Nullable
    private ConversationViewCallback conversationViewCallback;

    public LPAppointmentSchedulerHandler(@NotNull Context context, @NotNull String brandId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        this.brandId = brandId;
        this.TAG = "LPAppointmentSchedulerHandler";
        this.contextRef = new WeakReference<Context>(context);
        this.appointmentSchedulerLog = new AppointmentSchedulerLog(){

            public void log(@NotNull LogLevel level, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1: {
                        LPLog.INSTANCE.v(TAG, message);
                        break;
                    }
                    case 2: {
                        LPLog.INSTANCE.i(TAG, message);
                        break;
                    }
                    case 3: {
                        LPLog.INSTANCE.w(TAG, message);
                        break;
                    }
                    case 4: {
                        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000155, message);
                        break;
                    }
                    case 5: {
                        LPLog.INSTANCE.d(TAG, message);
                        break;
                    }
                    default: {
                        LPLog.INSTANCE.d(TAG, message);
                    }
                }
            }

            @Metadata(mv={1, 6, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[LogLevel.values().length];
                    nArray[LogLevel.VERBOSE.ordinal()] = 1;
                    nArray[LogLevel.INFO.ordinal()] = 2;
                    nArray[LogLevel.WARNING.ordinal()] = 3;
                    nArray[LogLevel.ERROR.ordinal()] = 4;
                    nArray[LogLevel.DEBUG.ordinal()] = 5;
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        };
        this.subscribeToAppointmentLogs();
    }

    @Nullable
    public final ConversationViewCallback getConversationViewCallback() {
        return this.conversationViewCallback;
    }

    public final void setConversationViewCallback(@Nullable ConversationViewCallback conversationViewCallback) {
        this.conversationViewCallback = conversationViewCallback;
    }

    private final void subscribeToAppointmentLogs() {
        LPAppointmentScheduler.Companion.subscribeToLogs(this.appointmentSchedulerLog);
    }

    public final void unSubscribeToAppointmentLogs() {
        LPLog.INSTANCE.i(this.TAG, "unSubscribeToAppointmentLogs");
        LPAppointmentScheduler.Companion.unSubscribeToLogs(this.appointmentSchedulerLog);
    }

    public final void initializeAppointmentScheduler(@NotNull JSONObject data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Context is not initialized");
            return;
        }
        Context context2 = context;
        try {
            LPAppointmentInfo info = LPAppointmentScheduler.Companion.initialize(context2, data, (AppointmentSchedulerOperations)this);
            if (info != null && !info.getAppointmentSlots().isEmpty()) {
                Unit unit;
                ConversationViewCallback conversationViewCallback = this.conversationViewCallback;
                if (conversationViewCallback != null) {
                    conversationViewCallback.onAppointmentSchedulerRequested(info);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to load AppointmentScheduler. conversationViewCallback is null");
                }
            } else {
                Object object = info;
                boolean bl = object != null && (object = object.getAppointmentSlots()) != null ? object.isEmpty() : false;
                if (bl) {
                    Toast.makeText((Context)context2, (int)R.string.lpmessaging_appointment_no_slots_error_message, (int)0).show();
                    LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to load AppointmentScheduler. No appointments available");
                } else {
                    Toast.makeText((Context)context2, (int)R.string.lpmessaging_general_error_message, (int)0).show();
                    LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to load AppointmentScheduler. LPAppointmentInfo is null");
                }
            }
        }
        catch (Exception error) {
            Toast.makeText((Context)context2, (int)R.string.lpmessaging_general_error_message, (int)0).show();
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to initialize AppointmentScheduler. " + error);
        }
    }

    public void onAppointmentConfirmed(@NotNull AppointmentSlot appointment) {
        Intrinsics.checkNotNullParameter((Object)appointment, (String)"appointment");
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Context is not initialized");
            return;
        }
        Context context2 = context;
        LPLog.INSTANCE.i(this.TAG, "User confirmed appointment: " + appointment);
        JSONObject metadata = new JSONObject();
        try {
            CharSequence charSequence;
            metadata.put("type", (Object)"scheduleSlot");
            metadata.put("id", (Object)appointment.getId());
            metadata.put("start", appointment.getStartTime() / (long)1000);
            if (appointment.getEndTime() > 0L) {
                metadata.put("end", appointment.getEndTime() / (long)1000);
            }
            if (!((charSequence = (CharSequence)appointment.getTitle()) == null || charSequence.length() == 0)) {
                metadata.put("title", (Object)appointment.getTitle());
            }
            if (!((charSequence = (CharSequence)appointment.getDescription()) == null || charSequence.length() == 0)) {
                metadata.put("description", (Object)appointment.getDescription());
            }
            if (!((charSequence = (CharSequence)appointment.getImageURL()) == null || charSequence.length() == 0)) {
                metadata.put("imageUrl", (Object)appointment.getImageURL());
            }
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000156, "Failed to generate appointment response metadata. " + (Object)((Object)e));
        }
        StringBuilder message = new StringBuilder();
        message.append(appointment.getTitle());
        if (!TextUtils.isEmpty((CharSequence)appointment.getTitle())) {
            message.append("\n");
        }
        message.append(appointment.getDescription());
        if (!TextUtils.isEmpty((CharSequence)appointment.getDescription())) {
            message.append("\n");
        }
        long l = appointment.getStartTime();
        long l2 = appointment.getEndTime();
        String string2 = context2.getString(R.string.lp_appointment_date_format);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026_appointment_date_format)");
        String string3 = context2.getString(R.string.lp_appointment_time_format);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026_appointment_time_format)");
        Locale locale = LocaleUtils.getInstance().getLocale();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getInstance().locale");
        String dateTime = StringUtils.INSTANCE.createAppointmentSelectionMessage(l, l2, string2, string3, locale);
        message.append(dateTime);
        MessagingFactory.getInstance().getController().sendMessage(this.brandId, this.brandId, message.toString(), new DeliveryStatusUpdateInfo(new JSONArray().put((Object)metadata)));
    }

    public void onAppointmentSchedulerClosed() {
        block0: {
            ConversationViewCallback conversationViewCallback = this.conversationViewCallback;
            if (conversationViewCallback == null) break block0;
            conversationViewCallback.onAppointmentSchedulerClosed();
        }
    }

    public void startImageLoading(@NotNull ImageView imageView, @Nullable String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Context is not initialized");
            return;
        }
        Context context2 = context;
        CharSequence charSequence = imageUrl;
        if (charSequence == null || charSequence.length() == 0) {
            PicassoUtils.get((Context)context2).load(R.drawable.lp_default_appointment_avatar).transform((Transformation)new CircleTransform()).error(R.drawable.lp_default_appointment_avatar).into(imageView);
        } else {
            PicassoUtils.get((Context)context2).load(imageUrl).transform((Transformation)new CircleTransform()).error(R.drawable.lp_default_appointment_avatar).into(imageView, new Callback(){

                public void onSuccess() {
                }

                public void onError(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }
            });
        }
    }
}

