/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils.cobrowse;

import android.annotation.SuppressLint;
import android.app.PendingIntent;
import android.app.PictureInPictureParams;
import android.app.RemoteAction;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.drawable.Icon;
import android.os.Build;
import androidx.annotation.RequiresApi;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.utils.cobrowse.ActionReceiver;
import com.liveperson.infra.messaging_ui.utils.cobrowse.OnCobrowseActionListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a,\u0010\t\u001a\u00020\n*\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0001\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\fH\u0000\u001a\u001c\u0010\u0013\u001a\u00020\u0014*\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u000fH\u0003\u001a\f\u0010\u0016\u001a\u00020\u000f*\u00020\fH\u0001\u001a4\u0010\u0017\u001a\u00020\u0014*\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0001H\u0003\u001a\u0014\u0010\u001e\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0016\u0010!\u001a\u0004\u0018\u00010 *\u00020\f2\u0006\u0010\"\u001a\u00020#H\u0001\u001a\"\u0010$\u001a\u0004\u0018\u00010 *\u00020\f2\u000e\b\u0004\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120&H\u0081\b\u00f8\u0001\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006'"}, d2={"ACTION_CLOSE_SILENTLY", "", "ACTION_END_CALL", "ACTION_FLIP_CAMERA", "ACTION_MUTE_MIC", "ACTION_MUTE_VIDEO", "KEY_DIALOG_ID", "intentFilter", "Landroid/content/IntentFilter;", "addCobrowseActions", "Landroid/app/PictureInPictureParams$Builder;", "context", "Landroid/content/Context;", "dialogID", "isVideoCall", "", "isVoiceEnabled", "closeCobrowseActivitySilently", "", "createConsumerVoicePendingAction", "Landroid/app/RemoteAction;", "isEnabled", "isPictureInPictureSupported", "pendingActionOf", "iconRes", "", "titleRes", "contentDescriptionRes", "action", "dialogId", "registerCobrowseActionReceiver", "broadcastReceiver", "Landroid/content/BroadcastReceiver;", "registerForCobrowseActions", "onCobrowseActionListener", "Lcom/liveperson/infra/messaging_ui/utils/cobrowse/OnCobrowseActionListener;", "registerOnCloseCobrowseEvent", "block", "Lkotlin/Function0;", "messaging_ui_release"})
@JvmName(name="CobrowseUtils")
public final class CobrowseUtils {
    @NotNull
    private static final String KEY_DIALOG_ID = "dialog.id";
    @NotNull
    private static final String ACTION_CLOSE_SILENTLY = "action.close_silently";
    @NotNull
    private static final String ACTION_FLIP_CAMERA = "action.flip_camera";
    @NotNull
    private static final String ACTION_END_CALL = "action.end_call";
    @NotNull
    private static final String ACTION_MUTE_MIC = "action.mute_mic";
    @NotNull
    private static final String ACTION_MUTE_VIDEO = "action.mute_video";
    @NotNull
    private static final IntentFilter intentFilter;

    @RequiresApi(value=26)
    @NotNull
    public static final PictureInPictureParams.Builder addCobrowseActions(@NotNull PictureInPictureParams.Builder $this$addCobrowseActions, @NotNull Context context, @NotNull String dialogID, boolean isVideoCall, boolean isVoiceEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$addCobrowseActions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)dialogID, (String)"dialogID");
        Object[] objectArray = new RemoteAction[]{CobrowseUtils.pendingActionOf(context, R.drawable.lp_cobrowse_end_call, R.string.lp_cobrowse_end_call, R.string.lp_cobrowse_end_call, ACTION_END_CALL, dialogID), CobrowseUtils.createConsumerVoicePendingAction(context, dialogID, isVoiceEnabled)};
        List list = CollectionsKt.mutableListOf((Object[])objectArray);
        if (isVideoCall) {
            list.add(CobrowseUtils.pendingActionOf(context, R.drawable.lp_cobrowse_camera_switch_icon, R.string.lp_cobrowse_change_camera, R.string.lp_cobrowse_change_camera, ACTION_FLIP_CAMERA, dialogID));
            list.add(CobrowseUtils.pendingActionOf(context, R.drawable.lp_cobrowse_camera_off_icon, R.string.lp_cobrowse_camera_off, R.string.lp_cobrowse_camera_off, ACTION_MUTE_VIDEO, dialogID));
        }
        PictureInPictureParams.Builder builder = $this$addCobrowseActions.setActions(list);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setActions(list)");
        return builder;
    }

    @JvmName(name="isPictureInPictureSupported")
    public static final boolean isPictureInPictureSupported(@NotNull Context $this$isPictureInPictureSupported) {
        Intrinsics.checkNotNullParameter((Object)$this$isPictureInPictureSupported, (String)"<this>");
        return Build.VERSION.SDK_INT >= 24 && $this$isPictureInPictureSupported.getPackageManager().hasSystemFeature("android.software.picture_in_picture");
    }

    @JvmName(name="registerForCobrowseActions")
    @Nullable
    public static final BroadcastReceiver registerForCobrowseActions(@NotNull Context $this$registerForCobrowseActions, @NotNull OnCobrowseActionListener onCobrowseActionListener) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$registerForCobrowseActions, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)onCobrowseActionListener, (String)"onCobrowseActionListener");
        ActionReceiver receiver2 = new ActionReceiver(onCobrowseActionListener);
        Object object2 = $this$registerForCobrowseActions;
        try {
            ActionReceiver actionReceiver;
            Context $this$registerForCobrowseActions_u24lambda_u2d2 = object2;
            boolean bl = false;
            ActionReceiver it = actionReceiver = receiver2;
            boolean bl2 = false;
            CobrowseUtils.registerCobrowseActionReceiver($this$registerForCobrowseActions_u24lambda_u2d2, it);
            object = Result.constructor-impl((Object)((Object)actionReceiver));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (BroadcastReceiver)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @SuppressLint(value={"UnspecifiedRegisterReceiverFlag"})
    @Nullable
    public static final BroadcastReceiver registerOnCloseCobrowseEvent(@NotNull Context $this$registerOnCloseCobrowseEvent, @NotNull Function0<Unit> block) {
        BroadcastReceiver broadcastReceiver;
        Intrinsics.checkNotNullParameter((Object)$this$registerOnCloseCobrowseEvent, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$registerOnCloseCobrowseEvent = false;
        BroadcastReceiver receiver2 = new BroadcastReceiver(block){
            final /* synthetic */ Function0<Unit> $block;
            {
                this.$block = $block;
            }

            public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                this.$block.invoke();
            }
        };
        IntentFilter intentFilter = new IntentFilter(ACTION_CLOSE_SILENTLY);
        try {
            if (Build.VERSION.SDK_INT >= 26) {
                $this$registerOnCloseCobrowseEvent.registerReceiver(receiver2, intentFilter, 4);
            } else {
                $this$registerOnCloseCobrowseEvent.registerReceiver(receiver2, intentFilter);
            }
            broadcastReceiver = receiver2;
        }
        catch (Throwable throwable) {
            broadcastReceiver = null;
        }
        return broadcastReceiver;
    }

    public static final void closeCobrowseActivitySilently(@NotNull Context $this$closeCobrowseActivitySilently) {
        Intrinsics.checkNotNullParameter((Object)$this$closeCobrowseActivitySilently, (String)"<this>");
        Intent intent = new Intent(ACTION_CLOSE_SILENTLY).setPackage($this$closeCobrowseActivitySilently.getPackageName());
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(ACTION_CLOSE_SILE\u2026).setPackage(packageName)");
        Intent intent2 = intent;
        $this$closeCobrowseActivitySilently.sendBroadcast(intent2);
    }

    @RequiresApi(value=26)
    private static final RemoteAction createConsumerVoicePendingAction(Context $this$createConsumerVoicePendingAction, String dialogID, boolean isEnabled) {
        Triple triple = isEnabled ? new Triple((Object)R.string.lp_cobrowse_mic_on, (Object)R.string.lp_cobrowse_mic_on, (Object)R.drawable.lp_cobrowse_mic_on_icon) : new Triple((Object)R.string.lp_cobrowse_mic_off, (Object)R.string.lp_cobrowse_mic_off, (Object)R.drawable.lp_cobrowse_mic_off_icon);
        int title = ((Number)triple.component1()).intValue();
        int accessibilityTitle = ((Number)triple.component2()).intValue();
        int icon = ((Number)triple.component3()).intValue();
        return CobrowseUtils.pendingActionOf($this$createConsumerVoicePendingAction, icon, title, accessibilityTitle, ACTION_MUTE_MIC, dialogID);
    }

    @RequiresApi(value=26)
    private static final RemoteAction pendingActionOf(Context $this$pendingActionOf, int iconRes, int titleRes, int contentDescriptionRes, String action, String dialogId) {
        long requestCode = (long)dialogId.hashCode() + (long)action.hashCode();
        Intent intent = new Intent(action).setPackage($this$pendingActionOf.getPackageName()).putExtra(KEY_DIALOG_ID, dialogId);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(action).setPackag\u2026(KEY_DIALOG_ID, dialogId)");
        Intent intent2 = intent;
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)$this$pendingActionOf, (int)Math.abs((int)requestCode), (Intent)intent2, (int)0xC000000);
        Icon icon = Icon.createWithResource((Context)$this$pendingActionOf, (int)iconRes);
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"createWithResource(this, iconRes)");
        Icon icon2 = icon;
        String string2 = $this$pendingActionOf.getString(titleRes);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(titleRes)");
        String title = string2;
        String string3 = $this$pendingActionOf.getString(contentDescriptionRes);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(contentDescriptionRes)");
        String contentDescription = string3;
        return new RemoteAction(icon2, (CharSequence)title, (CharSequence)contentDescription, pendingIntent);
    }

    private static final void registerCobrowseActionReceiver(Context $this$registerCobrowseActionReceiver, BroadcastReceiver broadcastReceiver) {
        if (Build.VERSION.SDK_INT >= 33) {
            $this$registerCobrowseActionReceiver.registerReceiver(broadcastReceiver, intentFilter, 4);
        } else {
            $this$registerCobrowseActionReceiver.registerReceiver(broadcastReceiver, intentFilter);
        }
    }

    static {
        IntentFilter intentFilter;
        IntentFilter $this$intentFilter_u24lambda_u2d0 = intentFilter = new IntentFilter(ACTION_FLIP_CAMERA);
        boolean bl = false;
        $this$intentFilter_u24lambda_u2d0.addAction(ACTION_END_CALL);
        $this$intentFilter_u24lambda_u2d0.addAction(ACTION_MUTE_MIC);
        $this$intentFilter_u24lambda_u2d0.addAction(ACTION_MUTE_VIDEO);
        CobrowseUtils.intentFilter = intentFilter;
    }
}

