/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import androidx.vectordrawable.graphics.drawable.VectorDrawableCompat;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsAgentViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsDownloadableFileViewProcessor;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.utils.FileSharingUtils;
import java.io.File;

public class AmsAgentFileViewHolder
extends AmsAgentViewHolder {
    public static final String TAG = "AmsAgentFileViewHolder";
    public ImageView mMessageImageView;
    protected ImageView mFileStatusView;
    protected AmsDownloadableFileViewProcessor mDownloadableFileViewProcessor;
    protected MessagingChatMessage.MessageType mMessageType;
    private int mDocumentImageResourceId;
    private boolean mIsDocumentType;

    public AmsAgentFileViewHolder(View itemView, MessagingChatMessage.MessageType messageType) {
        super(itemView);
        this.mMessageType = messageType;
        this.mMessageImageView = (ImageView)itemView.findViewById(R.id.lpui_message_image);
        this.mFileStatusView = (ImageView)itemView.findViewById(R.id.lpui_message_status_image);
        this.mDownloadableFileViewProcessor = new AmsDownloadableFileViewProcessor(itemView, messageType){

            @Override
            protected void onNotStartedAction() {
                AmsAgentFileViewHolder.this.mDownloadableFileViewProcessor.stopAnimation();
                AmsAgentFileViewHolder.this.mDownloadableFileViewProcessor.mFileStatusView.setVisibility(0);
                AmsAgentFileViewHolder.this.mDownloadableFileViewProcessor.mFileStatusView.setImageResource(R.drawable.lpmessaging_ui_image_download);
            }

            @Override
            protected void onCompletedAction() {
                AmsAgentFileViewHolder.this.mDownloadableFileViewProcessor.stopAnimation();
                AmsAgentFileViewHolder.this.mDownloadableFileViewProcessor.mFileStatusView.setVisibility(4);
            }

            @Override
            protected void onRequestingUrlAction() {
                AmsAgentFileViewHolder.this.mDownloadableFileViewProcessor.mFileStatusView.setVisibility(0);
                AmsAgentFileViewHolder.this.mDownloadableFileViewProcessor.startProgressBar();
            }
        };
    }

    @Override
    public void applyChanges(Bundle changes, Message message) {
        super.applyChanges(changes, message);
        this.mDownloadableFileViewProcessor.applyChanges(changes);
        if (!TextUtils.isEmpty((CharSequence)this.mDownloadableFileViewProcessor.mPreviewImage)) {
            this.setMessageImage(Uri.parse((String)this.mDownloadableFileViewProcessor.mPreviewImage));
        } else if (!TextUtils.isEmpty((CharSequence)this.mDownloadableFileViewProcessor.mFullFile) && !this.mIsDocumentType) {
            this.setMessageImageNoPlaceholder(Uri.parse((String)this.mDownloadableFileViewProcessor.mFullFile));
        }
        this.updateContentDescription();
    }

    private void setMessageImage(Uri imageUri) {
        Resources resources = this.mFileStatusView.getContext().getResources();
        Resources.Theme theme = this.mFileStatusView.getContext().getTheme();
        VectorDrawableCompat drawable2 = VectorDrawableCompat.create((Resources)resources, (int)R.drawable.lpmessaging_ui_image_light_large, (Resources.Theme)theme);
        if (this.mIsDocumentType && this.mDocumentImageResourceId != 0) {
            this.mMessageImageView.setImageResource(this.mDocumentImageResourceId);
        } else {
            PicassoUtils.get((Context)this.itemView.getContext()).load(new File(imageUri.getPath())).error(R.drawable.lp_messaging_ui_icon_image_broken).placeholder((Drawable)drawable2).centerCrop().fit().into(this.mMessageImageView);
        }
    }

    private void setIsDocumentType(String fileType) {
        FileSharingType fileSharingType = FileSharingType.getFileTypeFromExtension((String)fileType.toLowerCase());
        if (FileSharingUtils.isDocumentType((FileSharingType)fileSharingType)) {
            this.mIsDocumentType = true;
            switch (fileSharingType) {
                case PDF: {
                    this.mDocumentImageResourceId = R.drawable.lp_pdf_thumbnail;
                    break;
                }
                case DOCX: {
                    this.mDocumentImageResourceId = R.drawable.lp_docx_thumbnail;
                    break;
                }
                case XLSX: {
                    this.mDocumentImageResourceId = R.drawable.lp_xlsx_thumbnail;
                    break;
                }
                case PPTX: {
                    this.mDocumentImageResourceId = R.drawable.lp_pptx_thumbnail;
                    break;
                }
                default: {
                    this.mDocumentImageResourceId = R.drawable.lp_messaging_ui_icon_image_broken;
                    break;
                }
            }
        } else {
            this.mIsDocumentType = false;
        }
    }

    private void setMessageImageNoPlaceholder(Uri imageUri) {
        LPLog.INSTANCE.d(TAG, this.mFileStatusView.hashCode() + " setMessageImageNoPlaceholder: displaying imageUri: " + imageUri.getPath());
        PicassoUtils.get((Context)this.itemView.getContext()).load(new File(imageUri.getPath())).error(R.drawable.lp_messaging_ui_icon_image_broken).noPlaceholder().centerCrop().fit().into(this.mMessageImageView);
    }

    @Override
    public void setMessageText(String text, boolean enabled) {
        super.setMessageText(text, enabled);
        if (TextUtils.isEmpty((CharSequence)text)) {
            this.mMessageTextView.setVisibility(8);
        } else {
            this.mMessageTextView.setVisibility(0);
        }
    }

    public void setMessageImage(String fullImagePath, String previewUri, FilesTable.LoadStatus loadStatus, String fileType) {
        this.setIsDocumentType(fileType);
        if (!TextUtils.isEmpty((CharSequence)previewUri)) {
            this.setMessageImage(Uri.parse((String)previewUri));
            this.mDownloadableFileViewProcessor.applyLoadStatusForDownloadFlow(loadStatus);
        } else if (!TextUtils.isEmpty((CharSequence)fullImagePath) && !this.mIsDocumentType) {
            this.setMessageImageNoPlaceholder(Uri.parse((String)fullImagePath));
            this.mDownloadableFileViewProcessor.applyLoadStatusForUploadFlow(loadStatus);
        } else {
            this.mDownloadableFileViewProcessor.applyLoadStatusForDownloadFlow(FilesTable.LoadStatus.PREVIEW_ERROR);
            this.mMessageImageView.setImageResource(R.drawable.lp_messaging_ui_icon_image_broken);
        }
    }

    public void setImageClickListener(View.OnClickListener onClickListener) {
        if (this.mMessageImageView != null) {
            this.mMessageImageView.setOnClickListener(onClickListener);
        }
    }

    public void setImageLongClickListener(View.OnLongClickListener onLongClickListener) {
        if (this.mMessageImageView != null) {
            this.mMessageImageView.setOnLongClickListener(onLongClickListener);
        }
    }

    @Override
    public void updateContentDescription() {
        Context context = this.getContext();
        if (context != null) {
            String agent = context.getResources().getString(R.string.lp_accessibility_agent);
            String fileType = MessagingChatMessage.MessageType.AGENT_IMAGE == this.mMessageType ? context.getResources().getString(R.string.lp_accessibility_photo) : context.getResources().getString(R.string.lp_accessibility_file);
            this.setContentDescription(agent + ", " + (!TextUtils.isEmpty((CharSequence)this.mAgentNickName) ? this.mAgentNickName : "") + " " + fileType + ": " + this.mMessageTextView.getText().toString() + ", " + this.mTimestampAccessibilityString);
            this.mMessageImageView.setContentDescription((CharSequence)fileType);
        }
    }

    public AmsDownloadableFileViewProcessor getAmsDownloadableFileViewProcessor() {
        return this.mDownloadableFileViewProcessor;
    }

    public void recycle() {
        super.recycle();
        this.mMessageImageView.setImageDrawable(null);
        this.setImageClickListener(null);
        this.setImageLongClickListener(null);
    }
}

