/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.core.content.ContextCompat;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.controller.AudioPlayable;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsConsumerViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.AmsDownloadableFileViewProcessor;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.ui.CustomTextView;
import com.liveperson.infra.utils.AndroidFrameworkUtils;
import com.liveperson.infra.utils.DateUtils;
import com.liveperson.infra.utils.LPAudioUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;

public class AmsConsumerVoiceViewHolder
extends AmsConsumerViewHolder
implements AudioPlayable {
    private static final String TAG = "AmsConsumerVoiceViewHolder";
    private ImageView mPlayPauseImageView;
    private ImageView mFileStatusView;
    private ProgressBar mPlayProgressBar;
    private CustomTextView mDurationTextView;
    private String mBrandId;
    private long fileRowId = -1L;
    private long messageRowId = -1L;
    private String conversationId;
    private String swiftPath;
    private boolean mDurationSet = false;
    private boolean mCurrentlyPlaying = false;
    private ValueAnimator mProgressBarAnimator;
    private LPAudioUtils mAudioUtils;
    private AmsDownloadableFileViewProcessor downloadableFileViewProcessor;

    public AmsConsumerVoiceViewHolder(View itemView, MessagingChatMessage.MessageType messageType, String brandId) {
        super(itemView, messageType);
        this.mPlayPauseImageView = (ImageView)itemView.findViewById(R.id.lpui_voice_play_pause_button);
        this.mPlayProgressBar = (ProgressBar)itemView.findViewById(R.id.lpui_voice_play_progress_bar);
        this.mDurationTextView = (CustomTextView)itemView.findViewById(R.id.lpui_voice_duration_text_view);
        this.mFileStatusView = (ImageView)itemView.findViewById(R.id.lpui_message_status_image);
        this.mBrandId = brandId;
        this.mAudioUtils = MessagingFactory.getInstance().getController().getAudioUtils();
        this.downloadableFileViewProcessor = new AmsDownloadableFileViewProcessor(itemView, messageType){

            @Override
            protected void onNotStartedAction() {
                this.stopAnimation();
                this.mFileStatusView.setVisibility(0);
                AmsConsumerVoiceViewHolder.this.mPlayPauseImageView.setVisibility(4);
                this.mFileStatusView.setImageResource(R.drawable.lpmessaging_ui_voice_download);
                AmsConsumerVoiceViewHolder.this.setDownloadButtonClickActionForVoice(AmsConsumerVoiceViewHolder.this.swiftPath, AmsConsumerVoiceViewHolder.this.messageRowId, AmsConsumerVoiceViewHolder.this.fileRowId, AmsConsumerVoiceViewHolder.this.conversationId);
            }

            @Override
            protected void onCompletedAction() {
                this.stopAnimation();
                this.mFileStatusView.setVisibility(4);
                AmsConsumerVoiceViewHolder.this.mPlayPauseImageView.setVisibility(0);
            }

            @Override
            protected void onRequestingUrlAction() {
                this.mFileStatusView.setVisibility(0);
                AmsConsumerVoiceViewHolder.this.mPlayPauseImageView.setVisibility(4);
                this.startProgressBar();
            }
        };
    }

    @Override
    public void applyChanges(Bundle changes, Message message) {
        super.applyChanges(changes, message);
        this.downloadableFileViewProcessor.applyChanges(changes);
        this.fileRowId = changes.getLong("EXTRA_FILE_ROW_ID", this.fileRowId);
        String filePath = changes.getString("EXTRA_LOCAL_URL", null);
        if (!this.mDurationSet && !TextUtils.isEmpty((CharSequence)filePath)) {
            this.setDurationText(filePath);
            this.setPlayButtonClickAction(filePath);
        }
        this.updateContentDescription();
    }

    public void setVoiceProperties(String fullFilePath, FilesTable.LoadStatus loadStatus, FullMessageRow fullMessageRow) {
        this.mDurationTextView.setVisibility(4);
        this.swiftPath = fullMessageRow.getFileMessage().getSwiftPath();
        this.messageRowId = fullMessageRow.getMessagingChatMessage().getLocalId();
        this.fileRowId = fullMessageRow.getFileMessage().getFileRowId();
        this.conversationId = fullMessageRow.getMessagingChatMessage().getDialogId();
        if (!TextUtils.isEmpty((CharSequence)fullFilePath)) {
            LPLog.INSTANCE.d(TAG, this.mFileStatusView.hashCode() + " fullImagePath available loadStatus = " + loadStatus);
            this.mPlayPauseImageView.setImageDrawable(ContextCompat.getDrawable((Context)this.itemView.getContext(), (int)R.drawable.lp_messaging_ui_ic_voice_play));
            this.setDurationText(fullFilePath);
            this.setPlayButtonClickAction(fullFilePath);
            this.downloadableFileViewProcessor.applyLoadStatusForUploadFlow(loadStatus);
        } else {
            LPLog.INSTANCE.d(TAG, this.mFileStatusView.hashCode() + " previewUri available loadStatus = " + loadStatus);
            this.setDownloadButtonClickActionForVoice(this.swiftPath, this.messageRowId, this.fileRowId, this.conversationId);
            this.downloadableFileViewProcessor.applyLoadStatusForDownloadFlow(loadStatus);
        }
    }

    public void setCurrentPlaying(String fullFilePath, int currentPlayingLocation, int currentPlayingDuration) {
        LPLog.INSTANCE.d(TAG, "setCurrentPlaying: binding currently playing file. FilePath = " + fullFilePath + ", Location = " + currentPlayingLocation + ", Duration = " + currentPlayingDuration);
        this.setPlaying(true);
        this.mAudioUtils.getPlayingAudioManager().addPlayingAndStopOthers((AudioPlayable)this);
        LPLog.INSTANCE.d(TAG, "setCurrentPlaying: current location: " + this.mAudioUtils.getCurrentPlayingLocation());
        this.mProgressBarAnimator = ValueAnimator.ofInt((int[])new int[]{currentPlayingLocation, currentPlayingDuration});
        this.mProgressBarAnimator.setDuration((long)(currentPlayingDuration - currentPlayingLocation));
        this.mProgressBarAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mPlayProgressBar.setMax(currentPlayingDuration);
        this.mProgressBarAnimator.addUpdateListener(valueAnimator -> this.mPlayProgressBar.setProgress(((Integer)valueAnimator.getAnimatedValue()).intValue()));
        this.mProgressBarAnimator.start();
        this.mAudioUtils.bindPlayingAudio(fullFilePath, new LPAudioUtils.PlaybackCallback(){

            public void onPlaybackStarted(String audioFileUrl, int durationMilliseconds) {
            }

            public void onPlaybackCompleted(boolean successfully, String audioFileUrl) {
                LPLog.INSTANCE.d(AmsConsumerVoiceViewHolder.TAG, "onPlaybackCompleted: audio playback reached end of file");
                AmsConsumerVoiceViewHolder.this.mAudioUtils.getPlayingAudioManager().removePlaying((AudioPlayable)AmsConsumerVoiceViewHolder.this);
                AmsConsumerVoiceViewHolder.this.setPlaying(false);
            }
        });
    }

    private void setPlayButtonClickAction(String filePath) {
        this.mPlayPauseImageView.setOnClickListener(view -> {
            if (this.mCurrentlyPlaying) {
                LPLog.INSTANCE.d(TAG, "Play/pause button clicked. Stop playing");
                this.stopPlaying();
            } else {
                LPLog.INSTANCE.d(TAG, "Play/pause button clicked. Start playing file: " + filePath);
                this.playVoiceMessage(filePath);
            }
        });
    }

    private void setDownloadButtonClickActionForVoice(String swiftPath, long messageRowId, long fileRowId, String conversationId) {
        this.mFileStatusView.setOnClickListener(view -> {
            if (!MessagingFactory.getInstance().getController().mConnectionController.isSocketReady(this.mBrandId)) {
                LPLog.INSTANCE.d(TAG, "onClick: Socket not ready, play fail animation");
                this.downloadableFileViewProcessor.startFailedAnimation();
            } else {
                LPLog.INSTANCE.d(TAG, "onClick: Download voice file " + swiftPath);
                MessagingFactory.getInstance().getController().downloadFile(FileSharingType.VOICE, this.mBrandId, this.mBrandId, swiftPath, messageRowId, fileRowId, conversationId);
            }
        });
    }

    private void setDurationText(String filePath) {
        LPAudioUtils.getDuration((String)filePath, (ICallback)new ICallback<Integer, Exception>(){

            public void onSuccess(Integer durationInMs) {
                LPLog.INSTANCE.d(AmsConsumerVoiceViewHolder.TAG, "onSuccess: set the duration string from milliseconds: " + durationInMs);
                AmsConsumerVoiceViewHolder.this.mDurationTextView.setVisibility(0);
                AmsConsumerVoiceViewHolder.this.mDurationTextView.setText((CharSequence)DateUtils.getDurationString((long)durationInMs.intValue()));
            }

            public void onError(Exception exception) {
                LPLog.INSTANCE.w(AmsConsumerVoiceViewHolder.TAG, "onError: error getting the voice file duration. Set 00:00", (Throwable)exception);
                AmsConsumerVoiceViewHolder.this.mDurationTextView.setText((CharSequence)"00:00");
            }
        });
    }

    @Override
    protected int resend(Message message, MessagingChatMessage.MessageType messageType) {
        LPLog.INSTANCE.d(TAG, "resend: resending message: " + LPLog.INSTANCE.mask((Object)message.getMessage()));
        return MessagingFactory.getInstance().getController().resendMessage(message.getEventId(), message.getDialogId(), this.fileRowId, messageType, false);
    }

    public void playVoiceMessage(String filePath) {
        LPLog.INSTANCE.d(TAG, "playVoiceMessage: play audio file: " + filePath);
        this.mAudioUtils.getPlayingAudioManager().addPlayingAndStopOthers((AudioPlayable)this);
        this.mAudioUtils.stopPlayback();
        this.mAudioUtils.playAudio(filePath, filePath, new LPAudioUtils.PlaybackCallback(){

            public void onPlaybackStarted(String audioFileUrl, int durationMilliseconds) {
                AmsConsumerVoiceViewHolder.this.setPlaying(true);
                AmsConsumerVoiceViewHolder.this.mProgressBarAnimator = ValueAnimator.ofInt((int[])new int[]{0, durationMilliseconds});
                AmsConsumerVoiceViewHolder.this.mProgressBarAnimator.setDuration((long)durationMilliseconds);
                AmsConsumerVoiceViewHolder.this.mProgressBarAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
                AmsConsumerVoiceViewHolder.this.mPlayProgressBar.setMax(durationMilliseconds);
                AmsConsumerVoiceViewHolder.this.mProgressBarAnimator.addUpdateListener(valueAnimator -> AmsConsumerVoiceViewHolder.this.mPlayProgressBar.setProgress(((Integer)valueAnimator.getAnimatedValue()).intValue()));
                AmsConsumerVoiceViewHolder.this.mProgressBarAnimator.start();
            }

            public void onPlaybackCompleted(boolean successfully, String audioFileUrl) {
                LPLog.INSTANCE.d(AmsConsumerVoiceViewHolder.TAG, "onPlaybackCompleted: audio playback reached end of file");
                AmsConsumerVoiceViewHolder.this.mAudioUtils.getPlayingAudioManager().removePlaying((AudioPlayable)AmsConsumerVoiceViewHolder.this);
                AmsConsumerVoiceViewHolder.this.setPlaying(false);
            }
        });
    }

    public void stopPlaying() {
        LPLog.INSTANCE.d(TAG, "stopPlaying: stop playing audio file");
        this.mAudioUtils.getPlayingAudioManager().removePlaying((AudioPlayable)this);
        this.mAudioUtils.stopPlayback();
        this.setPlaying(false);
    }

    private void setPlaying(boolean playing) {
        Drawable drawable2;
        this.mCurrentlyPlaying = playing;
        if (playing) {
            drawable2 = ContextCompat.getDrawable((Context)this.itemView.getContext(), (int)R.drawable.lp_messaging_ui_ic_voice_pause);
            this.mPlayPauseImageView.setContentDescription((CharSequence)AndroidFrameworkUtils.getResources().getString(R.string.lp_accessibility_audio_pause_button));
        } else {
            drawable2 = ContextCompat.getDrawable((Context)this.itemView.getContext(), (int)R.drawable.lp_messaging_ui_ic_voice_play);
            this.mPlayPauseImageView.setContentDescription((CharSequence)AndroidFrameworkUtils.getResources().getString(R.string.lp_accessibility_audio_play_button));
            this.mProgressBarAnimator.cancel();
            this.mPlayProgressBar.setProgress(0);
        }
        this.mPlayPauseImageView.setImageDrawable(drawable2);
    }

    @Override
    public void updateContentDescription() {
        Context context = this.getContext();
        if (context != null) {
            String youWord = context.getResources().getString(R.string.lp_accessibility_you);
            String voice = context.getResources().getString(R.string.lp_accessibility_voice);
            String errorMessage = context.getResources().getString(R.string.lp_accessibility_resend) + " " + voice;
            this.mMessageErrorView.setContentDescription((CharSequence)errorMessage);
            this.setContentDescription(youWord + ", " + voice + ": " + this.mTimestampAccessibilityString);
        }
    }

    public void recycle() {
        super.recycle();
        LPLog.INSTANCE.d(TAG, "recycle: recycling AmsConsumerVoiceViewHolder");
        if (this.mCurrentlyPlaying) {
            this.mProgressBarAnimator.cancel();
            this.mPlayProgressBar.setProgress(0);
            this.mAudioUtils.getPlayingAudioManager().removePlaying((AudioPlayable)this);
        }
        this.mDurationSet = false;
        this.mCurrentlyPlaying = false;
    }
}

