/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.decorators;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.ui.view.utils.picasso.CircleTransform;
import com.liveperson.infra.utils.PicassoUtils;
import com.squareup.picasso.Transformation;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J(\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0016\u0010!\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004J\u0018\u0010\"\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/liveperson/infra/messaging_ui/view/decorators/AgentIsTypingDecorator;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "()V", "agentAvatarUrl", "", "agentIsTyping", "", "avatarView", "Landroid/widget/ImageView;", "currentDrawableIndex", "", "deltaTime", "", "ellipsisDrawable", "Landroid/graphics/drawable/AnimationDrawable;", "ellipsisView", "typingIndicatorRoot", "Landroid/view/View;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "fixLayoutSize", "view", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "getItemOffsets", "outRect", "Landroid/graphics/Rect;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "onDraw", "c", "setAgentIsTyping", "setAvatarImage", "uriStr", "Companion", "messaging_ui_release"})
public final class AgentIsTypingDecorator
extends RecyclerView.ItemDecoration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private View typingIndicatorRoot;
    private ImageView avatarView;
    private ImageView ellipsisView;
    private boolean agentIsTyping;
    @NotNull
    private String agentAvatarUrl = "";
    private AnimationDrawable ellipsisDrawable;
    private int currentDrawableIndex;
    private long deltaTime;
    @NotNull
    private static final String TAG = "AgentIsTypingDecorator";

    public final void setAgentIsTyping(boolean agentIsTyping, @NotNull String agentAvatarUrl) {
        Intrinsics.checkNotNullParameter((Object)agentAvatarUrl, (String)"agentAvatarUrl");
        this.agentIsTyping = agentIsTyping;
        this.agentAvatarUrl = agentAvatarUrl;
        if (this.typingIndicatorRoot != null && agentIsTyping) {
            ImageView imageView = this.avatarView;
            if (imageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"avatarView");
                imageView = null;
            }
            this.setAvatarImage(imageView, agentAvatarUrl);
        }
    }

    public void onDraw(@NotNull Canvas c, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        View recyclerViewItem;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.onDraw(c, parent, state);
        RecyclerView.Adapter adapter = parent.getAdapter();
        if (adapter == null) {
            return;
        }
        RecyclerView.Adapter adapter2 = adapter;
        if (this.typingIndicatorRoot == null) {
            View view = this.typingIndicatorRoot = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.lpmessaging_ui_chat_bubble_agent_is_typing, (ViewGroup)parent, false);
            Intrinsics.checkNotNull((Object)view);
            View view2 = view.findViewById(R.id.lpui_agent_bubbleAvatar);
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"typingIndicatorRoot!!.fi\u2026.lpui_agent_bubbleAvatar)");
            this.avatarView = (ImageView)view2;
            if (((CharSequence)this.agentAvatarUrl).length() > 0) {
                ImageView imageView = this.avatarView;
                if (imageView == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"avatarView");
                    imageView = null;
                }
                this.setAvatarImage(imageView, this.agentAvatarUrl);
            }
            View view3 = this.typingIndicatorRoot;
            Intrinsics.checkNotNull((Object)view3);
            View view4 = view3.findViewById(R.id.lpui_agent_is_typing_animated_indicator);
            Intrinsics.checkNotNullExpressionValue((Object)view4, (String)"typingIndicatorRoot!!.fi\u2026yping_animated_indicator)");
            this.ellipsisView = (ImageView)view4;
            ImageView imageView = this.ellipsisView;
            if (imageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisView");
                imageView = null;
            }
            Drawable drawable2 = imageView.getDrawable();
            if (drawable2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.graphics.drawable.AnimationDrawable");
            }
            this.ellipsisDrawable = (AnimationDrawable)drawable2;
            View view5 = this.typingIndicatorRoot;
            Intrinsics.checkNotNull((Object)view5);
            this.fixLayoutSize(view5, parent);
        }
        if (!this.agentIsTyping) {
            ImageView imageView = this.ellipsisView;
            if (imageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisView");
                imageView = null;
            }
            imageView.setVisibility(8);
            return;
        }
        ImageView imageView = this.ellipsisView;
        if (imageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisView");
            imageView = null;
        }
        imageView.setVisibility(0);
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        View view = recyclerViewItem = layoutManager != null ? layoutManager.findViewByPosition(adapter2.getItemCount() - 1) : null;
        if (recyclerViewItem != null) {
            c.save();
            c.translate(0.0f, (float)recyclerViewItem.getBottom());
            this.draw(c);
            c.restore();
        }
        parent.invalidate();
    }

    private final void draw(Canvas canvas) {
        long lastTimeAnimated = SystemClock.uptimeMillis();
        AnimationDrawable animationDrawable = this.ellipsisDrawable;
        if (animationDrawable == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisDrawable");
            animationDrawable = null;
        }
        if (this.deltaTime + (long)animationDrawable.getDuration(this.currentDrawableIndex) < lastTimeAnimated) {
            AnimationDrawable animationDrawable2;
            this.deltaTime = lastTimeAnimated;
            AnimationDrawable animationDrawable3 = this.ellipsisDrawable;
            if (animationDrawable3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisDrawable");
                animationDrawable3 = null;
            }
            this.currentDrawableIndex = (this.currentDrawableIndex + 1) % animationDrawable3.getNumberOfFrames();
            ImageView imageView = this.ellipsisView;
            if (imageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisView");
                imageView = null;
            }
            if ((animationDrawable2 = this.ellipsisDrawable) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"ellipsisDrawable");
                animationDrawable2 = null;
            }
            imageView.setImageDrawable(animationDrawable2.getFrame(this.currentDrawableIndex));
        }
        View view = this.typingIndicatorRoot;
        Intrinsics.checkNotNull((Object)view);
        view.draw(canvas);
    }

    private final void setAvatarImage(ImageView avatarView, String uriStr) {
        if (TextUtils.isEmpty((CharSequence)uriStr)) {
            avatarView.setImageResource(R.drawable.lp_messaging_ui_ic_agent_avatar);
            avatarView.setColorFilter(ContextCompat.getColor((Context)avatarView.getContext(), (int)R.color.agent_avatar_icon_color), PorterDuff.Mode.MULTIPLY);
            return;
        }
        avatarView.setImageResource(R.drawable.lp_messaging_ui_ic_agent_avatar);
        avatarView.setColorFilter(null);
        PicassoUtils.get((Context)avatarView.getContext()).load(uriStr).noPlaceholder().transform((Transformation)new CircleTransform()).into(avatarView);
    }

    private final void fixLayoutSize(View view, RecyclerView parent) {
        if (view.getLayoutParams() == null) {
            view.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        }
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getWidth(), (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getHeight(), (int)0);
        int childWidth = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(parent.getPaddingLeft() + parent.getPaddingRight()), (int)view.getLayoutParams().width);
        int childHeight = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(parent.getPaddingTop() + parent.getPaddingBottom()), (int)view.getLayoutParams().height);
        view.measure(childWidth, childHeight);
        view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super.getItemOffsets(outRect, view, parent, state);
        if (parent.getAdapter() == null) {
            return;
        }
        int position = parent.getChildAdapterPosition(view);
        if (this.agentIsTyping) {
            RecyclerView.Adapter adapter = parent.getAdapter();
            Intrinsics.checkNotNull((Object)adapter);
            if (position == adapter.getItemCount() - 1) {
                View view2 = this.typingIndicatorRoot;
                Intrinsics.checkNotNull((Object)view2);
                outRect.bottom = 2 + view2.getHeight();
                return;
            }
        }
        outRect.bottom = 0;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/liveperson/infra/messaging_ui/view/decorators/AgentIsTypingDecorator$Companion;", "", "()V", "TAG", "", "getTAG$annotations", "messaging_ui_release"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getTAG$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

