/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui;

import android.app.Activity;
import android.content.Context;
import androidx.fragment.app.Fragment;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.PushUnregisterType;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.callbacks.LogoutLivePersonCallBack;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging_ui.IMessagingUi;
import com.liveperson.infra.messaging_ui.MessagingUi;
import com.liveperson.infra.messaging_ui.MessagingUiInitData;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.otel.LPTelemetryManager;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownCompletionListener;

public class MessagingUIFactory
implements IMessagingUi,
Clearable {
    protected static MessagingUIFactory instance;
    protected MessagingUi mMessagingUi;

    protected MessagingUIFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MessagingUIFactory getInstance() {
        if (instance != null) return instance;
        Class<MessagingUIFactory> clazz = MessagingUIFactory.class;
        synchronized (MessagingUIFactory.class) {
            if (instance != null) return instance;
            instance = new MessagingUIFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public synchronized void init(Context context, MessagingUiInitData initData) {
        this.initializeMessagingUI();
        this.mMessagingUi.init(context, initData);
    }

    private void initializeMessagingUI() {
        if (this.mMessagingUi == null) {
            this.mMessagingUi = new MessagingUi();
        }
    }

    @Override
    public boolean isInitialized() {
        return this.mMessagingUi != null && this.mMessagingUi.isInitialized();
    }

    public MessagingUi getMessagingUi() {
        return this.mMessagingUi;
    }

    public void clear() {
        this.mMessagingUi.clear();
    }

    @Override
    public Fragment getConversationFragment(String brandId, LPAuthenticationParams lpAuthenticationParams, ConversationViewParams params) {
        return this.mMessagingUi.getConversationFragment(brandId, lpAuthenticationParams, params);
    }

    @Override
    public boolean showConversation(Activity activity, String brandId, LPAuthenticationParams lpAuthenticationParams, ConversationViewParams params) {
        if (Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled)) {
            LPTelemetryManager.INSTANCE.begin(LPTraceType.ENABLE_OFFLINE_MESSAGING);
        }
        return this.mMessagingUi.showConversation(activity, brandId, lpAuthenticationParams, params);
    }

    @Override
    public void hideConversation(Activity activity) {
        this.mMessagingUi.hideConversation(activity);
    }

    @Override
    public void onAgentAvatarTapped(String agentOriginatorId) {
        this.mMessagingUi.onAgentAvatarTapped(agentOriginatorId);
    }

    @Override
    public void shutDown(ShutDownCompletionListener shutDownCompletionListener) {
        this.mMessagingUi.shutDown(shutDownCompletionListener);
    }

    @Override
    public void logout(Context context, MessagingUiInitData initData, boolean forceLogOut, PushUnregisterType type, LPAuthenticationType authType, LogoutLivePersonCallBack logoutLivePersonCallBack) {
        this.initializeMessagingUI();
        this.mMessagingUi.logout(context, initData, forceLogOut, type, authType, logoutLivePersonCallBack);
    }
}

