/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.activity;

import android.app.Activity;
import android.app.PictureInPictureParams;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Bundle;
import android.util.Rational;
import android.view.MenuItem;
import android.view.View;
import androidx.activity.OnBackPressedCallback;
import androidx.annotation.RequiresApi;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.core.app.PictureInPictureModeChangedInfo;
import androidx.core.util.Consumer;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.LifecycleOwner;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.CobrowseFragment;
import com.liveperson.infra.messaging_ui.utils.cobrowse.CobrowseUtils;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.CoBrowseManager;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 *2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u000e\u001a\u00020\fH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\nH\u0001J\b\u0010\u0013\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\nH\u0003J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\nH\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\fH\u0001J\u0012\u0010\u001b\u001a\u00020\f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\b\u0010\u001e\u001a\u00020\fH\u0014J\u0012\u0010\u001f\u001a\u00020\f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0014J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\fH\u0014J\b\u0010&\u001a\u00020\fH\u0014J\u0010\u0010'\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010(\u001a\u00020\f*\u00020!H\u0002J\f\u0010)\u001a\u00020\f*\u00020!H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/liveperson/infra/messaging_ui/activity/CobrowseActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Landroidx/core/util/Consumer;", "Landroidx/core/app/PictureInPictureModeChangedInfo;", "()V", "closeEventBroadcastReceiver", "Landroid/content/BroadcastReceiver;", "currentDialogId", "", "isVideoCall", "", "accept", "", "info", "addOnBackPressedCallback", "changeActionBarVisibility", "isInPictureInPictureMode", "changePipVoiceIcon", "isVoiceEnabled", "collapseToPictureInPictureMode", "enterPictureInPictureModeWithParams", "generatePictureInPictureParams", "Landroid/app/PictureInPictureParams;", "dialogId", "getMaxNumPictureInPictureActions", "", "hideCobrowseScreen", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onDestroy", "onNewIntent", "intent", "Landroid/content/Intent;", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "onStop", "onUserLeaveHint", "setTollbarTitle", "moveToForeground", "showCobrowseFragment", "Companion", "messaging_ui_release"})
@SourceDebugExtension(value={"SMAP\nCobrowseActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CobrowseActivity.kt\ncom/liveperson/infra/messaging_ui/activity/CobrowseActivity\n+ 2 CobrowseUtils.kt\ncom/liveperson/infra/messaging_ui/utils/cobrowse/CobrowseUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n107#2,15:244\n1#3:259\n*S KotlinDebug\n*F\n+ 1 CobrowseActivity.kt\ncom/liveperson/infra/messaging_ui/activity/CobrowseActivity\n*L\n80#1:244,15\n*E\n"})
public final class CobrowseActivity
extends AppCompatActivity
implements Consumer<PictureInPictureModeChangedInfo> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isVideoCall;
    @Nullable
    private String currentDialogId;
    @Nullable
    private BroadcastReceiver closeEventBroadcastReceiver;
    @NotNull
    private static final String TAG = "CobrowseActivity";
    @NotNull
    private static final String KEY_URL = "cobrowse.url";
    @NotNull
    private static final String KEY_DIALOG_ID = "cobrowse.dialog_id";
    @NotNull
    private static final String KEY_BRAND_ID = "cobrowse.brand_id";
    @NotNull
    private static final String KEY_IS_VIDEO_CALL = "cobrowse.is_video";
    private static final int ASPECT_RATIO_WIDTH = 150;
    private static final int ASPECT_RATIO_HEIGHT = 100;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addOnPictureInPictureModeChangedListener(this);
        this.setContentView(R.layout.lpmessaging_ui_activity_cobrowse);
        this.isVideoCall = this.getIntent().getBooleanExtra(KEY_IS_VIDEO_CALL, false);
        View view = this.findViewById(R.id.toolbar);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(R.id.toolbar)");
        Toolbar toolbar = (Toolbar)view;
        this.setSupportActionBar(toolbar);
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            ActionBar $this$onCreate_u24lambda_u240 = actionBar;
            boolean bl = false;
            $this$onCreate_u24lambda_u240.setDisplayHomeAsUpEnabled(true);
            $this$onCreate_u24lambda_u240.setDisplayShowHomeEnabled(true);
        }
        if (savedInstanceState == null) {
            this.currentDialogId = this.getIntent().getStringExtra(KEY_DIALOG_ID);
            Intent intent = this.getIntent();
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
            this.showCobrowseFragment(intent);
            Intent intent2 = this.getIntent();
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"intent");
            this.moveToForeground(intent2);
        }
        this.setTollbarTitle(this.isVideoCall);
        CobrowseActivity cobrowseActivity = this;
        BroadcastReceiver broadcastReceiver = this.closeEventBroadcastReceiver;
        if (broadcastReceiver == null) {
            BroadcastReceiver broadcastReceiver2;
            Context context = (Context)this;
            CobrowseActivity cobrowseActivity2 = cobrowseActivity;
            boolean $i$f$registerOnCloseCobrowseEvent = false;
            BroadcastReceiver receiver$iv = new BroadcastReceiver(this){
                final /* synthetic */ CobrowseActivity this$0;
                {
                    this.this$0 = cobrowseActivity;
                }

                public void onReceive(@Nullable Context context, @Nullable Intent intent) {
                    boolean bl = false;
                    this.this$0.finishAndRemoveTask();
                }
            };
            IntentFilter intentFilter$iv = new IntentFilter("action.close_silently");
            try {
                if (Build.VERSION.SDK_INT >= 26) {
                    $this$registerOnCloseCobrowseEvent$iv.registerReceiver(receiver$iv, intentFilter$iv, 4);
                } else {
                    $this$registerOnCloseCobrowseEvent$iv.registerReceiver(receiver$iv, intentFilter$iv);
                }
                broadcastReceiver2 = receiver$iv;
            }
            catch (Throwable throwable$iv) {
                broadcastReceiver2 = null;
            }
            broadcastReceiver = broadcastReceiver2;
            cobrowseActivity = cobrowseActivity2;
        }
        cobrowseActivity.closeEventBroadcastReceiver = broadcastReceiver;
        this.addOnBackPressedCallback();
    }

    protected void onNewIntent(@Nullable Intent intent) {
        String dialogId;
        super.onNewIntent(intent);
        Intent intent2 = intent;
        String string2 = dialogId = intent2 != null ? intent2.getStringExtra(KEY_DIALOG_ID) : null;
        if (dialogId != null && !Intrinsics.areEqual((Object)dialogId, (Object)this.currentDialogId)) {
            this.showCobrowseFragment(intent);
        }
    }

    protected void onStop() {
        super.onStop();
        if (Build.VERSION.SDK_INT >= 24 && this.isInPictureInPictureMode()) {
            this.finishAndRemoveTask();
        }
    }

    protected void onUserLeaveHint() {
        super.onUserLeaveHint();
        if (!this.collapseToPictureInPictureMode()) {
            this.finishAndRemoveTask();
        }
    }

    protected void onDestroy() {
        String brandId;
        Object $this$onDestroy_u24lambda_u243;
        CobrowseActivity cobrowseActivity = this;
        try {
            Unit unit;
            $this$onDestroy_u24lambda_u243 = cobrowseActivity;
            boolean bl = false;
            BroadcastReceiver broadcastReceiver = $this$onDestroy_u24lambda_u243.closeEventBroadcastReceiver;
            if (broadcastReceiver != null) {
                BroadcastReceiver it = broadcastReceiver;
                boolean bl2 = false;
                $this$onDestroy_u24lambda_u243.unregisterReceiver(it);
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            $this$onDestroy_u24lambda_u243 = Result.constructor-impl(unit);
        }
        catch (Throwable bl) {
            $this$onDestroy_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        cobrowseActivity = $this$onDestroy_u24lambda_u243;
        if (Result.isSuccess-impl((Object)((Object)cobrowseActivity))) {
            Unit it = (Unit)cobrowseActivity;
            boolean bl = false;
            this.closeEventBroadcastReceiver = null;
        }
        Intent intent = this.getIntent();
        String string2 = brandId = intent != null ? intent.getStringExtra(KEY_BRAND_ID) : null;
        if (brandId != null) {
            CoBrowseManager.instance.setIsCobrowseActive(brandId, false);
        }
        this.removeOnPictureInPictureModeChangedListener(this);
        super.onDestroy();
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (item.getItemId() == 16908332) {
            if (this.collapseToPictureInPictureMode()) {
                bl = true;
            } else {
                this.finish();
                bl = super.onOptionsItemSelected(item);
            }
        } else {
            bl = super.onOptionsItemSelected(item);
        }
        return bl;
    }

    public int getMaxNumPictureInPictureActions() {
        return 4;
    }

    @JvmName(name="hideCobrowseScreen")
    public final void hideCobrowseScreen() {
        this.finishAndRemoveTask();
    }

    @JvmName(name="changePipVoiceIcon")
    public final void changePipVoiceIcon(boolean isVoiceEnabled) {
        if (Build.VERSION.SDK_INT >= 26 && this.isInPictureInPictureMode()) {
            CobrowseActivity cobrowseActivity = this;
            try {
                CobrowseActivity $this$changePipVoiceIcon_u24lambda_u245 = cobrowseActivity;
                boolean bl = false;
                String string2 = $this$changePipVoiceIcon_u24lambda_u245.currentDialogId;
                if (string2 == null) {
                    return;
                }
                String dialogId = string2;
                try {
                    $this$changePipVoiceIcon_u24lambda_u245.setPictureInPictureParams($this$changePipVoiceIcon_u24lambda_u245.generatePictureInPictureParams(dialogId, isVoiceEnabled));
                }
                catch (Throwable throwable) {
                    LPLog.INSTANCE.d(TAG, "Failed to set picture in picture params", throwable);
                }
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
        }
    }

    private final void addOnBackPressedCallback() {
        OnBackPressedCallback callback2 = new OnBackPressedCallback(this){
            final /* synthetic */ CobrowseActivity this$0;
            {
                this.this$0 = $receiver;
                super(true);
            }

            public void handleOnBackPressed() {
                if (!CobrowseActivity.access$collapseToPictureInPictureMode(this.this$0)) {
                    this.setEnabled(false);
                    this.this$0.getOnBackPressedDispatcher().onBackPressed();
                }
            }
        };
        this.getOnBackPressedDispatcher().addCallback((LifecycleOwner)this, callback2);
    }

    @RequiresApi(value=26)
    private final PictureInPictureParams generatePictureInPictureParams(String dialogId, boolean isVoiceEnabled) {
        PictureInPictureParams.Builder params = new PictureInPictureParams.Builder();
        if (Build.VERSION.SDK_INT >= 31) {
            params.setSeamlessResizeEnabled(true);
        }
        PictureInPictureParams.Builder builder = params.setAspectRatio(new Rational(150, 100));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"params.setAspectRatio(Ra\u2026TH, ASPECT_RATIO_HEIGHT))");
        PictureInPictureParams pictureInPictureParams = CobrowseUtils.addCobrowseActions(builder, (Context)this, dialogId, this.isVideoCall, isVoiceEnabled).build();
        Intrinsics.checkNotNullExpressionValue((Object)pictureInPictureParams, (String)"params.setAspectRatio(Ra\u2026led)\n            .build()");
        return pictureInPictureParams;
    }

    private final boolean collapseToPictureInPictureMode() {
        return Build.VERSION.SDK_INT >= 26 && CobrowseActivity.enterPictureInPictureModeWithParams$default(this, false, 1, null);
    }

    @RequiresApi(value=26)
    private final boolean enterPictureInPictureModeWithParams(boolean isVoiceEnabled) {
        boolean bl;
        String string2 = this.currentDialogId;
        if (string2 == null) {
            return false;
        }
        String dialogId = string2;
        PictureInPictureParams params = this.generatePictureInPictureParams(dialogId, isVoiceEnabled);
        try {
            bl = this.enterPictureInPictureMode(params);
        }
        catch (Throwable throwable) {
            LPLog.INSTANCE.d(TAG, "Failed to enter picture in picture mode", throwable);
            bl = false;
        }
        return bl;
    }

    static /* synthetic */ boolean enterPictureInPictureModeWithParams$default(CobrowseActivity cobrowseActivity, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return cobrowseActivity.enterPictureInPictureModeWithParams(bl);
    }

    private final void showCobrowseFragment(Intent $this$showCobrowseFragment) {
        String string2 = $this$showCobrowseFragment.getStringExtra(KEY_URL);
        if (string2 == null) {
            return;
        }
        String url = string2;
        String string3 = $this$showCobrowseFragment.getStringExtra(KEY_DIALOG_ID);
        if (string3 == null) {
            return;
        }
        String dialogId = string3;
        String string4 = $this$showCobrowseFragment.getStringExtra(KEY_BRAND_ID);
        if (string4 == null) {
            return;
        }
        String brandId = string4;
        boolean isVideoCall = $this$showCobrowseFragment.getBooleanExtra(KEY_IS_VIDEO_CALL, false);
        CoBrowseManager.instance.setIsCobrowseActive(brandId, true);
        CobrowseFragment cobrowseFragment = CobrowseFragment.newInstance(url, dialogId, brandId, isVideoCall);
        FragmentTransaction fragmentTransaction = this.getSupportFragmentManager().beginTransaction();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentTransaction, (String)"supportFragmentManager.beginTransaction()");
        FragmentTransaction transaction = fragmentTransaction;
        transaction.replace(R.id.lpmessaging_ui_cobrowse_fragment_container, (Fragment)cobrowseFragment, "CobrowseFragment");
        transaction.commit();
    }

    private final void changeActionBarVisibility(boolean isInPictureInPictureMode) {
        block1: {
            block0: {
                if (!isInPictureInPictureMode) break block0;
                ActionBar actionBar = this.getSupportActionBar();
                if (actionBar == null) break block1;
                actionBar.hide();
                break block1;
            }
            ActionBar actionBar = this.getSupportActionBar();
            if (actionBar == null) break block1;
            actionBar.show();
        }
    }

    private final void moveToForeground(Intent $this$moveToForeground) {
        Messaging messaging;
        Messaging it = messaging = MessagingFactory.getInstance().getController();
        boolean bl = false;
        Object object = it.isInitialized() ? messaging : null;
        if (object == null) {
            return;
        }
        Messaging messaging2 = object;
        String string2 = $this$moveToForeground.getStringExtra(KEY_BRAND_ID);
        if (string2 == null) {
            return;
        }
        String brandId = string2;
        LPAuthenticationParams lPAuthenticationParams = messaging2.mAccountsController.getLPAuthenticationParams(brandId);
        if (lPAuthenticationParams == null) {
            return;
        }
        LPAuthenticationParams params = lPAuthenticationParams;
        ConversationViewParams conversationViewParams = messaging2.getConversationViewParams();
        if (conversationViewParams == null) {
            return;
        }
        ConversationViewParams conversationViewParams2 = conversationViewParams;
        messaging2.moveToForeground(brandId, params, conversationViewParams2);
    }

    private final void setTollbarTitle(boolean isVideoCall) {
        int titleRes = isVideoCall ? R.string.video_cobrowseInvitationHeading : R.string.voice_cobrowseInvitationHeading;
        this.setTitle(this.getString(titleRes));
    }

    public void accept(@Nullable PictureInPictureModeChangedInfo info) {
        PictureInPictureModeChangedInfo pictureInPictureModeChangedInfo = info;
        if (pictureInPictureModeChangedInfo == null) {
            return;
        }
        boolean isInPictureInPictureMode = pictureInPictureModeChangedInfo.isInPictureInPictureMode();
        this.changeActionBarVisibility(isInPictureInPictureMode);
    }

    @JvmStatic
    @JvmName(name="newIntent")
    @NotNull
    public static final Intent newIntent(@NotNull Activity $this$newIntent, @NotNull String url, @NotNull String dialogId, @NotNull String brandId, boolean isVideoCall) {
        return Companion.newIntent($this$newIntent, url, dialogId, brandId, isVideoCall);
    }

    public static final /* synthetic */ boolean access$collapseToPictureInPictureMode(CobrowseActivity $this) {
        return $this.collapseToPictureInPictureMode();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/liveperson/infra/messaging_ui/activity/CobrowseActivity$Companion;", "", "()V", "ASPECT_RATIO_HEIGHT", "", "ASPECT_RATIO_WIDTH", "KEY_BRAND_ID", "", "KEY_DIALOG_ID", "KEY_IS_VIDEO_CALL", "KEY_URL", "TAG", "newIntent", "Landroid/content/Intent;", "Landroid/app/Activity;", "url", "dialogId", "brandId", "isVideoCall", "", "messaging_ui_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmName(name="newIntent")
        @NotNull
        public final Intent newIntent(@NotNull Activity $this$newIntent, @NotNull String url, @NotNull String dialogId, @NotNull String brandId, boolean isVideoCall) {
            Intrinsics.checkNotNullParameter((Object)$this$newIntent, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)dialogId, (String)"dialogId");
            Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
            Intent intent = new Intent((Context)$this$newIntent, CobrowseActivity.class).putExtra(CobrowseActivity.KEY_URL, url).putExtra(CobrowseActivity.KEY_DIALOG_ID, dialogId).putExtra(CobrowseActivity.KEY_BRAND_ID, brandId).putExtra(CobrowseActivity.KEY_IS_VIDEO_CALL, isVideoCall);
            Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(this, CobrowseAct\u2026_VIDEO_CALL, isVideoCall)");
            return intent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

