/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.fragment;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.PermissionRequest;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.liveperson.api.sdk.PermissionType;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.activity.CobrowseActivity;
import com.liveperson.infra.messaging_ui.fragment.NestedFragmentsContainerCallbacks;
import com.liveperson.infra.messaging_ui.utils.PermissionUtilsKt;
import com.liveperson.infra.messaging_ui.utils.cobrowse.CobrowseJSUtils;
import com.liveperson.infra.messaging_ui.utils.cobrowse.CobrowseUtils;
import com.liveperson.infra.messaging_ui.utils.cobrowse.OnCobrowseActionListener;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.CoBrowseManager;
import com.liveperson.messaging.model.CoBrowseMetadata;
import com.liveperson.messaging.model.Dialog;
import java.util.ArrayList;
import java.util.Map;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;

public class CobrowseFragment
extends Fragment
implements OnCobrowseActionListener {
    private static final long PERIOD_IN_MILLIS = 1000L;
    public static final String TAG = "CobrowseFragment";
    public static final String URL = "url";
    public static final String JOIN = "join";
    public static final String ACTION = "action";
    public static final String IS_VIDEO_CALL = "is_video";
    public static final String DIALOG_ID = "dialogId";
    public static final String BRAND_ID = "brandId";
    public static final String FRAGMENT_DIALOG = "dialog";
    public static final String CURRENT_DIALOG = "dialog.id.current";
    private String mUrl;
    private String mDialogId;
    private String mBrandId;
    private WebView mWebView;
    private LocalBroadcastReceiver mCobrowseStateReceiver;
    private LocalBroadcastReceiver mDialogStateChangeReceiver;
    private NestedFragmentsContainerCallbacks mNestedFragmentsContainerCallbacks;
    private int mOldOrientation = -1;
    private ActivityResultLauncher<String[]> mCobrowsePermissionsLauncher;
    private PermissionRequest mPermissionRequest;
    private BroadcastReceiver mCobrowseActionsReceiver;
    private Handler mPeriodicJobHandler;

    public static Bundle newArguments(String url, String dialogId, String brandId, boolean isVideoCall) {
        Bundle bundle = new Bundle();
        bundle.putString(DIALOG_ID, dialogId);
        bundle.putString(URL, url);
        bundle.putString(BRAND_ID, brandId);
        bundle.putBoolean(IS_VIDEO_CALL, isVideoCall);
        return bundle;
    }

    public static CobrowseFragment newInstance(String url, String dialogId, String brandId, boolean isVideoCall) {
        CobrowseFragment cobrowseFragment = new CobrowseFragment();
        cobrowseFragment.setArguments(CobrowseFragment.newArguments(url, dialogId, brandId, isVideoCall));
        return cobrowseFragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.initCobrowsePermissionsLauncher();
        this.mNestedFragmentsContainerCallbacks = this.getParentFragment() instanceof NestedFragmentsContainerCallbacks ? (NestedFragmentsContainerCallbacks)this.getParentFragment() : new NestedFragmentsContainerCallbacks.NullNestedFragmentsContainerCallbacks();
    }

    private void initCobrowsePermissionsLauncher() {
        this.mCobrowsePermissionsLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestMultiplePermissions(), result -> this.handlePermissionResult((Map<String, Boolean>)result));
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mUrl = this.getArguments().getString(URL);
            this.mDialogId = this.getArguments().getString(DIALOG_ID);
            this.mBrandId = this.getArguments().getString(BRAND_ID);
        }
    }

    public void onStart() {
        super.onStart();
        if (this.mWebView != null) {
            this.mWebView.requestFocus();
        }
        this.holdCurrentOrientation();
        this.registerDialogStateChangedReceiver();
        this.registerCobrowseReceivedReceiver();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.lpmessaging_ui_cobrowse_layout, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Bundle arguments = this.getArguments();
        if (arguments != null) {
            boolean isVideoCall = arguments.getBoolean(IS_VIDEO_CALL);
            this.setCobrowseCallTitle(isVideoCall);
        }
        this.initializeWebView(view);
        view.setClickable(true);
    }

    public void onStop() {
        this.unregisterCobrowseBroadcastReceiver();
        super.onStop();
    }

    public void onDestroyView() {
        WebView webView;
        View rootView = this.getView();
        if (rootView != null) {
            rootView.setOnClickListener(null);
        }
        if ((webView = this.mWebView) != null) {
            webView.setWebChromeClient(null);
            webView.setWebViewClient(null);
            if (this.mPeriodicJobHandler != null) {
                this.mPeriodicJobHandler.removeCallbacksAndMessages(null);
                this.mPeriodicJobHandler = null;
            }
        }
        this.mWebView = null;
        super.onDestroyView();
    }

    public void onDestroy() {
        this.mWebView = null;
        if (this.mPeriodicJobHandler != null) {
            this.mPeriodicJobHandler.removeCallbacksAndMessages(null);
            this.mPeriodicJobHandler = null;
        }
        this.unregisterCobrowseBroadcastReceiver();
        super.onDestroy();
    }

    public void onDetach() {
        this.mCobrowsePermissionsLauncher.unregister();
        this.mNestedFragmentsContainerCallbacks = new NestedFragmentsContainerCallbacks.NullNestedFragmentsContainerCallbacks();
        super.onDetach();
    }

    public boolean hideItSelf(String dialogId) {
        if (TextUtils.equals((CharSequence)dialogId, (CharSequence)this.mDialogId) || TextUtils.equals((CharSequence)dialogId, (CharSequence)CURRENT_DIALOG)) {
            return this.slideOutCobrowseFragment();
        }
        return false;
    }

    private boolean slideOutCobrowseFragment() {
        boolean isPipMode;
        FragmentActivity activity = this.getActivity();
        boolean bl = isPipMode = Configuration.getBoolean((int)R.bool.lp_cobrowse_picture_in_picture_enabled) && activity instanceof CobrowseActivity;
        if (isPipMode) {
            this.hideCobrowseActivity();
        } else if (this.getParentFragment() != null && this.mNestedFragmentsContainerCallbacks != null) {
            this.mNestedFragmentsContainerCallbacks.slideOutCobrowseFragment();
        }
        return true;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initializeWebView(View rootView) {
        this.mWebView = (WebView)rootView.findViewById(R.id.lpmessaging_ui_webview);
        WebSettings settings = this.mWebView.getSettings();
        settings.setAllowContentAccess(false);
        settings.setAllowFileAccess(false);
        settings.setMediaPlaybackRequiresUserGesture(false);
        settings.setJavaScriptEnabled(true);
        this.mWebView.setWebChromeClient(new WebChromeClient(){

            public void onPermissionRequest(PermissionRequest request) {
                if (CobrowseFragment.this.getContext() == null) {
                    return;
                }
                CobrowseFragment.this.requestWebPermissions(request);
            }

            public void onPermissionRequestCanceled(PermissionRequest request) {
                if (CobrowseFragment.this.getContext() == null) {
                    return;
                }
                DialogFragment fragment = (DialogFragment)CobrowseFragment.this.getChildFragmentManager().findFragmentByTag(CobrowseFragment.FRAGMENT_DIALOG);
                if (null != fragment) {
                    fragment.dismiss();
                }
            }
        });
        this.mWebView.setWebViewClient(new WebViewClient(){

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                super.onReceivedHttpError(view, request, errorResponse);
                LPLog.INSTANCE.i(CobrowseFragment.TAG, "PCI receive http error: " + errorResponse);
            }

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                LPLog.INSTANCE.i(CobrowseFragment.TAG, "PCI receive  error: " + error);
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                LPLog.INSTANCE.i(CobrowseFragment.TAG, "PCI receive  redirect: " + url);
                return false;
            }

            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                LPLog.INSTANCE.d(CobrowseFragment.TAG, "onPageFinished sdk - " + Build.VERSION.SDK_INT);
                CobrowseFragment.this.mWebView.evaluateJavascript("(function() { return ('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>'); })();", html -> LPLog.INSTANCE.d("HTML", html));
                FragmentActivity activity = CobrowseFragment.this.getActivity();
                if (CobrowseFragment.this.mPeriodicJobHandler == null && activity instanceof CobrowseActivity) {
                    CobrowseFragment.this.mPeriodicJobHandler = new Handler();
                    CobrowseFragment.this.mPeriodicJobHandler.postDelayed((Runnable)new PeriodicWebViewUpdates(), 1000L);
                }
            }
        });
        this.mWebView.loadUrl(this.mUrl);
    }

    private void registerCobrowseReceivedReceiver() {
        if (this.mCobrowseStateReceiver == null) {
            LPLog.INSTANCE.d(TAG, "CoBrowseLogic cobrowsefragment registerCobrowseReceivedReceiver");
            this.mCobrowseStateReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_COBROWSE_RECEIVED").build((context, intent) -> {
                String dialogId = intent.getStringExtra(DIALOG_ID);
                String brandId = intent.getStringExtra(BRAND_ID);
                boolean isMainDialogResolved = intent.getBooleanExtra("isMainDialogResolved", false);
                if (TextUtils.equals((CharSequence)this.mDialogId, (CharSequence)dialogId)) {
                    CoBrowseMetadata metadata = CoBrowseManager.instance.getMetadata(brandId, dialogId);
                    LPLog.INSTANCE.d(TAG, "CoBrowseLogic cobrowsefragment registerCobrowseReceivedReceiver brandId: " + brandId + " callback " + dialogId + "   mDialogId:" + this.mDialogId + "   metdata: " + (metadata != null));
                    if (metadata != null && !metadata.isJoinable() || isMainDialogResolved) {
                        this.slideOutCobrowseFragment();
                    }
                }
            });
        } else {
            this.mCobrowseStateReceiver.register();
        }
        if (this.mCobrowseActionsReceiver == null) {
            this.mCobrowseActionsReceiver = CobrowseUtils.registerForCobrowseActions((Context)this.requireActivity(), this);
        }
    }

    private void unregisterCobrowseBroadcastReceiver() {
        if (this.mCobrowseActionsReceiver != null) {
            try {
                this.requireActivity().unregisterReceiver(this.mCobrowseActionsReceiver);
                this.mCobrowseActionsReceiver = null;
            }
            catch (Exception exception) {
                LPLog.INSTANCE.d(TAG, "Failed to unregister cobrowse actions receiver", (Throwable)exception);
            }
        }
        if (this.mCobrowseStateReceiver != null) {
            try {
                this.mCobrowseStateReceiver.unregister();
                this.mCobrowseStateReceiver = null;
            }
            catch (Exception exception) {
                LPLog.INSTANCE.d(TAG, "Failed to unregister cobrowse state receiver", (Throwable)exception);
            }
        }
        if (this.mDialogStateChangeReceiver != null) {
            try {
                this.mDialogStateChangeReceiver.unregister();
                this.mDialogStateChangeReceiver = null;
            }
            catch (Exception exception) {
                LPLog.INSTANCE.d(TAG, "Failed to unregister cobrowse state receiver", (Throwable)exception);
            }
        }
    }

    protected void registerDialogStateChangedReceiver() {
        if (this.mDialogStateChangeReceiver == null) {
            this.mDialogStateChangeReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_UPDATE_DIALOG_CLOSED").addAction("BROADCAST_UPDATE_CONVERSATION_CLOSED").build((context, intent) -> this.handleClosedDialogIntent(intent));
        } else {
            this.mDialogStateChangeReceiver.register();
        }
    }

    private void holdCurrentOrientation() {
        android.content.res.Configuration config = this.getResources().getConfiguration();
        int orientation = config.orientation;
        LPLog.INSTANCE.d(TAG, "holdCurrentOrientation: config = " + (orientation == 1 ? "Configuration.ORIENTATION_PORTRAIT" : "Configuration.ORIENTATION_LANDSCAPE"));
        LPLog.INSTANCE.d(TAG, "holdCurrentOrientation: old orientation = " + this.requireActivity().getRequestedOrientation());
        if (this.mOldOrientation == -1) {
            this.mOldOrientation = this.requireActivity().getRequestedOrientation();
        }
        LPLog.INSTANCE.d(TAG, "holdCurrentOrientation: Getting old orientation: " + this.mOldOrientation);
        if (orientation == 1) {
            this.requireActivity().setRequestedOrientation(1);
        } else if (orientation == 2) {
            this.requireActivity().setRequestedOrientation(0);
        }
    }

    private void requestWebPermissions(PermissionRequest request) {
        this.mPermissionRequest = request;
        String[] webPermissions = request.getResources();
        String[] androidPermissions = new String[webPermissions.length];
        block8: for (int i = 0; i < webPermissions.length; ++i) {
            String webPermission;
            switch (webPermission = webPermissions[i]) {
                case "android.webkit.resource.AUDIO_CAPTURE": {
                    androidPermissions[i] = "android.permission.RECORD_AUDIO";
                    continue block8;
                }
                case "android.webkit.resource.VIDEO_CAPTURE": {
                    androidPermissions[i] = "android.permission.CAMERA";
                    continue block8;
                }
            }
        }
        this.mCobrowsePermissionsLauncher.launch((Object)androidPermissions);
    }

    private void handlePermissionResult(Map<String, Boolean> nativePermissionsResult) {
        ArrayList<String> grantedPermissions = new ArrayList<String>();
        block8: for (Map.Entry<String, Boolean> permissionResult : nativePermissionsResult.entrySet()) {
            String permission2 = permissionResult.getKey();
            boolean isPermissionGranted = permissionResult.getValue();
            switch (permission2) {
                case "android.permission.CAMERA": {
                    if (isPermissionGranted) {
                        grantedPermissions.add("android.webkit.resource.VIDEO_CAPTURE");
                        continue block8;
                    }
                    this.handleCameraPermissionIsNotGranted();
                    continue block8;
                }
                case "android.permission.RECORD_AUDIO": {
                    if (isPermissionGranted) {
                        grantedPermissions.add("android.webkit.resource.AUDIO_CAPTURE");
                        continue block8;
                    }
                    this.handleMicrophonePermissionIsNotGranted();
                    continue block8;
                }
            }
            LPLog.INSTANCE.d(TAG, "Unsupported permission: " + permission2);
        }
        if (this.mPermissionRequest != null) {
            if (grantedPermissions.size() < this.mPermissionRequest.getResources().length) {
                this.mPermissionRequest.deny();
            } else {
                this.mPermissionRequest.grant(grantedPermissions.toArray(new String[0]));
            }
        }
    }

    private void handleCameraPermissionIsNotGranted() {
        boolean shouldDisplayPermissionDialog = PreferenceManager.getInstance().getBooleanValue("pref_camera_permission_dialog_status", this.mBrandId, false);
        if (this.getActivity() != null) {
            PermissionUtilsKt.handleNotGrantedPermission(this.mBrandId, 2, "android.permission.CAMERA", PermissionType.PHOTO_SHARING, shouldDisplayPermissionDialog, (Activity)this.getActivity());
        }
    }

    private void handleMicrophonePermissionIsNotGranted() {
        boolean shouldDisplayPermissionDialog = PreferenceManager.getInstance().getBooleanValue("pref_record_permission_dialog_status", this.mBrandId, false);
        if (this.getActivity() != null) {
            PermissionUtilsKt.handleNotGrantedPermission(this.mBrandId, 3, "android.permission.RECORD_AUDIO", PermissionType.VOICE_RECORDING, shouldDisplayPermissionDialog, (Activity)this.getActivity());
        }
    }

    private void checkCurrentPictureInPictureState() {
        FragmentActivity activity = this.getActivity();
        if (Build.VERSION.SDK_INT >= 24 && activity instanceof CobrowseActivity && activity.isInPictureInPictureMode()) {
            CobrowseJSUtils.changeConsumerViewsVisibility(this.mWebView, false);
        } else {
            CobrowseJSUtils.changeConsumerViewsVisibility(this.mWebView, true);
        }
    }

    private void handleClosedDialogIntent(Intent intent) {
        if (intent == null || intent.getAction() == null) {
            return;
        }
        String dialogId = null;
        switch (intent.getAction()) {
            case "BROADCAST_UPDATE_DIALOG_CLOSED": {
                dialogId = intent.getStringExtra("DIALOG_ID");
                break;
            }
            case "BROADCAST_UPDATE_CONVERSATION_CLOSED": {
                dialogId = intent.getStringExtra("CONVERSATION_ID");
                break;
            }
        }
        Messaging controller = MessagingFactory.getInstance().getController();
        if (controller == null || !controller.isInitialized()) {
            return;
        }
        Dialog dialog = controller.amsDialogs.getActiveDialog();
        if (dialog != null && TextUtils.equals((CharSequence)dialog.getDialogId(), (CharSequence)dialogId)) {
            this.slideOutCobrowseFragment();
        }
    }

    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
        if (Build.VERSION.SDK_INT >= 24 && isInPictureInPictureMode) {
            CobrowseJSUtils.changeConsumerViewsVisibility(this.mWebView, false);
        } else {
            CobrowseJSUtils.changeConsumerViewsVisibility(this.mWebView, true);
        }
        if (this.mPeriodicJobHandler != null) {
            this.mPeriodicJobHandler.removeCallbacksAndMessages(null);
            this.mPeriodicJobHandler.postDelayed((Runnable)new PeriodicWebViewUpdates(), 1000L);
        }
    }

    @Override
    public void onCameraChanged() {
        CobrowseJSUtils.performCameraFlipButtonClick(this.mWebView);
        this.checkCurrentPictureInPictureState();
    }

    @Override
    public void onVideoStateChanged() {
        CobrowseJSUtils.performVideoButtonClick(this.mWebView);
        this.checkCurrentPictureInPictureState();
    }

    @Override
    public void onMicrophoneStateChanged() {
        CobrowseJSUtils.performMuteVoiceButtonClick(this.mWebView);
    }

    @Override
    public void onCallEnded(@Nullable String dialogId) {
        if (TextUtils.equals((CharSequence)dialogId, (CharSequence)this.mDialogId)) {
            CoBrowseManager.instance.cancelCobrowse(this.mBrandId, this.mUrl, "endCall");
            this.hideCobrowseActivity();
        }
    }

    private void hideCobrowseActivity() {
        FragmentActivity activity = this.getActivity();
        if (activity != null && Build.VERSION.SDK_INT >= 24 && activity.isInPictureInPictureMode() && activity instanceof CobrowseActivity) {
            ((CobrowseActivity)activity).hideCobrowseScreen();
        } else if (activity != null) {
            activity.finish();
        }
    }

    private void changePipModeMicIcon(boolean isEnabled) {
        FragmentActivity activity = this.getActivity();
        if (activity instanceof CobrowseActivity) {
            ((CobrowseActivity)activity).changePipVoiceIcon(isEnabled);
        }
    }

    private void setCobrowseCallTitle(boolean isVideoCall) {
        int cobrowseTitleRes = isVideoCall ? R.string.video_cobrowseInvitationHeading : R.string.voice_cobrowseInvitationHeading;
        if (this.mNestedFragmentsContainerCallbacks != null) {
            this.mNestedFragmentsContainerCallbacks.showCobrowseToolbar(cobrowseTitleRes);
        }
    }

    private class PeriodicWebViewUpdates
    implements Runnable {
        private PeriodicWebViewUpdates() {
        }

        @Override
        public void run() {
            WebView webView = CobrowseFragment.this.mWebView;
            if (webView != null) {
                CobrowseFragment.this.checkCurrentPictureInPictureState();
                Handler handler = CobrowseFragment.this.mPeriodicJobHandler;
                if (handler != null) {
                    handler.postDelayed((Runnable)this, 1000L);
                }
                CobrowseJSUtils.observeMicStateChanges(webView, (Function1<? super Boolean, Unit>)((Function1)enabled -> {
                    CobrowseFragment.this.changePipModeMicIcon((boolean)enabled);
                    return Unit.INSTANCE;
                }));
            }
        }
    }
}

