/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.fragment;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.MimeTypeMap;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.PickVisualMediaRequest;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.LifecycleOwner;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.api.response.types.CSAT;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.api.sdk.PermissionType;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.IPermissionCallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging_ui.MessagingUIFactory;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.accessibility.AccessibilityAnnouncer;
import com.liveperson.infra.messaging_ui.activity.CobrowseActivity;
import com.liveperson.infra.messaging_ui.dialog.NewUserDialog;
import com.liveperson.infra.messaging_ui.fragment.CaptionPreviewFragment;
import com.liveperson.infra.messaging_ui.fragment.CobrowseFragment;
import com.liveperson.infra.messaging_ui.fragment.ConnectionStatusController;
import com.liveperson.infra.messaging_ui.fragment.ConversationFragmentCallbacks;
import com.liveperson.infra.messaging_ui.fragment.ConversationViewCallback;
import com.liveperson.infra.messaging_ui.fragment.FeedbackFragment;
import com.liveperson.infra.messaging_ui.fragment.FullImageFragment;
import com.liveperson.infra.messaging_ui.fragment.IConnectable;
import com.liveperson.infra.messaging_ui.fragment.NestedFragmentsContainerCallbacks;
import com.liveperson.infra.messaging_ui.fragment.SecuredFormFragment;
import com.liveperson.infra.messaging_ui.hybrid.actions.HybridSDKActions;
import com.liveperson.infra.messaging_ui.hybrid.actions.broadcast.OnHybridSDKActionListener;
import com.liveperson.infra.messaging_ui.notification.NotificationController;
import com.liveperson.infra.messaging_ui.uicomponents.AmsEnterMessage;
import com.liveperson.infra.messaging_ui.uicomponents.AttachmentMenu;
import com.liveperson.infra.messaging_ui.uicomponents.IScrollDownIndicator;
import com.liveperson.infra.messaging_ui.uicomponents.ScrollDownIndicator;
import com.liveperson.infra.messaging_ui.uicomponents.inlinemessages.InlineMessagesController;
import com.liveperson.infra.messaging_ui.uicomponents.list.BlockInputAreaCallback;
import com.liveperson.infra.messaging_ui.uicomponents.list.ChatMessageListRecyclerView;
import com.liveperson.infra.messaging_ui.utils.AppointmentSchedulerOperationsImpl;
import com.liveperson.infra.messaging_ui.utils.ConversationFragmentUtilsKt;
import com.liveperson.infra.messaging_ui.utils.ConversationInBackgroundService;
import com.liveperson.infra.messaging_ui.utils.ConversationStateHandler;
import com.liveperson.infra.messaging_ui.utils.PermissionUtilsKt;
import com.liveperson.infra.messaging_ui.utils.StringUtils;
import com.liveperson.infra.messaging_ui.utils.UriFileUtils;
import com.liveperson.infra.messaging_ui.utils.cobrowse.CobrowseUtils;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualItemAction;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.IActivityProvider;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.MessagingContextualActionModeBehavior;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.MessagingContextualSimpleMenuBehavior;
import com.liveperson.infra.model.LPWelcomeMessage;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.otel.LPTelemetryManager;
import com.liveperson.infra.otel.LPTraceSpan;
import com.liveperson.infra.otel.LPTraceType;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.infra.ui.view.ui.progress.LPProgressBar;
import com.liveperson.infra.ui.view.uicomponents.IConnectionChangedCustomView;
import com.liveperson.infra.ui.view.uicomponents.IConversationProvider;
import com.liveperson.infra.ui.view.uicomponents.IEnterMessageListener;
import com.liveperson.infra.utils.AccessibilityChecker;
import com.liveperson.infra.utils.FileUtils;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.infra.utils.UIUtils;
import com.liveperson.lpappointmentscheduler.AppointmentOperationsHolder;
import com.liveperson.lpappointmentscheduler.AppointmentSchedulerFragment;
import com.liveperson.lpappointmentscheduler.AppointmentSchedulerOperations;
import com.liveperson.lpappointmentscheduler.models.AppointmentSlot;
import com.liveperson.lpappointmentscheduler.models.LPAppointmentInfo;
import com.liveperson.lpdatepicker.DatePickerFragment;
import com.liveperson.lpdatepicker.model.DatePickerParams;
import com.liveperson.lpdatepicker.model.DatePickerResult;
import com.liveperson.lpdatepicker.utils.BundleUtils;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.CoBrowseManager;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.model.AmsAccount;
import com.liveperson.messaging.model.AmsConversations;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.AmsMessages;
import com.liveperson.messaging.model.ConversationUtils;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.offline.OfflineMessagingManager;
import com.liveperson.messaging.utils.FileSharingUtils;
import com.liveperson.messaging.utils.LPFileProvider;
import com.liveperson.messaging.wm.WelcomeMessageBroadcastReceiver;
import com.liveperson.messaging.wm.WelcomeMessageEventListener;
import com.liveperson.messaging.wm.WelcomeMessageManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ConversationFragment
extends Fragment
implements NestedFragmentsContainerCallbacks,
BlockInputAreaCallback,
ContextualItemAction,
ConversationViewCallback,
IConnectable,
AccessibilityAnnouncer,
WelcomeMessageEventListener,
ConnectionStatusController.OnVisibilityChangedListener,
OnHybridSDKActionListener {
    public static final String TAG = "ConversationFragment";
    public static final String BUNDLE_CONVERSATION_ID = "bundle_conversation_id";
    private static final String BUNDLE_CACHED_AUTH_PARAMS = "bundle_cached_auth_params";
    public static final String BUNDLE_IS_SOCKET_CONNECTED = "bundle_is_connected";
    public static final String BUNDLE_IS_AUTH_COMPLETED = "bundle_is_authenticated";
    public static final String BUNDLE_KEEP_WELCOME_MESSAGE = "keep_welcome_message";
    public static final String BUNDLE_KEEP_CLEAN_HISTORY_FLAG_STATE = "keep_clean_history_flag_state";
    private static final String BUNDLE_RECYCLER_LAYOUT_STATE = "chat_messaging_list_recycler_view_state";
    private static final String BUNDLE_CONTEXTUAL_BEHAVIOR_STATE = "bundle_contextual_behavior_state";
    private static final String BUNDLE_CONTEXTUAL_BEHAVIOR_STATE_FILE = "bundle_contextual_behavior_state_file";
    public static final int REQUEST_TAKE_PHOTO = 1546;
    public static final int PICK_DOCUMENT_FOR_MESSAGE = 1547;
    private static final String SDK_MODE = "SDKMode";
    private static final int REQUEST_CAMERA = 2;
    private static final int REQUEST_RECORD = 3;
    private static final int REQUEST_CREATE_NEW_FILE = 4;
    private static final int REQUEST_DATE_PICKER = 7;
    private static final String PREF_LP_PHOTO = "pref_lp_photo";
    private static final String PREF_SAVE_FILE_PATH = "pref_save_file_path";
    protected ChatMessageListRecyclerView mRecyclerView;
    protected View mLiveRegionView;
    protected TextView mEmptyView;
    protected AmsEnterMessage mEnterMessageLayout;
    protected RelativeLayout mConversationLayout;
    protected LPProgressBar mOfflineProgressBar;
    protected LocalBroadcastReceiver mConnectionReceiver;
    protected LocalBroadcastReceiver mConversationStateChangeReceiver;
    protected LocalBroadcastReceiver mDialogStateChangeReceiver;
    protected LocalBroadcastReceiver mFormStateChangeReceiver;
    protected LocalBroadcastReceiver mCobrowseWebviewReceiver;
    protected LocalBroadcastReceiver mCobrowseReceivedReceiver;
    protected LocalBroadcastReceiver mAgentProfileUpdatesReceiver;
    protected LocalBroadcastReceiver mAgentTypingReceiver;
    protected LocalBroadcastReceiver mUnAuthenticatedUserExpired;
    protected LocalBroadcastReceiver mFileUploadStatusReceiver;
    protected BroadcastReceiver mWelcomeMessageEventReceiver;
    protected BroadcastReceiver mHybridActionsReceiver;
    protected ConversationFragmentCallbacks mFragmentContainer;
    protected InlineMessagesController mInlineMessagesController;
    protected String mBrandId;
    protected LPAuthenticationParams mLPAuthenticationParams;
    protected ConversationViewParams mConversationViewParams;
    protected IConversationProvider mIConversationProvider;
    protected String conversationId;
    protected ContextualActionBehavior mContextualActionBehavior;
    private AttachmentMenu mAttachmentMenu;
    private ConnectionStatusController mConnectionStatusController;
    private boolean mReadOnlyMode = false;
    private boolean mLastSocketReady;
    private boolean mIsTypingAnnouncementEnabledInBubble;
    private boolean mIsTypingAnnouncementEnabled;
    private boolean mIsSDKInActivityMode;
    private Parcelable mSavedRecyclerLayoutState;
    private ArrayList<Integer> mContextualBehaviorStateData;
    private boolean mContextualBehaviorIsFile;
    private boolean isPerformingFileOperation;
    private boolean isRequestingPermission;
    private String mAgentNickName;
    private boolean hasSocketBeenOpened;
    private boolean isAuthenCompleted;
    private boolean isOpeningCobrowseActivity;
    private boolean keepCleanHistoryFlagState;
    private View mLoadingView;
    private ActivityResultLauncher<PickVisualMediaRequest> pickMedia;
    private boolean mIsInitialLaunch;
    private boolean mPerformingBackNavigation;
    private ActivityResultLauncher<String> recordAudioRequestPermissionLauncher;
    private ActivityResultLauncher<String> cameraRequestPermissionLauncher;
    private ActivityResultLauncher<String[]> mCobrowsePermissionsLauncher;
    private Runnable mOpenCobrowseRunnable;

    public static ConversationFragment newInstance(String brandId, LPAuthenticationParams lpAuthenticationParams, ConversationViewParams conversationViewParams, boolean isSDKActivity) {
        Bundle args = new Bundle();
        args.putString("brand_id", brandId);
        args.putParcelable("auth_key", (Parcelable)lpAuthenticationParams);
        args.putBoolean("read_only", conversationViewParams.isViewOnlyMode());
        args.putParcelable("view_params", (Parcelable)conversationViewParams);
        args.putBoolean(SDK_MODE, isSDKActivity);
        ConversationFragment fragment = new ConversationFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        this.initPermissionLaunchers();
        LocaleUtils.getInstance().init(context);
        if (MessagingFactory.getInstance().getController() != null) {
            MessagingFactory.getInstance().getController().initMaskedMessage(context);
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mBrandId = this.getArguments().getString("brand_id");
        this.mReadOnlyMode = this.getArguments().getBoolean("read_only");
        this.mConversationViewParams = (ConversationViewParams)this.getArguments().getParcelable("view_params");
        this.subscribeToAppointmentListResult((LifecycleOwner)this);
        this.subscribeToDatePickerResult((LifecycleOwner)this);
        boolean keepWelcomeMessage = false;
        LPAuthenticationParams cachedAuthParams = null;
        Messaging controller = MessagingFactory.getInstance().getController();
        if (savedInstanceState != null) {
            this.mContextualBehaviorStateData = savedInstanceState.getIntegerArrayList(BUNDLE_CONTEXTUAL_BEHAVIOR_STATE);
            this.mContextualBehaviorIsFile = savedInstanceState.getBoolean(BUNDLE_CONTEXTUAL_BEHAVIOR_STATE_FILE, false);
            keepWelcomeMessage = savedInstanceState.getBoolean(BUNDLE_KEEP_WELCOME_MESSAGE, false);
            this.keepCleanHistoryFlagState = savedInstanceState.getBoolean(BUNDLE_KEEP_CLEAN_HISTORY_FLAG_STATE, false);
            this.hasSocketBeenOpened = savedInstanceState.getBoolean(BUNDLE_IS_SOCKET_CONNECTED, false);
            this.isAuthenCompleted = savedInstanceState.getBoolean(BUNDLE_IS_AUTH_COMPLETED, false);
            cachedAuthParams = Build.VERSION.SDK_INT >= 33 ? (LPAuthenticationParams)savedInstanceState.getParcelable(BUNDLE_CACHED_AUTH_PARAMS, LPAuthenticationParams.class) : (LPAuthenticationParams)savedInstanceState.getParcelable(BUNDLE_CACHED_AUTH_PARAMS);
        } else {
            OfflineMessagingManager offlineMessagingManager;
            CoBrowseManager.instance.setIsCobrowseActive(this.mBrandId, false);
            this.mIsInitialLaunch = true;
            if (controller != null && (offlineMessagingManager = controller.getOfflineManager()) != null) {
                offlineMessagingManager.clearPendingOfflineMessages().execute();
            }
        }
        if (controller != null && !keepWelcomeMessage) {
            AmsMessages amsMessages = controller.amsMessages;
            if (amsMessages != null) {
                amsMessages.removeTemporalWelcomeMessage().execute();
            }
            controller.setWelcomeMessageMetadata(null, this.mBrandId);
            WelcomeMessageManager manager = controller.getWelcomeMessageManager();
            if (manager != null) {
                manager.clearWelcomeMessage();
            }
        }
        this.mLPAuthenticationParams = cachedAuthParams != null ? cachedAuthParams : (LPAuthenticationParams)this.getArguments().getParcelable("auth_key");
        if (this.mConversationViewParams != null) {
            this.mReadOnlyMode = this.mConversationViewParams.isViewOnlyMode();
        }
        this.mIsSDKInActivityMode = this.getArguments().getBoolean(SDK_MODE);
        boolean isSdkVersionChanged = PreferenceManager.getInstance().getBooleanValue("SDK_VERSION_CHANGED_CLEAR_DATABASE_KEY", "appLevelPreferences", false);
        if (isSdkVersionChanged) {
            LPLog.INSTANCE.d(TAG, "Doing tasks when upgrading sdk version");
            if (PreferenceManager.getInstance().getBooleanValue("RESET_DB_ENCRYPTION_SERVICE_KEY", "appLevelPreferences", false)) {
                LPLog.INSTANCE.d(TAG, "Need to reset DBEncryptionService");
                MessagingFactory.getInstance().getController().resetDBEncryptionService();
                PreferenceManager.getInstance().remove("RESET_DB_ENCRYPTION_SERVICE_KEY", "appLevelPreferences");
            }
            this.clearDBToReFetchHistoryFromTheServer();
            PreferenceManager.getInstance().setBooleanValue("SDK_VERSION_CHANGED_CLEAR_DATABASE_KEY", "appLevelPreferences", false);
        }
        this.initConversationProvider();
        this.createContextualActionBehavior();
        this.preparePhotoPickerActivity();
    }

    private void createContextualActionBehavior() {
        this.mContextualActionBehavior = new MessagingContextualActionModeBehavior(this.mContextualBehaviorStateData, this.mContextualBehaviorIsFile);
        this.mContextualActionBehavior = Configuration.getBoolean((int)R.bool.contextual_menu_on_toolbar) ? new MessagingContextualActionModeBehavior(this.mContextualBehaviorStateData, this.mContextualBehaviorIsFile) : new MessagingContextualSimpleMenuBehavior(this.mContextualBehaviorStateData, this.mContextualBehaviorIsFile);
        this.mContextualActionBehavior.setContextualItemAction(this);
    }

    public void onStart() {
        LPTraceSpan offlineMsgSpan;
        super.onStart();
        ConversationStateHandler.setIsConversationFragmentRunning(true);
        this.setActivityProvider();
        this.mRecyclerView.setBlockInputAreaCallback(this);
        if (Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled) && (offlineMsgSpan = LPTelemetryManager.INSTANCE.getSpanByTraceType(LPTraceType.ENABLE_OFFLINE_MESSAGING)) != null) {
            offlineMsgSpan.end();
        }
    }

    public void onStop() {
        super.onStop();
        LPLog.INSTANCE.d(TAG, "onStop:");
        if (this.mRecyclerView != null) {
            this.mRecyclerView.removeListener();
        }
        if (this.mRecyclerView != null) {
            this.mRecyclerView.setBlockInputAreaCallback(null);
        }
        boolean isUnAuth = MessagingFactory.getInstance().getController().mAccountsController.isInUnAuthMode(this.mBrandId);
        if (this.isPerformingFileOperation && isUnAuth) {
            this.startConversationBackgroundService();
        }
        this.clearActivityProvider();
        MessagingFactory.getInstance().getController().amsDialogs.clearFetchConversationRequestDialogs();
    }

    private void startConversationBackgroundService() {
        try {
            Intent intent = new Intent(this.getActivity().getBaseContext(), ConversationInBackgroundService.class);
            intent.putExtra("bundle_brand_id", this.mBrandId);
            this.getActivity().startService(intent);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000E7, "Failed to start ConversationInBackgroundService: ", (Throwable)e);
        }
    }

    private void stopConversationBackgroundService() {
        try {
            if (this.isServiceRunning(ConversationInBackgroundService.class)) {
                this.getActivity().stopService(new Intent(this.getActivity().getBaseContext(), ConversationInBackgroundService.class));
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000E8, "Failed to stop ConversationInBackground service: ", (Throwable)e);
        }
    }

    private boolean isServiceRunning(Class<?> serviceClass) {
        ActivityManager manager = (ActivityManager)this.getActivity().getSystemService("activity");
        for (ActivityManager.RunningServiceInfo service : manager.getRunningServices(Integer.MAX_VALUE)) {
            if (!serviceClass.getName().equals(service.service.getClassName())) continue;
            return true;
        }
        return false;
    }

    private void clearActivityProvider() {
        this.mContextualActionBehavior.setActivityProvider(null);
    }

    private void setActivityProvider() {
        IActivityProvider activityProvider = () -> ((ConversationFragment)this).getActivity();
        this.mContextualActionBehavior.setActivityProvider(activityProvider);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        LPLog.INSTANCE.d(TAG, "onCreateView = " + this.mBrandId);
        View view = inflater.inflate(R.layout.lpmessaging_ui_fragment_conversation, container, false);
        if (savedInstanceState != null) {
            this.conversationId = savedInstanceState.getString(BUNDLE_CONVERSATION_ID);
            this.mReadOnlyMode = savedInstanceState.getBoolean("read_only");
        }
        if (!this.mIsSDKInActivityMode) {
            Bitmap background = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.conversation_background);
            if (background != null) {
                view.setBackground(this.getResources().getDrawable(R.drawable.conversation_background));
            } else {
                view.setBackgroundColor(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.conversation_background));
            }
        }
        return view;
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mConversationLayout = (RelativeLayout)view.findViewById(R.id.lpui_list_enter_msg_container);
        this.mAttachmentMenu = (AttachmentMenu)view.findViewById(R.id.attachment_menu);
        this.mLiveRegionView = view.findViewById(R.id.lpui_live_region_view);
        this.mRecyclerView = (ChatMessageListRecyclerView)view.findViewById(R.id.lpui_recycler_view);
        this.mRecyclerView.setAnnouncer(this);
        this.mEmptyView = (TextView)view.findViewById(R.id.lpui_recycler_view_empty_view);
        this.mLoadingView = view.findViewById(R.id.lpui_loading_view);
        if (Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth) && !Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled)) {
            this.mLoadingView.setVisibility(0);
        } else {
            this.mLoadingView.setVisibility(8);
        }
        int cacheSize = Configuration.getInteger((int)R.integer.recycler_view_cache_size);
        this.mRecyclerView.setItemViewCacheSize(cacheSize);
        LPLog.INSTANCE.d(TAG, "onViewCreated: Set RecyclerView cache size to " + cacheSize);
        this.mEnterMessageLayout = (AmsEnterMessage)view.findViewById(R.id.lpui_enter);
        this.mOfflineProgressBar = (LPProgressBar)view.findViewById(R.id.lpmessaging_ui_offline_progressbar);
        this.mEnterMessageLayout.setBrandIdProvider(this.mIConversationProvider);
        this.mEnterMessageLayout.setAnnouncer(this);
        this.mEnterMessageLayout.setIsOfflineMessagingEnabled(Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled));
        this.mEnterMessageLayout.setEnterMessageListener(new IEnterMessageListener(){

            public void onMessageSent() {
            }

            public void onVoiceRecordingPermissionRequired(IPermissionCallback permissionCallback) {
                if (Build.VERSION.SDK_INT >= 23) {
                    if (ConversationFragment.this.verifyRecordPermission((Activity)ConversationFragment.this.getActivity())) {
                        if (permissionCallback != null) {
                            permissionCallback.onPermissionsGranted();
                        }
                    } else {
                        permissionCallback.onPermissionsDenied();
                    }
                } else if (permissionCallback != null) {
                    permissionCallback.onPermissionsGranted();
                }
            }
        });
        this.onReadOnlyModeChanged(this.mReadOnlyMode);
        this.mEnterMessageLayout.setOverflowMenu(this.mAttachmentMenu);
        this.mAttachmentMenu.setListener(new AttachmentMenu.AttachmentMenuListener(){

            @Override
            public void onGalleryButtonPressed() {
                ConversationFragment.this.mAttachmentMenu.hide();
                ConversationFragment.this.openPhotoPicker();
            }

            @Override
            public void onCameraButtonPressed() {
                ConversationFragment.this.mAttachmentMenu.hide();
                ConversationFragment.this.openCamera();
            }

            @Override
            public void onDocumentButtonPressed() {
                ConversationFragment.this.mAttachmentMenu.hide();
                ConversationFragment.this.openFileChooser();
            }
        });
        this.mConnectionStatusController = (ConnectionStatusController)view.findViewById(R.id.lpmessaging_ui_connection_status_view);
        this.mConnectionStatusController.setAnnouncer(this);
        this.mConnectionStatusController.setOnVisibilityChangedListener(this);
        FragmentManager childFragmentManager = this.getChildFragmentManager();
        this.setConversationLayoutVisible(childFragmentManager.getFragments().isEmpty());
    }

    private void preparePhotoPickerActivity() {
        LPLog.INSTANCE.d(TAG, "preparePhotoPickerActivity");
        this.pickMedia = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.PickVisualMedia(), uri -> {
            FragmentActivity activity = this.getActivity();
            if (uri != null && activity != null) {
                this.saveToLocalFileAndUpload((Uri)uri, (Activity)activity);
            }
        });
    }

    private void saveToLocalFileAndUpload(Uri uri, Activity activity) {
        UriFileUtils.saveToFile((Context)activity, UriFileUtils.asSafeUri(uri), (Function1<? super Uri, Unit>)((Function1)output -> {
            String imagePath = ImageUtils.getImagePath((Context)this.getActivity(), (Uri)output);
            int orientation = ImageUtils.getImageRotation((String)imagePath, (boolean)false);
            activity.runOnUiThread(() -> this.startFileUpload((Uri)output, orientation, false));
            return Unit.INSTANCE;
        }));
    }

    public void onActivityCreated(Bundle savedInstanceState) {
        LPLog.INSTANCE.d(TAG, "onActivityCreated");
        super.onActivityCreated(savedInstanceState);
        this.attachActivity(this.getActivity());
        boolean isInitialized = MessagingUIFactory.getInstance().isInitialized();
        LPLog.INSTANCE.d(TAG, "onActivityCreated isInitialized = " + isInitialized);
        if (!isInitialized) {
            LPLog.INSTANCE.d(TAG, "onActivityCreated removing fragment! ");
            try {
                this.getActivity().getSupportFragmentManager().beginTransaction().remove((Fragment)this).commit();
            }
            catch (Exception error) {
                String className = this.getActivity() != null ? this.getActivity().getClass().getName() : "";
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000150, "onActivityCreated: Failed to remove attached fragment from activity: " + className, (Throwable)error);
            }
            return;
        }
        if (!this.keepCleanHistoryFlagState) {
            MessagingFactory.getInstance().getController().removeClearHistoryFlag(this.mBrandId);
        }
        MessagingFactory.getInstance().getController().setConversationViewParams(this.mConversationViewParams);
        if (!TextUtils.isEmpty((CharSequence)PreferenceManager.getInstance().getStringValue("CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY", this.mBrandId, ""))) {
            MessagingFactory.getInstance().getController().unregisterPusherOnLiteLogout(this.mBrandId, PreferenceManager.getInstance().getStringValue("CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY", this.mBrandId, ""));
        }
        if (savedInstanceState != null) {
            this.mSavedRecyclerLayoutState = savedInstanceState.getParcelable(BUNDLE_RECYCLER_LAYOUT_STATE);
            this.initRelevantToolbar();
        }
        this.initRecyclerView();
        this.mAgentNickName = this.getString(R.string.brand_name);
        this.mIsTypingAnnouncementEnabled = Configuration.getBoolean((int)R.bool.announce_agent_typing);
        this.mIsTypingAnnouncementEnabledInBubble = Configuration.getBoolean((int)R.bool.show_agent_typing_in_message_bubble);
        this.mInlineMessagesController = new InlineMessagesController((Context)this.getActivity(), this.getResources(), this.getView(), this.mIConversationProvider);
        this.updateAgentDetails();
        if (this.mFragmentContainer != null) {
            if (this.getAppointmentSchedulerFragment() != null) {
                this.mFragmentContainer.hideConversationToolBar(true);
            } else if (this.getDatePickerFragment() != null) {
                this.mFragmentContainer.hideConversationToolBar(true);
            }
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putString(BUNDLE_CONVERSATION_ID, this.conversationId);
        outState.putBoolean("read_only", this.mReadOnlyMode);
        outState.putBoolean(BUNDLE_KEEP_WELCOME_MESSAGE, true);
        outState.putBoolean(BUNDLE_KEEP_CLEAN_HISTORY_FLAG_STATE, true);
        if (this.isCobrowseActive()) {
            outState.putBoolean(BUNDLE_IS_SOCKET_CONNECTED, this.hasSocketBeenOpened);
            outState.putBoolean(BUNDLE_IS_AUTH_COMPLETED, this.isAuthenCompleted);
        }
        if (this.mRecyclerView != null && this.mRecyclerView.getLayoutManager() != null && this.mContextualActionBehavior != null) {
            outState.putParcelable(BUNDLE_RECYCLER_LAYOUT_STATE, this.mRecyclerView.getLayoutManager().onSaveInstanceState());
            outState.putIntegerArrayList(BUNDLE_CONTEXTUAL_BEHAVIOR_STATE, this.mContextualActionBehavior.getListOfSelectedItems());
            outState.putBoolean(BUNDLE_CONTEXTUAL_BEHAVIOR_STATE_FILE, this.mContextualActionBehavior.getIfFileSelectedBeforeOrientation());
        } else {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000014D, "onSaveInstanceState is called when ConversationFragment is not initialized");
        }
        if (this.mLPAuthenticationParams != null) {
            outState.putParcelable(BUNDLE_CACHED_AUTH_PARAMS, (Parcelable)this.mLPAuthenticationParams);
        }
        super.onSaveInstanceState(outState);
    }

    protected void initRecyclerView() {
        IScrollDownIndicator scrollDownIndicator;
        if (Configuration.getBoolean((int)R.bool.scroll_down_indicator_enabled)) {
            ScrollDownIndicator indicator = (ScrollDownIndicator)this.getView().findViewById(R.id.lpui_scroll_down_indicator);
            indicator.setAnnouncer(this);
            scrollDownIndicator = indicator;
        } else {
            scrollDownIndicator = new IScrollDownIndicator.NullImplementation();
        }
        this.mRecyclerView.initData(MessagingFactory.getInstance().getController(), this.mIConversationProvider.getBrandId(), scrollDownIndicator, this.mContextualActionBehavior);
        this.mRecyclerView.setConversationViewCallback(this);
    }

    protected void attachActivity(FragmentActivity activity) {
        this.mFragmentContainer = activity instanceof ConversationFragmentCallbacks ? (ConversationFragmentCallbacks)activity : new ConversationFragmentCallbacks.NullConversationFragmentCallbacks();
    }

    private void announceAgentTypingEvent() {
        String stringToAnnounce = TextUtils.isEmpty((CharSequence)this.mAgentNickName) ? this.getString(R.string.lp_accessibility_agent_is_typing) : this.getString(R.string.lp_accessibility_is_typing, new Object[]{this.mAgentNickName});
        this.announce(stringToAnnounce);
    }

    private void onConnectionChanged(boolean isConnected) {
        FeedbackFragment feedbackFragment;
        LPLog.INSTANCE.d(TAG, "onConnectionChanged isConnected = " + isConnected);
        this.mEnterMessageLayout.onConnectionChanged(isConnected);
        if (this.mRecyclerView != null) {
            this.mRecyclerView.onConnectionChanged(isConnected);
        }
        if (isConnected) {
            MessagingFactory.getInstance().getController().changeChatState(this.mBrandId, this.mBrandId, ChatState.ACTIVE);
            MessagingFactory.getInstance().getController().amsConversations.notifyClosedConversationFromDB(this.mBrandId);
        }
        if (this.getActivity() instanceof IConnectionChangedCustomView) {
            ((IConnectionChangedCustomView)this.getActivity()).onConnectionChanged(isConnected);
        }
        if ((feedbackFragment = this.getFeedbackFragment()) != null) {
            feedbackFragment.onConnectionChanged(isConnected);
        }
    }

    public boolean verifyRecordPermission(Activity activity) {
        int recordPermissions = ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.RECORD_AUDIO");
        if (recordPermissions == 0) {
            return true;
        }
        MessagingFactory.getInstance().getController().mEventsProxy.onUserActionOnPreventedPermission(PermissionType.VOICE_RECORDING);
        this.isRequestingPermission = true;
        this.recordAudioRequestPermissionLauncher.launch((Object)"android.permission.RECORD_AUDIO");
        return false;
    }

    private void initPermissionLaunchers() {
        this.initRecordAudioPermissionLauncher();
        this.initCameraPermissionLauncher();
        this.initCobrowsePermissionsLauncher();
    }

    private void initRecordAudioPermissionLauncher() {
        this.recordAudioRequestPermissionLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), result -> {
            this.isRequestingPermission = false;
            if (!result.booleanValue()) {
                boolean shouldDisplayPermissionDialog = PreferenceManager.getInstance().getBooleanValue("pref_record_permission_dialog_status", this.mBrandId, false);
                if (this.getActivity() != null) {
                    PermissionUtilsKt.handleNotGrantedPermission(this.mBrandId, 3, "android.permission.RECORD_AUDIO", PermissionType.VOICE_RECORDING, shouldDisplayPermissionDialog, (Activity)this.getActivity());
                }
            }
        });
    }

    public boolean verifyCameraPermission(Activity activity) {
        int cameraPermissionStatus;
        boolean cameraPermissionDeclared = ConversationFragment.hasPermissionInManifest((Context)activity, "android.permission.CAMERA");
        int n = cameraPermissionStatus = !cameraPermissionDeclared ? 0 : ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.CAMERA");
        if (cameraPermissionStatus == 0) {
            return true;
        }
        MessagingFactory.getInstance().getController().mEventsProxy.onUserActionOnPreventedPermission(PermissionType.PHOTO_SHARING);
        this.isRequestingPermission = true;
        this.cameraRequestPermissionLauncher.launch((Object)"android.permission.CAMERA");
        return false;
    }

    private static boolean hasPermissionInManifest(@NonNull Context context, @NonNull String permissionName) {
        String packageName = context.getPackageName();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 4096);
            String[] declaredPermissions = packageInfo.requestedPermissions;
            if (declaredPermissions != null) {
                for (String p : declaredPermissions) {
                    if (!p.equals(permissionName)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public void startCamera() {
        try {
            Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            if (takePictureIntent.resolveActivity(this.requireActivity().getPackageManager()) != null) {
                Context applicationContext = this.requireContext().getApplicationContext();
                Uri imageUri = ImageUtils.createImageFileForCamera((Context)applicationContext, (String)this.mBrandId);
                takePictureIntent.putExtra("output", (Parcelable)imageUri);
                PreferenceManager.getInstance().setStringValue(PREF_LP_PHOTO, this.mBrandId, imageUri.toString());
                LPLog.INSTANCE.d(TAG, "startCamera: starting camera");
                List resolvedIntentActivities = applicationContext.getPackageManager().queryIntentActivities(takePictureIntent, 65536);
                for (ResolveInfo resolvedIntentInfo : resolvedIntentActivities) {
                    String packageName = resolvedIntentInfo.activityInfo.packageName;
                    applicationContext.grantUriPermission(packageName, imageUri, 3);
                }
                LPLog.INSTANCE.d(TAG, "startCamera: imageUri = " + imageUri);
                this.isPerformingFileOperation = true;
                this.startActivityForResult(takePictureIntent, 1546);
            } else {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000157, "Failed to resolve Activity when starting camera");
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000EA, "IOException launching camera Intent", (Throwable)e);
        }
    }

    public void openDocumentProvider() {
        String[] allDocumentTypes = new String[]{"pdf", "docx", "pptx", "xlsx", "jpg", "jpeg", "png", "gif"};
        ArrayList<String> mimeTypes = new ArrayList<String>();
        for (String documentType : allDocumentTypes) {
            String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(documentType);
            mimeTypes.add(mimeType);
        }
        Intent intent = new Intent("android.intent.action.OPEN_DOCUMENT");
        intent.addCategory("android.intent.category.OPENABLE");
        intent.setType("*/*");
        intent.putExtra("android.intent.extra.MIME_TYPES", mimeTypes.toArray(new String[0]));
        intent.putExtra("android.content.extra.SHOW_ADVANCED", true);
        this.isPerformingFileOperation = true;
        this.startActivityForResult(intent, 1547);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        LPLog.INSTANCE.d(TAG, "onActivityResult: resultCode = " + resultCode);
        if (requestCode == 1546 && resultCode == -1) {
            String imageUriString = PreferenceManager.getInstance().getStringValue(PREF_LP_PHOTO, this.mBrandId, null);
            if (imageUriString == null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000EC, "onActivityResult: image URI from preferences is null");
                return;
            }
            Uri imageUri = Uri.parse((String)imageUriString);
            String imagePath = ImageUtils.getImagePath((Context)this.getActivity(), (Uri)imageUri);
            int orientation = ImageUtils.getImageRotation((String)imagePath, (boolean)true);
            if (Build.VERSION.SDK_INT < 21) {
                this.getContext().revokeUriPermission(imageUri, 3);
            }
            this.startFileUpload(Uri.parse((String)imageUriString), orientation, true);
            this.isPerformingFileOperation = false;
        } else if (requestCode == 1547 && resultCode == -1) {
            if (data != null && data.getData() != null) {
                int orientation = 0;
                Uri safeUri = UriFileUtils.asSafeUri(data.getData());
                FileSharingType fileType = FileSharingUtils.getFileSharingTypeFromUri((String)data.getData().toString(), (Context)this.getActivity());
                if (!FileSharingUtils.isDocumentType((FileSharingType)fileType)) {
                    String imagePath = ImageUtils.getImagePath((Context)this.getActivity(), (Uri)safeUri);
                    orientation = ImageUtils.getImageRotation((String)imagePath, (boolean)false);
                }
                this.startFileUpload(safeUri, orientation, false);
            }
            this.isPerformingFileOperation = false;
        } else if (requestCode == 4 && resultCode == -1 && data != null && data.getData() != null) {
            Uri publicDir = UriFileUtils.asSafeUri(data.getData());
            String filePath = PreferenceManager.getInstance().getStringValue(PREF_SAVE_FILE_PATH, this.mBrandId, null);
            if (!TextUtils.isEmpty((CharSequence)filePath)) {
                File privateDir = new File(filePath);
                boolean isFileSaved = FileUtils.writeFileContent((Context)this.requireActivity().getApplicationContext(), (File)privateDir, (Uri)publicDir);
                if (isFileSaved) {
                    String toastMessageSaved = this.getResources().getString(R.string.lp_file_saved_to_toast);
                    Toast.makeText((Context)this.getActivity(), (CharSequence)toastMessageSaved, (int)1).show();
                }
                LPLog.INSTANCE.d(TAG, "Saving file from: srcPath = [" + privateDir.getPath() + "] to dstPath [" + publicDir.getPath() + "] isFileSaved = " + isFileSaved);
            }
        }
    }

    private void onDatePickerResult(@Nullable DatePickerResult datePickerResult) {
        this.hideDatePickerFragment();
        if (datePickerResult == null) {
            LPLog.INSTANCE.i(TAG, "REQUEST_DATE_PICKER - RESULT_CANCELED: no date selected");
            return;
        }
        long startDate = datePickerResult.getStart();
        long endDate = datePickerResult.getEnd();
        DatePickerParams.Type pickerType = datePickerResult.getParams().getType();
        String dateFormat = datePickerResult.getParams().getDateFormat();
        LPLog.INSTANCE.i(TAG, "REQUEST_DATE_PICKER - RESULT_OK: StartDate = " + startDate + " - EndDate = " + endDate + " - pickerType = " + pickerType + " - dateFormat = " + dateFormat);
        Locale locale = LocaleUtils.getInstance().getLocale();
        LPLog.INSTANCE.i(TAG, "locale = " + locale);
        JSONObject metadata = new JSONObject();
        try {
            metadata.put("type", (Object)"datePickerResponse");
            metadata.put("start", startDate);
            if (pickerType == DatePickerParams.Type.RANGE) {
                metadata.put("end", endDate);
            }
        }
        catch (JSONException e) {
            Toast.makeText((Context)this.requireContext(), (int)R.string.lpmessaging_general_error_message, (int)0).show();
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000015E, e.getMessage(), (Throwable)e);
        }
        LPLog.INSTANCE.i(TAG, "REQUEST_DATE_PICKER - RESULT_OK: metadata = " + metadata.toString());
        String message = pickerType == DatePickerParams.Type.SINGLE ? StringUtils.createDatePickerMessage(startDate, dateFormat, locale) : StringUtils.createDatePickerMessage(startDate, endDate, dateFormat, locale);
        LPLog.INSTANCE.i(TAG, "REQUEST_DATE_PICKER - RESULT_OK: formatted message = " + message);
        MessagingFactory.getInstance().getController().sendMessage(this.mBrandId, this.mBrandId, message, new DeliveryStatusUpdateInfo(new JSONArray().put((Object)metadata)));
    }

    private void subscribeToAppointmentListResult(LifecycleOwner owner) {
        AppointmentSchedulerOperationsImpl operations = new AppointmentSchedulerOperationsImpl(this.getContext(), this.mBrandId);
        AppointmentOperationsHolder.INSTANCE.init((AppointmentSchedulerOperations)operations);
        this.getChildFragmentManager().setFragmentResultListener("appointment.request", owner, (requestKey, result) -> {
            String key = "appointment.slot";
            AppointmentSlot slot = (AppointmentSlot)result.getParcelable(key);
            if (slot != null) {
                operations.onAppointmentConfirmed(slot);
            }
            this.hideAppointmentSchedulerFragment();
        });
    }

    private void subscribeToDatePickerResult(LifecycleOwner owner) {
        this.getChildFragmentManager().setFragmentResultListener("DatePickerKey", owner, (requestKey, result) -> this.onDatePickerResult(BundleUtils.getDatePickerResult((Bundle)result)));
    }

    private void startFileUpload(Uri data, int orientation, boolean imageFromCamera) {
        if (FileSharingUtils.getFileSharingTypeFromUri((String)data.toString(), (Context)this.getContext()) != FileSharingType.UNKNOWN) {
            if (!Configuration.getBoolean((int)R.bool.lp_is_consumer_file_caption_enabled)) {
                this.uploadFileWithoutCaption(data.toString(), imageFromCamera);
                return;
            }
            CaptionPreviewFragment fragment = this.getCaptionPreviewFragment();
            if (fragment == null || !fragment.isAdded()) {
                this.executePendingFragmentTransaction(fragment);
                CaptionPreviewFragment captionPreviewFragment = CaptionPreviewFragment.newInstance(this.mBrandId, data.toString(), orientation, imageFromCamera);
                FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
                transaction.add(R.id.lpui_fragment_child_container, (Fragment)captionPreviewFragment, "CaptionPreviewFragment");
                transaction.addToBackStack("CaptionPreviewFragment");
                this.setAccessibilityImportance(false);
                this.setConversationLayoutVisible(false);
                transaction.commit();
            }
        } else {
            Toast.makeText((Context)this.getContext(), (int)R.string.lp_failed_file_type_not_supported, (int)1).show();
        }
    }

    public void onResume() {
        boolean isSocketReady;
        super.onResume();
        LPLog.INSTANCE.d(TAG, "onResume: ");
        Messaging messagingController = MessagingFactory.getInstance().getController();
        if (messagingController == null) {
            LPLog.INSTANCE.w(TAG, "onResume: Messaging is not initialized");
            return;
        }
        ConversationStateHandler.setConversationBackgroundStatus(false);
        this.stopConversationBackgroundService();
        if (!this.isRequestingPermission) {
            this.isPerformingFileOperation = false;
        }
        if (ConversationStateHandler.isHideConversationCalledInBackground()) {
            LPLog.INSTANCE.i(TAG, "Hiding the conversation screen");
            ConversationStateHandler.setIsHideConversationCalledInBackground(false);
            try {
                this.getActivity().getSupportFragmentManager().beginTransaction().remove((Fragment)this).commit();
            }
            catch (Exception error) {
                String className = this.getActivity() != null ? this.getActivity().getClass().getName() : "";
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000150, "onResume: Failed to remove attached fragment from activity: " + className, (Throwable)error);
            }
            return;
        }
        this.refreshLoadingViewOption();
        this.registerBroadCastReceivers();
        ForegroundService.getInstance().register(this.mBrandId, this.mIConversationProvider.getTargetId());
        this.moveToForeground();
        NotificationController.instance.clearMessagesForBrand((Context)this.getActivity(), this.mBrandId);
        boolean isInitialized = messagingController.isInitialized();
        LPLog.INSTANCE.i(TAG, "onResume: Is messaging initialized? " + isInitialized);
        this.mLastSocketReady = isSocketReady = isInitialized && messagingController.mConnectionController.isSocketReady(this.mBrandId);
        this.onConnectionChanged(isSocketReady);
        boolean isUpdated = isInitialized && messagingController.mConnectionController.isUpdated(this.mBrandId);
        this.mEnterMessageLayout.onUpdate(isUpdated);
        this.shouldShowOfflineProgressBar(!isUpdated);
        boolean isConnecting = isInitialized && messagingController.mConnectionController.isConnecting(this.mBrandId);
        this.mConnectionStatusController.initState(isSocketReady, isConnecting |= isInitialized && messagingController.mAccountsController.isInUnAuthMode(this.mBrandId));
        if (this.mInlineMessagesController != null) {
            this.mInlineMessagesController.register(this.mBrandId);
        }
        this.mEnterMessageLayout.restoreTypedText();
        if (this.mRecyclerView != null) {
            if (!InternetConnectionService.isNetworkAvailable()) {
                LPLog.INSTANCE.d(TAG, "No internet connection. Adding message listener");
                this.mRecyclerView.onForeground();
            } else if (Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled)) {
                this.mRecyclerView.onForeground();
            } else if (this.isCobrowseActive()) {
                this.mRecyclerView.onForeground();
            } else if (Configuration.getBoolean((int)R.bool.lp_cobrowse_picture_in_picture_enabled) && ForegroundService.getInstance().isBrandForeground(this.mBrandId)) {
                this.mRecyclerView.onForeground();
            }
        }
    }

    private void moveToForeground() {
        Messaging messaging = MessagingFactory.getInstance().getController();
        LPAuthenticationParams params = messaging.mAccountsController.getLPAuthenticationParams(this.mBrandId);
        if (this.mIsInitialLaunch) {
            LPLog.INSTANCE.d(TAG, "Initial launch. using authentication params");
            this.mIsInitialLaunch = false;
        } else if (params != null && !Objects.equals(params, this.mLPAuthenticationParams)) {
            this.mLPAuthenticationParams = params;
        }
        messaging.moveToForeground(this.mBrandId, this.mLPAuthenticationParams, this.mConversationViewParams);
    }

    @Override
    public void connect() {
        MessagingFactory.getInstance().getController().connect(this.mBrandId, this.mLPAuthenticationParams, this.mConversationViewParams);
    }

    public void onPause() {
        super.onPause();
        LPLog.INSTANCE.d(TAG, "onPause: ");
        this.unregisterFragment();
        this.moveToBackground();
        ConversationStateHandler.setConversationBackgroundStatus(true);
        if (!(this.isRequestingPermission || this.isCobrowseActive() || this.isPerformingFileOperation)) {
            if (this.mEnterMessageLayout != null) {
                this.mEnterMessageLayout.onBackground();
            }
            if (this.mRecyclerView != null) {
                this.mRecyclerView.onBackground();
            }
        }
        if (this.isOpeningCobrowseActivity) {
            this.isOpeningCobrowseActivity = false;
        }
        this.setAgentIsTyping(false, null);
    }

    protected void unregisterFragment() {
        this.unregisterForegroundService();
        this.unregisterReceivers();
        this.unregisterControllers();
    }

    private void moveToBackground() {
        try {
            if (!this.isRequestingPermission) {
                boolean isUnAuth = MessagingFactory.getInstance().getController().mAccountsController.isInUnAuthMode(this.mBrandId);
                if (isUnAuth) {
                    if (!this.isPerformingFileOperation) {
                        this.clearDBToReFetchHistoryFromTheServer();
                    }
                    MessagingFactory.getInstance().getController().moveToBackground(this.mBrandId, 0L);
                } else {
                    long timeout = this.isCobrowseActive() ? TimeUnit.DAYS.toMillis(1L) : (long)Configuration.getInteger((int)R.integer.background_timeout_short_ms);
                    MessagingFactory.getInstance().getController().moveToBackground(this.mBrandId, timeout);
                }
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000ED, "Failed to clear database or to close socket.");
        }
    }

    private void clearDBToReFetchHistoryFromTheServer() {
        LPLog.INSTANCE.d(TAG, "clearDBToReFetchHistoryFromTheServer");
        PreferenceManager.getInstance().remove("hide_closed_conversations", this.mBrandId);
        MessagingFactory.getInstance().getController().mConnectionController.clearLastUpdateTime(this.mBrandId);
        MessagingFactory.getInstance().getController().clearAllConversationData(this.mBrandId);
        FileUtils.deleteFileAsync((File)this.getActivity().getApplicationContext().getFilesDir());
    }

    protected void registerBroadCastReceivers() {
        this.registerWelcomeMessageReceiver();
        this.registerHybridActionsReceiver();
        this.registerConnectionReceiver();
        this.registerConversationStateChangedReceiver();
        this.registerDialogStateChangedReceiver();
        this.registerFormStateChangeReceiver();
        this.registerCobrowseWebviewReceiver();
        this.registerCobrowseReceivedReceiver();
        this.mConnectionStatusController.registerToChanges(this);
        this.registerAgentTypingReceiver();
        this.registerUnAuthenticatedUserExpired();
        this.registerFileUploadStatusReceiver();
        this.registerAgentInfoChangedReceiver();
    }

    private void registerAgentTypingReceiver() {
        if (this.mAgentTypingReceiver == null) {
            this.mAgentTypingReceiver = new LocalBroadcastReceiver.Builder().addAction("agent_typing").build((context, intent) -> {
                boolean isTyping = intent.getBooleanExtra("is_typing", false);
                String originatorId = intent.getStringExtra("originator_id");
                if (!isTyping || this.mConversationViewParams != null && this.mConversationViewParams.getHistoryConversationsStateToDisplay() != LPConversationsHistoryStateToDisplay.CLOSE) {
                    this.setAgentIsTyping(isTyping, originatorId);
                }
            });
        } else {
            this.mAgentTypingReceiver.register();
        }
    }

    private void registerUnAuthenticatedUserExpired() {
        if (this.mUnAuthenticatedUserExpired == null) {
            this.mUnAuthenticatedUserExpired = new LocalBroadcastReceiver.Builder().addAction("LP_ON_UNAUTHENTICATED_USER_EXPIRED_INTENT_ACTION").build((context, intent) -> {
                if (this.getFragmentManager() != null) {
                    NewUserDialog.getInstance().show(this.getFragmentManager(), "NewUserDialog");
                }
            });
        } else {
            this.mUnAuthenticatedUserExpired.register();
        }
    }

    protected void registerFormStateChangeReceiver() {
        if (this.mFormStateChangeReceiver == null) {
            this.mFormStateChangeReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_UPDATE_FORM_URL").build((context, intent) -> {
                LPLog.INSTANCE.d(TAG, "Got PCI update onBroadcastReceived");
                if (intent != null) {
                    String url = intent.getStringExtra("url");
                    String invitation_id = intent.getStringExtra("invitation_id");
                    String form_title = intent.getStringExtra("form_title");
                    if (!url.isEmpty()) {
                        this.showSecuredFormFragment(url, invitation_id, form_title);
                    }
                }
            });
        } else {
            this.mFormStateChangeReceiver.register();
        }
    }

    protected void registerCobrowseWebviewReceiver() {
        if (this.mCobrowseWebviewReceiver == null) {
            this.mCobrowseWebviewReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_COBROWSE_WEBVIEW").build((context, intent) -> {
                if (intent != null) {
                    UIUtils.hideKeyboard((Activity)this.requireActivity());
                    String dialogId = intent.getStringExtra("dialogId");
                    String url = intent.getStringExtra("url");
                    String action = intent.getStringExtra("action");
                    boolean join = intent.getBooleanExtra("join", false);
                    boolean isVideoCall = intent.getBooleanExtra("is_video", false);
                    if (TextUtils.isEmpty((CharSequence)url)) {
                        LPLog.INSTANCE.d(TAG, "CoBrowse Call url is NULL");
                    } else if (join) {
                        this.showCobrowseScreen(dialogId, url, isVideoCall);
                    } else {
                        CoBrowseManager.instance.cancelCobrowse(this.mBrandId, url, action);
                    }
                }
            });
        } else {
            this.mCobrowseWebviewReceiver.register();
        }
    }

    protected void registerCobrowseReceivedReceiver() {
        if (this.mCobrowseReceivedReceiver == null) {
            this.mCobrowseReceivedReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_COBROWSE_RECEIVED").build((context, intent) -> {
                String automaticMessageKey = intent.getStringExtra("automaticMessageKey");
                String dialogId = intent.getStringExtra("dialogId");
                String agentId = intent.getStringExtra("agentId");
                boolean newMessages = intent.getBooleanExtra("newMessages", false);
                boolean isMainDialogResolved = intent.getBooleanExtra("isMainDialogResolved", false);
                if (newMessages) {
                    if (this.mRecyclerView != null && this.mRecyclerView.getAdapter() != null) {
                        this.mRecyclerView.getAdapter().notifyDataSetChanged();
                    }
                    LPLog.INSTANCE.d(TAG, "CoBrowseLogic cobrowsefragment registerCobrowseReceivedReceiver received system message " + LPLog.INSTANCE.mask((Object)automaticMessageKey));
                }
                this.announceCobrowseEvent(automaticMessageKey, agentId, dialogId);
                String activeDialogId = MessagingFactory.getInstance().getController().amsDialogs.getActiveCoBrowseDialogId();
                LPLog.INSTANCE.d(TAG, "automaticMessageKey: " + LPLog.INSTANCE.mask((Object)automaticMessageKey) + " for dialogId: " + dialogId);
                if (activeDialogId != null && (activeDialogId.equals(dialogId) && (automaticMessageKey.equals("COLLABORATION_CALL_ENDED_BY_CONSUMER") || automaticMessageKey.equals("COLLABORATION_CALL_ENDED_BY_AGENT") || automaticMessageKey.equals("COLLABORATION_CALL_DECLINED") || automaticMessageKey.equals("COLLABORATION_CALL_CANCEL_INVITATION") || automaticMessageKey.equals("COLLABORATION_CALL_NOT_JOINED") || automaticMessageKey.equals("COLLABORATION_CALL_TIMEOUT") || automaticMessageKey.equals("COLLABORATION_CALL_ENDED")) || isMainDialogResolved)) {
                    LPLog.INSTANCE.i(TAG, "registerCobrowseReceivedReceiver: Remove CoBrows message from view");
                    this.mRecyclerView.removeCoBrowsMessageFromView(dialogId);
                    MessagingFactory.getInstance().getController().amsDialogs.setActiveCoBrowseDialogId(null);
                }
            });
        } else {
            this.mCobrowseReceivedReceiver.register();
        }
    }

    protected void registerDialogStateChangedReceiver() {
        if (this.mDialogStateChangeReceiver == null) {
            this.mDialogStateChangeReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_UPDATE_CSAT_DIALOG").addAction("BROADCAST_UPDATE_DIALOG_CLOSED").build((context, intent) -> {
                String targetId = intent.getStringExtra("KEY_DIALOG_TARGET_ID");
                LPLog.INSTANCE.d(TAG, "Got update on brand - dialog state: " + targetId);
                if (this.mIConversationProvider.getTargetId().equals(targetId) && intent.getAction() != null && intent.getAction().equals("BROADCAST_UPDATE_DIALOG_CLOSED")) {
                    String dialogId = intent.getStringExtra("DIALOG_ID");
                    this.handleClosedDialog(dialogId);
                }
            });
        } else {
            this.mDialogStateChangeReceiver.register();
        }
    }

    protected void registerConversationStateChangedReceiver() {
        if (this.mConversationStateChangeReceiver == null) {
            this.mConversationStateChangeReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_UPDATE_CSAT_CONVERSATION").addAction("BROADCAST_UPDATE_CONVERSATION_CLOSED").build((context, intent) -> {
                String targetId = intent.getStringExtra("CONVERSATION_TARGET_ID");
                LPLog.INSTANCE.d(TAG, "Got update on brand - conversation state: " + targetId);
                if (this.mIConversationProvider.getTargetId().equals(targetId) && intent.getAction() != null) {
                    if (intent.getAction().equals("BROADCAST_UPDATE_CONVERSATION_CLOSED")) {
                        String conversationID = intent.getStringExtra("CONVERSATION_ID");
                        this.handleConversationClosed(conversationID);
                    } else if (intent.getAction().equals("BROADCAST_UPDATE_CSAT_CONVERSATION")) {
                        String conversationID = intent.getStringExtra("CONVERSATION_ID");
                        ConversationState state = ConversationState.values()[intent.getIntExtra("CONVERSATION_STATE", -1)];
                        int isShowedCsatValue = intent.getIntExtra("CONVERSATION_SHOWED_CSAT", CSAT.CSAT_SHOW_STATUS.NO_VALUE.getValue());
                        CSAT.CSAT_SHOW_STATUS isShowedCsat = CSAT.CSAT_SHOW_STATUS.parse((int)isShowedCsatValue);
                        String agentId = intent.getStringExtra("CONVERSATION_ASSIGNED_AGENT");
                        this.handleConversationUpdate(conversationID, state, isShowedCsat, agentId);
                    }
                }
            });
        } else {
            this.mConversationStateChangeReceiver.register();
        }
    }

    protected void registerFileUploadStatusReceiver() {
        if (this.mFileUploadStatusReceiver == null) {
            this.mFileUploadStatusReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_FILE_UPLOAD_FAILED").build((context, intent) -> {
                String errorMessage = intent.getStringExtra("KEY_FILE_UPLOAD_ERROR");
                this.showErrorDialog(errorMessage);
            });
        } else {
            this.mFileUploadStatusReceiver.register();
        }
    }

    protected void registerWelcomeMessageReceiver() {
        if (this.mWelcomeMessageEventReceiver == null) {
            this.mWelcomeMessageEventReceiver = WelcomeMessageBroadcastReceiver.createReceiver((WelcomeMessageEventListener)this);
        }
        WelcomeMessageBroadcastReceiver.registerWelcomeMessageActions((BroadcastReceiver)this.mWelcomeMessageEventReceiver, (Context)this.requireActivity(), (String)this.mBrandId);
    }

    protected void registerHybridActionsReceiver() {
        if (this.mHybridActionsReceiver == null) {
            this.mHybridActionsReceiver = HybridSDKActions.createHybridActionsReceiver(this);
        }
        HybridSDKActions.registerHybridActionsReceiver((Context)this.requireActivity(), this.mHybridActionsReceiver);
    }

    protected void registerAgentInfoChangedReceiver() {
        if (this.mAgentProfileUpdatesReceiver == null) {
            this.mAgentProfileUpdatesReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_AGENT_CHANGED").addAction("BROADCAST_KEY_AUTH_COMPLETED_ACTION").build((context, intent) -> this.updateAgentDetails());
        } else {
            this.mAgentProfileUpdatesReceiver.register();
        }
    }

    protected void handleClosedDialog(String dialogId) {
        Messaging controller = MessagingFactory.getInstance().getController();
        this.hideCobrowseFragment();
        this.mRecyclerView.removeQuickRepliesMessageOfDialog(dialogId);
        this.mRecyclerView.notifyLastMessageChanges();
        Dialog dialog = controller.amsDialogs.getActiveDialog();
        if (dialog == null) {
            controller.refreshMonitoringEngagement();
        }
        if (dialog != null && dialog.getDialogType() == DialogType.POST_SURVEY) {
            this.tryToClearCoBrowseDialog(controller);
        }
        controller.sendBroadcastStopTyping();
    }

    protected void handleConversationClosed(String conversationId) {
        boolean shouldClearActiveDialog;
        Messaging controller = MessagingFactory.getInstance().getController();
        this.mRecyclerView.removeQuickRepliesMessageOfConversation(conversationId);
        boolean bl = shouldClearActiveDialog = !controller.amsConversations.isConversationActive(this.mBrandId);
        if (shouldClearActiveDialog) {
            this.tryToClearCoBrowseDialog(controller);
        }
    }

    private void tryToClearCoBrowseDialog(Messaging controller) {
        AmsDialogs dialogs = controller.amsDialogs;
        String activeCoBrowseDialogId = dialogs.getActiveCoBrowseDialogId();
        if (activeCoBrowseDialogId != null) {
            LPLog.INSTANCE.d(TAG, "handleConversationClosed: hiding CoBrows fragment and removing from view");
            this.hideCobrowseFragment();
            this.mRecyclerView.removeCoBrowsMessageFromView(activeCoBrowseDialogId);
            dialogs.setActiveCoBrowseDialogId(null);
        }
    }

    protected void handleConversationUpdate(String conversationID, ConversationState state, CSAT.CSAT_SHOW_STATUS csatShowStatus, String agentId) {
        switch (state) {
            case CLOSE: {
                LPLog.INSTANCE.d(TAG, "handle Dialog Update - conversation is closed. csatShowStatus = " + csatShowStatus);
                this.hideSecuredFormFragment();
                this.hideAppointmentSchedulerFragment();
                this.hideDatePickerFragment();
                this.setAgentIsTyping(false, null);
                if (csatShowStatus == CSAT.CSAT_SHOW_STATUS.NOT_SHOWN) {
                    this.showFeedbackFragment(conversationID, agentId);
                    break;
                }
                this.hideFeedBackFragment();
                break;
            }
            case OPEN: {
                this.hideFeedBackFragment();
                break;
            }
        }
    }

    private void showFeedbackFragment(String conversationID, String agentId) {
        LPLog.INSTANCE.i(TAG, "Dialog is closed.");
        if (!Configuration.getBoolean((int)R.bool.show_feedback)) {
            LPLog.INSTANCE.i(TAG, "show_feedback configuration is set to false");
            return;
        }
        Messaging controller = MessagingFactory.getInstance().getController();
        controller.amsConversations.updateCSAT(this.mBrandId, conversationID);
        controller.amsDialogs.queryDialogsByConversationId(conversationID).setPostQueryOnBackground(dialogs -> {
            boolean doesConversationHasSurveyWithMessages = false;
            for (Dialog dialog : dialogs) {
                if (dialog.getDialogType() != DialogType.POST_SURVEY) continue;
                doesConversationHasSurveyWithMessages = true;
            }
            if (!doesConversationHasSurveyWithMessages && !TextUtils.isEmpty((CharSequence)agentId)) {
                controller.amsUsers.getUserById(agentId).setPostQueryOnUI(data -> {
                    if (data != null) {
                        LPLog.INSTANCE.i(TAG, "Agent available, showing csat screen.");
                        this.onConversationResolved(conversationID);
                        this.showFeedbackFragment(data.getNickname(), data.getAvatarUrl(), conversationID);
                    }
                }).execute();
            } else {
                Infra.instance.postOnMainThread(() -> this.onConversationResolved(conversationID));
            }
        }).execute();
    }

    protected void registerConnectionReceiver() {
        if (this.mConnectionReceiver == null) {
            LocalBroadcastReceiver.Builder connectionReceiverBuilder = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_KEY_SOCKET_READY_ACTION").addAction("BROADCAST_AMS_CONNECTION_UPDATE_ACTION").addAction("BROADCAST_KEY_AUTH_COMPLETED_ACTION");
            LPLog.INSTANCE.d(TAG, "registerConnectionReceiver - lp_hide_ui_until_auth:" + Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth));
            if (Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth)) {
                connectionReceiverBuilder.addAction("BROADCAST_SOCKET_OPEN_ACTION");
            }
            this.mConnectionReceiver = connectionReceiverBuilder.build((context, intent) -> {
                String brandId = intent.getStringExtra("BROADCAST_KEY_BRAND_ID");
                if ("BROADCAST_KEY_SOCKET_READY_ACTION".equals(intent.getAction())) {
                    if (this.mBrandId.equals(brandId)) {
                        boolean isConnected = intent.getBooleanExtra("BROADCAST_KEY_SOCKET_READY_EXTRA", false);
                        LPLog.INSTANCE.i(TAG, "Connection changed! new status: " + isConnected + " last status: " + this.mLastSocketReady);
                        if (this.mLastSocketReady != isConnected) {
                            this.mLastSocketReady = isConnected;
                            this.onConnectionChanged(isConnected);
                        }
                    }
                } else if ("BROADCAST_AMS_CONNECTION_UPDATE_ACTION".equals(intent.getAction())) {
                    if (this.mBrandId.equals(brandId)) {
                        String otelUrl;
                        boolean isUpdated = intent.getBooleanExtra("BROADCAST_AMS_CONNECTION_UPDATE_EXTRA", false);
                        this.mEnterMessageLayout.onUpdate(isUpdated);
                        if (isUpdated && (otelUrl = PreferenceManager.getInstance().getStringValue("otelDomainConsumerSdk", this.mBrandId, null)) != null) {
                            LPTelemetryManager.INSTANCE.endParentCollector(otelUrl);
                        }
                        this.shouldShowOfflineProgressBar(!isUpdated);
                    }
                } else if ("BROADCAST_KEY_AUTH_COMPLETED_ACTION".equals(intent.getAction())) {
                    if (this.mRecyclerView != null) {
                        this.mRecyclerView.onForeground();
                    }
                    this.isAuthenCompleted = true;
                    if (this.hasSocketBeenOpened && Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth)) {
                        this.mLoadingView.setVisibility(8);
                    }
                } else if ("BROADCAST_SOCKET_OPEN_ACTION".equals(intent.getAction())) {
                    this.hasSocketBeenOpened = true;
                    if (this.isAuthenCompleted && Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth)) {
                        this.mLoadingView.setVisibility(8);
                    }
                }
            });
        }
        this.mConnectionReceiver.register();
    }

    protected void unregisterReceivers() {
        this.unregisterBroadcastReceivers(this.mConnectionReceiver, this.mConversationStateChangeReceiver);
        this.unregisterBroadcastReceivers(this.mCobrowseWebviewReceiver);
        if (!this.isOpeningCobrowseActivity && !this.isCobrowseActive()) {
            this.unregisterBroadcastReceivers(this.mCobrowseReceivedReceiver);
        }
        this.unregisterBroadcastReceivers(this.mDialogStateChangeReceiver, this.mFormStateChangeReceiver);
        this.unregisterBroadcastReceivers(this.mAgentTypingReceiver, this.mAgentProfileUpdatesReceiver, this.mUnAuthenticatedUserExpired, this.mFileUploadStatusReceiver);
        try {
            if (this.mWelcomeMessageEventReceiver != null) {
                this.requireActivity().unregisterReceiver(this.mWelcomeMessageEventReceiver);
            }
            if (this.mHybridActionsReceiver != null) {
                this.requireActivity().unregisterReceiver(this.mHybridActionsReceiver);
            }
        }
        catch (Exception exception) {
            LPLog.INSTANCE.d(TAG, "Failed to unregister receiver", (Throwable)exception);
        }
    }

    protected void unregisterControllers() {
        if (this.mInlineMessagesController != null) {
            this.mInlineMessagesController.unregister();
        }
        if (this.mConnectionStatusController != null) {
            this.mConnectionStatusController.unregister();
        }
    }

    protected void unregisterForegroundService() {
        ForegroundService.getInstance().unregisterBrand(this.mIConversationProvider.getBrandId());
        ForegroundService.getInstance().unregisterTarget(this.mIConversationProvider.getTargetId());
    }

    protected void initConversationProvider() {
        LPLog.INSTANCE.d(TAG, "initConversationProvider");
        this.mBrandId = this.getArguments().getString("brand_id");
        this.mIConversationProvider = new IConversationProvider(){

            public String getBrandId() {
                return ConversationFragment.this.mBrandId;
            }

            public String getTargetId() {
                return ConversationFragment.this.mBrandId;
            }
        };
    }

    public boolean onBackPressed() {
        if (!this.isVisible()) {
            return false;
        }
        FeedbackFragment feedbackFragment = this.getFeedbackFragment();
        if (feedbackFragment != null) {
            if (feedbackFragment.isAdded()) {
                MessagingFactory.getInstance().getController().mEventsProxy.onCsatSkipped();
                this.setConversationLayoutVisible(true);
                return feedbackFragment.slideOutFragment();
            }
            return false;
        }
        SecuredFormFragment securedFormFragment = this.getSecuredFormFragment();
        if (securedFormFragment != null) {
            this.setConversationLayoutVisible(true);
            return securedFormFragment.isAdded() && securedFormFragment.slideOutFragment();
        }
        CobrowseFragment cobrowseFragment = this.getCobrowseFragment();
        if (cobrowseFragment != null && cobrowseFragment.isAdded()) {
            this.setAccessibilityImportance(true);
            this.setConversationLayoutVisible(true);
            return cobrowseFragment.hideItSelf("dialog.id.current");
        }
        FullImageFragment fullImageFragment = this.getFullImageFragment();
        if (fullImageFragment != null) {
            this.getChildFragmentManager().popBackStack();
            this.setConversationLayoutVisible(true);
            this.setAccessibilityImportance(true);
            return true;
        }
        CaptionPreviewFragment captionPreviewFragment = this.getCaptionPreviewFragment();
        if (captionPreviewFragment != null) {
            this.getChildFragmentManager().popBackStack();
            this.setConversationLayoutVisible(true);
            this.setAccessibilityImportance(true);
            return true;
        }
        AppointmentSchedulerFragment appointmentSchedulerFragment = this.getAppointmentSchedulerFragment();
        if (appointmentSchedulerFragment != null) {
            this.setConversationLayoutVisible(true);
            this.setAccessibilityImportance(true);
            this.hideAppointmentSchedulerFragment();
            return true;
        }
        DatePickerFragment datePickerFragment = this.getDatePickerFragment();
        if (datePickerFragment != null) {
            this.setConversationLayoutVisible(true);
            this.setAccessibilityImportance(true);
            this.hideDatePickerFragment();
            return true;
        }
        if (this.getFragmentManager().getBackStackEntryCount() > 0) {
            this.getFragmentManager().popBackStack();
        }
        this.onConversationFragmentClosed();
        return false;
    }

    public void onDestroyView() {
        ScrollDownIndicator indicator;
        View rootView;
        if (this.mRecyclerView != null) {
            this.mRecyclerView.setAnnouncer(null);
            this.mRecyclerView.setConversationViewCallback(null);
            this.mRecyclerView.setBlockInputAreaCallback(null);
            this.mInlineMessagesController = null;
        }
        if (this.mEnterMessageLayout != null) {
            this.mEnterMessageLayout.setAnnouncer(null);
        }
        if (this.mConnectionStatusController != null) {
            this.mConnectionStatusController.setAnnouncer(null);
            this.mConnectionStatusController.setOnVisibilityChangedListener(null);
        }
        if ((rootView = this.getView()) != null && (indicator = (ScrollDownIndicator)rootView.findViewById(R.id.lpui_scroll_down_indicator)) != null) {
            indicator.setAnnouncer(null);
        }
        super.onDestroyView();
    }

    public void onDestroy() {
        AppointmentOperationsHolder.INSTANCE.clear();
        ImageUtils.clearImageRequests((Context)this.getContext());
        if (this.mContextualActionBehavior != null) {
            this.mContextualActionBehavior.setContextualItemAction(null);
        }
        if (this.mInlineMessagesController != null) {
            this.mInlineMessagesController.hideAll();
        }
        try {
            FragmentActivity activity = this.requireActivity();
            if (this.mWelcomeMessageEventReceiver != null) {
                activity.unregisterReceiver(this.mWelcomeMessageEventReceiver);
                this.mWelcomeMessageEventReceiver = null;
            }
            if (this.mHybridActionsReceiver != null) {
                activity.unregisterReceiver(this.mHybridActionsReceiver);
                this.mHybridActionsReceiver = null;
            }
        }
        catch (Exception exception) {
            LPLog.INSTANCE.d(TAG, "Failed to unregister receiver", (Throwable)exception);
        }
        if (this.isCobrowseActive()) {
            this.unregisterBroadcastReceivers(this.mCobrowseReceivedReceiver);
        }
        LPLog.INSTANCE.d(TAG, "onDestroy");
        this.unregisterLaunchers();
        super.onDestroy();
        ConversationStateHandler.setIsConversationFragmentRunning(false);
    }

    public void onDetach() {
        if (this.pickMedia != null) {
            this.pickMedia.unregister();
        }
        if (this.recordAudioRequestPermissionLauncher != null) {
            this.recordAudioRequestPermissionLauncher.unregister();
        }
        if (this.cameraRequestPermissionLauncher != null) {
            this.cameraRequestPermissionLauncher.unregister();
        }
        if (this.mCobrowsePermissionsLauncher != null) {
            this.mCobrowsePermissionsLauncher.unregister();
        }
        super.onDetach();
    }

    private void unregisterLaunchers() {
        List<ActivityResultLauncher> launchers = Arrays.asList(this.pickMedia, this.recordAudioRequestPermissionLauncher, this.cameraRequestPermissionLauncher, this.mCobrowsePermissionsLauncher);
        for (ActivityResultLauncher launcher : launchers) {
            if (launcher == null) continue;
            launcher.unregister();
        }
    }

    public void initRelevantToolbar() {
        FeedbackFragment feedbackFragment = this.getFeedbackFragment();
        if (feedbackFragment != null && this.mFragmentContainer != null) {
            this.mFragmentContainer.setFeedBackMode(true, feedbackFragment);
        }
    }

    protected void onConversationResolved(String conversationServerId) {
        this.conversationId = conversationServerId;
        if (this.mInlineMessagesController != null) {
            this.mInlineMessagesController.onConversationResolved();
        }
        UIUtils.hideKeyboard((Activity)this.getActivity());
    }

    private void showFeedbackFragment(String agentNickname, String avatarUrl, String conversationId) {
        LPLog.INSTANCE.d(TAG, "Showing FeedbackFragment - agentNickname = " + LPLog.INSTANCE.mask((Object)agentNickname));
        this.mEnterMessageLayout.enableMicButtonTooltips(false);
        FeedbackFragment fragment = this.getFeedbackFragment();
        if (fragment == null || !fragment.isAdded()) {
            this.executePendingFragmentTransaction(fragment);
            MessagingFactory.getInstance().getController().mEventsProxy.onCsatLaunched();
            FeedbackFragment feedbackFragment = FeedbackFragment.newInstance(agentNickname, avatarUrl, conversationId);
            if (this.mFragmentContainer != null) {
                this.mFragmentContainer.setFeedBackMode(true, feedbackFragment);
            }
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.setCustomAnimations(R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out, R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out);
            transaction.add(R.id.lpui_fragment_child_container, (Fragment)feedbackFragment, "FeedbackFragment");
            transaction.addToBackStack("FeedbackFragment");
            this.setAccessibilityImportance(false);
            this.setConversationLayoutVisible(false);
            transaction.commit();
        }
    }

    private FeedbackFragment getFeedbackFragment() {
        return (FeedbackFragment)this.getChildFragmentManager().findFragmentByTag("FeedbackFragment");
    }

    private SecuredFormFragment getSecuredFormFragment() {
        return (SecuredFormFragment)this.getChildFragmentManager().findFragmentByTag("SecuredFormFragment");
    }

    private CobrowseFragment getCobrowseFragment() {
        return (CobrowseFragment)this.getChildFragmentManager().findFragmentByTag("CobrowseFragment");
    }

    private FullImageFragment getFullImageFragment() {
        return (FullImageFragment)this.getChildFragmentManager().findFragmentByTag(FullImageFragment.TAG);
    }

    private CaptionPreviewFragment getCaptionPreviewFragment() {
        return (CaptionPreviewFragment)this.getChildFragmentManager().findFragmentByTag("CaptionPreviewFragment");
    }

    private AppointmentSchedulerFragment getAppointmentSchedulerFragment() {
        String tag = "AppointmentSchedulerFragment";
        return (AppointmentSchedulerFragment)this.getChildFragmentManager().findFragmentByTag(tag);
    }

    private DatePickerFragment getDatePickerFragment() {
        return (DatePickerFragment)this.getChildFragmentManager().findFragmentByTag("DatePickerFragment");
    }

    private void setAccessibilityImportance(boolean isImportant) {
        if (AccessibilityChecker.exploreByTouchEnabled((Context)this.getActivity())) {
            if (isImportant) {
                this.mConversationLayout.setImportantForAccessibility(1);
            } else {
                this.mConversationLayout.setImportantForAccessibility(4);
            }
        }
    }

    private void showSecuredFormFragment(String url, String invitationId, String formTitle) {
        SecuredFormFragment fragment = this.getSecuredFormFragment();
        if (fragment == null || !fragment.isAdded()) {
            this.executePendingFragmentTransaction(fragment);
            Bundle bundle = new Bundle();
            bundle.putString("url", url);
            bundle.putString("invitation_id", invitationId);
            bundle.putString("form_title", formTitle);
            SecuredFormFragment securedFormFragment = new SecuredFormFragment();
            securedFormFragment.setArguments(bundle);
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.setCustomAnimations(R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out, R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out);
            transaction.add(R.id.lpui_fragment_child_container, (Fragment)securedFormFragment, "SecuredFormFragment");
            transaction.addToBackStack("SecuredFormFragment");
            this.setAccessibilityImportance(false);
            this.setConversationLayoutVisible(false);
            UIUtils.hideKeyboard((Activity)this.getActivity());
            transaction.commit();
        }
    }

    private void hideSecuredFormFragment() {
        this.setConversationLayoutVisible(true);
        SecuredFormFragment fragment = this.getSecuredFormFragment();
        LPLog.INSTANCE.d(TAG, "hideSecuredFormFragment, fragment = " + (Object)((Object)fragment));
        if (fragment != null && fragment.isAdded()) {
            fragment.slideOutSecureFormFragment();
        }
    }

    private void initCameraPermissionLauncher() {
        this.cameraRequestPermissionLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), result -> {
            this.isRequestingPermission = false;
            if (result.booleanValue()) {
                this.startCamera();
            } else {
                this.isPerformingFileOperation = false;
                boolean shouldDisplayPermissionDialog = PreferenceManager.getInstance().getBooleanValue("pref_camera_permission_dialog_status", this.mBrandId, false);
                if (this.getActivity() != null) {
                    PermissionUtilsKt.handleNotGrantedPermission(this.mBrandId, 2, "android.permission.CAMERA", PermissionType.PHOTO_SHARING, shouldDisplayPermissionDialog, (Activity)this.getActivity());
                }
            }
        });
    }

    private void initCobrowsePermissionsLauncher() {
        this.mCobrowsePermissionsLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestMultiplePermissions(), result -> {
            this.isRequestingPermission = false;
            boolean isGranted = true;
            Iterator iterator = result.values().iterator();
            while (iterator.hasNext()) {
                boolean permissionResult = (Boolean)iterator.next();
                isGranted &= permissionResult;
            }
            if (isGranted && this.mOpenCobrowseRunnable != null) {
                this.mOpenCobrowseRunnable.run();
            }
            this.mOpenCobrowseRunnable = null;
        });
    }

    private void showCobrowseScreen(String dialogId, String url, boolean isVideoCall) {
        CobrowseFragment fragment;
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            return;
        }
        if (CobrowseUtils.isPictureInPictureSupported((Context)activity)) {
            if (Configuration.getBoolean((int)R.bool.lp_cobrowse_picture_in_picture_enabled)) {
                this.launchCobrowsePIPMode((Activity)activity, dialogId, url, isVideoCall);
                return;
            }
            if (this.isCobrowseActive()) {
                CobrowseUtils.closeCobrowseActivitySilently((Context)activity);
            }
        }
        if ((fragment = this.getCobrowseFragment()) == null || !fragment.isAdded()) {
            this.executePendingFragmentTransaction(fragment);
            CobrowseFragment cobrowseFragment = CobrowseFragment.newInstance(url, dialogId, this.mBrandId, isVideoCall);
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.setCustomAnimations(R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out, R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out);
            transaction.add(R.id.lpui_fragment_child_container, (Fragment)cobrowseFragment, "CobrowseFragment");
            transaction.addToBackStack("CobrowseFragment");
            this.setAccessibilityImportance(false);
            this.setConversationLayoutVisible(false);
            transaction.commit();
        }
    }

    private void launchCobrowsePIPMode(Activity activity, String dialogId, String url, boolean isVideoCall) {
        this.mOpenCobrowseRunnable = () -> {
            this.isOpeningCobrowseActivity = true;
            this.startActivity(CobrowseActivity.newIntent(activity, url, dialogId, this.mBrandId, isVideoCall));
        };
        String[] permissions = isVideoCall ? new String[]{"android.permission.RECORD_AUDIO", "android.permission.CAMERA"} : new String[]{"android.permission.RECORD_AUDIO"};
        this.isRequestingPermission = true;
        this.mCobrowsePermissionsLauncher.launch((Object)permissions);
    }

    private void hideCobrowseFragment() {
        FragmentActivity activity = this.getActivity();
        CobrowseFragment fragment = this.getCobrowseFragment();
        this.setConversationLayoutVisible(true);
        this.setAccessibilityImportance(true);
        LPLog.INSTANCE.d(TAG, "hideCobrowseFragment, fragment = " + fragment);
        if (fragment != null && fragment.isAdded()) {
            fragment.hideItSelf("dialog.id.current");
        } else if (activity != null && this.isCobrowseActive()) {
            CobrowseUtils.closeCobrowseActivitySilently((Context)activity);
        }
    }

    private void hideFeedBackFragment() {
        this.setConversationLayoutVisible(true);
        this.mEnterMessageLayout.enableMicButtonTooltips(true);
        FeedbackFragment fragment = this.getFeedbackFragment();
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: hideFeedBackFragment, fragment = " + fragment);
        if (fragment != null) {
            fragment.slideOutFragment();
        }
    }

    private void executePendingFragmentTransaction(Fragment fragment) {
        if (fragment != null && !fragment.isAdded()) {
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.remove(fragment);
            transaction.commit();
            this.getChildFragmentManager().executePendingTransactions();
        }
    }

    public void onConversationFragmentClosed() {
        Messaging controller = MessagingFactory.getInstance().getController();
        FragmentActivity activity = this.getActivity();
        if (activity != null && this.isCobrowseActive()) {
            this.mPerformingBackNavigation = true;
            CobrowseUtils.closeCobrowseActivitySilently((Context)activity);
        }
        if (controller != null) {
            AmsMessages amsMessages;
            AmsConversations amsConversations = controller.amsConversations;
            if (amsConversations != null) {
                amsConversations.notifyConversationFragmentClosedEvent();
            }
            if ((amsMessages = controller.amsMessages) != null) {
                amsMessages.clearWelcomeMessageMetadata();
            }
            controller.onConversationDestroyed(this.mBrandId);
        } else {
            LPLog.INSTANCE.w(TAG, "onDestroy: Messaging is not initialized");
        }
    }

    private void updateAgentDetails() {
        boolean hasFinishedAuthenticating;
        Messaging controller = MessagingFactory.getInstance().getController();
        Dialog dialog = controller.amsDialogs.getActiveDialog();
        AmsAccount account = controller.mAccountsController.getAccount(this.mBrandId);
        boolean bl = hasFinishedAuthenticating = account != null && account.hasFinishedAuthenticating();
        if (dialog == null || !hasFinishedAuthenticating) {
            this.updateAgentData(null, null);
            if (this.mFragmentContainer != null) {
                this.mFragmentContainer.updateCurrentConversationAgentId(null);
            }
            return;
        }
        String currentAgentId = dialog.getAssignedAgentId();
        controller.amsUsers.getUserById(currentAgentId).setPostQueryOnUI(data -> {
            if (data == null) {
                this.updateAgentData(null, null);
                if (this.mFragmentContainer != null) {
                    this.mFragmentContainer.updateCurrentConversationAgentId(null);
                }
            } else if (!TextUtils.isEmpty((CharSequence)data.getNickname())) {
                this.updateAgentData(data.getNickname(), data.getAvatarUrl());
                if (this.mFragmentContainer != null) {
                    this.mFragmentContainer.updateCurrentConversationAgentId(currentAgentId);
                }
            }
        }).execute();
    }

    private void updateAgentData(String nickname, String avatarUrl) {
        this.mAgentNickName = nickname;
        if (this.mFragmentContainer != null) {
            this.mFragmentContainer.updateAgentDetails(nickname, avatarUrl);
        }
    }

    @Override
    public void sendCSAT(int starsNumber, int yesNoValue) {
        MessagingFactory.getInstance().getController().sendCSAT(this.mBrandId, this.conversationId, starsNumber, yesNoValue);
    }

    @Override
    public void onSurveySubmitted(String conversationId, int starRating) {
        FeedbackFragment feedbackFragment = this.getFeedbackFragment();
        if (feedbackFragment != null && this.mFragmentContainer != null) {
            this.mFragmentContainer.onSurveySubmitted(feedbackFragment);
        }
        MessagingFactory.getInstance().getController().mEventsProxy.onCsatSubmitted(conversationId, starRating);
    }

    private void setAgentIsTyping(boolean isTyping, String originatorId) {
        if (this.mIsTypingAnnouncementEnabledInBubble) {
            this.mRecyclerView.setAgentIsTyping(isTyping, originatorId);
        } else if (this.mFragmentContainer != null) {
            this.mFragmentContainer.updateAgentTypingIndication(isTyping);
        }
        if (this.mIsTypingAnnouncementEnabled && isTyping) {
            this.announceAgentTypingEvent();
        }
    }

    @Override
    public void setSecureFormMode(boolean on, String formTitle) {
        if (this.mFragmentContainer != null) {
            this.mFragmentContainer.setSecureFormMode(on, formTitle);
        }
    }

    @Override
    public void showCobrowseToolbar(int titleRes) {
        if (this.mFragmentContainer != null) {
            this.mFragmentContainer.showCobrowseToolbar(titleRes);
        }
    }

    @Override
    public void setFullImageMode(boolean on) {
        if (this.mFragmentContainer != null) {
            this.mFragmentContainer.setFullImageMode(on);
        }
    }

    @Override
    public void setCaptionPreviewMode(boolean on, String title) {
        if (!on) {
            this.setAccessibilityImportance(true);
            this.setConversationLayoutVisible(true);
        }
        if (this.mFragmentContainer != null) {
            this.mFragmentContainer.setCaptionPreviewMode(on, title);
        }
    }

    @Override
    public void slideOutCobrowseFragment() {
        if (this.mFragmentContainer != null) {
            this.mFragmentContainer.hideCobrowseToolbar();
        }
        this.setConversationLayoutVisible(true);
        if (this.getActivity() != null) {
            this.getChildFragmentManager().popBackStack();
        }
        this.requestFocusOnChildFragmentSlideOut();
    }

    @Override
    public void slideOutSecureFormFragment() {
        if (this.mFragmentContainer != null) {
            this.mFragmentContainer.setSecureFormMode(false, null);
        }
        this.setConversationLayoutVisible(true);
        if (this.getActivity() != null) {
            this.getChildFragmentManager().popBackStack();
        }
        this.requestFocusOnChildFragmentSlideOut();
    }

    private void requestFocusOnChildFragmentSlideOut() {
        if (this.getActivity() != null && AccessibilityChecker.exploreByTouchEnabled((Context)this.getActivity())) {
            this.setAccessibilityImportance(true);
            this.setConversationLayoutVisible(true);
            this.mRecyclerView.post(() -> {
                this.mRecyclerView.requestFocus();
                this.mRecyclerView.focusLastItem();
            });
        } else {
            this.mEnterMessageLayout.post(() -> this.mEnterMessageLayout.requestFocus());
        }
    }

    @Override
    public void slideOutFeedbackFragment() {
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: slideOutFragment, popping back stack");
        if (this.mFragmentContainer != null) {
            this.mFragmentContainer.setFeedBackMode(false, null);
        }
        if (this.getActivity() != null) {
            this.getChildFragmentManager().popBackStack();
        }
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: slideOutFragment, popping back stack completed. getFeedbackFragment() = " + this.getFeedbackFragment());
        MessagingFactory.getInstance().getController().mEventsProxy.onCsatDismissed();
        this.requestFocusOnChildFragmentSlideOut();
    }

    @Override
    public void slideOutFragment() {
        if (this.getActivity() != null) {
            this.getChildFragmentManager().popBackStack();
        }
        this.requestFocusOnChildFragmentSlideOut();
    }

    @Override
    public void PerformCopyTextToClipboard(String text) {
        ClipboardManager clipboard = (ClipboardManager)Infra.instance.getApplicationContext().getSystemService("clipboard");
        ClipData clip = ClipData.newPlainText((CharSequence)"", (CharSequence)text);
        clipboard.setPrimaryClip(clip);
    }

    @Override
    public void performSaveFile(String filePath) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            LPLog.INSTANCE.d(TAG, "invalid filepath = " + filePath + " cannot save file ");
            return;
        }
        this.saveFileToPublicDownloadsDir(filePath);
        PreferenceManager.getInstance().setStringValue(PREF_SAVE_FILE_PATH, this.mBrandId, filePath);
    }

    private void saveFileToPublicDownloadsDir(String filePath) {
        try {
            File privateDirectory = new File(filePath);
            String fileName = privateDirectory.getName();
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            String ext = MimeTypeMap.getFileExtensionFromUrl((String)filePath).toLowerCase();
            String type = mime.getMimeTypeFromExtension(ext);
            Intent intent = new Intent("android.intent.action.CREATE_DOCUMENT");
            intent.addCategory("android.intent.category.OPENABLE");
            intent.setType(type);
            intent.putExtra("android.intent.extra.TITLE", fileName);
            this.isPerformingFileOperation = true;
            this.startActivityForResult(intent, 4);
        }
        catch (Exception error) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000EE, "createNewFile: Failed to send request to create new file ", (Throwable)error);
        }
    }

    @Override
    public void performOpenLink(String link, boolean isCustomisedLink, BaseViewHolder.LinkType linkType) {
        try {
            Intent intent = null;
            Uri uri = null;
            switch (linkType) {
                case PHONE: {
                    intent = new Intent("android.intent.action.DIAL");
                    uri = Uri.parse((String)("tel:" + link));
                    break;
                }
                case EMAIL: {
                    intent = new Intent("android.intent.action.SENDTO");
                    uri = Uri.parse((String)("mailto:" + link));
                    break;
                }
                case URL: {
                    String schema;
                    intent = new Intent("android.intent.action.VIEW");
                    try {
                        schema = Uri.parse((String)link).getScheme();
                    }
                    catch (Exception ex) {
                        schema = null;
                    }
                    if (!isCustomisedLink && schema == null) {
                        uri = Uri.parse((String)("http://" + link));
                        break;
                    }
                    uri = Uri.parse((String)link);
                    break;
                }
                case NAVIGATION: {
                    uri = Uri.parse((String)link);
                    intent = new Intent("android.intent.action.VIEW");
                }
            }
            if (intent != null && uri != null) {
                intent.setData(uri);
                if (intent.resolveActivity(this.getActivity().getPackageManager()) != null) {
                    this.startActivity(intent);
                }
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000EF, "Failed to open a link.", (Throwable)e);
        }
    }

    @Override
    public void performFileAction(String filePath, ContextualItemAction.Action action) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            LPLog.INSTANCE.d(TAG, "invalid filepath = " + filePath + " cannot perform action " + action.name());
            return;
        }
        File file = new File(filePath);
        MimeTypeMap mime = MimeTypeMap.getSingleton();
        String ext = MimeTypeMap.getFileExtensionFromUrl((String)filePath).toLowerCase();
        String type = mime.getMimeTypeFromExtension(ext);
        String title = null;
        Uri contentUri = LPFileProvider.getUriForFile((Context)this.getActivity(), (String)(Infra.getFileProviderAuthorityPrefix() + this.getActivity().getApplicationInfo().packageName), (File)file);
        Intent intent = new Intent();
        switch (action) {
            case SHARE: {
                intent.setAction("android.intent.action.SEND");
                intent.putExtra("android.intent.extra.STREAM", (Parcelable)contentUri);
                intent.setDataAndType(contentUri, type);
                intent.setFlags(1);
                title = this.getResources().getString(R.string.lp_file_share);
                break;
            }
            case OPEN: {
                intent.setAction("android.intent.action.VIEW");
                intent.setDataAndType(contentUri, type);
                intent.setFlags(1);
                title = this.getResources().getString(R.string.lp_file_open);
            }
        }
        PackageManager packageManager = this.getActivity().getPackageManager();
        List activities = packageManager.queryIntentActivities(intent, 65536);
        if (activities != null && !activities.isEmpty()) {
            for (ResolveInfo resolvedIntentInfo : activities) {
                String packageName = resolvedIntentInfo.activityInfo.packageName;
                this.getActivity().grantUriPermission(packageName, contentUri, 1);
            }
        }
        this.isPerformingFileOperation = true;
        this.getActivity().startActivity(Intent.createChooser((Intent)intent, (CharSequence)title));
    }

    @Override
    public void onFileClicked(FileSharingType fileSharingType, String filePath, String imageSwiftPath, long messageRowId, long fileRowId, String conversationId) {
        if (TextUtils.isEmpty((CharSequence)filePath)) {
            MessagingFactory.getInstance().getController().downloadFile(fileSharingType, this.mBrandId, this.mBrandId, imageSwiftPath, messageRowId, fileRowId, conversationId);
        } else if (!this.mContextualActionBehavior.isSelectable()) {
            switch (fileSharingType.getCommonFileType()) {
                case IMAGE: {
                    this.openFullImageScreen(filePath);
                    break;
                }
                case DOCUMENT: {
                    this.performFileAction(filePath, ContextualItemAction.Action.OPEN);
                    break;
                }
            }
        }
    }

    @Override
    public void restoreRecyclerViewInstanceState() {
        if (this.mSavedRecyclerLayoutState != null) {
            LPLog.INSTANCE.d(TAG, "onHistoryLoaded: restoring previous recyclerview state");
            if (this.mRecyclerView.getLayoutManager() != null) {
                this.mRecyclerView.getLayoutManager().onRestoreInstanceState(this.mSavedRecyclerLayoutState);
            }
        }
    }

    @Override
    public void showEmptyView() {
        if (this.mLoadingView.getVisibility() != 8) {
            this.mLoadingView.setVisibility(8);
        }
        if (this.mRecyclerView.getVisibility() != 4) {
            this.mRecyclerView.setVisibility(4);
        }
        if (this.mEmptyView.getVisibility() != 0) {
            this.mEmptyView.setVisibility(0);
        }
    }

    @Override
    public void hideEmptyView() {
        if (Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth)) {
            if (this.hasSocketBeenOpened && this.isAuthenCompleted) {
                this.mLoadingView.setVisibility(8);
            } else if (Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled)) {
                this.mLoadingView.setVisibility(8);
            } else if (this.isCobrowseActive()) {
                this.mLoadingView.setVisibility(8);
            } else {
                this.mLoadingView.setVisibility(0);
            }
        } else {
            this.mLoadingView.setVisibility(8);
        }
        if (this.mRecyclerView.getVisibility() != 0) {
            this.mRecyclerView.setVisibility(0);
        }
        if (this.mEmptyView.getVisibility() != 4) {
            this.mEmptyView.setVisibility(4);
        }
    }

    @Override
    public void onDatePickerClicked(@NonNull DatePickerParams calendarInitInfo) {
        this.openDatePickerInFragment(calendarInitInfo);
    }

    private void openDatePickerInFragment(@NonNull DatePickerParams params) {
        DatePickerFragment fragment = this.getDatePickerFragment();
        if (fragment == null || !fragment.isAdded()) {
            this.executePendingFragmentTransaction((Fragment)fragment);
            fragment = DatePickerFragment.newInstance((DatePickerParams)params);
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.setCustomAnimations(R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out, R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out);
            transaction.add(R.id.lpui_fragment_child_container, (Fragment)fragment, "DatePickerFragment");
            transaction.addToBackStack("DatePickerFragment");
            this.setAccessibilityImportance(false);
            this.setConversationLayoutVisible(false);
            transaction.commit();
            if (this.mFragmentContainer != null) {
                this.mFragmentContainer.hideConversationToolBar(true);
            }
            UIUtils.hideKeyboard((Activity)this.requireActivity());
        }
    }

    @Override
    public void onAppointmentSchedulerRequested(@NotNull LPAppointmentInfo lpAppointmentInfo) {
        AppointmentSchedulerFragment fragment = this.getAppointmentSchedulerFragment();
        if (fragment == null || !fragment.isAdded()) {
            this.executePendingFragmentTransaction((Fragment)fragment);
            Bundle bundle = new Bundle();
            bundle.putParcelable("LPAppointmentInitInfo", (Parcelable)lpAppointmentInfo);
            AppointmentSchedulerFragment appointmentSchedulerFragment = new AppointmentSchedulerFragment();
            appointmentSchedulerFragment.setArguments(bundle);
            FragmentTransaction transaction = this.getChildFragmentManager().beginTransaction();
            transaction.setCustomAnimations(R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out, R.anim.lpmessaging_ui_slide_in, R.anim.lpmessaging_ui_slide_out);
            String tag = "AppointmentSchedulerFragment";
            transaction.add(R.id.lpui_fragment_child_container, (Fragment)appointmentSchedulerFragment, tag);
            transaction.addToBackStack("AppointmentSchedulerFragment");
            this.setAccessibilityImportance(false);
            this.setConversationLayoutVisible(false);
            transaction.commit();
            if (this.mFragmentContainer != null) {
                this.mFragmentContainer.hideConversationToolBar(true);
            }
        }
    }

    public void onEventReceived(@NonNull String event) {
        Messaging messaging = MessagingFactory.getInstance().getController();
        if (!messaging.isInitialized()) {
            return;
        }
        if (!messaging.isSocketOpen(this.mBrandId)) {
            OfflineMessagingManager manager = messaging.getOfflineManager();
            if (manager != null && manager.isOfflineModeEnabled()) {
                LPLog.INSTANCE.d(TAG, "Welcome message changed in offline mode. Skipping.");
                return;
            }
            LPLog.INSTANCE.d(TAG, "Welcome message changed. Attempting to show message.");
        }
        ConversationUtils conversationUtils = new ConversationUtils(messaging);
        if (!"action.welcome.message.changed".equals(event)) {
            conversationUtils.cancelWelcomeMessageTimeoutTasks();
        }
        LPWelcomeMessage welcomeMessage = conversationUtils.getWelcomeMessage(this.mBrandId);
        Dialog dialog = messaging.amsDialogs.getActiveDialog();
        if (dialog != null) {
            return;
        }
        if (welcomeMessage != null) {
            conversationUtils.showWelcomeMessage(this.mBrandId, welcomeMessage);
        }
    }

    @Override
    public void openCamera() {
        UIUtils.hideKeyboard((Activity)this.requireActivity());
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.verifyCameraPermission((Activity)this.getActivity())) {
                this.startCamera();
            }
        } else {
            this.startCamera();
        }
    }

    @Override
    public void openPhotoPicker() {
        UIUtils.hideKeyboard((Activity)this.requireActivity());
        try {
            ConversationFragmentUtilsKt.startPhotoPicker(this.pickMedia);
        }
        catch (ActivityNotFoundException e) {
            Toast.makeText((Context)this.getContext(), (int)R.string.lp_photo_picker_error, (int)0).show();
            LPLog.INSTANCE.i(TAG, "Failed to load images from gallery");
        }
    }

    @Override
    public void openFileChooser() {
        UIUtils.hideKeyboard((Activity)this.requireActivity());
        this.openDocumentProvider();
    }

    @Override
    public void onReadOnlyModeChanged(boolean isReadOnlyMode) {
        this.mReadOnlyMode = isReadOnlyMode;
        this.mEnterMessageLayout.setVisibility(this.mReadOnlyMode ? 8 : 0);
    }

    private void hideAppointmentSchedulerFragment() {
        AppointmentSchedulerFragment appointmentSchedulerFragment = this.getAppointmentSchedulerFragment();
        if (appointmentSchedulerFragment != null) {
            this.getChildFragmentManager().popBackStack();
            this.setConversationLayoutVisible(true);
            this.setAccessibilityImportance(true);
        }
        if (this.mFragmentContainer != null) {
            this.mFragmentContainer.hideConversationToolBar(false);
        }
    }

    private void hideDatePickerFragment() {
        DatePickerFragment datePickerFragment = this.getDatePickerFragment();
        if (datePickerFragment != null) {
            this.getChildFragmentManager().popBackStack();
            this.setAccessibilityImportance(true);
            this.setConversationLayoutVisible(true);
        }
        if (this.mFragmentContainer != null) {
            this.mFragmentContainer.hideConversationToolBar(false);
        }
    }

    private void refreshLoadingViewOption() {
        boolean isSocketReady;
        Messaging controller = MessagingFactory.getInstance().getController();
        if (controller == null) {
            LPLog.INSTANCE.w(TAG, "refreshLoadingViewOption: Messaging is not initialized");
            return;
        }
        boolean bl = isSocketReady = controller.isInitialized() ? controller.mConnectionController.isSocketReady(this.mBrandId) : false;
        if (Configuration.getBoolean((int)R.bool.lp_hide_ui_until_auth) && !isSocketReady) {
            this.isAuthenCompleted = this.hasSocketBeenOpened = this.isCobrowseActive();
            if (this.mLoadingView != null) {
                int visibility = controller.getOfflineManager().isOfflineModeEnabled() ? 8 : 0;
                this.mLoadingView.setVisibility(visibility);
            }
        } else if (this.mLoadingView != null) {
            this.mLoadingView.setVisibility(8);
        }
    }

    private void openFullImageScreen(String fullImageLocalPath) {
        FullImageFragment fragment = (FullImageFragment)this.getChildFragmentManager().findFragmentByTag(FullImageFragment.class.getSimpleName());
        if (fragment == null) {
            fragment = FullImageFragment.newInstance(fullImageLocalPath);
        }
        this.setAccessibilityImportance(false);
        this.setConversationLayoutVisible(false);
        FragmentTransaction fragmentTransaction = this.getChildFragmentManager().beginTransaction();
        fragmentTransaction.addToBackStack(FullImageFragment.TAG);
        fragmentTransaction.add(R.id.lpui_fragment_child_container, (Fragment)fragment, FullImageFragment.TAG);
        fragmentTransaction.commit();
    }

    private void showErrorDialog(String message) {
        try {
            if (message.equals("Unsupported file size")) {
                String errorTitle = this.getResources().getString(R.string.lp_not_supported_file_size);
                String errorMessage = this.getResources().getString(R.string.lp_file_size_exceeds);
                new AlertDialog.Builder(this.requireContext(), R.style.LpAlertDialogCustom).setTitle((CharSequence)errorTitle).setMessage((CharSequence)errorMessage).setCancelable(false).setPositiveButton((CharSequence)"OK", null).show();
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F1, "Failed to display error dialog.", (Throwable)e);
        }
    }

    private void unregisterBroadcastReceiverSilently(LocalBroadcastReceiver receiver2) {
        if (receiver2 != null) {
            receiver2.unregister();
        }
    }

    private void unregisterBroadcastReceivers(LocalBroadcastReceiver ... receivers) {
        for (LocalBroadcastReceiver receiver2 : receivers) {
            this.unregisterBroadcastReceiverSilently(receiver2);
        }
    }

    @Override
    public void announce(@NonNull CharSequence announcement) {
        if (Configuration.getBoolean((int)R.bool.lp_announce_events_with_live_region)) {
            this.announceUsingLiveRegion(announcement);
        } else {
            this.announceNow(announcement);
        }
    }

    private void announceUsingLiveRegion(CharSequence announcement) {
        if (this.mLiveRegionView != null) {
            CharSequence contentDescription = this.mLiveRegionView.getContentDescription();
            if (TextUtils.equals((CharSequence)announcement, (CharSequence)contentDescription)) {
                this.mLiveRegionView.setContentDescription((CharSequence)"");
            }
            this.mLiveRegionView.setContentDescription(announcement);
        }
    }

    private void announceNow(CharSequence announcement) {
        if (this.mLiveRegionView != null) {
            this.mLiveRegionView.announceForAccessibility(announcement);
        }
    }

    private void announceCobrowseEvent(String messageKey, String agentId, String dialogId) {
        String str = CoBrowseManager.instance.getTranscendentMessageContent(messageKey);
        Messaging controller = MessagingFactory.getInstance().getController();
        Context context = this.getContext();
        if (controller != null && controller.isInitialized() && context != null && TextUtils.equals((CharSequence)controller.amsDialogs.getActiveCoBrowseDialogId(), (CharSequence)dialogId)) {
            controller.amsUsers.getUserById(agentId).setPostQueryOnUI(data -> {
                String nickname = data == null ? context.getString(R.string.lp_accessibility_agent) : data.getNickname();
                String msgFormatted = String.format(str, nickname);
                View announcemntView = this.mLiveRegionView;
                if (announcemntView != null) {
                    announcemntView.postDelayed(() -> this.announce(msgFormatted), 1000L);
                }
            }).execute();
        }
    }

    private void shouldShowOfflineProgressBar(boolean shouldShow) {
        int visibility = shouldShow && Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled) ? 0 : 8;
        LPProgressBar progressBar = this.mOfflineProgressBar;
        if (progressBar != null) {
            progressBar.setVisibility(visibility);
        }
    }

    private boolean isCobrowseActive() {
        String brandId = this.mBrandId;
        if (brandId == null) {
            return false;
        }
        return !this.mPerformingBackNavigation && CoBrowseManager.instance.isCobrowseActive(this.mBrandId) || this.isOpeningCobrowseActivity;
    }

    private void uploadFileWithoutCaption(String fileUrl, boolean capturedFromCamera) {
        FileSharingType type = FileSharingUtils.getFileSharingTypeFromUri((String)fileUrl, (Context)this.getActivity());
        Messaging messaging = MessagingFactory.getInstance().getController();
        if (messaging == null || !messaging.isInitialized()) {
            return;
        }
        messaging.sendFileMessage(type, this.mBrandId, this.mBrandId, fileUrl, "", capturedFromCamera);
    }

    private void setConversationLayoutVisible(boolean isVisible) {
        if (this.mConversationLayout != null) {
            int visibility = isVisible ? 0 : 8;
            this.mConversationLayout.setVisibility(visibility);
        }
    }

    @Override
    public void onVisibilityChanged(int visibility) {
        boolean isOfflineModeEnabled = Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled);
        if (this.mOfflineProgressBar != null && isOfflineModeEnabled) {
            int progressVisibility = visibility == 0 ? 8 : 0;
            this.mOfflineProgressBar.setVisibility(progressVisibility);
        }
    }

    @Override
    public void onBlockInputChecked(boolean isBlocked) {
        LPLog.INSTANCE.d(TAG, "onBlockInputChecked " + isBlocked);
        this.mEnterMessageLayout.setEnabled(!isBlocked);
        if (isBlocked) {
            UIUtils.hideKeyboard((Activity)this.requireActivity());
        }
    }

    static {
        AppCompatDelegate.setCompatVectorFromResourcesEnabled((boolean)true);
    }
}

