/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.fragment;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.IFeedbackActions;
import com.liveperson.infra.messaging_ui.fragment.NestedFragmentsContainerCallbacks;
import com.liveperson.infra.messaging_ui.utils.AccessbilityUtilsKt;
import com.liveperson.infra.ui.view.resources.ResourceHelper;
import com.liveperson.infra.ui.view.uicomponents.IConnectionChangedCustomView;
import com.liveperson.infra.ui.view.utils.picasso.CircleTransform;
import com.liveperson.infra.utils.AccessibilityChecker;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.messaging.MessagingFactory;
import com.squareup.picasso.Transformation;
import java.lang.ref.WeakReference;

public class FeedbackFragment
extends Fragment
implements IFeedbackActions,
IConnectionChangedCustomView {
    public static final String TAG = "FeedbackFragment";
    private static final String AGENT_NAME_KEY = "AGENT_NAME_KEY";
    private static final String AGENT_AVATAR_KEY = "AGENT_AVATAR_KEY";
    private static final String AGENT_CONVERSATION_ID_KEY = "AGENT_CONVERSATION_ID_KEY";
    private static final int SLIDE_OUT_FRAGMENT = 3;
    private static final int FRAGMENT_SLIDE_DELAY_TIME_SHORT = 3000;
    private static final int FRAGMENT_SLIDE_DELAY_TIME_LONG = 4500;
    private static final String BUNDLE_NUM_STARS_SELECTED = "num_stars_selected";
    private static final String BUNDLE_YES_BUTTON_SELECTED = "yes_button_selected";
    private static final String BUNDLE_NO_BUTTON_SELECTED = "no_button_selected";
    private static final String BUNDLE_SUBMIT_BUTTON_ENABLED = "submit_button_selected";
    private static final String BUNDLE_SCREEN_STATE = "screen_state";
    public static final boolean CSAT_FLOW_DEBUG = true;
    private Handler mStarHandler;
    private LinearLayout mFinalSubmitLayout;
    private TextView mRateText;
    private TextView mQuestionText;
    private Button mSubmitButton;
    private LinearLayout mFeedbackLayout;
    private ImageView[] mStars;
    private Button mQuestionPositiveBtn;
    private Button mQuestionNegativeBtn;
    private NestedFragmentsContainerCallbacks mNestedFragmentsContainerCallbacks;
    private String mAgentNickname;
    private String mConversationID;
    private String mAgentAvatarUri;
    private String[] mStarsDescriptionTextArray;
    private int mSelectedStarNumber;
    private boolean isQuestionPositiveBtn = false;
    private boolean isQuestionNegativeBtn = false;
    private boolean isSubmitEnabled = false;
    private ScreenState mScreenState = null;

    public static FeedbackFragment newInstance(String agentName, String agentAvatarUri, String conversationId) {
        Bundle bundle = new Bundle();
        bundle.putString(AGENT_NAME_KEY, agentName);
        bundle.putString(AGENT_AVATAR_KEY, agentAvatarUri);
        bundle.putString(AGENT_CONVERSATION_ID_KEY, conversationId);
        FeedbackFragment feedbackFragment = new FeedbackFragment();
        feedbackFragment.setArguments(bundle);
        feedbackFragment.mScreenState = ScreenState.CSAT;
        return feedbackFragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mStarHandler = new StarHandler(this);
        this.onAttachFragment();
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: onCreate " + this.hashCode());
        if (savedInstanceState != null) {
            this.mScreenState = ScreenState.values()[savedInstanceState.getInt(BUNDLE_SCREEN_STATE)];
            this.mSelectedStarNumber = savedInstanceState.getInt(BUNDLE_NUM_STARS_SELECTED, 0);
            this.isQuestionPositiveBtn = savedInstanceState.getBoolean(BUNDLE_YES_BUTTON_SELECTED, false);
            this.isQuestionNegativeBtn = savedInstanceState.getBoolean(BUNDLE_NO_BUTTON_SELECTED, false);
            this.isSubmitEnabled = savedInstanceState.getBoolean(BUNDLE_SUBMIT_BUTTON_ENABLED, false);
            LPLog.INSTANCE.d(TAG, "CSAT_FLOW: restoreUIState, mScreenState = " + (Object)((Object)this.mScreenState) + " mSelectedStarNumber = " + this.mSelectedStarNumber);
        } else {
            LPLog.INSTANCE.d(TAG, "CSAT_FLOW: NO DATA to restore, mScreenState = " + (Object)((Object)this.mScreenState));
        }
    }

    public void onAttachFragment() {
        if (this.getParentFragment() instanceof NestedFragmentsContainerCallbacks) {
            this.mNestedFragmentsContainerCallbacks = (NestedFragmentsContainerCallbacks)this.getParentFragment();
            return;
        }
        this.mNestedFragmentsContainerCallbacks = new NestedFragmentsContainerCallbacks.NullNestedFragmentsContainerCallbacks();
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: onSaveInstanceState, mSelectedStarNumber = " + this.mSelectedStarNumber);
        outState.putInt(BUNDLE_NUM_STARS_SELECTED, this.mSelectedStarNumber);
        outState.putBoolean(BUNDLE_YES_BUTTON_SELECTED, this.mQuestionPositiveBtn != null ? this.mQuestionPositiveBtn.isSelected() : this.isQuestionPositiveBtn);
        outState.putBoolean(BUNDLE_NO_BUTTON_SELECTED, this.mQuestionNegativeBtn != null ? this.mQuestionNegativeBtn.isSelected() : this.isQuestionNegativeBtn);
        outState.putBoolean(BUNDLE_SUBMIT_BUTTON_ENABLED, this.mSubmitButton != null ? this.mSubmitButton.isEnabled() : this.isSubmitEnabled);
        if (this.mScreenState != null) {
            LPLog.INSTANCE.d(TAG, "CSAT_FLOW: onSaveInstanceState, mScreenState = " + (Object)((Object)this.mScreenState));
            outState.putInt(BUNDLE_SCREEN_STATE, this.mScreenState.ordinal());
        }
        super.onSaveInstanceState(outState);
    }

    @Override
    public void closeFeedBackScreen() {
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: closeFeedBackScreen, sendEmptyMessage SLIDE_OUT_FRAGMENT");
        this.mStarHandler.sendEmptyMessage(3);
    }

    @Override
    public void skipFeedBackScreen() {
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: skipFeedBackScreen, sendEmptyMessage SLIDE_OUT_FRAGMENT");
        this.mStarHandler.sendEmptyMessage(3);
        this.mNestedFragmentsContainerCallbacks.sendCSAT(-1, -1);
        MessagingFactory.getInstance().getController().mEventsProxy.onCsatSkipped();
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View feedbackScreen = inflater.inflate(R.layout.lpmessaging_ui_feedback_layout, container, false);
        this.applyColors(feedbackScreen);
        feedbackScreen.setClickable(true);
        Bundle arguments = this.getArguments();
        this.mAgentNickname = arguments.getString(AGENT_NAME_KEY, "");
        this.mConversationID = arguments.getString(AGENT_CONVERSATION_ID_KEY, "");
        this.mAgentAvatarUri = arguments.getString(AGENT_AVATAR_KEY, "");
        this.mFeedbackLayout = (LinearLayout)feedbackScreen.findViewById(R.id.lpui_feedback_layout);
        LinearLayout mStarsLayout = (LinearLayout)this.mFeedbackLayout.findViewById(R.id.lpui_stars_layout);
        this.mStars = new ImageView[5];
        this.mStars[0] = (ImageView)mStarsLayout.findViewById(R.id.lpui_star_1);
        this.mStars[1] = (ImageView)mStarsLayout.findViewById(R.id.lpui_star_2);
        this.mStars[2] = (ImageView)mStarsLayout.findViewById(R.id.lpui_star_3);
        this.mStars[3] = (ImageView)mStarsLayout.findViewById(R.id.lpui_star_4);
        this.mStars[4] = (ImageView)mStarsLayout.findViewById(R.id.lpui_star_5);
        this.mStarsDescriptionTextArray = this.getResources().getStringArray(R.array.lp_feedback_array);
        this.mRateText = (TextView)this.mFeedbackLayout.findViewById(R.id.lpui_rate_text);
        this.mQuestionText = (TextView)this.mFeedbackLayout.findViewById(R.id.lpui_feedback_question);
        this.mSubmitButton = (Button)feedbackScreen.findViewById(R.id.lpui_feedback_submit_button);
        this.mFinalSubmitLayout = (LinearLayout)feedbackScreen.findViewById(R.id.lpui_feedback_thank_you);
        this.mQuestionPositiveBtn = (Button)feedbackScreen.findViewById(R.id.lpui_csat_positive_button);
        this.mQuestionNegativeBtn = (Button)feedbackScreen.findViewById(R.id.lpui_csat_negative_button);
        ViewGroup yesNoContainer = (ViewGroup)this.mFeedbackLayout.findViewById(R.id.lpui_yesno_container);
        View yesNoQuestionTextView = this.mFeedbackLayout.findViewById(R.id.lpui_yesno_title);
        View agentDetailsContainer = this.mFeedbackLayout.findViewById(R.id.lpui_feedback_avatar_view_details);
        this.restoreUIState();
        this.setStarsDrawables();
        this.mQuestionText.setText((CharSequence)this.getText(R.string.lp_feedback_question).toString());
        AccessbilityUtilsKt.markAsAccessibilityHeading((View)this.mQuestionText, true);
        if (yesNoQuestionTextView != null) {
            AccessbilityUtilsKt.markAsAccessibilityHeading(yesNoQuestionTextView, true);
        }
        this.setYesNoSection((View)yesNoContainer);
        this.setAgentDetailsSection((View)yesNoContainer, agentDetailsContainer);
        this.setStarsClickListener();
        this.setSubmitListener();
        if (this.mScreenState == ScreenState.THANK_YOU) {
            this.showThankYouScreenIfNeeded();
        }
        return feedbackScreen;
    }

    public void onStart() {
        super.onStart();
        if (this.mFeedbackLayout != null) {
            this.mFeedbackLayout.requestFocus();
        }
    }

    private void setAgentDetailsSection(View yesNoContainer, View agentDetailsContainer) {
        if (Configuration.getBoolean((int)R.bool.show_agent_details_csat)) {
            agentDetailsContainer.setVisibility(0);
            if (Configuration.getBoolean((int)R.bool.show_yes_no_question)) {
                yesNoContainer.setVisibility(8);
            }
            this.fillAgentDetails(agentDetailsContainer);
        } else {
            agentDetailsContainer.setVisibility(8);
        }
    }

    private void fillAgentDetails(@NonNull View agentDetailsContainer) {
        TextView agentName = (TextView)agentDetailsContainer.findViewById(R.id.lpui_feedback_avatar_view_details_name);
        agentName.setText((CharSequence)this.mAgentNickname);
        ImageView agentAvatar = (ImageView)agentDetailsContainer.findViewById(R.id.lpui_feedback_avatar_view_details_bubble_avatar);
        if (TextUtils.isEmpty((CharSequence)this.mAgentAvatarUri)) {
            agentAvatar.setImageResource(R.drawable.lp_messaging_ui_ic_agent_avatar);
            agentAvatar.setColorFilter(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.agent_avatar_icon_color), PorterDuff.Mode.MULTIPLY);
        } else {
            agentAvatar.setColorFilter(null);
            agentAvatar.setImageResource(R.drawable.lp_messaging_ui_ic_agent_avatar);
            PicassoUtils.get((Context)this.requireContext()).load(this.mAgentAvatarUri).noPlaceholder().transform((Transformation)new CircleTransform()).into(agentAvatar);
        }
    }

    private void setSubmitListener() {
        this.mSubmitButton.setOnClickListener(view -> {
            int yesNoQuestionValue = this.getYesNoQuestionValue();
            LPLog.INSTANCE.i(TAG, "Submit button presses. rate: " + this.mSelectedStarNumber + ", yesNoQuestionValue = " + yesNoQuestionValue);
            this.mNestedFragmentsContainerCallbacks.sendCSAT(this.mSelectedStarNumber, yesNoQuestionValue);
            this.mNestedFragmentsContainerCallbacks.onSurveySubmitted(this.mConversationID, this.mSelectedStarNumber);
            LPLog.INSTANCE.d(TAG, "CSAT_FLOW: setSubmitListener");
            this.showThankYouScreenIfNeeded();
        });
    }

    private void showThankYouScreenIfNeeded() {
        if (Configuration.getBoolean((int)R.bool.show_csat_thank_you)) {
            this.showThankYouScreen();
        } else {
            LPLog.INSTANCE.d(TAG, "show thank you page configuration is false");
            this.mScreenState = null;
            this.mStarHandler.sendEmptyMessage(3);
        }
    }

    private void showThankYouScreen() {
        this.mScreenState = ScreenState.THANK_YOU;
        this.mSubmitButton.setVisibility(8);
        this.mFeedbackLayout.setVisibility(8);
        this.mFinalSubmitLayout.setVisibility(0);
        this.mFinalSubmitLayout.requestFocus();
        int delay = AccessibilityChecker.exploreByTouchEnabled((Context)this.requireContext()) ? 4500 : 3000;
        this.mStarHandler.sendEmptyMessageDelayed(3, (long)delay);
    }

    private void setYesNoSection(View yesNoContainer) {
        if (Configuration.getBoolean((int)R.bool.show_yes_no_question)) {
            this.displayYesNoSection(yesNoContainer);
        } else {
            yesNoContainer.setVisibility(8);
        }
    }

    private void displayYesNoSection(@NonNull View yesNoContainer) {
        yesNoContainer.setVisibility(0);
        this.mQuestionNegativeBtn.setOnClickListener(view -> {
            this.mQuestionPositiveBtn.setSelected(false);
            this.mQuestionNegativeBtn.setSelected(true);
            this.enableSubmitButton();
        });
        this.mQuestionPositiveBtn.setOnClickListener(view -> {
            this.mQuestionNegativeBtn.setSelected(false);
            this.mQuestionPositiveBtn.setSelected(true);
            this.enableSubmitButton();
        });
    }

    private void restoreUIState() {
        this.mQuestionPositiveBtn.setSelected(this.isQuestionPositiveBtn);
        this.mQuestionNegativeBtn.setSelected(this.isQuestionNegativeBtn);
        this.mSubmitButton.setEnabled(this.isSubmitEnabled);
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: restoreUIState " + this.mSelectedStarNumber);
    }

    public void onConnectionChanged(boolean isConnected) {
        if (this.mSubmitButton == null) {
            return;
        }
        if (this.mQuestionPositiveBtn.isSelected() || this.mQuestionNegativeBtn.isSelected() || this.mSelectedStarNumber > 0) {
            this.mSubmitButton.setEnabled(true);
        } else {
            this.mSubmitButton.setEnabled(false);
        }
    }

    private void applyColors(@NonNull View feedbackScreen) {
        ResourceHelper.updateBackgroundColor((View)feedbackScreen.findViewById(R.id.lpui_feedbackLayoutRootView), (int)R.color.feedback_fragment_background_color);
        ResourceHelper.updateTextColor((TextView)this.mQuestionText, (int)R.color.feedback_fragment_title_question);
        ResourceHelper.updateTextColor((TextView)this.mRateText, (int)R.color.feedback_fragment_rate_text);
        ResourceHelper.updateTextColor((TextView)((TextView)feedbackScreen.findViewById(R.id.lpui_yesno_title)), (int)R.color.feedback_fragment_title_yesno);
    }

    private int getYesNoQuestionValue() {
        if (this.mQuestionNegativeBtn.isSelected()) {
            return 0;
        }
        if (this.mQuestionPositiveBtn.isSelected()) {
            return 1;
        }
        return -1;
    }

    public Animation onCreateAnimation(int transit, final boolean enter, int nextAnim) {
        if (nextAnim == 0) {
            return null;
        }
        try {
            Animation animation = AnimationUtils.loadAnimation((Context)this.getActivity(), (int)nextAnim);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (enter) {
                        if (FeedbackFragment.this.mFeedbackLayout != null) {
                            FeedbackFragment.this.mFeedbackLayout.requestFocus();
                        }
                        if (FeedbackFragment.this.mQuestionText != null) {
                            FeedbackFragment.this.mQuestionText.requestFocus();
                        }
                    }
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            return animation;
        }
        catch (Resources.NotFoundException e) {
            return null;
        }
    }

    public void onResume() {
        super.onResume();
        LPLog.INSTANCE.d(TAG, "onResume");
        if (this.mScreenState == ScreenState.THANK_YOU || this.mScreenState == null) {
            LPLog.INSTANCE.d(TAG, "CSAT_FLOW: onResume, calling closeFeedBackScreen, mScreenState = " + (Object)((Object)this.mScreenState));
            this.closeFeedBackScreen();
        }
    }

    public void onPause() {
        super.onPause();
        LPLog.INSTANCE.d(TAG, "onPause");
        LPLog.INSTANCE.d(TAG, "CSAT_FLOW: onPause, removing message SLIDE_OUT_FRAGMENT");
        this.mStarHandler.removeMessages(3);
    }

    private void enableSubmitButton() {
        if (!this.mSubmitButton.isEnabled()) {
            this.mSubmitButton.setEnabled(InternetConnectionService.isNetworkAvailable());
        }
    }

    private void setStarsClickListener() {
        for (int i = 0; i < this.mStars.length; ++i) {
            ImageView v = this.mStars[i];
            v.setTag((Object)(i + 1));
            v.setOnClickListener(arg_0 -> this.lambda$setStarsClickListener$3((View)v, arg_0));
        }
    }

    private void setStarsDrawables() {
        int i;
        for (i = 0; i < this.mSelectedStarNumber; ++i) {
            this.mStars[i].setImageResource(R.drawable.lpmessaging_ui_star_full);
            if (i == this.mSelectedStarNumber - 1) {
                String selectedSentence = Infra.instance.getApplicationContext().getResources().getString(R.string.lp_accessibility_selected) + " " + this.mStarsDescriptionTextArray[i];
                this.mStars[i].announceForAccessibility((CharSequence)selectedSentence);
                this.mStars[i].setContentDescription((CharSequence)selectedSentence);
                continue;
            }
            this.mStars[i].setContentDescription((CharSequence)this.mStarsDescriptionTextArray[i]);
        }
        for (i = this.mSelectedStarNumber; i < this.mStars.length; ++i) {
            this.mStars[i].setImageResource(R.drawable.lpmessaging_ui_star_empty);
            this.mStars[i].setContentDescription((CharSequence)this.mStarsDescriptionTextArray[i]);
        }
        int index = this.mSelectedStarNumber - 1;
        if (index >= 0) {
            this.mRateText.setText((CharSequence)this.mStarsDescriptionTextArray[index]);
        } else {
            this.mRateText.setText((CharSequence)"");
        }
    }

    public boolean slideOutFragment() {
        LPLog.INSTANCE.d(TAG, "slideOutFragment");
        if (this.mStarHandler != null) {
            LPLog.INSTANCE.d(TAG, "CSAT_FLOW: slideOutFragment, mStarHandler is not null");
            if (!this.mStarHandler.hasMessages(3)) {
                this.mStarHandler.sendEmptyMessage(3);
            } else {
                LPLog.INSTANCE.d(TAG, "CSAT_FLOW: slideOutFragment, there is an identical call in queue on delay");
            }
        } else {
            LPLog.INSTANCE.d(TAG, "CSAT_FLOW: slideOutFragment, mStarHandler IS null, popBackStack");
            if (this.getParentFragment() != null) {
                this.getParentFragment().getChildFragmentManager().popBackStack();
            } else {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000014F, "slideOutFragment: Attempt to access null parent fragment");
            }
        }
        this.mScreenState = null;
        return true;
    }

    private /* synthetic */ void lambda$setStarsClickListener$3(View v, View view) {
        int starNumber = (Integer)v.getTag();
        if (starNumber != this.mSelectedStarNumber) {
            this.mSelectedStarNumber = starNumber;
            this.setStarsDrawables();
            this.enableSubmitButton();
        }
    }

    private static enum ScreenState {
        CSAT,
        THANK_YOU;

    }

    private static class StarHandler
    extends Handler {
        private WeakReference<FeedbackFragment> feedbackFragment;

        public StarHandler(FeedbackFragment frag) {
            this.feedbackFragment = new WeakReference<FeedbackFragment>(frag);
        }

        public void handleMessage(Message msg) {
            if (this.feedbackFragment == null || this.feedbackFragment.get() == null) {
                LPLog.INSTANCE.d(FeedbackFragment.TAG, "CSAT_FLOW: handleMessage, reference is not available");
                this.feedbackFragment = null;
                return;
            }
            FeedbackFragment feedFragment = (FeedbackFragment)this.feedbackFragment.get();
            if (msg.what == 3) {
                LPLog.INSTANCE.d(FeedbackFragment.TAG, "CSAT_FLOW: handleMessage SLIDE_OUT_FRAGMENT");
                this.removeCallbacksAndMessages(null);
                if (feedFragment != null && !feedFragment.isDetached() && feedFragment.mNestedFragmentsContainerCallbacks != null) {
                    LPLog.INSTANCE.d(FeedbackFragment.TAG, "CSAT_FLOW: Handler, running Slide out fragment from conversation fragment");
                    feedFragment.mNestedFragmentsContainerCallbacks.slideOutFeedbackFragment();
                } else if (feedFragment != null) {
                    LPLog.INSTANCE.d(FeedbackFragment.TAG, "CSAT_FLOW: feedFragment.isDetached() = " + feedFragment.isDetached());
                    LPLog.INSTANCE.d(FeedbackFragment.TAG, "CSAT_FLOW:  feedFragment.mNestedFragmentsContainerCallbacks = " + feedFragment.mNestedFragmentsContainerCallbacks);
                } else {
                    LPLog.INSTANCE.e(FeedbackFragment.TAG, ErrorCode.ERR_0000014E, "Feed fragment is null while sliding out");
                }
                if (feedFragment != null) {
                    feedFragment.mScreenState = null;
                } else {
                    LPLog.INSTANCE.e(FeedbackFragment.TAG, ErrorCode.ERR_0000014E, "Feed fragment is null while setting screen state");
                }
            }
        }
    }
}

