/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.hybrid.actions;

import android.content.Context;
import android.content.Intent;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.hybrid.HybridSDKUtils;
import com.liveperson.messaging.hybrid.commands.base.HybridSDKCommand;
import com.liveperson.messaging.hybrid.commands.exceptions.HybridSDKException;
import com.liveperson.messaging.hybrid.commands.exceptions.IncorrectConversationHistoryStateException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u000b0\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/liveperson/infra/messaging_ui/hybrid/actions/ChangeReadOnlyModeActionCommand;", "Lcom/liveperson/messaging/hybrid/commands/base/HybridSDKCommand;", "", "isReadOnlyMode", "", "(Z)V", "execute", "messaging", "Lcom/liveperson/messaging/Messaging;", "callback", "Lcom/liveperson/infra/ICallback;", "Lcom/liveperson/messaging/hybrid/commands/exceptions/HybridSDKException;", "messaging_ui_release"})
public final class ChangeReadOnlyModeActionCommand
implements HybridSDKCommand<Unit> {
    private final boolean isReadOnlyMode;

    public ChangeReadOnlyModeActionCommand(boolean isReadOnlyMode) {
        this.isReadOnlyMode = isReadOnlyMode;
    }

    public void execute(@NotNull Messaging messaging, @NotNull ICallback<Unit, HybridSDKException> callback2) {
        Intrinsics.checkNotNullParameter((Object)messaging, (String)"messaging");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        Messaging controller = HybridSDKUtils.requireForegroundState((Messaging)messaging);
        Context context = controller.getApplicationContext();
        Intent intent = new Intent("action.change_view_mode").setPackage(context.getPackageName()).putExtra("mode.read_only", this.isReadOnlyMode);
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"Intent(ACTION_CHANGE_VIE\u2026NLY_MODE, isReadOnlyMode)");
        Intent intent2 = intent;
        ConversationViewParams conversationViewParams = HybridSDKUtils.requireConversationViewParams((Messaging)controller);
        if (conversationViewParams.getHistoryConversationsStateToDisplay() == LPConversationsHistoryStateToDisplay.CLOSE && !this.isReadOnlyMode) {
            throw new IncorrectConversationHistoryStateException("History conversations state is set to closed conversation. Can't disable read only mode.");
        }
        context.sendBroadcast(intent2);
        callback2.onSuccess((Object)Unit.INSTANCE);
    }
}

