/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.hybrid.actions;

import android.content.Intent;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging_ui.hybrid.exceptions.FileSharingNotSupportedException;
import com.liveperson.infra.messaging_ui.hybrid.exceptions.PhotoSharingNotSupportedException;
import com.liveperson.infra.messaging_ui.hybrid.exceptions.PhotoSharingSiteSettingsNotSupportedException;
import com.liveperson.infra.ui.R;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.hybrid.HybridSDKUtils;
import com.liveperson.messaging.hybrid.commands.exceptions.HybridSDKException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0005\u001a\u00020\u0006*\u00020\u0006H\u0000\u001a(\u0010\u0007\u001a\u00020\b*\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fH\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\u00a8\u0006\u000e"}, d2={"isFileSharingKillSwitchEnabled", "", "Lcom/liveperson/infra/managers/PreferenceManager;", "(Lcom/liveperson/infra/managers/PreferenceManager;)Z", "isPhotoSharingSiteSettingsEnabled", "requireStateToStartMediaFlow", "Lcom/liveperson/messaging/Messaging;", "startFileSharingFlow", "", "action", "", "callback", "Lcom/liveperson/infra/ICallback;", "Lcom/liveperson/messaging/hybrid/commands/exceptions/HybridSDKException;", "messaging_ui_release"})
public final class HybridMediaActionUtilsKt {
    private static final boolean isFileSharingKillSwitchEnabled(PreferenceManager $this$isFileSharingKillSwitchEnabled) {
        return $this$isFileSharingKillSwitchEnabled.getBooleanValue("kill_switch_photo_sharing_enabled_preference_key", "appLevelPreferences", false);
    }

    private static final boolean isPhotoSharingSiteSettingsEnabled(PreferenceManager $this$isPhotoSharingSiteSettingsEnabled) {
        return $this$isPhotoSharingSiteSettingsEnabled.getBooleanValue("site_settings_photo_sharing_enabled_preference_key", "appLevelPreferences", false);
    }

    @NotNull
    public static final Messaging requireStateToStartMediaFlow(@NotNull Messaging $this$requireStateToStartMediaFlow) {
        Intrinsics.checkNotNullParameter((Object)$this$requireStateToStartMediaFlow, (String)"<this>");
        Messaging controller = HybridSDKUtils.requireStateToSendMessage((Messaging)$this$requireStateToStartMediaFlow);
        PreferenceManager preferenceManager = PreferenceManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)preferenceManager, (String)"preferenceManager");
        if (!HybridMediaActionUtilsKt.isFileSharingKillSwitchEnabled(preferenceManager)) {
            throw new FileSharingNotSupportedException("File sharing kill switch is not enabled", null, 2, null);
        }
        if (!HybridMediaActionUtilsKt.isPhotoSharingSiteSettingsEnabled(preferenceManager)) {
            throw new PhotoSharingSiteSettingsNotSupportedException("Photo sharing site settings are not enabled", null, 2, null);
        }
        if (!Configuration.getBoolean((int)R.bool.enable_photo_sharing)) {
            throw new PhotoSharingNotSupportedException("Photo sharing is not enabled in configuration", null, 2, null);
        }
        return controller;
    }

    public static final void startFileSharingFlow(@NotNull Messaging $this$startFileSharingFlow, @NotNull String action, @NotNull ICallback<Unit, HybridSDKException> callback2) {
        Intrinsics.checkNotNullParameter((Object)$this$startFileSharingFlow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        $this$startFileSharingFlow.getApplicationContext().sendBroadcast(new Intent(action).setPackage($this$startFileSharingFlow.getApplicationContext().getPackageName()));
        callback2.onSuccess((Object)Unit.INSTANCE);
    }
}

