/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.google.android.gms.common.util.Strings;
import com.google.android.material.progressindicator.CircularProgressIndicator;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.IPermissionCallback;
import com.liveperson.infra.R;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging_ui.MessagingUIFactory;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.accessibility.AccessibilityAnnouncer;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.ui.R;
import com.liveperson.infra.ui.view.ui.TooltipWindow;
import com.liveperson.infra.ui.view.uicomponents.BaseEnterMessage;
import com.liveperson.infra.utils.DateUtils;
import com.liveperson.infra.utils.DetectHeadsetUnpluggedBroadcastReceiver;
import com.liveperson.infra.utils.LPAudioUtils;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.infra.utils.LpRecognitionListener;
import com.liveperson.infra.utils.LpSpeechRecognizerSingleton;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.model.AmsConnection;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;

public class AmsEnterMessage
extends BaseEnterMessage {
    private static final String TAG = "AmsEnterMessage";
    private static final long SHOW_TYPING_DELAY_MS = 2000L;
    public static final int MAX_RECORD_TIME_MS = 120000;
    public int speechRecognitionInputCompleteSilenceLengthMillis;
    public static int SPEECH_RECOGNITION_INDICATOR_PROGRESS_SIZE = 100;
    public Handler mHandler = new Handler();
    private ChatState currentChatState = ChatState.ACTIVE;
    private ValueAnimator mColorAnim;
    private ValueAnimator mRecordProgressBarAnimator;
    protected ProgressBar mRecordProgressBar;
    protected TextView mMaxRecordTimeTextView;
    protected TextView mRecordProgressTimeTextView;
    protected int mMaxRecordTimeMs;
    private ViewGroup enterMessageLayout;
    private ViewGroup recordVoiceLayout;
    private ViewGroup recordingControlsLayout;
    private ViewGroup speechRecognitionControlsLayout;
    private AccessibilityAnnouncer mAnnouncer;
    private static final int MSG_MIC_LONGER_PRESS = 117;
    protected ImageButton voiceControlButton;
    protected ImageButton speechRecognitionControlButton;
    protected ImageView recordingIndicator;
    private CircularProgressIndicator speechRecognitionProgressIndicator;
    protected TooltipWindow mMicTooltipWindow;
    private SpeechRecognizer speechRecognizer;
    private boolean voiceButtonEnabled = false;
    private boolean isVoiceRecordingFeatureEnabled = false;
    private boolean isRecognitionInProgress = false;
    private String mPausedRecordingFilePath = null;
    private WeakReference<Timer> speechRecognitionProgressTimer;
    private WeakReference<TimerTask> timerTask;
    private WeakReference<LpRecognitionListener> lpRecognitionListener;
    private WeakReference<LPAudioUtils.SpeechRecognitionResultCallback> speechRecognitionResultCallback;
    private View.OnClickListener speechRecognitionControlButtonOnClickListener;
    private RecordingStatus recordingStatus = RecordingStatus.STOPPED;
    private DetectHeadsetUnpluggedBroadcastReceiver mDetectHeadsetUnpluggedBroadcastReceiver = new DetectHeadsetUnpluggedBroadcastReceiver(){

        protected void onUnpluggedHeadset() {
            AmsEnterMessage.this.onCancelRecording();
            AmsEnterMessage.this.stopSpeechRecognitionIfNeeded();
        }
    };
    private Handler handler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message message) {
            if (message.what == 117) {
                AmsEnterMessage.this.mMicTooltipWindow.showToolTip((View)AmsEnterMessage.this.voiceControlButton, AmsEnterMessage.this.getResources().getString(R.string.lp_mic_tooltip_release));
            }
            return true;
        }
    });

    public AmsEnterMessage(Context context) {
        super(context);
    }

    public AmsEnterMessage(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AmsEnterMessage(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void initializeViews() {
        super.initializeViews();
        this.mRecordProgressBar = (ProgressBar)this.findViewById(R.id.lpui_voice_recording_progress_bar);
        this.mMaxRecordTimeTextView = (TextView)this.findViewById(R.id.lpui_voice_recording_max_time_text_view);
        this.mRecordProgressTimeTextView = (TextView)this.findViewById(R.id.lpui_voice_recording_time_text_view);
        this.mMaxRecordTimeMs = Configuration.getInteger((int)R.integer.lp_record_max_time_seconds) * 1000;
        this.speechRecognitionInputCompleteSilenceLengthMillis = Configuration.getInteger((int)R.integer.lp_speech_recognition_input_complete_silence_length_millis);
        if (this.mMaxRecordTimeMs > 120000) {
            this.mMaxRecordTimeMs = 120000;
        }
        this.enterMessageLayout = (ViewGroup)this.findViewById(R.id.lpui_enter_message_layout);
        this.recordVoiceLayout = (ViewGroup)this.findViewById(R.id.lpui_voice_record_layout);
        this.recordingControlsLayout = (ViewGroup)this.findViewById(R.id.lpui_recording_controls_layout);
        this.speechRecognitionControlsLayout = (ViewGroup)this.findViewById(R.id.lpui_speech_recognition_controls_layout);
        this.voiceControlButton = (ImageButton)this.findViewById(R.id.lpui_voice_control_button);
        this.speechRecognitionControlButton = (ImageButton)this.findViewById(R.id.lpui_speech_recognition_control_button);
        this.mMicTooltipWindow = new TooltipWindow(this.getContext());
        this.recordingIndicator = (ImageView)this.findViewById(R.id.lpui_recording_indicator);
        this.speechRecognitionProgressIndicator = (CircularProgressIndicator)this.findViewById(R.id.lpui_speech_recognition_progress_bar);
        this.isVoiceRecordingFeatureEnabled = this.isVoiceConfigurationEnabled();
        this.setVoiceControlButtonPreferences(this.isVoiceRecordingFeatureEnabled);
        this.setSpeechRecognitionControlButtonPreferences(this.isSpeechRecognitionEnabled());
        this.initSpeechRecognition();
        this.setRecordingTrashButtonPreferences();
        this.setRecordingLayoutAnimation();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void initSpeechRecognition() {
        this.configureSpeechRecording((ImageView)this.speechRecognitionControlButton);
        this.speechRecognitionControlButtonOnClickListener = v -> this.onSpeechRecognitionButtonPressed();
        this.speechRecognitionControlButton.setOnClickListener(this.speechRecognitionControlButtonOnClickListener);
        this.speechRecognitionControlButton.setContentDescription((CharSequence)this.getResources().getString(R.string.lp_accessibility_voice_recognition_button));
    }

    private void onSpeechRecognitionButtonPressed() {
        if (this.isRecordingInProgress()) {
            return;
        }
        if (this.isRecognitionInProgress) {
            this.stopSpeechRecognitionIfNeeded();
            return;
        }
        if (this.mEnterMessageListener != null) {
            this.mEnterMessageListener.onVoiceRecordingPermissionRequired(new IPermissionCallback(){

                public void onPermissionsGranted() {
                    AmsEnterMessage.this.startSpeechRecognition();
                }

                public void onPermissionsDenied() {
                    AmsEnterMessage.this.isRecognitionInProgress = false;
                    LPLog.INSTANCE.w(AmsEnterMessage.TAG, "onPermissionsDenied: Record voice permissions denied by user");
                }
            });
        }
    }

    public void onConnectionChanged(boolean isConnected) {
        super.onConnectionChanged(isConnected);
        this.isVoiceRecordingFeatureEnabled = this.isVoiceConfigurationEnabled();
        this.setVoiceControlButtonPreferences(this.isVoiceRecordingFeatureEnabled);
        this.setSpeechRecognitionControlButtonPreferences(this.isSpeechRecognitionEnabled());
        this.updateVoiceAndSpeechRecognitionControlButton(this.isEnabled());
        if (this.voiceButtonEnabled) {
            this.updateEnterMessageView(this.recordingStatus != RecordingStatus.STOPPED);
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateVoiceAndSpeechRecognitionControlButton(enabled);
    }

    public void enableMicButtonTooltips(boolean enable) {
        if (this.mMicTooltipWindow != null) {
            this.mMicTooltipWindow.enable(enable);
            if (!enable) {
                this.mMicTooltipWindow.dismissTooltip();
            }
        }
    }

    private void updateVoiceAndSpeechRecognitionControlButton(boolean isEnabled) {
        if (isEnabled && (this.mIsConnected || Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled))) {
            this.voiceControlButton.setEnabled(true);
            this.voiceControlButton.setAlpha(1.0f);
            this.speechRecognitionControlButton.setEnabled(true);
        } else {
            this.voiceControlButton.setEnabled(false);
            this.voiceControlButton.setAlpha(0.5f);
            this.speechRecognitionControlButton.setEnabled(false);
        }
    }

    private boolean isVoiceConfigurationEnabled() {
        boolean voiceSharingSiteSettingsEnabled = PreferenceManager.getInstance().getBooleanValue("site_settings_voice_sharing_enabled_preference_key", "appLevelPreferences", true);
        boolean result = voiceSharingSiteSettingsEnabled && Configuration.getBoolean((int)R.bool.enable_voice_sharing);
        LPLog.INSTANCE.d(TAG, "isVoiceConfigurationEnabled() voiceSharingSiteSettingsEnabled = " + voiceSharingSiteSettingsEnabled + " result = " + result);
        return result;
    }

    private boolean isSpeechRecognitionEnabled() {
        boolean res = Configuration.getBoolean((int)R.bool.lp_speech_recognition_enabled);
        LPLog.INSTANCE.d(TAG, "isVoiceConfigurationEnabled() res = " + res);
        return res;
    }

    private void setVoiceControlButtonPreferences(boolean isEnabled) {
        if (isEnabled) {
            this.recordingControlsLayout.setVisibility(0);
            this.voiceButtonEnabled = true;
        } else {
            this.recordingControlsLayout.setVisibility(8);
            this.voiceButtonEnabled = false;
        }
        LPLog.INSTANCE.d(TAG, "setSpeechControlButtonPreferences. controlButton = " + this.voiceButtonEnabled);
    }

    private void setSpeechRecognitionControlButtonPreferences(boolean isEnabled) {
        if (isEnabled) {
            this.speechRecognitionControlsLayout.setVisibility(0);
            this.updateSpeechRecognitionProgressIndicator();
        } else {
            this.speechRecognitionControlsLayout.setVisibility(8);
        }
        LPLog.INSTANCE.d(TAG, "setSpeechRecognitionControlButtonPreferences. controlButton = " + isEnabled);
    }

    private void updateSpeechRecognitionProgressIndicator() {
        if (this.isRecognitionInProgress) {
            this.speechRecognitionProgressIndicator.setVisibility(0);
        } else {
            this.speechRecognitionProgressIndicator.setVisibility(8);
        }
    }

    private void setRecordingTrashButtonPreferences() {
        this.trashButton.setOnClickListener(view -> {
            this.onCancelRecording();
            this.stopSpeechRecognitionIfNeeded();
        });
        this.trashButton.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_voice_trash_button_color), PorterDuff.Mode.MULTIPLY);
    }

    private void setRecordingLayoutAnimation() {
        Animation in = AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0000);
        Animation out = AnimationUtils.loadAnimation((Context)this.getContext(), (int)0x10A0001);
        in.setDuration(200L);
        out.setDuration(200L);
        this.mEnterMessageLayoutSwitcher.setInAnimation(in);
        this.mEnterMessageLayoutSwitcher.setOutAnimation(out);
    }

    public void onBackground() {
        super.onBackground();
        if (this.isRecordingInProgress()) {
            this.onCancelRecording();
        }
        this.stopSpeechRecognitionIfNeeded();
    }

    protected void sendMessageWithURL(String message, String urlToParse, String title, String imageURL, String description, String siteName) {
        this.stopSpeechRecognitionIfNeeded();
        String brandId = this.mBrandIdProvider.getBrandId();
        Messaging messaging = MessagingFactory.getInstance().getController();
        ConnectionsController connectionController = messaging.mConnectionController;
        if (this.mIsOfflineMessagingEnabled || connectionController.isSocketReady(brandId) && connectionController.isUpdated(brandId)) {
            this.clearText();
            messaging.sendMessageWithURL(this.mBrandIdProvider.getTargetId(), brandId, message, urlToParse, title, description, imageURL, siteName);
            if (this.mEnterMessageListener != null) {
                this.mEnterMessageListener.onMessageSent();
            }
        } else {
            this.showNoNetworkMessage();
        }
    }

    protected void sendMessage(String message) {
        this.stopSpeechRecognitionIfNeeded();
        String brandId = this.mBrandIdProvider.getBrandId();
        Messaging messaging = MessagingFactory.getInstance().getController();
        ConnectionsController connectionController = messaging.mConnectionController;
        if (this.mIsOfflineMessagingEnabled || connectionController.isSocketReady(brandId) && connectionController.isUpdated(brandId)) {
            this.clearText();
            messaging.sendMessage(this.mBrandIdProvider.getTargetId(), brandId, message, null);
            if (this.mEnterMessageListener != null) {
                this.mEnterMessageListener.onMessageSent();
            }
        } else {
            this.showNoNetworkMessage();
        }
    }

    protected void onHasText(boolean hasText) {
        if (this.voiceButtonEnabled) {
            if (hasText) {
                this.recordingControlsLayout.setVisibility(8);
            } else {
                this.recordingControlsLayout.setVisibility(0);
            }
        }
    }

    protected void onAfterChangedText(String text) {
        LPLog.INSTANCE.d(TAG, "onAfterChangedText: Consumer changed text. Clearing all pending runnables and set a new one");
        this.mHandler.removeCallbacksAndMessages(null);
        if (TextUtils.isEmpty((CharSequence)text)) {
            this.currentChatState = ChatState.ACTIVE;
            this.changeState(ChatState.ACTIVE);
        } else {
            this.mHandler.postDelayed(() -> {
                LPLog.INSTANCE.d(TAG, "onAfterChangedText: Setting state to 'Not Typing'");
                this.currentChatState = ChatState.ACTIVE;
                this.changeState(ChatState.ACTIVE);
            }, 2000L);
        }
    }

    protected void onBeforeChangedText() {
        LPLog.INSTANCE.d(TAG, "onBeforeChangedText: Remove all pending 'not typing' action");
        this.mHandler.removeCallbacksAndMessages(null);
        if (this.currentChatState != ChatState.COMPOSING) {
            LPLog.INSTANCE.d(TAG, "onBeforeChangedText: set the status to 'typing'");
            this.currentChatState = ChatState.COMPOSING;
            this.changeState(ChatState.COMPOSING);
        }
    }

    private void startSpeechRecognition() {
        LPLog.INSTANCE.d(TAG, "startSpeechRecognition");
        this.isRecognitionInProgress = true;
        if (this.mMicTooltipWindow != null) {
            this.mMicTooltipWindow.enable(true);
        }
        IntentFilter intentFilter = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
        this.getContext().getApplicationContext().registerReceiver((BroadcastReceiver)this.mDetectHeadsetUnpluggedBroadcastReceiver, intentFilter);
        MessagingFactory.getInstance().getController().getAudioUtils().getPlayingAudioManager().stopAllCurrentlyPlaying();
        this.vibrate();
        this.textInput.setHint((CharSequence)Configuration.getString((int)R.string.lp_enter_message_speech_recognition_state));
        if (this.speechRecognizer == null) {
            this.speechRecognizer = LpSpeechRecognizerSingleton.INSTANCE.getInstance();
        }
        if (this.lpRecognitionListener == null || this.lpRecognitionListener.get() == null) {
            this.initSpeechRecognitionResultCallback();
            this.lpRecognitionListener = new WeakReference<LpRecognitionListener>(new LpRecognitionListener(this.textInput, (LPAudioUtils.SpeechRecognitionResultCallback)this.speechRecognitionResultCallback.get()));
        }
        this.speechRecognizer.setRecognitionListener((RecognitionListener)this.lpRecognitionListener.get());
        String language = LocaleUtils.getInstance().getKeyboardLanguage(this.getContext());
        this.speechRecognizer.startListening(MessagingFactory.getInstance().getController().getAudioUtils().prepareSpeechRecognizerIntent(language));
        this.setVoiceControlButtonPreferences(false);
        this.resetSpeechRecognitionIndicatorProgress();
    }

    private void initSpeechRecognitionResultCallback() {
        if (this.speechRecognitionResultCallback == null || this.speechRecognitionResultCallback.get() == null) {
            this.speechRecognitionResultCallback = new WeakReference<4>(new LPAudioUtils.SpeechRecognitionResultCallback(){

                public void onStopListening() {
                    LPLog.INSTANCE.d(AmsEnterMessage.TAG, "onStopListening");
                    AmsEnterMessage.this.stopSpeechRecognitionIfNeeded();
                }

                public void refreshProgressBar() {
                    LPLog.INSTANCE.d(AmsEnterMessage.TAG, "refreshProgressBar");
                    AmsEnterMessage.this.resetSpeechRecognitionIndicatorProgress();
                }
            });
        }
    }

    protected void stopSpeechRecognitionIfNeeded() {
        if (this.isRecognitionInProgress) {
            LPLog.INSTANCE.d(TAG, "onStopSpeechRecognition");
            this.isRecognitionInProgress = false;
            this.speechRecognitionProgressIndicator.setVisibility(4);
            this.textInput.setHint((CharSequence)this.textInput.getContext().getString(R.string.lp_enter_message));
            this.requestFocusOnTextInput();
            this.voiceButtonEnabled = this.isVoiceRecordingFeatureEnabled;
            if (TextUtils.isEmpty((CharSequence)this.textInput.getText())) {
                this.setVoiceControlButtonPreferences(this.isVoiceRecordingFeatureEnabled);
            }
            this.nullifySpeechRecognitionResources();
        }
    }

    private void resetSpeechRecognitionIndicatorProgress() {
        LPLog.INSTANCE.d(TAG, "resetSpeechRecognitionIndicatorProgress");
        this.nullifySpeechRecognitionTimer();
        this.speechRecognitionProgressIndicator.setProgressCompat(SPEECH_RECOGNITION_INDICATOR_PROGRESS_SIZE, true);
        this.speechRecognitionProgressIndicator.setIndicatorDirection(1);
        this.speechRecognitionProgressIndicator.setVisibility(0);
        this.speechRecognitionProgressTimer = new WeakReference<Timer>(new Timer());
        this.timerTask = new WeakReference<5>(new TimerTask(){
            int progress = SPEECH_RECOGNITION_INDICATOR_PROGRESS_SIZE;

            @Override
            public void run() {
                --this.progress;
                AmsEnterMessage.this.speechRecognitionProgressIndicator.setProgressCompat(this.progress, true);
                if (this.progress == 0 && AmsEnterMessage.this.speechRecognitionProgressTimer != null && AmsEnterMessage.this.speechRecognitionProgressTimer.get() != null) {
                    ((Timer)AmsEnterMessage.this.speechRecognitionProgressTimer.get()).cancel();
                    AmsEnterMessage.this.mHandler.post(() -> AmsEnterMessage.this.stopSpeechRecognitionIfNeeded());
                }
            }
        });
        ((Timer)this.speechRecognitionProgressTimer.get()).schedule((TimerTask)this.timerTask.get(), 0L, (long)(this.speechRecognitionInputCompleteSilenceLengthMillis / SPEECH_RECOGNITION_INDICATOR_PROGRESS_SIZE));
    }

    private void onRecordVoice() {
        if (this.isRecordingInProgress()) {
            return;
        }
        this.setSpeechRecognitionControlButtonPreferences(false);
        if (this.mMicTooltipWindow != null) {
            this.mMicTooltipWindow.enable(true);
        }
        String announcement = this.getResources().getString(R.string.lp_accessibility_voice_mic_activated, new Object[]{this.getMinutesLimit(), this.getSecondsLimit()});
        this.announceEvent(announcement);
        this.recordingStatus = RecordingStatus.RECORDING;
        IntentFilter intentFilter = new IntentFilter("android.media.AUDIO_BECOMING_NOISY");
        this.getContext().getApplicationContext().registerReceiver((BroadcastReceiver)this.mDetectHeadsetUnpluggedBroadcastReceiver, intentFilter);
        MessagingFactory.getInstance().getController().getAudioUtils().getPlayingAudioManager().stopAllCurrentlyPlaying();
        this.vibrate();
        this.textInput.setEnabled(false);
        this.hideSoftKeyboard((View)this.textInput);
        this.updateEnterMessageView(true);
        this.animateRecordingIndicator();
        this.animateRecordProgress(this.mMaxRecordTimeMs);
        this.setDurationText(this.mMaxRecordTimeMs);
        MessagingFactory.getInstance().getController().getAudioUtils().startRecording(LPAudioUtils.generateVoiceFileName(), this.mMaxRecordTimeMs, new LPAudioUtils.RecordingResultCallback(){

            public void onMaxRecordingDurationReached(@Nullable String audioFilePath) {
                AmsEnterMessage.this.recordingStatus = RecordingStatus.MAX_REACHED;
                AmsEnterMessage.this.onRecordingTerminated(audioFilePath);
            }

            public void onRecordingInterrupted(@Nullable String audioFilePath) {
                if (AmsEnterMessage.this.recordingStatus == RecordingStatus.RECORDING) {
                    AmsEnterMessage.this.recordingStatus = RecordingStatus.PAUSED;
                    AmsEnterMessage.this.onRecordingTerminated(audioFilePath);
                }
            }

            public void onRecordingStartFailed(@Nullable String audioFilePath) {
                LPLog.INSTANCE.d(AmsEnterMessage.TAG, "onRecordingStartFailed " + audioFilePath);
                AmsEnterMessage.this.mPausedRecordingFilePath = audioFilePath;
                AmsEnterMessage.this.deleteRecording();
                AmsEnterMessage.this.textInput.setEnabled(true);
            }
        });
    }

    private void onStopRecording(final boolean isSending, final @Nullable Runnable afterStopped) {
        if (this.recordingStatus == RecordingStatus.RECORDING) {
            this.unregisterDetectHeadsetUnpluggedBroadcastReceiver();
            MessagingFactory.getInstance().getController().getAudioUtils().stopRecording((ICallback)new ICallback<String, Exception>(){

                public void onSuccess(String filename) {
                    AmsEnterMessage.this.mPausedRecordingFilePath = filename;
                    AmsEnterMessage.this.recordingStatus = RecordingStatus.PAUSED;
                    AmsEnterMessage.this.stopRecordProgressBarAnimation();
                    if (afterStopped != null) {
                        afterStopped.run();
                    } else {
                        AmsEnterMessage.this.updateEnterMessageView(true);
                    }
                    LPAudioUtils.getDuration((String)filename, (ICallback)new ICallback<Integer, Exception>(){

                        public void onSuccess(Integer duration) {
                            if (!isSending) {
                                AmsEnterMessage.this.mRecordProgressTimeTextView.setText((CharSequence)DateUtils.getDurationString((long)duration.intValue()));
                                AmsEnterMessage.this.announceEvent(String.format(AmsEnterMessage.this.getResources().getString(R.string.lp_accessibility_voice_stop_recording_activated), TimeUnit.MILLISECONDS.toMinutes(duration.intValue()) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(duration.intValue())), TimeUnit.MILLISECONDS.toSeconds(duration.intValue()) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(duration.intValue()))));
                            }
                        }

                        public void onError(Exception exception) {
                        }
                    });
                }

                public void onError(Exception exception) {
                    LPLog.INSTANCE.d(AmsEnterMessage.TAG, "voice recording failed to stop", (Throwable)exception);
                }
            });
        }
    }

    private void onRecordingTerminated(@Nullable String audioFilePath) {
        this.mPausedRecordingFilePath = audioFilePath;
        this.stopRecordingIndicatorAnimation();
        this.updateEnterMessageView(true);
        if (this.recordingStatus == RecordingStatus.MAX_REACHED) {
            String mMaxRecordingReachedString = this.getResources().getString(R.string.lp_accessibility_voice_recording_limit_reached);
            AccessibilityManager am = (AccessibilityManager)this.getContext().getSystemService("accessibility");
            if (!am.isEnabled()) {
                this.mMicTooltipWindow.showToolTip((View)this.voiceControlButton, mMaxRecordingReachedString, true);
            }
            this.announceEvent(mMaxRecordingReachedString);
        }
    }

    private void onPlayBackRecording() {
        if (!(this.recordingStatus != RecordingStatus.MAX_REACHED && this.recordingStatus != RecordingStatus.PAUSED || Strings.isEmptyOrWhitespace((String)this.mPausedRecordingFilePath))) {
            MessagingFactory.getInstance().getController().getAudioUtils().getPlayingAudioManager().stopAllCurrentlyPlaying();
            MessagingFactory.getInstance().getController().getAudioUtils().playAudio(this.mPausedRecordingFilePath, TAG, new LPAudioUtils.PlaybackCallback(){

                public void onPlaybackStarted(String audioFileUrl, int durationMilliseconds) {
                    AmsEnterMessage.this.recordingStatus = RecordingStatus.PLAYING;
                    AmsEnterMessage.this.setDurationText(durationMilliseconds);
                    AmsEnterMessage.this.animateRecordProgress(durationMilliseconds);
                    AmsEnterMessage.this.updateEnterMessageView(true);
                }

                public void onPlaybackCompleted(boolean successfully, String audioFileUrl) {
                    AmsEnterMessage.this.stopRecordProgressBarAnimation();
                    AmsEnterMessage.this.recordingStatus = RecordingStatus.PAUSED;
                    AmsEnterMessage.this.updateEnterMessageView(true);
                }
            });
        }
    }

    private void onStopPlayback(boolean isSending, @Nullable Runnable afterStopped) {
        if (this.recordingStatus == RecordingStatus.PLAYING) {
            MessagingFactory.getInstance().getController().getAudioUtils().stopPlayback();
            this.recordingStatus = RecordingStatus.PAUSED;
            this.stopRecordProgressBarAnimation();
            if (afterStopped != null) {
                afterStopped.run();
            } else {
                this.updateEnterMessageView(true);
            }
            if (!isSending) {
                this.announceEvent(this.getResources().getString(R.string.lp_accessibility_voice_stop_replay_activated));
            }
        }
    }

    private void onCancelRecording() {
        switch (this.recordingStatus) {
            case RECORDING: {
                this.onStopRecording(false, this::deleteRecording);
                break;
            }
            case PLAYING: {
                this.onStopPlayback(false, this::deleteRecording);
                break;
            }
            default: {
                this.deleteRecording();
            }
        }
        this.textInput.setEnabled(true);
        this.announceEvent(this.getResources().getString(R.string.lp_accessibility_voice_trash_activated));
    }

    protected void sendMessage() {
        switch (this.recordingStatus) {
            case RECORDING: {
                this.onStopRecording(true, this::uploadRecording);
                break;
            }
            case PLAYING: {
                this.onStopPlayback(true, this::uploadRecording);
                break;
            }
            case PAUSED: 
            case MAX_REACHED: {
                this.uploadRecording();
                break;
            }
            default: {
                super.sendMessage();
            }
        }
        this.textInput.setEnabled(true);
    }

    private void deleteRecording() {
        boolean deleted = false;
        if (!Strings.isEmptyOrWhitespace((String)this.mPausedRecordingFilePath)) {
            File file = new File(this.mPausedRecordingFilePath);
            deleted = file.delete();
        }
        this.recordingStatus = RecordingStatus.STOPPED;
        LPLog.INSTANCE.d(TAG, "deleteRecording: file " + this.mPausedRecordingFilePath + (deleted ? " deleted" : " not deleted"));
        this.mPausedRecordingFilePath = null;
        this.updateEnterMessageView(false);
    }

    private void uploadRecording() {
        if (!Strings.isEmptyOrWhitespace((String)this.mPausedRecordingFilePath)) {
            MessagingFactory.getInstance().getController().sendFileMessage(FileSharingType.VOICE, this.mBrandIdProvider.getBrandId(), this.mBrandIdProvider.getTargetId(), this.mPausedRecordingFilePath, "", false);
        }
        this.recordingStatus = RecordingStatus.STOPPED;
        this.mPausedRecordingFilePath = null;
        this.updateEnterMessageView(false);
    }

    protected boolean isContentWaiting() {
        return this.recordingStatus != RecordingStatus.STOPPED || super.isContentWaiting();
    }

    private void updateEnterMessageView(boolean voiceWaiting) {
        this.updateSendButtonState();
        if (this.voiceControlButton != null) {
            switch (this.recordingStatus) {
                case PAUSED: 
                case MAX_REACHED: {
                    this.setVoiceControlAsReplayButton();
                    break;
                }
                case RECORDING: 
                case PLAYING: {
                    this.setVoiceControlAsStopButton();
                    break;
                }
                default: {
                    this.setVoiceControlAsMicButton();
                    if (!this.isSpeechRecognitionEnabled()) break;
                    this.setSpeechRecognitionControlButtonPreferences(true);
                }
            }
            LPLog.INSTANCE.d(TAG, "setVisibility. voiceButtonEnabled " + this.voiceButtonEnabled);
            this.onHasText(!this.getText().isEmpty());
        }
        if (this.recordingStatus == RecordingStatus.STOPPED || this.recordingStatus == RecordingStatus.PAUSED) {
            this.stopRecordingIndicatorAnimation();
            this.stopRecordProgressBarAnimation();
        }
        if (voiceWaiting && this.mEnterMessageLayoutSwitcher.getNextView() == this.recordVoiceLayout || !voiceWaiting && this.mEnterMessageLayoutSwitcher.getNextView() == this.enterMessageLayout) {
            this.mEnterMessageLayoutSwitcher.showNext();
        }
    }

    private void configureSpeechRecording(ImageView controlButton) {
        controlButton.setImageResource(R.drawable.lpinfra_ui_ic_voice_recognition);
        controlButton.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_speech_recognition_icon_color), PorterDuff.Mode.MULTIPLY);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setVoiceControlAsMicButton() {
        this.voiceControlButton.setImageResource(R.drawable.lpinfra_ui_ic_mic);
        this.voiceControlButton.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_voice_record_button_color), PorterDuff.Mode.MULTIPLY);
        this.voiceControlButton.setOnClickListener(view -> {
            if (this.mEnterMessageListener != null) {
                this.mEnterMessageListener.onVoiceRecordingPermissionRequired(new IPermissionCallback(){

                    public void onPermissionsGranted() {
                        if (!AmsEnterMessage.this.isRecordingInProgress()) {
                            String longPressToRecordString = AmsEnterMessage.this.getResources().getString(R.string.lp_mic_tooltip_long_press);
                            AccessibilityManager am = (AccessibilityManager)AmsEnterMessage.this.getContext().getSystemService("accessibility");
                            if (!am.isEnabled()) {
                                AmsEnterMessage.this.mMicTooltipWindow.showToolTip((View)AmsEnterMessage.this.voiceControlButton, longPressToRecordString);
                            }
                            AmsEnterMessage.this.announceEvent(longPressToRecordString);
                        }
                    }

                    public void onPermissionsDenied() {
                        LPLog.INSTANCE.w(AmsEnterMessage.TAG, "onPermissionsDenied: Record voice permissions denied by user");
                    }
                });
            }
        });
        this.voiceControlButton.setOnLongClickListener(view -> {
            if (this.mEnterMessageListener != null) {
                this.mEnterMessageListener.onVoiceRecordingPermissionRequired(new IPermissionCallback(){

                    public void onPermissionsGranted() {
                        AmsEnterMessage.this.onRecordVoice();
                    }

                    public void onPermissionsDenied() {
                        LPLog.INSTANCE.w(AmsEnterMessage.TAG, "onPermissionsDenied: Record voice permissions denied by user");
                    }
                });
                return true;
            }
            return false;
        });
        this.voiceControlButton.setOnTouchListener((v, event) -> {
            switch (event.getAction()) {
                case 0: {
                    AccessibilityManager am = (AccessibilityManager)this.getContext().getSystemService("accessibility");
                    if (this.isRecordingInProgress() || am.isEnabled()) break;
                    int micLongPressDelayForTooltip = this.getResources().getInteger(R.integer.lp_mic_tooltip_long_press_delay_ms);
                    this.handler.sendEmptyMessageDelayed(117, (long)micLongPressDelayForTooltip);
                    break;
                }
                case 1: {
                    this.handler.removeMessages(117);
                    this.mMicTooltipWindow.dismissTooltip();
                }
            }
            return false;
        });
        this.voiceControlButton.setContentDescription((CharSequence)String.format(this.getResources().getString(R.string.lp_accessibility_voice_mic_button), this.getMinutesLimit(), this.getSecondsLimit()));
        ViewCompat.setAccessibilityDelegate((View)this.voiceControlButton, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setClassName(null);
            }

            public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
                super.onPopulateAccessibilityEvent(host, event);
                host.setClickable(false);
                host.setLongClickable(true);
            }
        });
    }

    private long getMinutesLimit() {
        return TimeUnit.MILLISECONDS.toMinutes(this.mMaxRecordTimeMs) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(this.mMaxRecordTimeMs));
    }

    private long getSecondsLimit() {
        return TimeUnit.MILLISECONDS.toSeconds(this.mMaxRecordTimeMs) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(this.mMaxRecordTimeMs));
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setVoiceControlAsStopButton() {
        this.voiceControlButton.setImageResource(R.drawable.lpinfra_ui_ic_stop);
        this.voiceControlButton.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_voice_stop_button_color), PorterDuff.Mode.MULTIPLY);
        if (this.recordingStatus == RecordingStatus.RECORDING) {
            this.voiceControlButton.setOnClickListener(v -> this.onStopRecording(false, null));
            this.voiceControlButton.setContentDescription((CharSequence)this.getResources().getString(R.string.lp_accessibility_voice_stop_recording_button));
        } else {
            this.voiceControlButton.setOnClickListener(v -> this.onStopPlayback(false, null));
            this.voiceControlButton.setContentDescription((CharSequence)this.getResources().getString(R.string.lp_accessibility_voice_stop_replay_button));
        }
        this.voiceControlButton.setOnLongClickListener(null);
        this.voiceControlButton.setOnTouchListener(null);
        ViewCompat.setAccessibilityDelegate((View)this.voiceControlButton, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
                super.onPopulateAccessibilityEvent(host, event);
                host.setClickable(true);
                host.setLongClickable(false);
            }
        });
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    private void setVoiceControlAsReplayButton() {
        this.voiceControlButton.setImageResource(R.drawable.lpinfra_ui_ic_replay);
        this.voiceControlButton.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.lp_voice_replay_button_color), PorterDuff.Mode.MULTIPLY);
        this.voiceControlButton.setOnClickListener(v -> this.onPlayBackRecording());
        this.voiceControlButton.setContentDescription((CharSequence)this.getResources().getString(R.string.lp_accessibility_voice_replay_button));
        this.voiceControlButton.setOnLongClickListener(null);
        this.voiceControlButton.setOnTouchListener(null);
        ViewCompat.setAccessibilityDelegate((View)this.voiceControlButton, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
                super.onPopulateAccessibilityEvent(host, event);
                host.setClickable(true);
                host.setLongClickable(false);
            }
        });
    }

    protected boolean shouldUpdateSendButton() {
        return true;
    }

    protected boolean isSpeechRecognitionInProgress() {
        return this.isRecognitionInProgress;
    }

    private void vibrate() {
        if (this.getContext().checkCallingOrSelfPermission("android.permission.VIBRATE") == 0) {
            Vibrator v = (Vibrator)this.getContext().getSystemService("vibrator");
            v.vibrate((long)Configuration.getInteger((int)R.integer.lp_on_recording_max_time_vibrate_ms));
        }
    }

    protected void changeState(ChatState state) {
        boolean isInitialized = MessagingUIFactory.getInstance().isInitialized();
        if (isInitialized) {
            Messaging messaging = MessagingFactory.getInstance().getController();
            AmsConnection amsConnection = messaging.mConnectionController.getConnection(this.mBrandIdProvider.getBrandId());
            if (amsConnection != null && amsConnection.isUpdated()) {
                messaging.changeChatState(this.mBrandIdProvider.getTargetId(), this.mBrandIdProvider.getBrandId(), state);
            }
        }
    }

    private void animateRecordingIndicator() {
        if (this.recordingIndicator != null) {
            this.mColorAnim = ObjectAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.mColorAnim.addUpdateListener(this::onRecordingIndicatorAnimationUpdate);
            this.mColorAnim.setDuration(1000L);
            this.mColorAnim.setRepeatMode(2);
            this.mColorAnim.setRepeatCount(-1);
            this.mColorAnim.start();
            this.recordingIndicator.setVisibility(0);
        }
    }

    private void onRecordingIndicatorAnimationUpdate(ValueAnimator animation) {
        if (this.recordingIndicator != null) {
            int red = this.getResources().getColor(0x1060016);
            float mul = ((Float)animation.getAnimatedValue()).floatValue();
            int alphaRed = this.adjustAlpha(red, mul);
            this.recordingIndicator.setColorFilter(alphaRed, PorterDuff.Mode.SRC_IN);
            if ((double)mul == 0.0) {
                this.recordingIndicator.setColorFilter(null);
            }
        }
    }

    private void animateRecordProgress(int durationMs) {
        if (this.mRecordProgressBar != null && this.mRecordProgressTimeTextView != null) {
            this.mRecordProgressBarAnimator = ValueAnimator.ofInt((int[])new int[]{0, durationMs});
            this.mRecordProgressBarAnimator.setDuration((long)durationMs);
            this.mRecordProgressBarAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mRecordProgressBar.setMax(durationMs);
            this.mRecordProgressBarAnimator.addUpdateListener(valueAnimator -> {
                this.mRecordProgressBar.setProgress(((Integer)valueAnimator.getAnimatedValue()).intValue());
                this.mRecordProgressTimeTextView.setText((CharSequence)DateUtils.getDurationString((long)valueAnimator.getCurrentPlayTime()));
            });
            this.mRecordProgressBarAnimator.start();
        }
    }

    private void setDurationText(int durationMs) {
        if (this.mMaxRecordTimeTextView != null) {
            this.mMaxRecordTimeTextView.setText((CharSequence)DateUtils.getDurationString((long)durationMs));
        }
    }

    private void stopRecordProgressBarAnimation() {
        if (this.mRecordProgressBarAnimator != null) {
            this.mRecordProgressBarAnimator.cancel();
        }
    }

    private void stopRecordingIndicatorAnimation() {
        if (this.recordingIndicator != null) {
            this.recordingIndicator.setVisibility(8);
            if (this.mColorAnim != null) {
                this.mColorAnim.cancel();
                this.recordingIndicator.setColorFilter(null);
                this.mColorAnim = null;
            }
        }
    }

    private void announceEvent(CharSequence eventDescription) {
        if (this.mAnnouncer != null) {
            this.mAnnouncer.announce(eventDescription);
        }
    }

    public void setAnnouncer(AccessibilityAnnouncer announcer) {
        this.mAnnouncer = announcer;
    }

    protected boolean isRecordingInProgress() {
        return this.recordingStatus != RecordingStatus.STOPPED;
    }

    private int adjustAlpha(int color2, float factor) {
        int alpha = Math.round((float)Color.alpha((int)color2) * factor);
        int red = Color.red((int)color2);
        int green = Color.green((int)color2);
        int blue = Color.blue((int)color2);
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    private void nullifySpeechRecognitionTimer() {
        if (this.timerTask != null && this.timerTask.get() != null) {
            ((TimerTask)this.timerTask.get()).cancel();
            this.timerTask.clear();
        }
        this.timerTask = null;
        if (this.speechRecognitionProgressTimer != null && this.speechRecognitionProgressTimer.get() != null) {
            ((Timer)this.speechRecognitionProgressTimer.get()).cancel();
            ((Timer)this.speechRecognitionProgressTimer.get()).purge();
        }
        this.speechRecognitionProgressTimer = null;
    }

    private void nullifySpeechRecognizer() {
        if (this.speechRecognizer != null) {
            this.speechRecognizer.stopListening();
            this.speechRecognizer.cancel();
            this.speechRecognizer.destroy();
            this.speechRecognizer.setRecognitionListener(null);
        }
        this.speechRecognizer = null;
    }

    private void nullifySpeechRecognizerListeners() {
        if (this.lpRecognitionListener != null && this.lpRecognitionListener.get() != null) {
            this.lpRecognitionListener.clear();
        }
        this.lpRecognitionListener = null;
        this.speechRecognitionControlButtonOnClickListener = null;
    }

    private void unregisterDetectHeadsetUnpluggedBroadcastReceiver() {
        try {
            this.getContext().getApplicationContext().unregisterReceiver((BroadcastReceiver)this.mDetectHeadsetUnpluggedBroadcastReceiver);
        }
        catch (IllegalArgumentException e) {
            LPLog.INSTANCE.w(TAG, "unregisterDetectHeadsetUnpluggedBroadcastReceiver: receiver is not registered", (Throwable)e);
        }
    }

    private void nullifySpeechRecognitionResources() {
        LPLog.INSTANCE.d(TAG, "nullifySpeechRecognitionResources");
        this.nullifySpeechRecognitionTimer();
        this.nullifySpeechRecognizer();
        this.nullifySpeechRecognizerListeners();
        this.unregisterDetectHeadsetUnpluggedBroadcastReceiver();
    }

    private static enum RecordingStatus {
        STOPPED,
        MAX_REACHED,
        RECORDING,
        PAUSED,
        PLAYING;

    }
}

