/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.content.res.ResourcesCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.accessibility.AccessibilityAnnouncer;
import com.liveperson.infra.messaging_ui.uicomponents.IScrollDownIndicator;
import java.util.IllegalFormatException;

public class ScrollDownIndicator
extends ConstraintLayout
implements IScrollDownIndicator {
    private static String TAG = "ScrollDownIndicator";
    private static final long ANNOUNCEENT_DELAY = 200L;
    private TextView mCounter;
    private TextView mSummary;
    private MODE mMode = MODE.CLOSE;
    private boolean isSummaryEnabled = true;
    private ImageView mBackground;
    private ViewPropertyAnimator animator;
    private AccessibilityAnnouncer mAnnouncer;

    public ScrollDownIndicator(Context context) {
        super(context);
        this.init(context);
    }

    public ScrollDownIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ScrollDownIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.lpmessaging_ui_scroll_indicator, (ViewGroup)this);
        this.isSummaryEnabled = Configuration.getBoolean((int)R.bool.scroll_down_indicator_unread_summary_enabled);
        this.setVisibility(4);
        this.mCounter = (TextView)this.findViewById(R.id.scroll_down_indicator_unread_counter);
        this.mSummary = (TextView)this.findViewById(R.id.scroll_down_indicator_unread_summary);
        this.mBackground = (ImageView)this.findViewById(R.id.scroll_down_indicator_background);
        this.resetBackgroundAccessibilityAnnouncement();
        Drawable drawable2 = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.lpmessaging_ui_scroll_down_arrow);
        if (drawable2 != null) {
            int color2 = ResourcesCompat.getColor((Resources)this.getResources(), (int)R.color.scroll_down_indicator_arrow_down_color, (Resources.Theme)this.getContext().getTheme());
            DrawableCompat.setTint((Drawable)drawable2, (int)color2);
            ImageView scrollDownIconView = (ImageView)this.findViewById(R.id.scroll_down_indicator_icon);
            scrollDownIconView.setImageDrawable(drawable2);
        }
    }

    @Override
    public void setOnClickListener(View.OnClickListener l) {
        this.mBackground.setOnClickListener(l);
    }

    private void hideExtraData() {
        this.mCounter.setVisibility(4);
        this.mSummary.setVisibility(4);
    }

    @Override
    public boolean isExpand() {
        return this.mMode == MODE.OPEN_EXPAND;
    }

    @Override
    public void resetAndHide() {
        if (this.mMode != MODE.CLOSE) {
            this.mMode = MODE.CLOSE;
            this.hideExtraData();
            if (this.animator != null) {
                this.animator.cancel();
            }
            this.animator = this.animate().setStartDelay(100L).translationX((float)this.getWidth());
        }
    }

    @Override
    public void resetAndShowCollapsed() {
        if (this.mMode != MODE.OPEN_COLLAPSED) {
            if (this.animator != null) {
                this.animator.cancel();
            }
            if (this.mMode == MODE.CLOSE) {
                this.setTranslationX(this.getWidth());
            }
            this.mMode = MODE.OPEN_COLLAPSED;
            this.hideExtraData();
            this.animator = this.animate().translationX((float)(this.mSummary.getWidth() + this.mCounter.getWidth()));
            this.setVisibility(0);
            this.updateContentDescription(0);
        }
    }

    public void setAnnouncer(AccessibilityAnnouncer mAnnouncer) {
        this.mAnnouncer = mAnnouncer;
    }

    @Override
    public void show(int numOfUnreadAgentMessages, String lastMessage) {
        this.updateContentDescription(numOfUnreadAgentMessages);
        if (numOfUnreadAgentMessages > 0) {
            this.mCounter.setVisibility(0);
            String unread = String.valueOf(numOfUnreadAgentMessages);
            this.mCounter.setText((CharSequence)unread);
            this.announceUnreadMessages(numOfUnreadAgentMessages);
            if (this.animator != null) {
                this.animator.cancel();
            }
            if (this.isSummaryEnabled) {
                this.mSummary.setText((CharSequence)lastMessage);
                this.mSummary.setVisibility(0);
                this.setVisibility(0);
                float textWidth = this.mSummary.getPaint().measureText(this.mSummary.getText().toString());
                float excessTextViewWidth = (float)this.mSummary.getWidth() - textWidth;
                float xTranslation = excessTextViewWidth > 0.0f ? excessTextViewWidth : 0.0f;
                this.animator = this.animate().translationX(xTranslation);
            } else {
                this.mSummary.setText(null);
                this.mSummary.setVisibility(8);
                this.setVisibility(0);
                this.animator = this.animate().translationX((float)this.mSummary.getWidth());
            }
            this.mMode = MODE.OPEN_EXPAND;
        } else {
            this.resetAndHide();
        }
    }

    private void updateContentDescription(int unreadCount) {
        Resources resources = this.getResources();
        String description = resources.getString(R.string.lp_accessibility_scroll_down_indicator_description) + " " + resources.getString(R.string.lp_accessibility_sc_button) + " " + this.getUnreadMessageAnnouncement(unreadCount) + " " + resources.getString(R.string.lp_accessibility_scroll_down_indicator_hint);
        this.mBackground.setContentDescription((CharSequence)description);
    }

    private void resetBackgroundAccessibilityAnnouncement() {
        this.mBackground.setAccessibilityDelegate(new View.AccessibilityDelegate(){

            public void onInitializeAccessibilityNodeInfo(@NonNull View host, @NonNull AccessibilityNodeInfo info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setClassName((CharSequence)"");
            }
        });
    }

    private void announceUnreadMessages(int count) {
        Runnable announcementRunnable = () -> {
            AccessibilityAnnouncer announcer = this.mAnnouncer;
            if (announcer != null && this.mMode != MODE.CLOSE) {
                announcer.announce(this.getUnreadMessageAnnouncement(count));
            }
        };
        this.postDelayed(announcementRunnable, 200L);
    }

    @NonNull
    private String getUnreadMessageAnnouncement(int unreadCnt) {
        if (unreadCnt <= 0) {
            return "";
        }
        String unreadMsgBase = this.getResources().getQuantityString(R.plurals.lp_unread_message, unreadCnt);
        try {
            return String.format(unreadMsgBase, unreadCnt);
        }
        catch (IllegalFormatException ex) {
            LPLog.INSTANCE.d(TAG, "Failed to format lp_unread_message", (Throwable)ex);
            return "";
        }
    }

    private static enum MODE {
        CLOSE,
        OPEN_COLLAPSED,
        OPEN_EXPAND;

    }
}

