/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents.list;

import android.content.Context;
import android.util.AttributeSet;
import android.view.ViewTreeObserver;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.RecyclerView;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.accessibility.AccessibilityAnnouncer;
import com.liveperson.infra.messaging_ui.fragment.ConversationViewCallback;
import com.liveperson.infra.messaging_ui.uicomponents.IScrollDownIndicator;
import com.liveperson.infra.messaging_ui.uicomponents.list.BlockInputAreaCallback;
import com.liveperson.infra.messaging_ui.uicomponents.list.ChatMessageBgFgListener;
import com.liveperson.infra.messaging_ui.uicomponents.list.MessagesAsListAdapter;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.messaging_ui.view.decorators.AgentIsTypingDecorator;
import com.liveperson.infra.ui.view.sticky.StickyHeadersLinearLayoutManager;
import com.liveperson.infra.ui.view.uicomponents.IConnectionChangedCustomView;
import com.liveperson.messaging.Messaging;

public class ChatMessageListRecyclerView
extends RecyclerView
implements IConnectionChangedCustomView,
ChatMessageBgFgListener {
    public static final String TAG = "ChatMessageListRecyclerView";
    private static final AccessibilityAnnouncer DEFAULT_ANNOUNCER = new EmptyAccessibilityAnnouncer();
    private MessagesAsListAdapter mMessagesAsListAdapter;
    private AgentIsTypingDecorator mAgentIsTypingDecorator;
    private boolean isWaitingForAdapter;
    private final StickyHeadersLinearLayoutManager<MessagesAsListAdapter> mLayoutManager;
    private ViewTreeObserver.OnWindowAttachListener mOnWindowAttachListener;
    private AccessibilityAnnouncer mAnnouncer;
    private BlockInputAreaCallback savedBlockInputAreaCallback;

    public ChatMessageListRecyclerView(Context context) {
        this(context, null);
    }

    public ChatMessageListRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ChatMessageListRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mLayoutManager = StickyHeadersLinearLayoutManager.create((Context)context, () -> this.post(() -> {
            RecyclerView.Adapter adapter = this.getAdapter();
            if (adapter != null) {
                adapter.notifyDataSetChanged();
            }
        }));
        this.mLayoutManager.setStackFromEnd(true);
        this.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
    }

    private void setCopyBehavior(ContextualActionBehavior menuProvider) {
        this.mMessagesAsListAdapter.setCopyBehavior(menuProvider);
    }

    public void setBlockInputAreaCallback(BlockInputAreaCallback callback2) {
        if (this.mMessagesAsListAdapter != null) {
            this.mMessagesAsListAdapter.setBlockInputAreaCallback(callback2);
        } else {
            this.savedBlockInputAreaCallback = callback2;
        }
    }

    public void initData(final Messaging controller, final String brandId, final IScrollDownIndicator scrollDownIndicator, final ContextualActionBehavior menuProvider) {
        LPLog.INSTANCE.d(TAG, "isAttachedToWindow = " + this.isAttachedToWindow());
        if (!this.isAttachedToWindow()) {
            this.getViewTreeObserver().addOnWindowAttachListener(new ViewTreeObserver.OnWindowAttachListener(){

                @RequiresApi(api=18)
                public void onWindowAttached() {
                    LPLog.INSTANCE.d(ChatMessageListRecyclerView.TAG, "onWindowAttached ");
                    ChatMessageListRecyclerView.this.initializeAdapter(brandId, scrollDownIndicator, menuProvider);
                    ChatMessageListRecyclerView.this.getViewTreeObserver().removeOnWindowAttachListener((ViewTreeObserver.OnWindowAttachListener)this);
                    ChatMessageListRecyclerView.this.onConnectionChanged(controller.mConnectionController.isSocketReady(brandId));
                    if (ChatMessageListRecyclerView.this.mOnWindowAttachListener != null) {
                        ChatMessageListRecyclerView.this.mOnWindowAttachListener.onWindowAttached();
                    }
                }

                public void onWindowDetached() {
                    LPLog.INSTANCE.d(ChatMessageListRecyclerView.TAG, "onWindowDetached ");
                }
            });
        } else {
            this.initializeAdapter(brandId, scrollDownIndicator, menuProvider);
        }
    }

    public void setConversationViewCallback(final ConversationViewCallback conversationViewCallback) {
        if (this.mMessagesAsListAdapter != null) {
            this.mMessagesAsListAdapter.setConversationViewCallback(conversationViewCallback);
        } else {
            this.mOnWindowAttachListener = new ViewTreeObserver.OnWindowAttachListener(){

                public void onWindowAttached() {
                    if (ChatMessageListRecyclerView.this.mMessagesAsListAdapter != null) {
                        ChatMessageListRecyclerView.this.mMessagesAsListAdapter.setConversationViewCallback(conversationViewCallback);
                    }
                }

                public void onWindowDetached() {
                }
            };
        }
    }

    public void dispose() {
        this.setAccessibilityDelegateCompat(null);
        this.mLayoutManager.setOnLayoutChildrenListener(null);
        this.setLayoutManager(null);
        this.clearOnScrollListeners();
        this.getRootView().setAccessibilityDelegate(null);
        if (this.mMessagesAsListAdapter != null) {
            this.mMessagesAsListAdapter.setConversationViewCallback(null);
        }
        this.mOnWindowAttachListener = null;
        this.mMessagesAsListAdapter = null;
    }

    private void initializeAdapter(String brandId, IScrollDownIndicator scrollDownIndicator, ContextualActionBehavior menuProvider) {
        this.mMessagesAsListAdapter = new MessagesAsListAdapter(this, scrollDownIndicator, brandId);
        this.mMessagesAsListAdapter.init();
        this.setAdapter(this.mMessagesAsListAdapter);
        this.setCopyBehavior(menuProvider);
        this.mAgentIsTypingDecorator = new AgentIsTypingDecorator();
        this.addItemDecoration(this.mAgentIsTypingDecorator);
        if (this.isWaitingForAdapter) {
            this.isWaitingForAdapter = false;
            this.onForeground();
        }
        if (this.savedBlockInputAreaCallback != null) {
            this.mMessagesAsListAdapter.setBlockInputAreaCallback(this.savedBlockInputAreaCallback);
            this.savedBlockInputAreaCallback = null;
        }
    }

    public void onConnectionChanged(boolean isConnected) {
        if (this.mMessagesAsListAdapter != null) {
            if (isConnected) {
                this.mMessagesAsListAdapter.onConnectionAvailable();
            } else {
                this.mMessagesAsListAdapter.onConnectionLost();
            }
        }
    }

    @Override
    public void onBackground() {
        this.setAgentIsTyping(false, "");
        if (this.mMessagesAsListAdapter != null) {
            this.mMessagesAsListAdapter.onBackground();
        }
    }

    @Override
    public void onForeground() {
        if (this.mMessagesAsListAdapter != null) {
            this.mMessagesAsListAdapter.onForeground();
        } else {
            this.isWaitingForAdapter = true;
        }
    }

    public void removeListener() {
        if (this.mMessagesAsListAdapter != null) {
            this.mMessagesAsListAdapter.removeListener();
        }
    }

    public void focusLastItem() {
        if (this.mMessagesAsListAdapter == null) {
            return;
        }
        RecyclerView.ViewHolder viewHolder = this.findViewHolderForAdapterPosition(this.mMessagesAsListAdapter.getItemCount() - 1);
        if (viewHolder != null) {
            viewHolder.itemView.requestFocus();
        }
    }

    public void setAgentIsTyping(boolean isTyping, String originatorId) {
        this.post(() -> {
            if (this.mAgentIsTypingDecorator == null) {
                return;
            }
            if (isTyping) {
                if (this.mMessagesAsListAdapter != null) {
                    String avatarUrl = this.mMessagesAsListAdapter.getAgentAvatarUrl(originatorId);
                    this.mAgentIsTypingDecorator.setAgentIsTyping(true, avatarUrl);
                }
            } else {
                this.mAgentIsTypingDecorator.setAgentIsTyping(false, "");
            }
            this.invalidateItemDecorations();
        });
    }

    public void removeQuickRepliesMessageOfConversation(String conversationId) {
        this.post(() -> {
            if (this.mMessagesAsListAdapter != null) {
                this.mMessagesAsListAdapter.removeQuickRepliesMessageOfConversation(conversationId);
                this.invalidateItemDecorations();
            }
        });
    }

    public void removeQuickRepliesMessageOfDialog(String dialogId) {
        this.post(() -> {
            if (this.mMessagesAsListAdapter != null) {
                this.mMessagesAsListAdapter.removeQuickRepliesMessageOfDialog(dialogId);
                this.invalidateItemDecorations();
            }
        });
    }

    public void notifyLastMessageChanges() {
        this.post(() -> {
            MessagesAsListAdapter adapter = this.mMessagesAsListAdapter;
            if (adapter != null) {
                int lastPosition = adapter.getItemCount() - 1;
                adapter.notifyItemChanged(lastPosition);
            }
        });
    }

    public void removeCoBrowsMessageFromView(String dialogId) {
        this.post(() -> {
            if (this.mMessagesAsListAdapter != null) {
                this.mMessagesAsListAdapter.removeCoBrowsMessageOfConversation(dialogId);
                this.invalidateItemDecorations();
            }
        });
    }

    public AccessibilityAnnouncer getAnnouncer() {
        if (this.mAnnouncer == null) {
            return DEFAULT_ANNOUNCER;
        }
        return this.mAnnouncer;
    }

    public void setAnnouncer(AccessibilityAnnouncer announcer) {
        this.mAnnouncer = announcer;
    }

    private static class EmptyAccessibilityAnnouncer
    implements AccessibilityAnnouncer {
        private EmptyAccessibilityAnnouncer() {
        }

        @Override
        public void announce(@NonNull CharSequence announcement) {
            LPLog.INSTANCE.d(ChatMessageListRecyclerView.TAG, "Empty announcer: " + announcement);
        }
    }
}

