/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents.list;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Vibrator;
import android.text.TextUtils;
import android.util.Pair;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerViewAccessibilityDelegate;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.api.response.types.DeliveryStatus;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.analytics.LPAnalytics;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.accessibility.AccessibilityAnnouncer;
import com.liveperson.infra.messaging_ui.fragment.ConversationViewCallback;
import com.liveperson.infra.messaging_ui.uicomponents.IScrollDownIndicator;
import com.liveperson.infra.messaging_ui.uicomponents.list.BlockInputAreaCallback;
import com.liveperson.infra.messaging_ui.uicomponents.list.ChatMessageBgFgListener;
import com.liveperson.infra.messaging_ui.uicomponents.list.ChatMessageListRecyclerView;
import com.liveperson.infra.messaging_ui.uicomponents.list.MessagesAsListLoader;
import com.liveperson.infra.messaging_ui.utils.AccessbilityUtilsKt;
import com.liveperson.infra.messaging_ui.utils.ContentBlockingUtils;
import com.liveperson.infra.messaging_ui.utils.LPAppointmentSchedulerHandler;
import com.liveperson.infra.messaging_ui.view.adapter.ContextualMovementMethod;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.IMenuCallback;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent.AmsAgentFileViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent.AmsAgentFormInvitationViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent.AmsAgentMarkdownHyperlinkViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent.AmsAgentStructuredContentViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent.AmsAgentTypingViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent.AmsAgentURLViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent.AmsAgentViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.base.ParticipantFileViewHolderUtils;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.base.ParticipantSCViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.base.ParticipantViewHolderUtils;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.bot.AmsBotFileViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.bot.AmsBotMarkdownHyperlinkViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.bot.AmsBotStructuredContentViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.bot.AmsBotURLViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.bot.AmsBotViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.brand.AmsBrandMsgViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.consumer.AmsConsumerFileViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.consumer.AmsConsumerFormSubmissionViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.consumer.AmsConsumerURLViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.consumer.AmsConsumerViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.consumer.AmsConsumerVoiceViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.system.AmsControllerSystemViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.system.AmsSystemDialogResolvedViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.system.AmsSystemMaskedViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.system.AmsSystemResolvedViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.ui.AmsCoBrowseViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.ui.AmsLoadMoreViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.ui.DateHeaderViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.ui.UiUnreadIndicatorViewHolder;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.preferences.PushMessagePreferences;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.infra.ui.view.sticky.StickyHeaderHolder;
import com.liveperson.infra.ui.view.sticky.StickyHeadersLinearLayoutManager;
import com.liveperson.infra.utils.LPAudioUtils;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.infra.utils.markdown.HyperLinkUtils;
import com.liveperson.lp_structured_content.data.model.elements.complex.QuickRepliesElement;
import com.liveperson.lp_structured_content.ui.OnSCActionClickListener;
import com.liveperson.lp_structured_content.ui.QRActionClickListener;
import com.liveperson.lp_structured_content.utils.SCUtils;
import com.liveperson.lpdatepicker.model.DatePickerParams;
import com.liveperson.messaging.LivePersonEventsProxy;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.CoBrowseManager;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.CoBrowseMetadata;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.IllegalFormatException;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MessagesAsListAdapter
extends RecyclerView.Adapter<BaseViewHolder>
implements MessagesAsListLoader.OnListUpdated,
StickyHeaderHolder,
StickyHeaderHolder.ViewDecorator,
ChatMessageBgFgListener,
BaseViewHolder.OnRequestTimestampUpdateListener,
ContextualMovementMethod.OnLinkMovementListener {
    private static final String PAYLOAD_UPDATE_TIMESTAMP = "payload.update_timestamp";
    private static final String PAYLOAD_SC_PUBLISH_ACTION = "payload.sc_publish_action";
    private static final String TAG = "MessagesAsListAdapter";
    private static final String TYPE_SCROLL_TO_BOTTOM = "bottom";
    private static final String TYPE_SCROLL_TO_LAST_POSITION = "lastposition";
    private static final String TYPE_SCROLL_TO_FIRST_UNREAD = "firstunreadmessage";
    private static final String KEY_LAST_SCROLLED_FIRST_VISIBLE_ITEM_POSITION = "last_scrolled_first_visible_item_position";
    private static final String KEY_SCROLLING_OFFSET = "scrolling_items_offser";
    private static final int VIBRATION_DURATION_IN_MILLISECONDS = 400;
    private static final long SCROLL_EXPIRATION_DELAY = 10000L;
    private static final int SMOOTH_SCROLL_RANGE = 20;
    private static final int DB_MESSAGE_LOAD_LIMIT = 100;
    private final WeakReference<ChatMessageListRecyclerView> mRecyclerViewRef;
    private final WeakReference<IScrollDownIndicator> mScrollDownIndicatorRef;
    private MessagesAsListLoader messagesAsListLoader;
    private ContextualActionBehavior mMessagingContextualActionController;
    private ConversationViewCallback conversationViewCallback;
    private LPAppointmentSchedulerHandler lpAppointmentSchedulerHandler;
    private boolean mHideResolveMessage;
    private boolean mHideResolveSeparator;
    private boolean mHideAutoCloseResolveSeparator;
    private boolean firstTimeBringToForeground;
    private boolean fromPushNotification;
    private boolean pendingScrollToFirstUnreadMessage;
    private boolean pendingScrollToBottom;
    private boolean keepLastPositionOnNewMessage;
    private boolean isFirstScrollPerformed;
    private String mBrandId;
    private boolean permissionGranted = false;
    private boolean shouldScrollToFirstByPush = false;
    private boolean shouldScrollToFirstByInApp = false;
    private boolean shouldFocusOnlastMessage;
    private boolean shouldFocusOnUnreadBanner;
    private int lastScrolledPosition = 0;
    private int lastUIItemPosition = 0;
    private int mFirstUIItemPosition = 0;
    private Pair<View, Integer> lastHoverMoveEventPair;
    private final Handler mUpdatesHandler = new Handler(Looper.getMainLooper());
    private boolean mIsForeground = false;
    private long mLastKnownSystemMessageTimestamp = 0L;
    private BlockInputAreaCallback mBlockInputAreaCallback;

    public void setBlockInputAreaCallback(BlockInputAreaCallback callback2) {
        this.mBlockInputAreaCallback = callback2;
    }

    MessagesAsListAdapter(ChatMessageListRecyclerView chatMessageListRecyclerView, IScrollDownIndicator scrollDownIndicator, String brandId) {
        this.mBrandId = brandId;
        this.firstTimeBringToForeground = true;
        this.mRecyclerViewRef = new WeakReference<ChatMessageListRecyclerView>(chatMessageListRecyclerView);
        this.mScrollDownIndicatorRef = new WeakReference<IScrollDownIndicator>(scrollDownIndicator);
        this.registerAdapterDataObserver(new RecyclerView.AdapterDataObserver(){

            public void onItemRangeRemoved(int positionStart, int itemCount) {
                super.onItemRangeRemoved(positionStart, itemCount);
                MessagesAsListAdapter.this.notifyBlockInputChanged();
            }

            public void onItemRangeInserted(int positionStart, int itemCount) {
                FullMessageRow previousRow;
                super.onItemRangeInserted(positionStart, itemCount);
                if (positionStart > 0 && (previousRow = MessagesAsListAdapter.this.messagesAsListLoader.getItem(positionStart - 1)) != null) {
                    MessagingChatMessage previousMessage = previousRow.getMessagingChatMessage();
                    if (!MessagesAsListAdapter.this.isLastItem(positionStart - 1) && MessagingChatMessage.MessageType.isStructuredContent((MessagingChatMessage.MessageType)previousMessage.getMessageType())) {
                        MessagesAsListAdapter.this.notifyItemChanged(positionStart - 1, MessagesAsListAdapter.PAYLOAD_SC_PUBLISH_ACTION);
                    }
                }
                MessagesAsListAdapter.this.notifyBlockInputChanged();
            }

            public void onItemRangeChanged(int positionStart, int itemCount) {
                super.onItemRangeChanged(positionStart, itemCount);
                if (positionStart + itemCount == MessagesAsListAdapter.this.getItemCount()) {
                    MessagesAsListAdapter.this.notifyBlockInputChanged();
                }
            }
        });
    }

    public void init() {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        IScrollDownIndicator scrollDownIndicator = (IScrollDownIndicator)this.mScrollDownIndicatorRef.get();
        if (recyclerView == null) {
            return;
        }
        Context context = recyclerView.getContext().getApplicationContext();
        this.messagesAsListLoader = new MessagesAsListLoader(recyclerView, this, this.mBrandId);
        this.lpAppointmentSchedulerHandler = new LPAppointmentSchedulerHandler(context);
        if (scrollDownIndicator != null) {
            scrollDownIndicator.setOnClickListener(view -> this.scrollOnScrollDownIndicatorClicked());
        }
        this.mHideResolveMessage = !Configuration.getBoolean((int)R.bool.enable_conversation_resolved_message);
        this.mHideResolveSeparator = !Configuration.getBoolean((int)R.bool.enable_conversation_resolved_separator);
        this.mHideAutoCloseResolveSeparator = !Configuration.getBoolean((int)R.bool.lp_enable_conversation_resolved_separator_on_auto_close);
        this.initScrollListener();
        boolean isVibrateEnabled = Configuration.getBoolean((int)R.bool.vibrate_enabled);
        if (context.checkCallingOrSelfPermission("android.permission.VIBRATE") == 0 && isVibrateEnabled) {
            this.permissionGranted = true;
        }
        this.fromPushNotification = PushMessagePreferences.INSTANCE.isPushNotificationClicked();
        this.setUpAccessibilityDelegates();
    }

    public void setConversationViewCallback(ConversationViewCallback conversationViewCallback) {
        this.conversationViewCallback = conversationViewCallback;
        if (this.messagesAsListLoader != null) {
            this.messagesAsListLoader.setConversationViewCallback(conversationViewCallback);
        }
        if (this.lpAppointmentSchedulerHandler != null) {
            this.lpAppointmentSchedulerHandler.setConversationViewCallback(conversationViewCallback);
        }
    }

    private void onScrolled() {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        IScrollDownIndicator scrollDownIndicator = (IScrollDownIndicator)this.mScrollDownIndicatorRef.get();
        if (recyclerView == null) {
            return;
        }
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (!(manager instanceof StickyHeadersLinearLayoutManager)) {
            return;
        }
        StickyHeadersLinearLayoutManager layoutManager = (StickyHeadersLinearLayoutManager)manager;
        int firstPos = layoutManager.findFirstVisibleItemPosition();
        int lastPos = layoutManager.findLastVisibleItemPosition();
        if (this.mFirstUIItemPosition == firstPos && this.lastUIItemPosition == lastPos) {
            return;
        }
        if (firstPos == lastPos && lastPos == -1) {
            return;
        }
        this.mFirstUIItemPosition = firstPos;
        this.lastUIItemPosition = lastPos;
        if ((this.lastUIItemPosition <= this.lastScrolledPosition || this.lastScrolledPosition == 0) && this.lastUIItemPosition >= 0) {
            this.lastScrolledPosition = this.lastUIItemPosition;
        }
        LPLog.INSTANCE.d(TAG, "onScrolled: FirstVisibleItemPosition " + this.mFirstUIItemPosition + " lastUIItemPosition = " + this.lastUIItemPosition + " lastScrolledPosition: " + this.lastScrolledPosition);
        this.messagesAsListLoader.onScroll(this.mFirstUIItemPosition);
        int visibleItemCount = layoutManager.getChildCount();
        int totalItemCount = layoutManager.getItemCount();
        int pastVisibleItems = layoutManager.findFirstVisibleItemPosition();
        LPLog.INSTANCE.d(TAG, "onScrolled: if(pastVisibleItems + visibleItemCount >= totalItemCount) -> (" + pastVisibleItems + "+" + visibleItemCount + ">=" + totalItemCount + ")");
        if (pastVisibleItems + visibleItemCount >= totalItemCount) {
            LPLog.INSTANCE.d(TAG, "onScrolled: resetAndHide -> pastVisibleItems + visibleItemCount >= totalItemCount (" + pastVisibleItems + "+" + visibleItemCount + ">=" + totalItemCount + ")");
            if (scrollDownIndicator != null) {
                scrollDownIndicator.resetAndHide();
            }
            this.messagesAsListLoader.setNewMessageRead(true);
            this.messagesAsListLoader.setScrollDownIndicatorVisible(false);
        } else {
            int unreadPosition = this.messagesAsListLoader.getUnreadPosition();
            LPLog.INSTANCE.d(TAG, "onScrolled: lastUIItemPosition = " + this.lastUIItemPosition + " unreadPosition = " + unreadPosition);
            if (this.lastUIItemPosition >= unreadPosition && this.lastUIItemPosition != -1 || this.lastUIItemPosition < this.messagesAsListLoader.size() - 1 && !this.messagesAsListLoader.isScrollDownIndicatorVisible()) {
                LPLog.INSTANCE.d(TAG, "onScrolled: resetAndShowCollapsed -> (lastUIItemPosition >= unreadPosition) && (lastUIItemPosition != -1) (" + this.lastUIItemPosition + ">=" + unreadPosition + " && " + this.lastUIItemPosition + " != -1)");
                if (scrollDownIndicator != null) {
                    scrollDownIndicator.resetAndShowCollapsed();
                }
                this.messagesAsListLoader.setScrollDownIndicatorVisible(true);
            }
        }
    }

    private void initScrollListener() {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        recyclerView.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                LPLog.INSTANCE.d(MessagesAsListAdapter.TAG, "Accessibility: onScrolled " + dx + " " + dy);
                if (dx == 0 && dy == 0) {
                    MessagesAsListAdapter.this.requestAccessibilityFocusForLastItem(recyclerView, 300L);
                    return;
                }
                MessagesAsListAdapter.this.onScrolled();
            }

            public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
                LPLog.INSTANCE.d(MessagesAsListAdapter.TAG, "Accessibility: onScrollStateChanged " + newState);
                if (newState == 0) {
                    MessagesAsListAdapter.this.requestAccessibilityFocusForLastItem(recyclerView, 300L);
                }
            }
        });
    }

    private boolean wasPreviousEventAccessibilityFocusCleared() {
        boolean result = this.lastHoverMoveEventPair != null && ((Integer)this.lastHoverMoveEventPair.second == 65536 || (Integer)this.lastHoverMoveEventPair.second == 256);
        LPLog.INSTANCE.d(TAG, "wasPreviousEventAccessibilityFocusCleared " + result);
        return result;
    }

    private boolean wasPreviousViewAboveCurrent(View currentView) {
        if (this.lastHoverMoveEventPair == null) {
            return false;
        }
        Integer currentViewTag = (Integer)currentView.getTag(R.id.lp_messages_as_list_view_holder_position_key);
        Integer previousViewTag = (Integer)((View)this.lastHoverMoveEventPair.first).getTag(R.id.lp_messages_as_list_view_holder_position_key);
        LPLog.INSTANCE.d(TAG, "wasPreviousViewAboveCurrent currentViewTag = " + currentViewTag + " previousViewTag " + previousViewTag);
        return previousViewTag < currentViewTag;
    }

    private void setUpAccessibilityDelegates() {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        recyclerView.setAccessibilityDelegateCompat(new RecyclerViewAccessibilityDelegate(recyclerView){

            public boolean onRequestSendAccessibilityEvent(ViewGroup host, View child, AccessibilityEvent event) {
                Integer tag = (Integer)child.getTag(R.id.lp_messages_as_list_view_holder_position_key);
                if (tag.intValue() == MessagesAsListAdapter.this.getFirstVisibleItemPosition() && event.getEventType() == 32768 && MessagesAsListAdapter.this.getLastVisibleItemPosition() == MessagesAsListAdapter.this.messagesAsListLoader.size() - 1 && MessagesAsListAdapter.this.wasPreviousViewAboveCurrent(child) && MessagesAsListAdapter.this.wasPreviousEventAccessibilityFocusCleared()) {
                    MessagesAsListAdapter.this.lastHoverMoveEventPair = null;
                    LPLog.INSTANCE.d(MessagesAsListAdapter.TAG, "Accessibility: onRequestSendAccessibilityEvent: do not announce twice");
                    return false;
                }
                if (event.getEventType() == 128) {
                    MessagesAsListAdapter.this.lastHoverMoveEventPair = new Pair((Object)child, (Object)event.getEventType());
                } else if (event.getEventType() == 65536 || event.getEventType() == 256) {
                    MessagesAsListAdapter.this.lastHoverMoveEventPair = new Pair((Object)child, (Object)event.getEventType());
                }
                LPLog.INSTANCE.d(MessagesAsListAdapter.TAG, "Accessibility: onRequestSendAccessibilityEvent: call super");
                return super.onRequestSendAccessibilityEvent(host, child, event);
            }
        });
    }

    @Override
    public int getLoadLimit() {
        if (this.firstTimeBringToForeground) {
            String pushNavigation = Configuration.getString((int)R.string.lp_scroll_when_push_notification).toLowerCase();
            String inAppNavigation = Configuration.getString((int)R.string.lp_scroll_show_conversation).toLowerCase();
            int offset = PreferenceManager.getInstance().getIntValue(KEY_SCROLLING_OFFSET, this.mBrandId, -1);
            if (this.fromPushNotification) {
                if (TYPE_SCROLL_TO_LAST_POSITION.equals(pushNavigation)) {
                    if (offset < 100) {
                        this.shouldScrollToFirstByPush = true;
                        return Math.max(offset, 25);
                    }
                    return 25;
                }
                return 25;
            }
            if (TYPE_SCROLL_TO_LAST_POSITION.equals(inAppNavigation)) {
                if (offset < 100) {
                    this.shouldScrollToFirstByInApp = true;
                    return Math.max(offset, 25);
                }
                return 25;
            }
            return 25;
        }
        return 25;
    }

    @Override
    public int getFirstVisibleItemPosition() {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null || recyclerView.getLayoutManager() == null) {
            return -1;
        }
        return ((StickyHeadersLinearLayoutManager)recyclerView.getLayoutManager()).findFirstVisibleItemPosition();
    }

    @Override
    public int getLastVisibleItemPosition() {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null || recyclerView.getLayoutManager() == null) {
            return -1;
        }
        return ((StickyHeadersLinearLayoutManager)recyclerView.getLayoutManager()).findLastVisibleItemPosition();
    }

    @Override
    public void notifyUnreadMessagesChanged(int numOfUnreadAgentMessages, String lastMessage, int indexNumOfUnreadAgentMessage) {
        int lastVisibleItemPosition = this.getLastVisibleItemPosition();
        IScrollDownIndicator scrollDownIndicator = (IScrollDownIndicator)this.mScrollDownIndicatorRef.get();
        if (lastVisibleItemPosition < indexNumOfUnreadAgentMessage && !this.pendingScrollToBottom) {
            LPLog.INSTANCE.d(TAG, "notifyUnreadMessagesChanged: getLastVisibleItemPosition(" + lastVisibleItemPosition + ") < indexNumOfUnreadAgentMessage(" + indexNumOfUnreadAgentMessage + "). ShowScrollDownIndicator.");
            if (scrollDownIndicator != null) {
                scrollDownIndicator.show(numOfUnreadAgentMessages, lastMessage);
            }
            if (Configuration.getBoolean((int)R.bool.scroll_down_indicator_unread_summary_enabled)) {
                this.messagesAsListLoader.setScrollDownIndicatorVisible(true);
            }
        } else {
            LPLog.INSTANCE.d(TAG, "notifyUnreadMessagesChanged: don't show scrollDownIndicator. getLastVisibleItemPosition(" + lastVisibleItemPosition + ") > indexNumOfUnreadAgentMessage(" + indexNumOfUnreadAgentMessage + ")");
        }
    }

    @Override
    public void onItemMoved(int fromPos, int toPos) {
        this.notifyItemMoved(fromPos, toPos);
    }

    @Override
    public void onNewAgentMessageReceived(int position, FullMessageRow fullMessageRow) {
        int updatedLastUIItemPosition = this.getLastVisibleItemPosition();
        this.notifyItemInserted(position);
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        Context context = recyclerView.getContext();
        recyclerView.invalidateItemDecorations();
        LPLog.INSTANCE.d(TAG, "new Agent Message at position: " + position + " lastUIItemPosition = " + updatedLastUIItemPosition + " getItemCount() = " + this.getItemCount());
        if (updatedLastUIItemPosition + 1 == position) {
            LPLog.INSTANCE.d(TAG, "onNewAgentMessageReceived: scrollToPosition: " + position);
            if (this.pendingScrollToFirstUnreadMessage) {
                this.scrollToUnreadPosition();
                this.pendingScrollToFirstUnreadMessage = false;
            } else if (!this.fromPushNotification) {
                recyclerView.scrollToPosition(position);
            }
            this.setPushNotificationClickedFalse();
        }
        if (position == this.getItemCount() - 1) {
            MessagingChatMessage.MessageType type = fullMessageRow.getMessagingChatMessage().getMessageType();
            int prefixResource = MessagingChatMessage.MessageType.isBot((MessagingChatMessage.MessageType)type) ? R.string.lp_accessibility_new_bot_message : R.string.lp_accessibility_new_agent_message;
            this.announceAccessibilityMessage(context.getString(prefixResource), fullMessageRow);
            if (this.permissionGranted) {
                Vibrator v = (Vibrator)context.getSystemService("vibrator");
                v.vibrate(400L);
            }
        }
    }

    @Override
    public void onQuickRepliesMessageReceived() {
        MessagingChatMessage messagingChatMessage = this.messagesAsListLoader.getLastMessage().getMessagingChatMessage();
        String message = messagingChatMessage.getMessage();
        try {
            JSONObject jsonObject = new JSONObject(message);
            QuickRepliesElement quickRepliesElement = new QuickRepliesElement(jsonObject);
            List elements = quickRepliesElement.getElementList();
            if (elements.isEmpty()) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000043, "Failed to parse JSON, List is empty");
            } else {
                ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
                if (recyclerView != null) {
                    String qrContentDescription = SCUtils.composeQrContentDescription((Context)recyclerView.getContext(), (QuickRepliesElement)quickRepliesElement);
                    AccessibilityAnnouncer announcer = recyclerView.getAnnouncer();
                    announcer.announce(qrContentDescription);
                }
            }
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000043, "Failed to parse JSON", (Throwable)e);
        }
    }

    @Override
    public void onNewUnreadMessages(int indexNumOfUnreadAgentMessage, int numOfUnreadMessages) {
        LPLog.INSTANCE.d(TAG, "onNewUnreadMessages, indexNumOfUnreadAgentMessage = " + indexNumOfUnreadAgentMessage + ", numOfUnreadMessages = " + numOfUnreadMessages + ", lastVisibleItem = " + this.getLastVisibleItemPosition());
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (this.pendingScrollToBottom) {
            this.scrollToBottom();
            this.pendingScrollToBottom = false;
        } else if (this.pendingScrollToFirstUnreadMessage) {
            this.scrollToUnreadPosition();
            this.pendingScrollToFirstUnreadMessage = false;
        } else if (!this.fromPushNotification && (!this.messagesAsListLoader.hasVisibleItems() || numOfUnreadMessages == 1 && this.messagesAsListLoader.isItemAtPositionVisible(indexNumOfUnreadAgentMessage)) && recyclerView != null) {
            recyclerView.scrollToPosition(indexNumOfUnreadAgentMessage + numOfUnreadMessages);
        }
        this.setPushNotificationClickedFalse();
        this.notifyItemInserted(indexNumOfUnreadAgentMessage);
        if (recyclerView != null) {
            recyclerView.invalidateItemDecorations();
        }
    }

    @Override
    public void onNewMessagesLoaded(int position, int itemCount, int unreadMessages) {
        int updatedLastUIItemPosition = this.getLastVisibleItemPosition();
        LPLog.INSTANCE.d(TAG, "onNewMessagesLoaded, start: " + position + " lastUIItemPosition: " + updatedLastUIItemPosition + " count: " + itemCount + " unread messages: " + unreadMessages);
        this.notifyItemRangeInserted(position, itemCount);
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        recyclerView.invalidateItemDecorations();
        LPLog.INSTANCE.d(TAG, "onNewMessagesLoaded: updatedLastUIItemPosition: " + updatedLastUIItemPosition);
        if (updatedLastUIItemPosition != -1) {
            if (Math.abs(updatedLastUIItemPosition - position) <= 2) {
                if (unreadMessages > 0) {
                    if (!this.pendingScrollToBottom && !this.keepLastPositionOnNewMessage) {
                        ((StickyHeadersLinearLayoutManager)recyclerView.getLayoutManager()).scrollToPositionWithOffset(position, 0);
                    }
                } else {
                    LPLog.INSTANCE.d(TAG, "onNewMessagesLoaded: scrollToPosition position + itemCount -1 = " + (position + itemCount - 1));
                    recyclerView.scrollToPosition(position + itemCount - 1);
                }
            }
            this.shouldFocusOnlastMessage = true;
            this.shouldFocusOnUnreadBanner = true;
        } else if (this.isFirstScrollPerformed) {
            recyclerView.scrollToPosition(this.messagesAsListLoader.size() - 1);
        }
        this.keepLastPositionOnNewMessage = false;
        for (int i = position; i < position + itemCount; ++i) {
            FullMessageRow row = this.messagesAsListLoader.getItem(position);
            if (row == null || row.getMessagingChatMessage() == null || row.getMessagingChatMessage().getMessageType() != MessagingChatMessage.MessageType.CONTROLLER_SYSTEM || row.getMessagingChatMessage().getServerSequence() == -7) continue;
            this.announceAccessibilityMessage(recyclerView.getResources().getString(R.string.lp_accessibility_new_system_message), this.messagesAsListLoader.getItem(position));
        }
    }

    @Override
    public void onHistoryLoaded(int position, int numItems, boolean firstLoad) {
        LPLog.INSTANCE.d(TAG, "onHistoryLoaded, position: " + position + " numItems: " + numItems + " firstLoad  = " + firstLoad);
        this.notifyItemRangeInserted(position, numItems);
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView != null) {
            recyclerView.invalidateItemDecorations();
        }
        if (firstLoad) {
            if (this.conversationViewCallback != null) {
                this.conversationViewCallback.restoreRecyclerViewInstanceState();
            }
            if (!this.isFirstScrollPerformed) {
                this.performScroll();
            }
        }
    }

    @Override
    public void onNewUserMessageAdded(int position) {
        int lastItem = this.messagesAsListLoader.size() - 1;
        LPLog.INSTANCE.d(TAG, "onNewUserMessageAdded, at position: " + position + " scrolling to the end position: " + lastItem);
        this.notifyItemInserted(position);
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        recyclerView.invalidateItemDecorations();
        LPLog.INSTANCE.d(TAG, "onNewUserMessageAdded: scrollToPosition: " + lastItem);
        if (position > lastItem / 2) {
            recyclerView.scrollBy(0, Integer.MAX_VALUE);
        }
        recyclerView.invalidateItemDecorations();
    }

    @Override
    public void onNewSystemMessageAdded(int position, FullMessageRow fullMessageRow) {
        LPLog.INSTANCE.d(TAG, "onNewSystemMessageAdded at position " + position);
        this.notifyItemInserted(position);
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        recyclerView.invalidateItemDecorations();
        MessagingChatMessage message = fullMessageRow.getMessagingChatMessage();
        MessagingChatMessage.MessageType messageType = message.getMessageType();
        if (messageType == MessagingChatMessage.MessageType.SYSTEM_RESOLVED || messageType == MessagingChatMessage.MessageType.SYSTEM_DIALOG_RESOLVED) {
            long systemMessageTimeStamp;
            boolean scrollToBottomAfterResolveConversation = Configuration.getBoolean((int)R.bool.lp_scroll_to_bottom_after_resolve_conversation);
            if (this.mHideResolveSeparator && this.mHideResolveMessage) {
                this.messagesAsListLoader.removeItemFromDataSet(position, "onNewSystemMessageAdded");
                this.notifyItemRemoved(position);
                recyclerView.invalidateItemDecorations();
                if (scrollToBottomAfterResolveConversation) {
                    this.scrollToBottom();
                }
            } else if (message.getServerSequence() == -8 && this.mHideAutoCloseResolveSeparator) {
                this.messagesAsListLoader.removeItemFromDataSet(position, "onNewSystemMessageAdded");
                this.notifyItemRemoved(position);
                recyclerView.invalidateItemDecorations();
            } else {
                LPLog.INSTANCE.d(TAG, "onNewSystemMessageAdded, resolve message. scrolling to position: " + position);
                int updatedLastUIItemPosition = this.getLastVisibleItemPosition();
                if (position > updatedLastUIItemPosition) {
                    if (position == this.messagesAsListLoader.size() - 1) {
                        recyclerView.scrollBy(0, Integer.MAX_VALUE);
                    } else {
                        recyclerView.scrollToPosition(position);
                        LPLog.INSTANCE.d(TAG, "onNewSystemMessageAdded: scrollToPosition: " + position);
                    }
                }
            }
            if ((systemMessageTimeStamp = fullMessageRow.getMessagingChatMessage().getTimeStamp()) > this.mLastKnownSystemMessageTimestamp && this.messagesAsListLoader.addWelcomeMessage()) {
                recyclerView.smoothScrollToPosition(this.messagesAsListLoader.size());
                this.mLastKnownSystemMessageTimestamp = systemMessageTimeStamp;
            }
        } else if (messageType == MessagingChatMessage.MessageType.SYSTEM_MASKED) {
            LPLog.INSTANCE.d(TAG, "onNewSystemMessageAdded, system masked message. scrolling to position: " + position);
            recyclerView.scrollToPosition(position);
        } else if (messageType == MessagingChatMessage.MessageType.CONTROLLER_SYSTEM) {
            int updatedLastUIItemPosition = this.getLastVisibleItemPosition();
            LPLog.INSTANCE.d(TAG, "new Auto Message at position: " + position + " lastUIItemPosition = " + updatedLastUIItemPosition + " getItemCount() = " + this.getItemCount());
            if (updatedLastUIItemPosition + 1 == position) {
                LPLog.INSTANCE.d(TAG, "onNewSystemMessageAdded: scrollToPosition: " + position);
                recyclerView.scrollToPosition(position);
            }
        }
        if (message.getServerSequence() != -7) {
            this.announceAccessibilityMessage(recyclerView.getResources().getString(R.string.lp_accessibility_new_system_message), fullMessageRow);
        }
    }

    @Override
    public void onMessageUpdated(int position, Bundle changes) {
        LPLog.INSTANCE.d(TAG, "onMessageUpdated position: " + position + " changes = " + changes);
        if (changes == null || changes.isEmpty()) {
            this.notifyItemChanged(position);
        } else {
            this.notifyItemChanged(position, changes);
        }
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView != null) {
            recyclerView.invalidateItemDecorations();
        }
    }

    @Override
    public void onAnnounceDialogResolvedMessage(FullMessageRow fullMessageRow) {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView != null) {
            this.announceAccessibilityMessage(recyclerView.getResources().getString(R.string.lp_accessibility_new_system_message), fullMessageRow);
        }
    }

    @Override
    public void onClearAllMessages(int posStart, int itemCount) {
        LPLog.INSTANCE.d(TAG, "onClearAllMessages itemCount: " + itemCount);
        this.notifyItemRangeRemoved(posStart, itemCount);
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        IScrollDownIndicator indicator = (IScrollDownIndicator)this.mScrollDownIndicatorRef.get();
        if (recyclerView != null) {
            recyclerView.invalidateItemDecorations();
        }
        if (indicator != null) {
            indicator.resetAndHide();
        }
    }

    @Override
    public void onItemAdded(int position) {
        LPLog.INSTANCE.d(TAG, "onItemAdded position: " + position);
        this.notifyItemInserted(position);
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView != null) {
            recyclerView.invalidateItemDecorations();
        }
    }

    @Override
    public void onItemRemoved(int position) {
        LPLog.INSTANCE.d(TAG, "onItemRemoved position: " + position);
        this.notifyItemRemoved(position);
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView != null) {
            recyclerView.invalidateItemDecorations();
        }
    }

    public int getItemViewType(int position) {
        MessagingChatMessage message = this.messagesAsListLoader.getItem(position).getMessagingChatMessage();
        MessagingChatMessage.MessageType type = message.getMessageType();
        if (type == MessagingChatMessage.MessageType.SYSTEM_RESOLVED) {
            return message.getServerSequence();
        }
        return type.ordinal();
    }

    @NonNull
    public BaseViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Object holder = null;
        LayoutInflater layoutInflater = LayoutInflater.from((Context)parent.getContext());
        MessagingChatMessage.MessageType messageType = viewType > 0 ? MessagingChatMessage.MessageType.values()[viewType] : MessagingChatMessage.MessageType.SYSTEM_RESOLVED;
        switch (messageType) {
            case LOADING: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_load_more, parent, false);
                holder = new AmsLoadMoreViewHolder(v);
                break;
            }
            case SYSTEM_DIALOG_RESOLVED: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_system_dialog_resolved, parent, false);
                holder = new AmsSystemDialogResolvedViewHolder(v);
                break;
            }
            case SYSTEM_RESOLVED: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_system_resolved, parent, false);
                holder = new AmsSystemResolvedViewHolder(v);
                break;
            }
            case SYSTEM_MASKED: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_system, parent, false);
                holder = new AmsSystemMaskedViewHolder(v);
                break;
            }
            case BRAND: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_brand, parent, false);
                holder = new AmsBrandMsgViewHolder(v, this.mMessagingContextualActionController);
                break;
            }
            case AGENT: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_agent, parent, false);
                holder = new AmsAgentViewHolder(v);
                break;
            }
            case AGENT_MARKDOWN_HYPERLINK: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_agent, parent, false);
                holder = new AmsAgentMarkdownHyperlinkViewHolder(v);
                break;
            }
            case AGENT_IS_TYPING_INDICATOR: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_agent_is_typing, parent, false);
                holder = new AmsAgentTypingViewHolder(v);
                break;
            }
            case AGENT_IMAGE: 
            case AGENT_DOCUMENT: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_image_bubble_agent, parent, false);
                holder = new AmsAgentFileViewHolder(v, messageType);
                break;
            }
            case AGENT_URL: {
                boolean isBigPic = Configuration.getBoolean((int)R.bool.link_preview_use_big_picture);
                View v = isBigPic ? layoutInflater.inflate(R.layout.lpmessaging_ui_chat_url_bubble_agent, parent, false) : layoutInflater.inflate(R.layout.lpmessaging_ui_chat_url_small_bubble_agent, parent, false);
                holder = new AmsAgentURLViewHolder(v, this.mMessagingContextualActionController);
                break;
            }
            case AGENT_FORM: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_form_invitation_bubble_agent, parent, false);
                holder = new AmsAgentFormInvitationViewHolder(v, this.mBrandId);
                break;
            }
            case BOT: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_bot, parent, false);
                holder = new AmsBotViewHolder(v);
                break;
            }
            case BOT_IMAGE: 
            case BOT_DOCUMENT: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_image_bubble_bot, parent, false);
                holder = new AmsBotFileViewHolder(v, messageType);
                break;
            }
            case BOT_URL: {
                boolean isBigPic = Configuration.getBoolean((int)R.bool.link_preview_use_big_picture);
                View v = isBigPic ? layoutInflater.inflate(R.layout.lpmessaging_ui_chat_url_bubble_bot, parent, false) : layoutInflater.inflate(R.layout.lpmessaging_ui_chat_url_small_bubble_bot, parent, false);
                holder = new AmsBotURLViewHolder(v, this.mMessagingContextualActionController);
                break;
            }
            case BOT_MARKDOWN_HYPERLINK: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_bot, parent, false);
                holder = new AmsBotMarkdownHyperlinkViewHolder(v);
                break;
            }
            case CONSUMER: 
            case CONSUMER_MASKED: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_consumer, parent, false);
                holder = new AmsConsumerViewHolder(v, messageType);
                break;
            }
            case CONSUMER_IMAGE: 
            case CONSUMER_DOCUMENT: 
            case CONSUMER_IMAGE_MASKED: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_image_bubble_consumer, parent, false);
                holder = new AmsConsumerFileViewHolder(v, messageType);
                break;
            }
            case CONSUMER_URL_MASKED: 
            case CONSUMER_URL: {
                boolean isBigPic = Configuration.getBoolean((int)R.bool.link_preview_use_big_picture);
                View v = isBigPic ? layoutInflater.inflate(R.layout.lpmessaging_ui_chat_url_bubble_consumer, parent, false) : layoutInflater.inflate(R.layout.lpmessaging_ui_chat_url_small_bubble_consumer, parent, false);
                holder = new AmsConsumerURLViewHolder(v, messageType, this.mMessagingContextualActionController);
                break;
            }
            case CONSUMER_VOICE: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_voice_bubble_consumer, parent, false);
                holder = new AmsConsumerVoiceViewHolder(v, MessagingChatMessage.MessageType.CONSUMER_VOICE, this.mBrandId);
                break;
            }
            case CONSUMER_FORM: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_consumer, parent, false);
                holder = new AmsConsumerFormSubmissionViewHolder(v, messageType);
                break;
            }
            case UNREAD_INDICATOR: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_unread_indicator, parent, false);
                holder = new UiUnreadIndicatorViewHolder(v);
                break;
            }
            case AGENT_STRUCTURED_CONTENT: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_structured_content_agent, parent, false);
                holder = new AmsAgentStructuredContentViewHolder(v, this.mBrandId);
                break;
            }
            case AGENT_QUICK_REPLIES: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_structured_content_agent, parent, false);
                holder = new AmsAgentStructuredContentViewHolder(v, this.mBrandId);
                break;
            }
            case BOT_STRUCTURED_CONTENT: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_structured_content_bot, parent, false);
                holder = new AmsBotStructuredContentViewHolder(v, this.mBrandId);
                break;
            }
            case CONTROLLER_SYSTEM: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_controller_system, parent, false);
                holder = new AmsControllerSystemViewHolder(v);
                break;
            }
            case COBROWSE: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_cobrowse, parent, false);
                holder = new AmsCoBrowseViewHolder(v);
                break;
            }
            case DATE_HEADER: {
                View v = layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_date_header, parent, false);
                holder = new DateHeaderViewHolder(v);
            }
        }
        return holder;
    }

    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position, @NonNull List<Object> payloads) {
        if (!payloads.isEmpty()) {
            for (Object payload : payloads) {
                FullMessageRow row = this.messagesAsListLoader.getItem(position);
                MessagingChatMessage mMessagingChatMessage = row.getMessagingChatMessage();
                if (PAYLOAD_UPDATE_TIMESTAMP.equals(payload)) {
                    holder.onUpdateTimestampText();
                    holder.updateContentDescription();
                    continue;
                }
                if (payload instanceof Bundle) {
                    Bundle bundle = (Bundle)payload;
                    holder.applyChanges(bundle, (Message)mMessagingChatMessage);
                    continue;
                }
                if (!PAYLOAD_SC_PUBLISH_ACTION.equals(payload) || !(holder instanceof ParticipantSCViewHolder)) continue;
                ParticipantSCViewHolder sch = (ParticipantSCViewHolder)holder;
                OnSCActionClickListener globalListener = this.getSCActionClickListener(row.getMessagingChatMessage(), false, -5 == mMessagingChatMessage.getServerSequence(), false);
                sch.setParticipantNickName(row.getAgentNickName());
                sch.loadContent(row, globalListener, null, this.isLastItem(position) && this.isMessageDialogActive(mMessagingChatMessage.getDialogId()), !ContentBlockingUtils.isBlockSCEnabledSiteSettings());
            }
        } else {
            super.onBindViewHolder((RecyclerView.ViewHolder)holder, position, payloads);
        }
    }

    public boolean isStickyHeader(int position) {
        FullMessageRow row = this.messagesAsListLoader.getItem(position);
        if (row == null) {
            return false;
        }
        MessagingChatMessage message = row.getMessagingChatMessage();
        return message.getMessageType() == MessagingChatMessage.MessageType.DATE_HEADER;
    }

    public void decorateHeaderView(@Nullable View stickyHeader, int position) {
        if (stickyHeader != null) {
            ViewCompat.setElevation((View)stickyHeader, (float)10.0f);
            this.changeAccessibilityMode(stickyHeader, 2);
        }
    }

    public void removeHeaderViewDecoration(@Nullable View stickyHeader) {
        if (stickyHeader != null) {
            ViewCompat.setElevation((View)stickyHeader, (float)0.0f);
            this.changeAccessibilityMode(stickyHeader, 1);
        }
    }

    private void savePositionInTag(BaseViewHolder holder) {
        holder.itemView.setTag(R.id.lp_messages_as_list_view_holder_position_key, (Object)holder.getAbsoluteAdapterPosition());
    }

    public void onBindViewHolder(@NonNull BaseViewHolder holder, int position) {
        this.savePositionInTag(holder);
        FullMessageRow currentMessagingChatMessage = this.messagesAsListLoader.getItem(position);
        if (position == this.messagesAsListLoader.size() - 1) {
            this.messagesAsListLoader.setScrollDownIndicatorVisible(false);
            IScrollDownIndicator indicator = (IScrollDownIndicator)this.mScrollDownIndicatorRef.get();
            if (indicator != null) {
                indicator.resetAndHide();
            }
        }
        if (currentMessagingChatMessage == null) {
            LPLog.INSTANCE.d(TAG, "onBindViewHolder position: " + position + " message is null, skipping binding");
            return;
        }
        MessagingChatMessage mMessagingChatMessage = currentMessagingChatMessage.getMessagingChatMessage();
        String message = mMessagingChatMessage.getMessage();
        MessagingChatMessage.MessageType messageType = mMessagingChatMessage.getMessageType();
        long timeStamp = -1L;
        switch (messageType) {
            case LOADING: {
                AmsLoadMoreViewHolder loadingViewHolder = (AmsLoadMoreViewHolder)holder;
                loadingViewHolder.setMessageTextView(message);
                break;
            }
            case SYSTEM_DIALOG_RESOLVED: {
                LPLog.INSTANCE.d(TAG, "onBindViewHolder position: " + position + " systemDialogResolved");
                AmsSystemDialogResolvedViewHolder dialogResolvedViewHolder = (AmsSystemDialogResolvedViewHolder)holder;
                dialogResolvedViewHolder.hideSystemMessageView(this.mHideResolveSeparator);
                dialogResolvedViewHolder.setMessageTextView(message);
                dialogResolvedViewHolder.updateContentDescription();
                break;
            }
            case SYSTEM_RESOLVED: {
                AmsSystemResolvedViewHolder systemResolvedViewHolder = (AmsSystemResolvedViewHolder)holder;
                systemResolvedViewHolder.setMessageTextView(message);
                systemResolvedViewHolder.updateContentDescription();
                if (mMessagingChatMessage.getServerSequence() == -8) {
                    systemResolvedViewHolder.hideSystemMessageView(true, this.mHideAutoCloseResolveSeparator);
                    break;
                }
                systemResolvedViewHolder.hideSystemMessageView(this.mHideResolveMessage, this.mHideResolveSeparator);
                break;
            }
            case SYSTEM_MASKED: {
                AmsSystemMaskedViewHolder systemMaskedViewHolder = (AmsSystemMaskedViewHolder)holder;
                systemMaskedViewHolder.setMessageTextView(message);
                systemMaskedViewHolder.updateContentDescription();
                break;
            }
            case BRAND: {
                AmsBrandMsgViewHolder brandViewHolder = (AmsBrandMsgViewHolder)holder;
                brandViewHolder.setOnLinkMovementListener(this);
                brandViewHolder.setMessageText(message);
                timeStamp = mMessagingChatMessage.getTimeStamp();
                brandViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
                brandViewHolder.updateContentDescription();
                break;
            }
            case AGENT: {
                timeStamp = mMessagingChatMessage.getTimeStamp();
                AmsAgentViewHolder agentViewHolder = (AmsAgentViewHolder)holder;
                agentViewHolder.setOnLinkMovementListener(this);
                ParticipantViewHolderUtils.setData(agentViewHolder, currentMessagingChatMessage);
                agentViewHolder.setContextualActionBehavior(this.mMessagingContextualActionController);
                break;
            }
            case AGENT_MARKDOWN_HYPERLINK: {
                timeStamp = mMessagingChatMessage.getTimeStamp();
                AmsAgentMarkdownHyperlinkViewHolder amsAgentMarkdownHyperlinkViewHolder = (AmsAgentMarkdownHyperlinkViewHolder)holder;
                amsAgentMarkdownHyperlinkViewHolder.setOnLinkMovementListener(this);
                amsAgentMarkdownHyperlinkViewHolder.setContextualActionBehavior(this.mMessagingContextualActionController);
                ParticipantViewHolderUtils.setData(amsAgentMarkdownHyperlinkViewHolder, currentMessagingChatMessage);
                break;
            }
            case AGENT_IS_TYPING_INDICATOR: {
                AmsAgentTypingViewHolder agentViewHolder = (AmsAgentTypingViewHolder)holder;
                agentViewHolder.showTypingAnimation();
                agentViewHolder.setParticipantAvatar(currentMessagingChatMessage.getAgentAvatar());
                String agentIsTyping = agentViewHolder.itemView.getContext().getString(R.string.lp_accessibility_agent_is_typing);
                agentViewHolder.setContentDescription(agentIsTyping);
                break;
            }
            case AGENT_URL: {
                timeStamp = mMessagingChatMessage.getTimeStamp();
                AmsAgentURLViewHolder agentUrlViewHolder = (AmsAgentURLViewHolder)holder;
                agentUrlViewHolder.setOnLinkMovementListener(this);
                agentUrlViewHolder.setContextualActionBehavior(this.mMessagingContextualActionController);
                ParticipantViewHolderUtils.setData(agentUrlViewHolder, currentMessagingChatMessage);
                break;
            }
            case AGENT_FORM: {
                AmsAgentFormInvitationViewHolder agentFormInvitationViewHolder = (AmsAgentFormInvitationViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                agentFormInvitationViewHolder.setOnLinkMovementListener(this);
                agentFormInvitationViewHolder.setParticipantAvatar(currentMessagingChatMessage.getAgentAvatar());
                agentFormInvitationViewHolder.setParticipantNickName(currentMessagingChatMessage.getAgentNickName());
                agentFormInvitationViewHolder.setMessageState(mMessagingChatMessage.getMessageState());
                agentFormInvitationViewHolder.setViewAppearanceByState(mMessagingChatMessage.getMessageState());
                this.setAgentMessageText(mMessagingChatMessage, message, agentFormInvitationViewHolder);
                break;
            }
            case BOT: {
                timeStamp = mMessagingChatMessage.getTimeStamp();
                AmsBotViewHolder botViewHolder = (AmsBotViewHolder)holder;
                botViewHolder.setOnLinkMovementListener(this);
                botViewHolder.setContextualActionBehavior(this.mMessagingContextualActionController);
                ParticipantViewHolderUtils.setData(botViewHolder, currentMessagingChatMessage);
                break;
            }
            case BOT_URL: {
                timeStamp = mMessagingChatMessage.getTimeStamp();
                AmsBotURLViewHolder botURLViewHolder = (AmsBotURLViewHolder)holder;
                botURLViewHolder.setOnLinkMovementListener(this);
                botURLViewHolder.setContextualActionBehavior(this.mMessagingContextualActionController);
                ParticipantViewHolderUtils.setData(botURLViewHolder, currentMessagingChatMessage);
                break;
            }
            case BOT_MARKDOWN_HYPERLINK: {
                timeStamp = mMessagingChatMessage.getTimeStamp();
                AmsBotMarkdownHyperlinkViewHolder amsBotMarkdownHyperlinkViewHolder = (AmsBotMarkdownHyperlinkViewHolder)holder;
                amsBotMarkdownHyperlinkViewHolder.setOnLinkMovementListener(this);
                amsBotMarkdownHyperlinkViewHolder.setContextualActionBehavior(this.mMessagingContextualActionController);
                ParticipantViewHolderUtils.setData(amsBotMarkdownHyperlinkViewHolder, currentMessagingChatMessage);
                break;
            }
            case CONSUMER: 
            case CONSUMER_MASKED: {
                AmsConsumerViewHolder consumerViewHolder = (AmsConsumerViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                this.setConsumerMessageText(mMessagingChatMessage, message, consumerViewHolder);
                break;
            }
            case CONSUMER_IMAGE: 
            case CONSUMER_DOCUMENT: 
            case CONSUMER_IMAGE_MASKED: {
                AmsConsumerFileViewHolder consumerFileViewHolder = (AmsConsumerFileViewHolder)holder;
                this.setConsumerMessageText(mMessagingChatMessage, message, consumerFileViewHolder);
                timeStamp = mMessagingChatMessage.getTimeStamp();
                FileMessage fileMessage = currentMessagingChatMessage.getFileMessage();
                if (fileMessage != null) {
                    String previewUri = fileMessage.getPreview();
                    String fullImagePath = fileMessage.getLocalUrl();
                    FilesTable.LoadStatus loadStatus = fileMessage.getLoadStatus();
                    String fileType = fileMessage.getFileType();
                    consumerFileViewHolder.setMessageContent(fullImagePath, previewUri, loadStatus, fileType);
                    consumerFileViewHolder.getAmsDownloadableFileViewProcessor().setFileRowId(fileMessage.getFileRowId());
                } else if (messageType == MessagingChatMessage.MessageType.CONSUMER_DOCUMENT) {
                    String mimeType = currentMessagingChatMessage.getMessagingChatMessage().getContentType();
                    FileSharingType fileSharingType = FileSharingType.getFileTypeFromMimeType((String)mimeType);
                    consumerFileViewHolder.updateContentDescriptionForDocument(fileSharingType);
                    consumerFileViewHolder.setFileIcon(fileSharingType);
                } else {
                    consumerFileViewHolder.updateContentDescriptionForImage();
                }
                consumerFileViewHolder.setImageLongClickListener(v -> {
                    FileMessage onClickFileMessage = currentMessagingChatMessage.getFileMessage();
                    return consumerFileViewHolder.setContextualBehaviorOnLongClick(this.mMessagingContextualActionController.getOnLongClickListener((int)currentMessagingChatMessage.getMessagingChatMessage().getTimeStamp(), (BaseViewHolder)consumerFileViewHolder, onClickFileMessage));
                });
                consumerFileViewHolder.setImageClickListener(v -> {
                    if (this.conversationViewCallback != null) {
                        final MessagingChatMessage currentChatMessage = currentMessagingChatMessage.getMessagingChatMessage();
                        if (currentChatMessage == null) {
                            return;
                        }
                        final String dialogId = currentChatMessage.getDialogId();
                        final FileMessage mostUpdatedFileMessage = currentMessagingChatMessage.getFileMessage();
                        if (this.mMessagingContextualActionController.isSelectable()) {
                            consumerFileViewHolder.setContextualBehaviorOnClick(this.mMessagingContextualActionController.getOnClickListener((int)mMessagingChatMessage.getTimeStamp(), (BaseViewHolder)consumerFileViewHolder, mostUpdatedFileMessage));
                            return;
                        }
                        if (v.getId() != R.id.lpui_message_image) {
                            return;
                        }
                        if (mostUpdatedFileMessage == null) {
                            LPLog.INSTANCE.d(TAG, "file message is null, cannot download or open file");
                            return;
                        }
                        if (!MessagingFactory.getInstance().getController().mConnectionController.isSocketReady(this.mBrandId) && TextUtils.isEmpty((CharSequence)mostUpdatedFileMessage.getLocalUrl())) {
                            consumerFileViewHolder.getAmsDownloadableFileViewProcessor().startFailedAnimation();
                        } else {
                            MessagingFactory.getInstance().getController().amsDialogs.getDialogByIdAsync(dialogId, (ICallback)new ICallback<Dialog, Exception>(){

                                public void onSuccess(Dialog dialog) {
                                    this.handleOnClick(dialog.getConversationId());
                                }

                                public void onError(Exception exception) {
                                    this.handleOnClick(dialogId);
                                }

                                private void handleOnClick(String conversationId) {
                                    try {
                                        String fileExtension = mostUpdatedFileMessage.getFileType().toLowerCase();
                                        MessagesAsListAdapter.this.conversationViewCallback.onFileClicked(FileSharingType.getFileTypeFromExtension((String)fileExtension), mostUpdatedFileMessage.getLocalUrl(), mostUpdatedFileMessage.getSwiftPath(), currentChatMessage.getLocalId(), mostUpdatedFileMessage.getFileRowId(), conversationId);
                                    }
                                    catch (Exception e) {
                                        LPLog.INSTANCE.e(MessagesAsListAdapter.TAG, ErrorCode.ERR_000000F2, "Failed to perform file action.", (Throwable)e);
                                    }
                                }
                            });
                        }
                    }
                });
                break;
            }
            case AGENT_IMAGE: 
            case AGENT_DOCUMENT: {
                timeStamp = mMessagingChatMessage.getTimeStamp();
                AmsAgentFileViewHolder agentFileViewHolder = (AmsAgentFileViewHolder)holder;
                agentFileViewHolder.setOnLinkMovementListener(this);
                ParticipantFileViewHolderUtils.setData(agentFileViewHolder, currentMessagingChatMessage);
                ParticipantFileViewHolderUtils.registerListeners(agentFileViewHolder, this.mBrandId, currentMessagingChatMessage, this.mMessagingContextualActionController, this.conversationViewCallback);
                break;
            }
            case BOT_IMAGE: 
            case BOT_DOCUMENT: {
                timeStamp = mMessagingChatMessage.getTimeStamp();
                AmsBotFileViewHolder botFileViewHolder = (AmsBotFileViewHolder)holder;
                botFileViewHolder.setOnLinkMovementListener(this);
                ParticipantFileViewHolderUtils.setData(botFileViewHolder, currentMessagingChatMessage);
                ParticipantFileViewHolderUtils.registerListeners(botFileViewHolder, this.mBrandId, currentMessagingChatMessage, this.mMessagingContextualActionController, this.conversationViewCallback);
                break;
            }
            case CONSUMER_VOICE: {
                AmsConsumerVoiceViewHolder consumerVoiceViewHolder = (AmsConsumerVoiceViewHolder)holder;
                this.setConsumerMessageText(mMessagingChatMessage, message, consumerVoiceViewHolder);
                FileMessage voiceMessage = currentMessagingChatMessage.getFileMessage();
                if (voiceMessage != null) {
                    String voiceFilePath = voiceMessage.getLocalUrl();
                    FilesTable.LoadStatus loadStatus = voiceMessage.getLoadStatus();
                    consumerVoiceViewHolder.setVoiceProperties(voiceFilePath, loadStatus, currentMessagingChatMessage);
                    LPAudioUtils audioUtils = MessagingFactory.getInstance().getController().getAudioUtils();
                    if (audioUtils.isPlaying(voiceFilePath)) {
                        int playingLocation = audioUtils.getCurrentPlayingLocation();
                        int playingDuration = audioUtils.getCurrentPlayingDuration();
                        consumerVoiceViewHolder.setCurrentPlaying(voiceFilePath, playingLocation, playingDuration);
                    }
                }
                holder.updateContentDescription();
                break;
            }
            case CONSUMER_URL_MASKED: 
            case CONSUMER_URL: {
                AmsConsumerURLViewHolder consumerURLViewHolder = (AmsConsumerURLViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                this.setConsumerMessageText(mMessagingChatMessage, message, consumerURLViewHolder);
                break;
            }
            case CONSUMER_FORM: {
                AmsConsumerFormSubmissionViewHolder consumerFormSubmissionViewHolder = (AmsConsumerFormSubmissionViewHolder)holder;
                timeStamp = mMessagingChatMessage.getTimeStamp();
                this.setConsumerMessageText(mMessagingChatMessage, message, consumerFormSubmissionViewHolder);
                break;
            }
            case UNREAD_INDICATOR: {
                UiUnreadIndicatorViewHolder amsUnreadIndicatorViewHolder = (UiUnreadIndicatorViewHolder)holder;
                amsUnreadIndicatorViewHolder.setMessageTextView(message);
                amsUnreadIndicatorViewHolder.updateContentDescription();
                break;
            }
            case AGENT_STRUCTURED_CONTENT: {
                AmsAgentStructuredContentViewHolder amsAgentStructuredContentViewHolder = (AmsAgentStructuredContentViewHolder)holder;
                amsAgentStructuredContentViewHolder.setOnLinkMovementListener(this);
                OnSCActionClickListener globalListener = this.getSCActionClickListener(currentMessagingChatMessage.getMessagingChatMessage(), false, -5 == mMessagingChatMessage.getServerSequence(), false);
                amsAgentStructuredContentViewHolder.setParticipantNickName(currentMessagingChatMessage.getAgentNickName());
                amsAgentStructuredContentViewHolder.loadContent(currentMessagingChatMessage, globalListener, null, this.isLastItem(position) && this.isMessageDialogActive(mMessagingChatMessage.getDialogId()), !ContentBlockingUtils.isBlockSCEnabledSiteSettings());
                if (-5 == mMessagingChatMessage.getServerSequence()) {
                    amsAgentStructuredContentViewHolder.setParticipantAvatarAsBrand();
                } else {
                    amsAgentStructuredContentViewHolder.setParticipantAvatar(currentMessagingChatMessage.getAgentAvatar());
                }
                amsAgentStructuredContentViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
                amsAgentStructuredContentViewHolder.updateContentDescription();
                this.setAgentMessageText(mMessagingChatMessage, null, amsAgentStructuredContentViewHolder);
                break;
            }
            case BOT_STRUCTURED_CONTENT: {
                AmsBotStructuredContentViewHolder botSCHolder = (AmsBotStructuredContentViewHolder)holder;
                OnSCActionClickListener globalListener = this.getSCActionClickListener(currentMessagingChatMessage.getMessagingChatMessage(), false, -5 == mMessagingChatMessage.getServerSequence(), false);
                botSCHolder.setParticipantNickName(currentMessagingChatMessage.getAgentNickName());
                botSCHolder.setParticipantAvatar(currentMessagingChatMessage.getAgentAvatar());
                botSCHolder.loadContent(currentMessagingChatMessage, globalListener, null, this.isLastItem(position) && this.isMessageDialogActive(mMessagingChatMessage.getDialogId()), !ContentBlockingUtils.isBlockSCEnabledSiteSettings());
                botSCHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
                botSCHolder.updateContentDescription();
                botSCHolder.setContextualActionBehavior(this.mMessagingContextualActionController);
                break;
            }
            case AGENT_QUICK_REPLIES: {
                AmsAgentStructuredContentViewHolder amsAgentStructuredContentViewHolder = (AmsAgentStructuredContentViewHolder)holder;
                FullMessageRow associatedMessage = this.messagesAsListLoader.getItem(holder.getBindingAdapterPosition() - 1);
                if (associatedMessage == null) {
                    associatedMessage = currentMessagingChatMessage;
                }
                OnSCActionClickListener globalListener = this.getSCActionClickListener(associatedMessage.getMessagingChatMessage(), associatedMessage.getMessagingChatMessage().getServerSequence() == -4, -5 == associatedMessage.getMessagingChatMessage().getServerSequence(), true);
                QRActionClickListener quickRepliesCloseAction = () -> {
                    this.shouldFocusOnlastMessage = true;
                    this.messagesAsListLoader.hideShowQuickRepliesFlagInSharedPreference();
                };
                amsAgentStructuredContentViewHolder.loadContent(currentMessagingChatMessage, globalListener, quickRepliesCloseAction, true, true);
                amsAgentStructuredContentViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
                amsAgentStructuredContentViewHolder.setParticipantAvatar(currentMessagingChatMessage.getAgentAvatar());
                break;
            }
            case CONTROLLER_SYSTEM: {
                AmsControllerSystemViewHolder controllerSystemViewHolder = (AmsControllerSystemViewHolder)holder;
                controllerSystemViewHolder.setOnLinkMovementListener(this);
                controllerSystemViewHolder.setMessageTextView(message);
                controllerSystemViewHolder.updateContentDescription();
                break;
            }
            case COBROWSE: {
                LPLog.INSTANCE.d(TAG, "onBindViewHolder position: " + position + " cobrowse");
                AmsCoBrowseViewHolder coBrowseViewHolder = (AmsCoBrowseViewHolder)holder;
                coBrowseViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
                coBrowseViewHolder.setParticipantNickName(currentMessagingChatMessage.getAgentNickName());
                coBrowseViewHolder.setParticipantAvatar(currentMessagingChatMessage.getAgentAvatar());
                CoBrowseMetadata metadata = CoBrowseManager.instance.getMetadata(this.mBrandId, currentMessagingChatMessage.getMessagingChatMessage().getMessage());
                if (metadata != null) {
                    LPLog.INSTANCE.d(TAG, "cobrowsetable dialogId " + metadata.dialogId + "   isPresentable: " + metadata.isPresentable() + "    isClosed: " + metadata.isClosed() + "    isJoinable: " + metadata.isJoinable() + "   isInvite: " + metadata.isInvite() + "     sessionState: " + metadata.sessionState + "    notificationKey: " + metadata.notificationKey + "   metadataPresent: " + (metadata != null));
                    coBrowseViewHolder.setMetadata(metadata, this.mBrandId);
                    coBrowseViewHolder.setVisibility(metadata.isPresentable());
                    break;
                }
                coBrowseViewHolder.setVisibility(true);
                break;
            }
            case DATE_HEADER: {
                DateHeaderViewHolder dateHeaderViewHolder = (DateHeaderViewHolder)holder;
                dateHeaderViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
            }
        }
        if (timeStamp != -1L && this.mMessagingContextualActionController != null) {
            this.mMessagingContextualActionController.applyContextualActionBehavior((int)timeStamp, holder, currentMessagingChatMessage.getFileMessage());
        }
        holder.onBind();
    }

    private boolean isLastItem(int position) {
        for (int i = this.getItemCount() - 1; i > position; --i) {
            MessagingChatMessage message;
            FullMessageRow row = this.messagesAsListLoader.getItem(i);
            if (row == null || (message = row.getMessagingChatMessage()).getMessageType() == MessagingChatMessage.MessageType.LOADING || !MessagingChatMessage.MessageType.isAgentOrBot((MessagingChatMessage.MessageType)message.getMessageType()) && !MessagingChatMessage.MessageType.isConsumer((MessagingChatMessage.MessageType)message.getMessageType()) && message.getMessageType() != MessagingChatMessage.MessageType.SYSTEM_DIALOG_RESOLVED && message.getMessageType() != MessagingChatMessage.MessageType.SYSTEM_RESOLVED) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean onLinkClicked(@NonNull String url) {
        boolean isCallbackEnabled = Configuration.getBoolean((int)R.bool.lp_message_link_as_callback);
        LivePersonEventsProxy callback2 = MessagingFactory.getInstance().getController().mEventsProxy;
        if (isCallbackEnabled) {
            callback2.onLinkClicked(url);
            return true;
        }
        return false;
    }

    private OnSCActionClickListener getSCActionClickListener(final MessagingChatMessage chatMessage, final boolean isMetadataFromWelcomeMessage, final boolean isProactive, final boolean isQuickReply) {
        return new OnSCActionClickListener(){

            public void onPublishTextActionClick(String text, JSONArray metadata) {
                this.handleSCMessageAction(text, metadata);
                MessagesAsListAdapter.this.logAnalyticSCAction(isProactive, "onPublishTextActionClick");
                MessagesAsListAdapter.this.performQROptionTappedCallback(chatMessage, isQuickReply, text);
            }

            public void onLinkActionClick(String link, JSONArray metadata) {
                if (metadata != null) {
                    MessagesAsListAdapter.this.sendSCActionStatus(metadata, chatMessage, isMetadataFromWelcomeMessage);
                } else if (isQuickReply && !isMetadataFromWelcomeMessage) {
                    MessagesAsListAdapter.this.sendSCActionStatus(null, chatMessage, true);
                }
                LivePersonEventsProxy callback2 = MessagingFactory.getInstance().getController().mEventsProxy;
                if (!TextUtils.isEmpty((CharSequence)link)) {
                    if (Configuration.getBoolean((int)R.bool.structured_content_link_as_callback)) {
                        callback2.onStructuredContentLinkClicked(link);
                    } else if (Configuration.getBoolean((int)R.bool.lp_message_link_as_callback)) {
                        callback2.onLinkClicked(link);
                    } else {
                        MessagesAsListAdapter.this.mMessagingContextualActionController.getContextualItemAction().performOpenLink(link, false, BaseViewHolder.LinkType.URL);
                    }
                }
                MessagesAsListAdapter.this.logAnalyticSCAction(isProactive, "onLinkActionClick");
            }

            public void onNavigateActionClick(String latitude, String longitude, JSONArray metadata) {
                if (metadata != null) {
                    MessagesAsListAdapter.this.sendSCActionStatus(metadata, chatMessage, isMetadataFromWelcomeMessage);
                }
                if (!TextUtils.isEmpty((CharSequence)latitude) && !TextUtils.isEmpty((CharSequence)longitude)) {
                    String link = "geo:" + latitude + "," + longitude + "?q=" + latitude + "," + longitude;
                    MessagesAsListAdapter.this.mMessagingContextualActionController.getContextualItemAction().performOpenLink(link, false, BaseViewHolder.LinkType.NAVIGATION);
                }
                MessagesAsListAdapter.this.logAnalyticSCAction(isProactive, "onNavigateActionClick");
            }

            public void onDatePickerActionClick(JSONObject data) {
                block8: {
                    try {
                        if (data.has("type") && data.getString("type").equals("scheduleSlotList")) {
                            this.handleAppointmentSchedulerAction(data);
                            return;
                        }
                        long DEFAULT_RANGE = 4730400000000L;
                        DatePickerParams.Type type = DatePickerParams.Type.parse((String)data.optString("class", ""));
                        String title = data.getString("title");
                        long minDate = new Date().getTime() - 4730400000000L;
                        long maxDate = new Date().getTime() + 4730400000000L;
                        boolean hasMinDate = data.has("minDate");
                        boolean hasMaxDate = data.has("maxDate");
                        if (hasMinDate && !hasMaxDate) {
                            minDate = data.getLong("minDate") * 1000L;
                            maxDate = minDate + 4730400000000L;
                        } else if (!hasMinDate && hasMaxDate) {
                            maxDate = data.getLong("maxDate") * 1000L;
                            minDate = maxDate - 4730400000000L;
                        } else if (hasMinDate && hasMaxDate) {
                            minDate = data.getLong("minDate") * 1000L;
                            maxDate = data.getLong("maxDate") * 1000L;
                        }
                        String dateFormat = data.has("dateFormat") ? data.getString("dateFormat") : "";
                        DatePickerParams calendarInitInfo = new DatePickerParams(type, title, minDate, maxDate, dateFormat);
                        this.handleDatePickerClick(calendarInitInfo);
                    }
                    catch (JSONException e) {
                        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)MessagesAsListAdapter.this.mRecyclerViewRef.get();
                        if (recyclerView == null) break block8;
                        Toast.makeText((Context)recyclerView.getContext(), (int)R.string.lpmessaging_general_error_message, (int)0).show();
                        LPLog.INSTANCE.e(MessagesAsListAdapter.TAG, ErrorCode.ERR_0000015E, e.getMessage(), (Throwable)e);
                    }
                }
                MessagesAsListAdapter.this.logAnalyticSCAction(isProactive, "onDatePickerActionClick");
            }

            private void handleAppointmentSchedulerAction(JSONObject data) throws JSONException {
                MessagesAsListAdapter.this.lpAppointmentSchedulerHandler.initializeAppointmentScheduler(data);
            }

            private void handleDatePickerClick(DatePickerParams calendarInitInfo) {
                MessagesAsListAdapter.this.conversationViewCallback.onDatePickerClicked(calendarInitInfo);
            }

            private void handleSCMessageAction(String text, JSONArray metadata) {
                if (metadata != null) {
                    MessagesAsListAdapter.this.sendSCActionStatus(metadata, chatMessage, isMetadataFromWelcomeMessage);
                }
                MessagingFactory.getInstance().getController().sendMessage(MessagesAsListAdapter.this.mBrandId, MessagesAsListAdapter.this.mBrandId, text, new DeliveryStatusUpdateInfo(metadata));
            }
        };
    }

    private void logAnalyticSCAction(boolean isProactive, String actionType) {
        LPAuthenticationParams params = MessagingFactory.getInstance().getController().mAccountsController.getLPAuthenticationParams(this.mBrandId);
        if (params != null) {
            LPAnalytics.ConsumerAction.INSTANCE.trackClickStructuredContent(params.getAuthType(), LocaleUtils.getInstance().getLocaleCode(), isProactive, actionType);
        } else {
            LPLog.INSTANCE.d(TAG, "getLPAuthenticationParams: getLPAuthenticationParams returns null for brand with id: " + this.mBrandId);
        }
    }

    private void sendSCActionStatus(@Nullable JSONArray metadata, MessagingChatMessage chatMessage, boolean isMetadataFromWelcomeMessage) {
        if (isMetadataFromWelcomeMessage || !MessagingFactory.getInstance().getController().isDialogClosed(chatMessage.getDialogId())) {
            DeliveryStatusUpdateInfo info;
            String conversationId;
            Conversation conversation = MessagingFactory.getInstance().getController().amsConversations.getConversationFromTargetIdMap(this.mBrandId);
            String string2 = conversationId = conversation == null ? "" : conversation.getConversationId();
            if (metadata == null) {
                LPLog.INSTANCE.d(TAG, "onClick: Sending to UMS without metadata");
                info = null;
            } else {
                LPLog.INSTANCE.d(TAG, "onClick: Sending metadata to UMS: " + LPLog.INSTANCE.mask((Object)metadata.toString()));
                info = new DeliveryStatusUpdateInfo(metadata);
            }
            MessagingFactory.getInstance().getController().sendDeliveryStatusUpdateCommand(this.mBrandId, chatMessage.getDialogId(), conversationId, chatMessage.getServerSequence(), DeliveryStatus.ACTION, info);
        } else {
            LPLog.INSTANCE.i(TAG, "dialog closed, don't send metadata to UMS: " + LPLog.INSTANCE.mask((Object)metadata.toString()));
        }
    }

    private void setConsumerMessageText(MessagingChatMessage mMessagingChatMessage, String message, AmsConsumerViewHolder consumerViewHolder) {
        consumerViewHolder.setContextualActionBehavior(this.mMessagingContextualActionController);
        consumerViewHolder.setMessageText(message);
        consumerViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
        consumerViewHolder.setViewAppearanceByState(mMessagingChatMessage.getMessageState(), mMessagingChatMessage.getMessageType(), (Message)mMessagingChatMessage);
        consumerViewHolder.updateContentDescription();
    }

    private void setAgentMessageText(MessagingChatMessage mMessagingChatMessage, String message, AmsAgentViewHolder agentViewHolder) {
        agentViewHolder.setContextualActionBehavior(this.mMessagingContextualActionController);
        if (message != null) {
            agentViewHolder.setMessageText(message);
        }
        agentViewHolder.setTimestamp(mMessagingChatMessage.getTimeStamp());
        agentViewHolder.updateContentDescription();
    }

    void setCopyBehavior(ContextualActionBehavior contextualActionBehavior) {
        this.mMessagingContextualActionController = contextualActionBehavior;
        contextualActionBehavior.setMenuStateListener(new IMenuCallback(){

            @Override
            public void onMenuOpen() {
            }

            @Override
            public void onMenuClose() {
                MessagesAsListAdapter.this.notifyDataSetChanged();
            }
        });
        contextualActionBehavior.setActionMode();
    }

    public void onViewRecycled(@NonNull BaseViewHolder holder) {
        if (this.mMessagingContextualActionController != null) {
            this.mMessagingContextualActionController.onViewRecycled((RecyclerView.ViewHolder)holder);
        }
        holder.recycle();
        LPLog.INSTANCE.d(TAG, "onViewRecycled holder = " + holder.hashCode() + " type = " + holder.getItemViewType());
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
    }

    public void onViewAttachedToWindow(@NonNull BaseViewHolder holder) {
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.setRequestTimestampListener((BaseViewHolder.OnRequestTimestampUpdateListener)this);
        holder.observeTimestampChanges();
    }

    public void onViewDetachedFromWindow(@NonNull BaseViewHolder holder) {
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.stopObservingTimestampsChanges();
    }

    public int getItemCount() {
        return this.messagesAsListLoader.size();
    }

    void onConnectionAvailable() {
        this.messagesAsListLoader.onConnectionAvailable();
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView != null) {
            recyclerView.postDelayed(() -> {
                this.pendingScrollToBottom = false;
            }, 10000L);
        }
    }

    void onConnectionLost() {
        this.messagesAsListLoader.onConnectionLost();
    }

    @Override
    public void onBackground() {
        this.mIsForeground = false;
        this.lpAppointmentSchedulerHandler.unSubscribeToAppointmentLogs();
        this.messagesAsListLoader.onBackground();
        this.saveCurrentVisiblePosition();
        this.cancelTimestampUpdates();
    }

    public void removeListener() {
        this.messagesAsListLoader.removeListener();
    }

    public void requestTimestampsUpdate(int position) {
        if (this.mIsForeground) {
            this.notifyItemChanged(position, PAYLOAD_UPDATE_TIMESTAMP);
        }
    }

    public void onUpdateTimestampWithDelay(long delay, Runnable runnable) {
        if (this.mIsForeground) {
            if (delay > 0L) {
                this.mUpdatesHandler.postDelayed(runnable, delay);
            } else {
                this.mUpdatesHandler.post(runnable);
            }
        } else {
            this.cancelTimestampsUpdate(runnable);
        }
    }

    public void cancelTimestampsUpdate(Runnable runnable) {
        this.mUpdatesHandler.removeCallbacks(runnable);
    }

    private void saveCurrentVisiblePosition() {
        int savedFirstVisibleItemPosition;
        int firstVisiblePos = this.getFirstVisibleItemPosition();
        if (firstVisiblePos > 0) {
            --firstVisiblePos;
        }
        int threshold = firstVisiblePos + 100;
        int serverMessQuantity = this.messagesAsListLoader.getTotalMessagesWithPositiveSequence(threshold);
        int distance = serverMessQuantity - firstVisiblePos;
        if (this.messagesAsListLoader.size() < 100) {
            savedFirstVisibleItemPosition = this.getFirstVisibleItemPosition();
        } else if (distance < 100) {
            savedFirstVisibleItemPosition = 100 - distance;
            if (this.messagesAsListLoader.getUnreadPosition() != -1) {
                ++savedFirstVisibleItemPosition;
            }
        } else {
            savedFirstVisibleItemPosition = -1;
            distance = 0;
        }
        int lastPosition = this.getLastVisibleItemPosition();
        if (lastPosition == this.messagesAsListLoader.size() - 1) {
            distance = 0;
        }
        PreferenceManager.getInstance().setIntValue(KEY_SCROLLING_OFFSET, this.mBrandId, distance);
        PreferenceManager.getInstance().setIntValue(KEY_LAST_SCROLLED_FIRST_VISIBLE_ITEM_POSITION, this.mBrandId, savedFirstVisibleItemPosition);
    }

    @Override
    public void onForeground() {
        this.fromPushNotification = PushMessagePreferences.INSTANCE.isPushNotificationClicked();
        this.messagesAsListLoader.onForeground();
        this.mIsForeground = true;
        this.resumeTimestampUpdates();
        if (this.isFirstScrollPerformed) {
            this.performScroll();
        } else {
            this.shouldFocusOnlastMessage = true;
            this.shouldFocusOnUnreadBanner = true;
        }
        this.requestAccessibilityFocusForVisibleLastItem();
    }

    private void announceAccessibilityMessage(String prefix, FullMessageRow fullMessageRow) {
        AccessibilityAnnouncer announcer;
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        Context context = recyclerView.getContext();
        MessagingChatMessage.MessageType messageType = fullMessageRow.getMessagingChatMessage().getMessageType();
        String accessibilityText = "";
        switch (messageType) {
            case AGENT_FORM: {
                String securityFormDescription = context.getString(R.string.lpmessaging_ui_secure_form_to_fill_in_message);
                String fillInFormButton = context.getString(R.string.lpmessaging_ui_fill_in_form_text_button);
                String buttonAccessibilityText = context.getString(R.string.lp_accessibility_sc_button);
                accessibilityText = securityFormDescription + ". " + fillInFormButton + ". " + buttonAccessibilityText;
                break;
            }
            case AGENT_URL: 
            case BOT_URL: {
                accessibilityText = context.getString(R.string.lp_accessibility_link);
                break;
            }
            case AGENT_MARKDOWN_HYPERLINK: 
            case BOT_MARKDOWN_HYPERLINK: {
                String message = fullMessageRow.getMessagingChatMessage().getMessage();
                List hyperlinkItemList = HyperLinkUtils.buildHyperlinkList((String)message);
                String linkWord = context.getResources().getQuantityString(R.plurals.lp_accessibility_links, hyperlinkItemList.size(), new Object[]{hyperlinkItemList.size()});
                accessibilityText = HyperLinkUtils.buildMessageString((String)message) + ", " + linkWord;
                break;
            }
            default: {
                accessibilityText = "";
            }
        }
        String accessibilityMessage = AccessbilityUtilsKt.getAccessibilityMessage(fullMessageRow.getMessagingChatMessage(), accessibilityText, context);
        if (!(TextUtils.isEmpty((CharSequence)accessibilityMessage) && messageType == MessagingChatMessage.MessageType.SYSTEM_RESOLVED || (announcer = recyclerView.getAnnouncer()) == null)) {
            if (Configuration.getBoolean((int)R.bool.lp_announce_new_message_content)) {
                announcer.announce(prefix + accessibilityMessage);
            } else {
                int unreadMessagesCount = this.messagesAsListLoader.getUnreadMessagesCount();
                String unreadMessagesCountText = this.getUnreadMessagesAnnouncement(unreadMessagesCount);
                announcer.announce(prefix + " " + unreadMessagesCountText);
            }
        }
    }

    String getAgentAvatarUrl(String originatorId) {
        return this.messagesAsListLoader.getAgentUrl(originatorId);
    }

    void removeQuickRepliesMessageOfDialog(String dialogId) {
        this.messagesAsListLoader.removeQuickRepliesMessageOfDialog(dialogId);
    }

    void removeQuickRepliesMessageOfConversation(String conversationId) {
        this.messagesAsListLoader.removeQuickRepliesMessageOfConversation(conversationId);
    }

    void removeCoBrowsMessageOfConversation(String dialogId) {
        this.messagesAsListLoader.hideCoBrowsMessage(dialogId);
    }

    private void performScroll() {
        if (!MessagingFactory.getInstance().getController().mAccountsController.isInUnAuthMode(this.mBrandId)) {
            if (this.fromPushNotification) {
                this.scrollOnPushNotification();
            } else if (!this.firstTimeBringToForeground) {
                this.scrollOnForeground();
            } else {
                this.scrollOnInAppNavigation();
            }
            this.firstTimeBringToForeground = false;
        }
        this.isFirstScrollPerformed = true;
    }

    private void scrollOnForeground() {
        String scrollPosition = Configuration.getString((int)R.string.lp_scroll_when_foreground).toLowerCase();
        LPLog.INSTANCE.d(TAG, "Accessibility: On Foreground " + scrollPosition);
        this.shouldFocusOnlastMessage = true;
        switch (scrollPosition) {
            case "lastposition": {
                this.pendingScrollToBottom = false;
                this.shouldFocusOnUnreadBanner = true;
                break;
            }
            case "bottom": {
                this.scrollToBottom();
                this.shouldFocusOnUnreadBanner = false;
                break;
            }
            case "firstunreadmessage": {
                this.pendingScrollToBottom = false;
                this.shouldFocusOnUnreadBanner = true;
                if (this.messagesAsListLoader.getUnreadPosition() != -1) {
                    this.scrollToUnreadPosition();
                    break;
                }
                this.scrollToBottom();
                break;
            }
            default: {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F5, "Invalid scroll configuration for string: lp_scroll_when_foreground." + scrollPosition);
                this.pendingScrollToBottom = false;
            }
        }
    }

    private void scrollOnInAppNavigation() {
        int position = PreferenceManager.getInstance().getIntValue(KEY_LAST_SCROLLED_FIRST_VISIBLE_ITEM_POSITION, this.mBrandId, -1);
        int offset = PreferenceManager.getInstance().getIntValue(KEY_SCROLLING_OFFSET, this.mBrandId, 0);
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        this.shouldFocusOnlastMessage = true;
        String scrollPosition = Configuration.getString((int)R.string.lp_scroll_show_conversation).toLowerCase();
        LPLog.INSTANCE.d(TAG, "Accessibility: On InApp navigation " + scrollPosition);
        switch (scrollPosition) {
            case "lastposition": {
                this.pendingScrollToBottom = false;
                this.shouldFocusOnUnreadBanner = true;
                if (position < 0) break;
                StickyHeadersLinearLayoutManager manager = (StickyHeadersLinearLayoutManager)recyclerView.getLayoutManager();
                if (this.shouldScrollToFirstByInApp) {
                    int scrollingOffset = this.messagesAsListLoader.size() - offset;
                    manager.scrollToPositionWithOffset(scrollingOffset, 0);
                } else {
                    manager.scrollToPositionWithOffset(position, 0);
                }
                this.shouldScrollToFirstByInApp = false;
                break;
            }
            case "bottom": {
                this.shouldFocusOnUnreadBanner = false;
                this.pendingScrollToBottom = true;
                break;
            }
            case "firstunreadmessage": {
                this.pendingScrollToBottom = false;
                this.shouldFocusOnUnreadBanner = true;
                if (this.messagesAsListLoader.getUnreadPosition() != -1) {
                    this.scrollToUnreadPosition();
                }
                this.pendingScrollToFirstUnreadMessage = true;
                break;
            }
            default: {
                this.pendingScrollToBottom = true;
                this.shouldFocusOnUnreadBanner = true;
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F6, "Invalid scroll configuration for string: lp_scroll_show_conversation." + scrollPosition);
            }
        }
        PreferenceManager.getInstance().setIntValue(KEY_SCROLLING_OFFSET, this.mBrandId, 0);
        PreferenceManager.getInstance().setIntValue(KEY_LAST_SCROLLED_FIRST_VISIBLE_ITEM_POSITION, this.mBrandId, -1);
    }

    private void scrollOnPushNotification() {
        String scrollPosition = Configuration.getString((int)R.string.lp_scroll_when_push_notification).toLowerCase();
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        this.shouldFocusOnlastMessage = true;
        this.shouldFocusOnUnreadBanner = true;
        LPLog.INSTANCE.d(TAG, "Accessibility: On Push Notification " + scrollPosition);
        switch (scrollPosition) {
            case "lastposition": {
                this.pendingScrollToBottom = false;
                this.shouldFocusOnUnreadBanner = true;
                int inAppLastScrolledPosition = PreferenceManager.getInstance().getIntValue(KEY_LAST_SCROLLED_FIRST_VISIBLE_ITEM_POSITION, this.mBrandId, -1);
                int offset = PreferenceManager.getInstance().getIntValue(KEY_SCROLLING_OFFSET, this.mBrandId, 0);
                if (inAppLastScrolledPosition >= 0) {
                    this.keepLastPositionOnNewMessage = true;
                    if (this.shouldScrollToFirstByPush) {
                        int scrollingOffset = this.messagesAsListLoader.size() - offset;
                        ((StickyHeadersLinearLayoutManager)recyclerView.getLayoutManager()).scrollToPositionWithOffset(scrollingOffset, 0);
                    } else {
                        ((StickyHeadersLinearLayoutManager)recyclerView.getLayoutManager()).scrollToPositionWithOffset(inAppLastScrolledPosition, 0);
                    }
                    this.shouldScrollToFirstByPush = false;
                    break;
                }
                this.keepLastPositionOnNewMessage = false;
                break;
            }
            case "bottom": {
                this.shouldFocusOnUnreadBanner = false;
                this.pendingScrollToBottom = true;
                break;
            }
            case "firstunreadmessage": {
                this.pendingScrollToBottom = false;
                this.shouldFocusOnUnreadBanner = true;
                if (this.messagesAsListLoader.getUnreadPosition() != -1) {
                    this.scrollToUnreadPosition();
                }
                this.pendingScrollToFirstUnreadMessage = true;
                break;
            }
            default: {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F7, "Invalid scroll configuration for string: lp_scroll_when_push_notification." + scrollPosition);
                this.pendingScrollToBottom = true;
                this.shouldFocusOnUnreadBanner = true;
            }
        }
    }

    private void scrollOnScrollDownIndicatorClicked() {
        String scrollPosition = Configuration.getString((int)R.string.lp_scroll_when_scroll_down).toLowerCase();
        this.shouldFocusOnlastMessage = true;
        switch (scrollPosition) {
            case "firstunreadmessage": {
                this.shouldFocusOnUnreadBanner = true;
                this.scrollToUnreadPosition();
                break;
            }
            case "bottom": {
                this.shouldFocusOnUnreadBanner = false;
                this.smoothScrollToBottom();
                break;
            }
            default: {
                this.shouldFocusOnUnreadBanner = true;
                this.smoothScrollToBottom();
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F8, "Invalid scroll configuration for string: lp_scroll_when_scroll_down." + scrollPosition);
            }
        }
    }

    @Override
    public void scrollToBottom() {
        int position;
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView != null && (position = this.messagesAsListLoader.size() - 1) >= 0) {
            recyclerView.scrollToPosition(position);
            IScrollDownIndicator scrollDownIndicator = (IScrollDownIndicator)this.mScrollDownIndicatorRef.get();
            if (scrollDownIndicator != null) {
                scrollDownIndicator.resetAndHide();
            }
        }
    }

    private void smoothScrollToBottom() {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        if (this.messagesAsListLoader.size() == 0) {
            return;
        }
        int bottomPosition = this.messagesAsListLoader.size() - 1;
        if (this.messagesAsListLoader.size() - this.getLastVisibleItemPosition() <= 20) {
            recyclerView.smoothScrollToPosition(bottomPosition);
        } else {
            recyclerView.scrollToPosition(bottomPosition);
        }
    }

    private void scrollToUnreadPosition() {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        IScrollDownIndicator indicator = (IScrollDownIndicator)this.mScrollDownIndicatorRef.get();
        if (recyclerView == null) {
            return;
        }
        int unreadPosition = this.messagesAsListLoader.getUnreadPosition();
        if (this.messagesAsListLoader.size() > 0) {
            if (unreadPosition > -1 && unreadPosition < this.messagesAsListLoader.size()) {
                ((StickyHeadersLinearLayoutManager)recyclerView.getLayoutManager()).scrollToPositionWithOffset(unreadPosition, 0);
                if (indicator != null) {
                    indicator.resetAndShowCollapsed();
                }
                this.messagesAsListLoader.setScrollDownIndicatorVisible(true);
            } else {
                this.scrollToBottom();
            }
        }
    }

    private void setPushNotificationClickedFalse() {
        this.fromPushNotification = false;
    }

    private void cancelTimestampUpdates() {
        this.mUpdatesHandler.removeCallbacksAndMessages(null);
    }

    private void resumeTimestampUpdates() {
        ChatMessageListRecyclerView recyclerView = (ChatMessageListRecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        int firstPosition = this.getFirstVisibleItemPosition();
        int lastPosition = this.getLastVisibleItemPosition();
        for (int i = firstPosition; i < lastPosition; ++i) {
            RecyclerView.ViewHolder holder = recyclerView.findViewHolderForLayoutPosition(i);
            if (!(holder instanceof BaseViewHolder)) continue;
            this.onUpdateTimestampWithDelay(0L, (Runnable)((BaseViewHolder)holder));
        }
    }

    private void changeAccessibilityMode(@NonNull View headerView, int mode) {
        View child;
        headerView.setImportantForAccessibility(mode);
        if (headerView instanceof ViewGroup && (child = ((ViewGroup)headerView).getChildAt(0)) != null) {
            child.setImportantForAccessibility(mode);
        }
    }

    private void notifyBlockInputChanged() {
        int lastPosition;
        MessagesAsListLoader loader = this.messagesAsListLoader;
        BlockInputAreaCallback callback2 = this.mBlockInputAreaCallback;
        if (loader == null || callback2 == null) {
            return;
        }
        for (int i = lastPosition = this.getItemCount() - 1; i >= 0; --i) {
            FullMessageRow row = this.messagesAsListLoader.getItem(lastPosition);
            if (row == null) continue;
            MessagingChatMessage message = row.getMessagingChatMessage();
            if (MessagingChatMessage.MessageType.isStructuredContent((MessagingChatMessage.MessageType)message.getMessageType())) {
                if (this.isMessageDialogActive(message.getDialogId())) {
                    callback2.onBlockInputChecked(ContentBlockingUtils.isBlockInputAreaEnabled(message.getMessage()));
                } else {
                    callback2.onBlockInputChecked(false);
                }
                return;
            }
            if (message.getMessageType() == MessagingChatMessage.MessageType.LOADING || !MessagingChatMessage.MessageType.isAgentOrBot((MessagingChatMessage.MessageType)message.getMessageType()) && !MessagingChatMessage.MessageType.isConsumer((MessagingChatMessage.MessageType)message.getMessageType()) && message.getMessageType() != MessagingChatMessage.MessageType.SYSTEM_DIALOG_RESOLVED && message.getMessageType() != MessagingChatMessage.MessageType.SYSTEM_RESOLVED) continue;
            callback2.onBlockInputChecked(false);
            return;
        }
        callback2.onBlockInputChecked(false);
    }

    private boolean isMessageDialogActive(String dialogId) {
        Messaging messaging = MessagingFactory.getInstance().getController();
        if (messaging == null) {
            return false;
        }
        AmsDialogs dialogs = messaging.amsDialogs;
        if (dialogs == null) {
            return false;
        }
        Dialog dialog = dialogs.getActiveDialog();
        return dialog != null && dialogId.equals(dialog.getDialogId()) && dialog.isOpen();
    }

    private void performQROptionTappedCallback(@NonNull MessagingChatMessage chatMessage, boolean isQuickReply, String title) {
        if (!isQuickReply || chatMessage.getServerSequence() != -4) {
            return;
        }
        LPLog.INSTANCE.d(TAG, "Tapped option: " + title);
        MessagingFactory.getInstance().getController().mEventsProxy.onWelcomeMessageOptionTapped(title);
    }

    private String getUnreadMessagesAnnouncement(int count) {
        if (count < 1) {
            return "";
        }
        RecyclerView recyclerView = (RecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return "";
        }
        Context context = recyclerView.getContext().getApplicationContext();
        String format = context.getResources().getQuantityString(R.plurals.lp_unread_message, count);
        try {
            return String.format(format, count);
        }
        catch (IllegalFormatException ex) {
            LPLog.INSTANCE.d(TAG, "Failed to format lp_unread_message", (Throwable)ex);
            return "";
        }
    }

    private void requestAccessibilityFocusForVisibleLastItem() {
        RecyclerView recyclerView = (RecyclerView)this.mRecyclerViewRef.get();
        if (recyclerView == null) {
            return;
        }
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        if (adapter == null) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof StickyHeadersLinearLayoutManager) {
            StickyHeadersLinearLayoutManager manager = (StickyHeadersLinearLayoutManager)layoutManager;
            int lastVisibleItemPosition = ((StickyHeadersLinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            if (lastVisibleItemPosition == adapter.getItemCount() - 1) {
                this.requestAccessibilityFocusForLastItem(recyclerView, 1000L);
            }
        }
    }

    private void requestAccessibilityFocusForLastItem(RecyclerView recyclerView, long delay) {
        RecyclerView.Adapter adapter = recyclerView.getAdapter();
        if (adapter == null) {
            return;
        }
        RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
        if (layoutManager instanceof StickyHeadersLinearLayoutManager) {
            int firstVisibleItemPosition = ((StickyHeadersLinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            int lastVisibleItemPosition = ((StickyHeadersLinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            int unreadMessagePosition = this.messagesAsListLoader.getUnreadPosition();
            LPLog.INSTANCE.d(TAG, "Accessibility: first visible: " + firstVisibleItemPosition + " last visible " + lastVisibleItemPosition + " unread position " + unreadMessagePosition + " last adapter position " + (adapter.getItemCount() - 1));
            LPLog.INSTANCE.d(TAG, "Accessibility: shouldFocusOnlastMessage: " + this.shouldFocusOnlastMessage + " shouldFocusOnUnreadBanner " + this.shouldFocusOnUnreadBanner);
            if (unreadMessagePosition >= firstVisibleItemPosition && unreadMessagePosition <= lastVisibleItemPosition && this.shouldFocusOnUnreadBanner) {
                RecyclerView.ViewHolder holder = recyclerView.findViewHolderForAdapterPosition(unreadMessagePosition);
                if (holder instanceof UiUnreadIndicatorViewHolder) {
                    ((UiUnreadIndicatorViewHolder)holder).moveFocusToItself(300L);
                    this.shouldFocusOnlastMessage = false;
                    this.shouldFocusOnUnreadBanner = false;
                }
            } else if (this.shouldFocusOnlastMessage && lastVisibleItemPosition == adapter.getItemCount() - 1) {
                RecyclerView.ViewHolder holder = recyclerView.findViewHolderForAdapterPosition(lastVisibleItemPosition);
                if (holder instanceof AmsLoadMoreViewHolder) {
                    LPLog.INSTANCE.d(TAG, "Accessibility: Last message is loader, skip moving focus");
                    return;
                }
                if (holder instanceof DateHeaderViewHolder) {
                    LPLog.INSTANCE.d(TAG, "Accessibility: Last message is date hader, skip moving focus");
                    return;
                }
                if (holder instanceof AmsBrandMsgViewHolder) {
                    ((BaseViewHolder)holder).moveFocusToItself(delay);
                } else if (holder instanceof AmsAgentStructuredContentViewHolder) {
                    FullMessageRow row = this.messagesAsListLoader.getItem(adapter.getItemCount() - 1);
                    ((AmsAgentStructuredContentViewHolder)holder).moveFocusToItself(delay);
                    this.shouldFocusOnlastMessage = row != null && row.getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.AGENT_QUICK_REPLIES;
                } else if (holder instanceof BaseViewHolder) {
                    ((BaseViewHolder)holder).moveFocusToItself(delay);
                    this.shouldFocusOnlastMessage = false;
                }
            }
        }
    }
}

