/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents.list.header;

import android.content.Context;
import com.liveperson.infra.messaging_ui.uicomponents.list.header.DateHeaderUtilsKt;
import com.liveperson.infra.utils.DateUtils;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001(B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0006\u0010\"\u001a\u00020#J\u001c\u0010$\u001a\u00020#2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00170\u001f2\u0006\u0010 \u001a\u00020!J\u0014\u0010%\u001a\u00020\u0017*\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0007H\u0002J\u0015\u0010&\u001a\u00020\u0016*\u00020\u00172\u0006\u0010'\u001a\u00020\u0017H\u0082\u0004R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00030\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0007*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u00020\u0016*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0018R\u0018\u0010\u0019\u001a\u00020\u0007*\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006)"}, d2={"Lcom/liveperson/infra/messaging_ui/uicomponents/list/header/DateHeaderHelper;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "_headersPositionsMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "_knownListSize", "contextRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "headers", "", "getHeaders", "()Ljava/util/Map;", "asDayTimestamp", "getAsDayTimestamp", "(J)J", "isDateHeader", "", "Lcom/liveperson/messaging/model/FullMessageRow;", "(Lcom/liveperson/messaging/model/FullMessageRow;)Z", "timestamp", "getTimestamp", "(Lcom/liveperson/messaging/model/FullMessageRow;)J", "applyListChanges", "diff", "rows", "", "onDateHeaderChangedListener", "Lcom/liveperson/infra/messaging_ui/uicomponents/list/header/DateHeaderHelper$OnDateHeaderChangedListener;", "clearDateHeaders", "", "observeHeaderChanging", "headerOfTimeStamp", "isSentInTheSameDayAs", "row", "OnDateHeaderChangedListener", "messaging_ui_release"})
@SourceDebugExtension(value={"SMAP\nDateHeaderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateHeaderHelper.kt\ncom/liveperson/infra/messaging_ui/uicomponents/list/header/DateHeaderHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class DateHeaderHelper {
    @NotNull
    private final WeakReference<Context> contextRef;
    @NotNull
    private final HashMap<Long, Integer> _headersPositionsMap;
    private int _knownListSize;

    public DateHeaderHelper(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.contextRef = new WeakReference<Context>(context);
        this._headersPositionsMap = new HashMap();
    }

    public final void observeHeaderChanging(@NotNull List<? extends FullMessageRow> rows, @NotNull OnDateHeaderChangedListener onDateHeaderChangedListener) {
        int diff;
        block4: {
            Integer knownPosition;
            long currentTimeStamp;
            block5: {
                Context context;
                block7: {
                    block6: {
                        FullMessageRow fullMessageRow;
                        FullMessageRow fullMessageRow2;
                        FullMessageRow fullMessageRow3;
                        FullMessageRow fullMessageRow4;
                        Intrinsics.checkNotNullParameter(rows, (String)"rows");
                        Intrinsics.checkNotNullParameter((Object)onDateHeaderChangedListener, (String)"onDateHeaderChangedListener");
                        diff = 0;
                        diff = Math.abs(rows.size() - this._knownListSize);
                        FullMessageRow fullMessageRow5 = (FullMessageRow)CollectionsKt.firstOrNull(rows);
                        if (fullMessageRow5 == null) break block4;
                        FullMessageRow it = fullMessageRow4 = fullMessageRow5;
                        boolean bl = false;
                        Object object = fullMessageRow3 = !this.isDateHeader(it) ? fullMessageRow4 : null;
                        if (fullMessageRow3 == null) break block4;
                        FullMessageRow it2 = fullMessageRow2 = fullMessageRow3;
                        boolean bl2 = false;
                        Object object2 = fullMessageRow4 = !(it2.getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.LOADING) ? fullMessageRow2 : null;
                        if (fullMessageRow4 == null) break block4;
                        FullMessageRow it3 = fullMessageRow = fullMessageRow4;
                        boolean bl3 = false;
                        Object object3 = fullMessageRow2 = !(it3.getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.UNREAD_INDICATOR) ? fullMessageRow : null;
                        if (fullMessageRow2 == null) break block4;
                        it3 = fullMessageRow2;
                        boolean bl4 = false;
                        currentTimeStamp = this.getAsDayTimestamp(this.getTimestamp(it3));
                        knownPosition = this._headersPositionsMap.get(currentTimeStamp);
                        if (knownPosition != null) break block5;
                        Context context2 = (Context)this.contextRef.get();
                        context = context2;
                        if (context == null) break block6;
                        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"get()");
                        context = this.headerOfTimeStamp(context2, currentTimeStamp);
                        if (context != null) break block7;
                    }
                    return;
                }
                Context message = context;
                onDateHeaderChangedListener.onDateHeaderAdded(0, (FullMessageRow)message);
                Long l = currentTimeStamp;
                ((Map)this._headersPositionsMap).put(l, 0);
                int n = diff;
                diff = n + 1;
                break block4;
            }
            if (knownPosition != 0) {
                onDateHeaderChangedListener.onDateHeaderMoved(knownPosition + diff, 0);
                Long l = currentTimeStamp;
                ((Map)this._headersPositionsMap).put(l, 0);
            }
        }
        int addedItems = this.applyListChanges(diff, rows, onDateHeaderChangedListener);
        this._knownListSize = rows.size() + addedItems;
    }

    @NotNull
    public final Map<Long, Integer> getHeaders() {
        return this._headersPositionsMap;
    }

    public final void clearDateHeaders() {
        this._headersPositionsMap.clear();
    }

    private final FullMessageRow headerOfTimeStamp(Context $this$headerOfTimeStamp, long timestamp) {
        FullMessageRow fullMessageRow = FullMessageRow.createDateHeader((long)timestamp, (String)DateHeaderUtilsKt.getFormattedTimestamp($this$headerOfTimeStamp, timestamp));
        Intrinsics.checkNotNullExpressionValue((Object)fullMessageRow, (String)"createDateHeader(timesta\u2026ttedTimestamp(timestamp))");
        return fullMessageRow;
    }

    private final int applyListChanges(int diff, List<? extends FullMessageRow> rows, OnDateHeaderChangedListener onDateHeaderChangedListener) {
        int added = 0;
        for (int index = CollectionsKt.getLastIndex(rows); 0 < index; --index) {
            Number number;
            FullMessageRow current = rows.get(index);
            FullMessageRow previous = rows.get(index - 1);
            if (this.isDateHeader(current) || this.isSentInTheSameDayAs(current, previous)) continue;
            long currentTimeStamp = this.getAsDayTimestamp(this.getTimestamp(current));
            Integer knownPosition = this._headersPositionsMap.get(currentTimeStamp);
            if (knownPosition == null) {
                Context context = (Context)this.contextRef.get();
                if (context == null || (context = this.headerOfTimeStamp(context, currentTimeStamp)) == null) continue;
                Context message = context;
                onDateHeaderChangedListener.onDateHeaderAdded(index, (FullMessageRow)message);
                number = currentTimeStamp;
                Integer n = index;
                ((Map)this._headersPositionsMap).put(number, n);
                ++added;
                continue;
            }
            if (diff + knownPosition - added == index) continue;
            onDateHeaderChangedListener.onDateHeaderMoved(knownPosition + diff, index - added);
            Long l = currentTimeStamp;
            number = index;
            ((Map)this._headersPositionsMap).put(l, number);
        }
        return added;
    }

    private final boolean isSentInTheSameDayAs(FullMessageRow $this$isSentInTheSameDayAs, FullMessageRow row) {
        long next;
        long current = this.getAsDayTimestamp(this.getTimestamp($this$isSentInTheSameDayAs));
        return current == (next = this.getAsDayTimestamp(this.getTimestamp(row)));
    }

    private final long getAsDayTimestamp(long $this$asDayTimestamp) {
        return DateUtils.getBeginningOfDayTime((long)$this$asDayTimestamp);
    }

    private final long getTimestamp(FullMessageRow $this$timestamp) {
        return $this$timestamp.getMessagingChatMessage().getTimeStamp();
    }

    private final boolean isDateHeader(FullMessageRow $this$isDateHeader) {
        return $this$isDateHeader.getMessagingChatMessage().getMessageType() == MessagingChatMessage.MessageType.DATE_HEADER;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005H&J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\f"}, d2={"Lcom/liveperson/infra/messaging_ui/uicomponents/list/header/DateHeaderHelper$OnDateHeaderChangedListener;", "", "onDateHeaderAdded", "", "position", "", "messageRow", "Lcom/liveperson/messaging/model/FullMessageRow;", "onDateHeaderMoved", "oldPosition", "newPosition", "onDateHeaderRemoved", "messaging_ui_release"})
    public static interface OnDateHeaderChangedListener {
        public void onDateHeaderRemoved(int var1);

        public void onDateHeaderAdded(int var1, @NotNull FullMessageRow var2);

        public void onDateHeaderMoved(int var1, int var2);
    }
}

