/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils;

import android.content.Context;
import android.os.Build;
import android.view.View;
import androidx.annotation.StringRes;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.ui.view.utils.text.LPTextUtils;
import com.liveperson.lp_structured_content.utils.StructuredContentAccessibilityUtilsKt;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.model.MessagingChatMessage;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\n\u0010\u0002\u001a\u00020\u0003*\u00020\u0004\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\n\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0014\u0010\r\u001a\u00020\u0003*\u00020\u00042\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u001a\u0014\u0010\u0010\u001a\u00020\u0003*\u00020\u00042\b\b\u0001\u0010\u0011\u001a\u00020\u0012\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"TAG", "", "clearAccessibilityClass", "", "Landroid/view/View;", "getAccessibilityMessage", "Lcom/liveperson/messaging/model/MessagingChatMessage;", "accessibilityText", "context", "Landroid/content/Context;", "getAccessibilityNameForFileType", "fileSharingType", "Lcom/liveperson/messaging/background/filesharing/FileSharingType;", "markAsAccessibilityHeading", "isHeading", "", "setAccessibilityClickAction", "res", "", "messaging_ui_release"})
public final class AccessbilityUtilsKt {
    @NotNull
    private static final String TAG = "AccessibilityUtils";

    @NotNull
    public static final String getAccessibilityMessage(@NotNull MessagingChatMessage $this$getAccessibilityMessage, @NotNull String accessibilityText, @NotNull Context context) {
        Object accessibilityMessage;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getAccessibilityMessage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)accessibilityText, (String)"accessibilityText");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        MessagingChatMessage.MessageType messageType = $this$getAccessibilityMessage.getMessageType();
        if ((object = (accessibilityMessage = (switch (messageType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[messageType.ordinal()]) {
            case 1 -> {
                Object $this$getAccessibilityMessage_u24lambda_u240;
                Object var4_3 = $this$getAccessibilityMessage;
                try {
                    $this$getAccessibilityMessage_u24lambda_u240 = var4_3;
                    boolean $i$a$-runCatching-AccessbilityUtilsKt$getAccessibilityMessage$accessibilityMessage$1 = false;
                    $this$getAccessibilityMessage_u24lambda_u240 = Result.constructor-impl((Object)(new JSONObject($this$getAccessibilityMessage_u24lambda_u240.getMessage()).getString("title") + ". " + accessibilityText));
                }
                catch (Throwable $i$a$-runCatching-AccessbilityUtilsKt$getAccessibilityMessage$accessibilityMessage$1) {
                    $this$getAccessibilityMessage_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-AccessbilityUtilsKt$getAccessibilityMessage$accessibilityMessage$1));
                }
                var4_3 = $this$getAccessibilityMessage_u24lambda_u240;
                Throwable v1 = Result.exceptionOrNull-impl((Object)var4_3);
                if (v1 != null) {
                    Object it = $this$getAccessibilityMessage_u24lambda_u240 = v1;
                    boolean $i$a$-onFailure-AccessbilityUtilsKt$getAccessibilityMessage$accessibilityMessage$2 = false;
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000A2, "JSONException while unpacking Agent Form.", (Throwable)it);
                }
                yield (String)(Result.isFailure-impl((Object)var4_3) ? null : var4_3);
            }
            case 2, 3 -> {
                Object var5_4;
                Object var4_3 = $this$getAccessibilityMessage;
                try {
                    MessagingChatMessage $this$getAccessibilityMessage_u24lambda_u242 = var4_3;
                    boolean $i$a$-runCatching-AccessbilityUtilsKt$getAccessibilityMessage$accessibilityMessage$3 = false;
                    var5_4 = Result.constructor-impl((Object)StructuredContentAccessibilityUtilsKt.getSCAccessibilityAnnounce((JSONObject)new JSONObject($this$getAccessibilityMessage_u24lambda_u242.getMessage()), (Context)context));
                }
                catch (Throwable $i$a$-runCatching-AccessbilityUtilsKt$getAccessibilityMessage$accessibilityMessage$3) {
                    var5_4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-AccessbilityUtilsKt$getAccessibilityMessage$accessibilityMessage$3));
                }
                var4_3 = var5_4;
                Throwable v3 = Result.exceptionOrNull-impl((Object)var4_3);
                if (v3 != null) {
                    Object it = var5_4 = v3;
                    boolean $i$a$-onFailure-AccessbilityUtilsKt$getAccessibilityMessage$accessibilityMessage$4 = false;
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000A2, "JSONException while unpacking Structure content.", (Throwable)it);
                }
                yield (String)(Result.isFailure-impl((Object)var4_3) ? null : var4_3);
            }
            case 4, 5 -> $this$getAccessibilityMessage.getMessage() + ". " + accessibilityText;
            case 6, 7 -> LPTextUtils.asFormattedMessage((String)accessibilityText);
            default -> {
                String v4 = $this$getAccessibilityMessage.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"message");
                yield LPTextUtils.asFormattedMessage((String)v4);
            }
        }))) == null) {
            object = "";
        }
        return object;
    }

    @NotNull
    public static final String getAccessibilityNameForFileType(@NotNull Context $this$getAccessibilityNameForFileType, @NotNull FileSharingType fileSharingType) {
        Intrinsics.checkNotNullParameter((Object)$this$getAccessibilityNameForFileType, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileSharingType, (String)"fileSharingType");
        int resId = switch (WhenMappings.$EnumSwitchMapping$1[fileSharingType.ordinal()]) {
            case 1 -> R.string.lp_accessibility_file_type_pdf;
            case 2 -> R.string.lp_accessibility_file_type_docx;
            case 3 -> R.string.lp_accessibility_file_type_pptx;
            case 4 -> R.string.lp_accessibility_file_type_xlsx;
            case 5 -> R.string.lp_accessibility_file_type_unknown;
            default -> R.string.lp_accessibility_file_type_unknown;
        };
        String string2 = $this$getAccessibilityNameForFileType.getString(resId);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(resId)");
        return string2;
    }

    public static final void markAsAccessibilityHeading(@NotNull View $this$markAsAccessibilityHeading, boolean isHeading) {
        Intrinsics.checkNotNullParameter((Object)$this$markAsAccessibilityHeading, (String)"<this>");
        if (Build.VERSION.SDK_INT >= 28) {
            $this$markAsAccessibilityHeading.setAccessibilityHeading(isHeading);
        } else {
            ViewCompat.setAccessibilityHeading((View)$this$markAsAccessibilityHeading, (boolean)isHeading);
        }
    }

    public static /* synthetic */ void markAsAccessibilityHeading$default(View view, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        AccessbilityUtilsKt.markAsAccessibilityHeading(view, bl);
    }

    public static final void setAccessibilityClickAction(@NotNull View $this$setAccessibilityClickAction, @StringRes int res) {
        Intrinsics.checkNotNullParameter((Object)$this$setAccessibilityClickAction, (String)"<this>");
        AccessibilityNodeInfoCompat.AccessibilityActionCompat action = AccessibilityNodeInfoCompat.AccessibilityActionCompat.ACTION_CLICK;
        String string2 = $this$setAccessibilityClickAction.getContext().getResources().getString(res);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.resources.getString(res)");
        String actionContent = string2;
        ViewCompat.replaceAccessibilityAction((View)$this$setAccessibilityClickAction, (AccessibilityNodeInfoCompat.AccessibilityActionCompat)action, (CharSequence)actionContent, null);
    }

    public static final void clearAccessibilityClass(@NotNull View $this$clearAccessibilityClass) {
        Intrinsics.checkNotNullParameter((Object)$this$clearAccessibilityClass, (String)"<this>");
        AccessibilityDelegateCompat delegate2 = new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(@NotNull View host, @NotNull AccessibilityNodeInfoCompat info) {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                super.onInitializeAccessibilityNodeInfo(host, info);
                info.setClassName((CharSequence)"");
            }
        };
        ViewCompat.setAccessibilityDelegate((View)$this$clearAccessibilityClass, (AccessibilityDelegateCompat)delegate2);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[MessagingChatMessage.MessageType.values().length];
            try {
                nArray[MessagingChatMessage.MessageType.AGENT_FORM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessagingChatMessage.MessageType.AGENT_STRUCTURED_CONTENT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessagingChatMessage.MessageType.BOT_STRUCTURED_CONTENT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessagingChatMessage.MessageType.AGENT_URL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessagingChatMessage.MessageType.BOT_URL.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessagingChatMessage.MessageType.AGENT_MARKDOWN_HYPERLINK.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessagingChatMessage.MessageType.BOT_MARKDOWN_HYPERLINK.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[FileSharingType.values().length];
            try {
                nArray[FileSharingType.PDF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileSharingType.DOCX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileSharingType.PPTX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileSharingType.XLSX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FileSharingType.UNKNOWN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

