/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils;

import android.content.Context;
import android.text.TextUtils;
import android.widget.ImageView;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.utils.StringUtils;
import com.liveperson.infra.ui.view.utils.picasso.CircleTransform;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.lpappointmentscheduler.AppointmentSchedulerOperations;
import com.liveperson.lpappointmentscheduler.models.AppointmentSlot;
import com.liveperson.messaging.MessagingFactory;
import com.squareup.picasso.Callback;
import com.squareup.picasso.Transformation;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/liveperson/infra/messaging_ui/utils/AppointmentSchedulerOperationsImpl;", "Lcom/liveperson/lpappointmentscheduler/AppointmentSchedulerOperations;", "context", "Landroid/content/Context;", "brandId", "", "(Landroid/content/Context;Ljava/lang/String;)V", "onAppointmentConfirmed", "", "appointment", "Lcom/liveperson/lpappointmentscheduler/models/AppointmentSlot;", "startImageLoading", "imageView", "Landroid/widget/ImageView;", "imageUrl", "Companion", "messaging_ui_release"})
public final class AppointmentSchedulerOperationsImpl
implements AppointmentSchedulerOperations {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String brandId;
    @NotNull
    private static final String TAG = "AppointmentSchedulerOperationsImpl";

    public AppointmentSchedulerOperationsImpl(@NotNull Context context, @NotNull String brandId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        this.context = context;
        this.brandId = brandId;
    }

    public final void onAppointmentConfirmed(@NotNull AppointmentSlot appointment) {
        Intrinsics.checkNotNullParameter((Object)appointment, (String)"appointment");
        LPLog.INSTANCE.i(TAG, "User confirmed appointment: " + appointment);
        JSONObject metadata = new JSONObject();
        try {
            CharSequence charSequence;
            metadata.put("type", (Object)"scheduleSlot");
            metadata.put("id", (Object)appointment.getId());
            metadata.put("start", appointment.getStartTime() / (long)1000);
            if (appointment.getEndTime() > 0L) {
                metadata.put("end", appointment.getEndTime() / (long)1000);
            }
            if (!((charSequence = (CharSequence)appointment.getTitle()) == null || charSequence.length() == 0)) {
                metadata.put("title", (Object)appointment.getTitle());
            }
            if (!((charSequence = (CharSequence)appointment.getDescription()) == null || charSequence.length() == 0)) {
                metadata.put("description", (Object)appointment.getDescription());
            }
            if (!((charSequence = (CharSequence)appointment.getImageURL()) == null || charSequence.length() == 0)) {
                metadata.put("imageUrl", (Object)appointment.getImageURL());
            }
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000156, "Failed to generate appointment response metadata. " + e);
        }
        StringBuilder message = new StringBuilder();
        message.append(appointment.getTitle());
        if (!TextUtils.isEmpty((CharSequence)appointment.getTitle())) {
            message.append("\n");
        }
        message.append(appointment.getDescription());
        if (!TextUtils.isEmpty((CharSequence)appointment.getDescription())) {
            message.append("\n");
        }
        long l = appointment.getStartTime();
        long l2 = appointment.getEndTime();
        String string2 = this.context.getString(R.string.lp_appointment_date_format);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.getString(R.stri\u2026_appointment_date_format)");
        String string3 = this.context.getString(R.string.lp_appointment_time_format);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.getString(R.stri\u2026_appointment_time_format)");
        Locale locale = LocaleUtils.getInstance().getLocale();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getInstance().locale");
        String dateTime = StringUtils.INSTANCE.createAppointmentSelectionMessage(l, l2, string2, string3, locale);
        message.append(dateTime);
        MessagingFactory.getInstance().getController().sendMessage(this.brandId, this.brandId, message.toString(), new DeliveryStatusUpdateInfo(new JSONArray().put((Object)metadata)));
    }

    public void startImageLoading(@NotNull ImageView imageView, @Nullable String imageUrl) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        CharSequence charSequence = imageUrl;
        if (charSequence == null || charSequence.length() == 0) {
            PicassoUtils.get((Context)this.context).load(R.drawable.lp_default_appointment_avatar).transform((Transformation)new CircleTransform()).error(R.drawable.lp_default_appointment_avatar).into(imageView);
        } else {
            PicassoUtils.get((Context)this.context).load(imageUrl).transform((Transformation)new CircleTransform()).error(R.drawable.lp_default_appointment_avatar).into(imageView, new Callback(){

                public void onSuccess() {
                }

                public void onError(@NotNull Exception e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }
            });
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/infra/messaging_ui/utils/AppointmentSchedulerOperationsImpl$Companion;", "", "()V", "TAG", "", "messaging_ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

