/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils;

import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.lp_structured_content.ui.utils.BlockingElementsUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ContentBlockingUtils {
    private static final String TAG = "ContentBlockingUtils";

    public static boolean isBlockSCEnabledSiteSettings() {
        return PreferenceManager.getInstance().getBooleanValue("site_settings_block_sc_when_not_last_message_preference_key", "appLevelPreferences", false);
    }

    public static boolean isBlockInputAreaEnabledSiteSettings() {
        return PreferenceManager.getInstance().getBooleanValue("site_settings_block_text_input_value_preference_key", "appLevelPreferences", false);
    }

    public static boolean isBlockInputAreaEnabled(String message) {
        try {
            JSONObject jsonObject = new JSONObject(message);
            Boolean result = BlockingElementsUtils.shouldBlockTextInput((JSONObject)jsonObject);
            return result != null ? result : ContentBlockingUtils.isBlockInputAreaEnabledSiteSettings();
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000016L, "Failed to parse JSON", (Throwable)e);
            return ContentBlockingUtils.isBlockSCEnabledSiteSettings();
        }
    }
}

