/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.messaging.MessagingFactory;

public class ConversationInBackgroundService
extends Service {
    private static final String TAG = "ConversationInBackgroundService";
    public static final String BUNDLE_BRAND_ID = "bundle_brand_id";
    private String brandId;

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        LPLog.INSTANCE.d(TAG, "ConversationInBackground Service Started");
        this.brandId = intent.getStringExtra(BUNDLE_BRAND_ID);
        return 2;
    }

    public void onDestroy() {
        super.onDestroy();
        LPLog.INSTANCE.d(TAG, "ConversationInBackground Service Destroyed");
    }

    public void onTaskRemoved(Intent rootIntent) {
        LPLog.INSTANCE.d(TAG, "ConversationInBackground Service killed");
        try {
            if (!TextUtils.isEmpty((CharSequence)this.brandId)) {
                this.clearConversationData(this.brandId);
            }
            this.stopSelf();
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000109, "Failed to clear conversation data on app kill");
        }
    }

    private void clearConversationData(String brandId) {
        PreferenceManager.getInstance().remove("hide_closed_conversations", brandId);
        MessagingFactory.getInstance().getController().mConnectionController.clearLastUpdateTime(brandId);
        MessagingFactory.getInstance().getController().clearAllConversationData(brandId);
    }
}

