/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils;

import android.content.Context;
import android.widget.Toast;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.ConversationViewCallback;
import com.liveperson.lpappointmentscheduler.LPAppointmentScheduler;
import com.liveperson.lpappointmentscheduler.logger.AppointmentSchedulerLog;
import com.liveperson.lpappointmentscheduler.logger.LogLevel;
import com.liveperson.lpappointmentscheduler.models.LPAppointmentInfo;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u0006\u0010\u0017\u001a\u00020\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lcom/liveperson/infra/messaging_ui/utils/LPAppointmentSchedulerHandler;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "TAG", "", "appointmentSchedulerLog", "Lcom/liveperson/lpappointmentscheduler/logger/AppointmentSchedulerLog;", "contextRef", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "conversationViewCallback", "Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;", "getConversationViewCallback", "()Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;", "setConversationViewCallback", "(Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;)V", "initializeAppointmentScheduler", "", "data", "Lorg/json/JSONObject;", "subscribeToAppointmentLogs", "unSubscribeToAppointmentLogs", "messaging_ui_release"})
public final class LPAppointmentSchedulerHandler {
    @NotNull
    private final String TAG;
    @NotNull
    private final AppointmentSchedulerLog appointmentSchedulerLog;
    @NotNull
    private final WeakReference<Context> contextRef;
    @Nullable
    private ConversationViewCallback conversationViewCallback;

    public LPAppointmentSchedulerHandler(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.TAG = "LPAppointmentSchedulerHandler";
        this.contextRef = new WeakReference<Context>(context);
        this.appointmentSchedulerLog = new AppointmentSchedulerLog(){

            public void log(@NotNull LogLevel level, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)level, (String)"level");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
                    case 1: {
                        LPLog.INSTANCE.v(TAG, message);
                        break;
                    }
                    case 2: {
                        LPLog.INSTANCE.i(TAG, message);
                        break;
                    }
                    case 3: {
                        LPLog.INSTANCE.w(TAG, message);
                        break;
                    }
                    case 4: {
                        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000155, message);
                        break;
                    }
                    case 5: {
                        LPLog.INSTANCE.d(TAG, message);
                        break;
                    }
                    default: {
                        LPLog.INSTANCE.d(TAG, message);
                    }
                }
            }

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[LogLevel.values().length];
                    try {
                        nArray[LogLevel.VERBOSE.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LogLevel.INFO.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LogLevel.WARNING.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LogLevel.ERROR.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[LogLevel.DEBUG.ordinal()] = 5;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        };
        this.subscribeToAppointmentLogs();
    }

    @Nullable
    public final ConversationViewCallback getConversationViewCallback() {
        return this.conversationViewCallback;
    }

    public final void setConversationViewCallback(@Nullable ConversationViewCallback conversationViewCallback) {
        this.conversationViewCallback = conversationViewCallback;
    }

    private final void subscribeToAppointmentLogs() {
        LPAppointmentScheduler.Companion.subscribeToLogs(this.appointmentSchedulerLog);
    }

    public final void unSubscribeToAppointmentLogs() {
        LPLog.INSTANCE.i(this.TAG, "unSubscribeToAppointmentLogs");
        LPAppointmentScheduler.Companion.unSubscribeToLogs(this.appointmentSchedulerLog);
    }

    public final void initializeAppointmentScheduler(@NotNull JSONObject data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Context context = (Context)this.contextRef.get();
        if (context == null) {
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Context is not initialized");
            return;
        }
        Context context2 = context;
        try {
            LPAppointmentInfo info = LPAppointmentScheduler.Companion.initialize(context2, data);
            if (info != null && !info.getAppointmentSlots().isEmpty()) {
                Unit unit;
                ConversationViewCallback conversationViewCallback = this.conversationViewCallback;
                if (conversationViewCallback != null) {
                    conversationViewCallback.onAppointmentSchedulerRequested(info);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit == null) {
                    LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to load AppointmentScheduler. conversationViewCallback is null");
                }
            } else {
                Object object = info;
                boolean bl = object != null && (object = object.getAppointmentSlots()) != null ? object.isEmpty() : false;
                if (bl) {
                    Toast.makeText((Context)context2, (int)R.string.lpmessaging_appointment_no_slots_error_message, (int)0).show();
                    LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to load AppointmentScheduler. No appointments available");
                } else {
                    Toast.makeText((Context)context2, (int)R.string.lpmessaging_general_error_message, (int)0).show();
                    LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to load AppointmentScheduler. LPAppointmentInfo is null");
                }
            }
        }
        catch (Exception error) {
            Toast.makeText((Context)context2, (int)R.string.lpmessaging_general_error_message, (int)0).show();
            LPLog.INSTANCE.e(this.TAG, ErrorCode.ERR_00000155, "Failed to initialize AppointmentScheduler. " + error);
        }
    }
}

