/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.os.Build;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.liveperson.api.sdk.PermissionType;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.messaging.MessagingFactory;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a8\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00012\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a \u0010\u0013\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u0001H\u0002\u001a\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"PACKAGE_CONST", "", "PREF_CAMERA_PERMISSION_DIALOG_STATUS", "PREF_RECORD_PERMISSION_DIALOG_STATUS", "REQUEST_CAMERA", "", "REQUEST_RECORD", "TAG", "handleNotGrantedPermission", "", "brandId", "requestCode", "permission", "permissionType", "Lcom/liveperson/api/sdk/PermissionType;", "shouldDisplayPermissionDialog", "", "activity", "Landroid/app/Activity;", "setPermissionDialogDisplayStatus", "value", "showPermissionDialog", "messaging_ui_release"})
public final class PermissionUtilsKt {
    @NotNull
    private static final String TAG = "PermissionUtils";
    public static final int REQUEST_CAMERA = 2;
    public static final int REQUEST_RECORD = 3;
    @NotNull
    public static final String PREF_CAMERA_PERMISSION_DIALOG_STATUS = "pref_camera_permission_dialog_status";
    @NotNull
    public static final String PREF_RECORD_PERMISSION_DIALOG_STATUS = "pref_record_permission_dialog_status";
    @NotNull
    public static final String PACKAGE_CONST = "package";

    public static final void handleNotGrantedPermission(@NotNull String brandId, int requestCode, @NotNull String permission2, @Nullable PermissionType permissionType, boolean shouldDisplayPermissionDialog, @NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)permission2, (String)"permission");
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        LPLog.INSTANCE.d(TAG, "handleNotGrantedPermission= " + brandId + " requestCode= " + requestCode + " permission =" + permission2 + " permissionType= " + permissionType + " shouldDisplayPermissionDialog= " + shouldDisplayPermissionDialog);
        if (permissionType == null) {
            LPLog.INSTANCE.w(TAG, "handleNotGrantedPermission: permissionType was not set");
            return;
        }
        try {
            if (ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission2)) {
                LPLog.INSTANCE.d(TAG, "User pressed deny button without checking 'Don't ask again' box");
                MessagingFactory.getInstance().getController().mEventsProxy.onUserDeniedPermission(permissionType, false);
                if (shouldDisplayPermissionDialog) {
                    PermissionUtilsKt.setPermissionDialogDisplayStatus(requestCode, false, brandId);
                }
            } else {
                LPLog.INSTANCE.d(TAG, "User pressed 'deny' with flag 'do not show this again' or just pressed to access the gallery anytime afterwards");
                MessagingFactory.getInstance().getController().mEventsProxy.onUserDeniedPermission(permissionType, true);
                boolean showRationale = Build.VERSION.SDK_INT >= 23 ? activity.shouldShowRequestPermissionRationale(permission2) : false;
                LPLog.INSTANCE.d(TAG, " showRationale= " + showRationale + " shouldDisplayPermissionDialog= " + shouldDisplayPermissionDialog);
                if (!showRationale && shouldDisplayPermissionDialog) {
                    LPLog.INSTANCE.d(TAG, "Propose user to go to settings and allow permission if user denied it twice or CHECKED don't ask again. Not really best practice.");
                    PermissionUtilsKt.showPermissionDialog(requestCode, activity);
                } else if (!shouldDisplayPermissionDialog) {
                    PermissionUtilsKt.setPermissionDialogDisplayStatus(requestCode, true, brandId);
                }
            }
        }
        catch (Exception error) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000E9, "onRequestPermissionsResult: Failed to validate permission states ", (Throwable)error);
        }
    }

    private static final void setPermissionDialogDisplayStatus(int requestCode, boolean value, String brandId) {
        LPLog.INSTANCE.d(TAG, "setPermissionDialogDisplayStatus() requestCode " + requestCode + " value= " + value + " brandId= " + brandId);
        switch (requestCode) {
            case 2: {
                PreferenceManager.getInstance().setBooleanValue(PREF_CAMERA_PERMISSION_DIALOG_STATUS, brandId, value);
                break;
            }
            case 3: {
                PreferenceManager.getInstance().setBooleanValue(PREF_RECORD_PERMISSION_DIALOG_STATUS, brandId, value);
                break;
            }
            default: {
                return;
            }
        }
    }

    private static final void showPermissionDialog(int requestCode, Activity activity) {
        String string2 = activity.getString(R.string.lp_enable_permission_dialog_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activity.getString(R.str\u2026_permission_dialog_title)");
        String dialogTitle = string2;
        String string3 = activity.getString(R.string.lp_permission_dialog_go_to_settings_message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"activity.getString(R.str\u2026g_go_to_settings_message)");
        Object dialogMessage = string3;
        String accessType = null;
        int imageDrawable = 0;
        switch (requestCode) {
            case 2: {
                String string4 = activity.getString(R.string.lp_camera_permission_dialog_title);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"activity.getString(R.str\u2026_permission_dialog_title)");
                accessType = string4;
                Object[] objectArray = new Object[]{accessType};
                String string5 = String.format(dialogTitle, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(format, *args)");
                dialogTitle = string5;
                String string6 = activity.getString(R.string.lp_enable_camera_permission_dialog_message);
                objectArray = new Object[]{accessType};
                String string7 = String.format((String)dialogMessage, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(format, *args)");
                dialogMessage = string6 + " " + string7;
                imageDrawable = R.drawable.lpmessaging_ui_ic_camera;
                break;
            }
            case 3: {
                String string8 = activity.getString(R.string.lp_microphone_permission_dialog_title);
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"activity.getString(R.str\u2026_permission_dialog_title)");
                accessType = string8;
                Object[] objectArray = new Object[]{accessType};
                String string9 = String.format(dialogTitle, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(format, *args)");
                dialogTitle = string9;
                String string10 = activity.getString(R.string.lp_enable_microphone_permission_dialog_message);
                objectArray = new Object[]{accessType};
                String string11 = String.format((String)dialogMessage, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(format, *args)");
                dialogMessage = string10 + " " + string11;
                imageDrawable = R.drawable.lpinfra_ui_ic_mic;
                break;
            }
            default: {
                return;
            }
        }
        try {
            ImageView imageView = new ImageView((Context)activity);
            imageView.setImageResource(imageDrawable);
            imageView.setColorFilter(ContextCompat.getColor((Context)((Context)activity), (int)R.color.lp_blue), PorterDuff.Mode.SRC_IN);
            TextView customMessage = new TextView((Context)activity);
            customMessage.setText((CharSequence)dialogMessage);
            customMessage.setTextColor(ContextCompat.getColor((Context)((Context)activity), (int)R.color.lp_alert_dialog_title_description_color));
            customMessage.setPadding(50, 50, 50, 0);
            customMessage.setGravity(17);
            new AlertDialog.Builder((Context)activity, R.style.LpAlertDialogCustom).setIcon(imageView.getDrawable()).setTitle((CharSequence)dialogTitle).setView((View)customMessage).setCancelable(false).setPositiveButton((CharSequence)activity.getString(R.string.lp_permission_dialog_settings_button), (arg_0, arg_1) -> PermissionUtilsKt.showPermissionDialog$lambda$0(activity, arg_0, arg_1)).setNegativeButton((CharSequence)activity.getString(R.string.lp_permission_dialog_cancel_button), null).show();
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F0, "Failed to display permission dialog.", (Throwable)e);
        }
    }

    private static final void showPermissionDialog$lambda$0(Activity $activity, DialogInterface dialog, int which) {
        Intrinsics.checkNotNullParameter((Object)$activity, (String)"$activity");
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        intent.addFlags(0x10000000);
        Uri uri = Uri.fromParts((String)PACKAGE_CONST, (String)$activity.getPackageName(), null);
        intent.setData(uri);
        $activity.startActivity(intent);
    }
}

