/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.utils;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import com.liveperson.infra.database.DataBaseExecutor;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b*\u00020\b\u001a\u0014\u0010\n\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\u0001*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\u0001*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0002\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u001a&\u0010\u0015\u001a\u00020\u0016*\u00020\u00042\u0006\u0010\u000b\u001a\u00020\b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00160\u0018\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"FOLDER_IMAGES", "", "cachedImagesFolder", "Ljava/io/File;", "Landroid/content/Context;", "getCachedImagesFolder", "(Landroid/content/Context;)Ljava/io/File;", "asSafeUri", "Landroid/net/Uri;", "kotlin.jvm.PlatformType", "createFileInCacheDir", "uri", "getContentFileName", "getFileName", "getStringValueOfColumn", "Landroid/database/Cursor;", "columnName", "safeCopyTo", "", "Ljava/io/InputStream;", "file", "saveToFile", "", "block", "Lkotlin/Function1;", "messaging_ui_release"})
@JvmName(name="UriFileUtils")
@SourceDebugExtension(value={"SMAP\nUriFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UriFileUtils.kt\ncom/liveperson/infra/messaging_ui/utils/UriFileUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,71:1\n1#2:72\n36#3:73\n*S KotlinDebug\n*F\n+ 1 UriFileUtils.kt\ncom/liveperson/infra/messaging_ui/utils/UriFileUtils\n*L\n27#1:73\n*E\n"})
public final class UriFileUtils {
    @NotNull
    private static final String FOLDER_IMAGES = "temp_images";

    @NotNull
    public static final File getCachedImagesFolder(@NotNull Context $this$cachedImagesFolder) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$cachedImagesFolder, (String)"<this>");
        File $this$_get_cachedImagesFolder__u24lambda_u240 = file = new File($this$cachedImagesFolder.getCacheDir(), FOLDER_IMAGES);
        boolean bl = false;
        if (!$this$_get_cachedImagesFolder__u24lambda_u240.exists()) {
            $this$_get_cachedImagesFolder__u24lambda_u240.mkdirs();
        }
        return file;
    }

    public static final void saveToFile(@NotNull Context $this$saveToFile, @NotNull Uri uri, @NotNull Function1<? super Uri, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$saveToFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        DataBaseExecutor.execute(() -> UriFileUtils.saveToFile$lambda$4($this$saveToFile, uri, block));
    }

    private static final File createFileInCacheDir(Context $this$createFileInCacheDir, Uri uri) {
        File file;
        File file2;
        String string2 = UriFileUtils.getFileName($this$createFileInCacheDir, uri);
        if (string2 == null) {
            throw new IllegalStateException("Can't get file name");
        }
        String fileName = string2;
        File it = file2 = (file = new File(UriFileUtils.getCachedImagesFolder($this$createFileInCacheDir), fileName));
        boolean bl = false;
        if (!it.exists()) {
            it.createNewFile();
        }
        return file2;
    }

    /*
     * Unable to fully structure code
     */
    private static final String getFileName(Context $this$getFileName, Uri uri) {
        var3_2 = uri.getScheme();
        if (var3_2 == null) ** GOTO lbl-1000
        switch (var3_2.hashCode()) {
            case 951530617: {
                if (var3_2.equals("content")) {
                    v0 = UriFileUtils.getContentFileName($this$getFileName, uri);
                    break;
                }
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = uri.getPath();
                if (v1 != null) {
                    p0 = v1;
                    $i$a$-let-UriFileUtils$getFileName$fileName$1 = false;
                    v0 = new File(p0).getName();
                    break;
                }
                v0 = null;
            }
        }
        fileName = v0;
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getContentFileName(Context $this$getContentFileName, Uri uri) {
        String string2;
        Cursor cursor = $this$getContentFileName.getContentResolver().query(uri, null, null, null, null);
        if (cursor != null) {
            Closeable closeable = (Closeable)cursor;
            Throwable throwable = null;
            try {
                String string3;
                Cursor cursor2;
                Cursor cursor3;
                Cursor cursor4 = (Cursor)closeable;
                boolean bl = false;
                Cursor it = cursor3 = cursor4;
                boolean bl2 = false;
                Cursor cursor5 = cursor2 = it.moveToFirst() ? cursor3 : null;
                if (cursor5 != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)cursor5, (String)"takeIf { it.moveToFirst() }");
                    string3 = UriFileUtils.getStringValueOfColumn(cursor2, "_display_name");
                } else {
                    string3 = null;
                }
                String string4 = string3;
                string2 = string4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            string2 = null;
        }
        return string2;
    }

    private static final String getStringValueOfColumn(Cursor $this$getStringValueOfColumn, String columnName) {
        String string2 = $this$getStringValueOfColumn.getString($this$getStringValueOfColumn.getColumnIndexOrThrow(columnName));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(getColumnIndexOrThrow(columnName))");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final long safeCopyTo(InputStream $this$safeCopyTo, File file) {
        long l;
        Closeable closeable = $this$safeCopyTo;
        Throwable throwable = null;
        try {
            long l2;
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new FileOutputStream(file);
            Throwable throwable2 = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable2;
                boolean bl2 = false;
                l2 = ByteStreamsKt.copyTo$default((InputStream)$this$safeCopyTo, (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            l = l2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return l;
    }

    public static final Uri asSafeUri(@NotNull Uri $this$asSafeUri) {
        Intrinsics.checkNotNullParameter((Object)$this$asSafeUri, (String)"<this>");
        return Uri.parse((String)$this$asSafeUri.toString());
    }

    /*
     * WARNING - void declaration
     */
    private static final void saveToFile$lambda$4(Context $this_saveToFile, Uri $uri, Function1 $block) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this_saveToFile, (String)"$this_saveToFile");
            Intrinsics.checkNotNullParameter((Object)$uri, (String)"$uri");
            Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
            File file = null;
            try {
                void $this$toUri$iv;
                File file2;
                File it = file2 = UriFileUtils.createFileInCacheDir($this_saveToFile, $uri);
                boolean bl = false;
                file = it;
                it = file2;
                boolean bl2 = false;
                InputStream inputStream = $this_saveToFile.getContentResolver().openInputStream($uri);
                Intrinsics.checkNotNull((Object)inputStream);
                UriFileUtils.safeCopyTo(inputStream, it);
                boolean $i$f$toUri = false;
                Uri uri = Uri.fromFile((File)$this$toUri$iv);
                Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"fromFile(this)");
                Uri outputUri = uri;
                $block.invoke((Object)outputUri);
            }
            catch (Exception ex) {
                File file3;
                File file4 = file;
                if (file4 == null) break block3;
                File it = file3 = file4;
                boolean bl = false;
                file4 = it.exists() ? file3 : null;
                if (file4 != null) {
                    file4.delete();
                }
            }
        }
    }
}

