/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.copybehavior;

import android.text.TextUtils;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualItemAction;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.IActivityProvider;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.IMenuCallback;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.messaging.model.FileMessage;
import java.util.ArrayList;

public abstract class ContextualActionBehavior {
    protected IActivityProvider mActivityProvider;
    protected IMenuCallback mMenuCallback;
    protected ContextualItemAction mContextualItemAction;
    protected ArrayList<Integer> mBundledViewData;
    protected boolean mIsFileSelected;

    ContextualActionBehavior(ArrayList<Integer> bundledViewData, boolean IsFileSelected) {
        this.mIsFileSelected = IsFileSelected;
        this.mBundledViewData = bundledViewData != null ? bundledViewData : new ArrayList();
    }

    public abstract void setActionMode();

    public void setActivityProvider(IActivityProvider mActivityProvider) {
        this.mActivityProvider = mActivityProvider;
    }

    public void setMenuStateListener(IMenuCallback iMenuCallback) {
        this.mMenuCallback = iMenuCallback;
    }

    protected boolean hasFilePath(FileMessage fileMessage) {
        return fileMessage != null && !TextUtils.isEmpty((CharSequence)fileMessage.getFileType()) && !TextUtils.isEmpty((CharSequence)fileMessage.getLocalUrl()) && !fileMessage.getLocalUrl().contains("VOICE");
    }

    public abstract ArrayList<Integer> getListOfSelectedItems();

    public abstract boolean getIfFileSelectedBeforeOrientation();

    public abstract void onViewRecycled(RecyclerView.ViewHolder var1);

    public abstract void applyContextualActionBehavior(int var1, BaseViewHolder var2, FileMessage var3);

    public void setContextualItemAction(ContextualItemAction contextualItemAction) {
        this.mContextualItemAction = contextualItemAction;
    }

    public boolean isSelectable() {
        return false;
    }

    public abstract View.OnClickListener getOnClickListener(int var1, BaseViewHolder var2, FileMessage var3);

    public abstract View.OnLongClickListener getOnLongClickListener(int var1, BaseViewHolder var2, FileMessage var3);

    public ContextualItemAction getContextualItemAction() {
        return this.mContextualItemAction;
    }
}

