/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.copybehavior;

import android.view.Menu;
import android.view.MenuInflater;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualItemAction;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.messaging.model.FileMessage;
import java.util.ArrayList;

public class MessagingContextualSimpleMenuBehavior
extends ContextualActionBehavior {
    public MessagingContextualSimpleMenuBehavior(ArrayList<Integer> bundleViewData, boolean isFileSelected) {
        super(bundleViewData, isFileSelected);
    }

    @Override
    public void onViewRecycled(RecyclerView.ViewHolder viewHolder) {
    }

    @Override
    public void applyContextualActionBehavior(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        this.applyListeners(viewHolder, fileMessage);
    }

    private void applyListeners(BaseViewHolder viewHolder, FileMessage fileMessage) {
        viewHolder.itemView.setOnCreateContextMenuListener((menu2, v, menuInfo) -> {
            if (this.mActivityProvider != null) {
                String textToCopy = viewHolder.getTextToCopy();
                MenuInflater inflater = this.mActivityProvider.getActivity().getMenuInflater();
                inflater.inflate(R.menu.lpmessaging_ui_item_copy_menu, (Menu)menu2);
                if (fileMessage != null) {
                    if (this.hasFilePath(fileMessage)) {
                        menu2.findItem(R.id.context_menu_share).setVisible(true);
                        menu2.findItem(R.id.context_menu_share).setOnMenuItemClickListener(item -> {
                            this.mContextualItemAction.performFileAction(fileMessage.getLocalUrl(), ContextualItemAction.Action.SHARE);
                            return true;
                        });
                        menu2.findItem(R.id.context_menu_save).setVisible(true);
                        menu2.findItem(R.id.context_menu_save).setOnMenuItemClickListener(item -> {
                            this.mContextualItemAction.performSaveFile(fileMessage.getLocalUrl());
                            return true;
                        });
                        menu2.findItem(R.id.context_menu_copy).setVisible(false);
                    }
                } else {
                    menu2.findItem(R.id.context_menu_copy).setOnMenuItemClickListener(item -> {
                        this.mContextualItemAction.PerformCopyTextToClipboard(textToCopy);
                        return true;
                    });
                    menu2.findItem(R.id.context_menu_copy).setVisible(true);
                    menu2.findItem(R.id.context_menu_share).setVisible(false);
                    menu2.findItem(R.id.context_menu_save).setVisible(false);
                }
            }
        });
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public boolean getIfFileSelectedBeforeOrientation() {
        return false;
    }

    @Override
    public View.OnClickListener getOnClickListener(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        return null;
    }

    @Override
    public View.OnLongClickListener getOnLongClickListener(int itemId, BaseViewHolder viewHolder, FileMessage fileMessage) {
        this.applyListeners(viewHolder, fileMessage);
        return v -> false;
    }

    @Override
    public void setActionMode() {
    }

    @Override
    public ArrayList<Integer> getListOfSelectedItems() {
        return null;
    }
}

