/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.utils.AccessbilityUtilsKt;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent.AmsAgentViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.base.ParticipantFileViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.utils.AmsDownloadableFileViewProcessor;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.utils.ImageUtils;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.squareup.picasso.RequestCreator;
import java.io.File;

public class AmsAgentFileViewHolder
extends AmsAgentViewHolder
implements ParticipantFileViewHolder {
    public static final String TAG = "AmsAgentFileViewHolder";
    private final ImageView mMessageImageView;
    private final ImageView mFileStatusView;
    private final AmsDownloadableFileViewProcessor mDownloadableFileViewProcessor;
    private final MessagingChatMessage.MessageType mMessageType;

    public AmsAgentFileViewHolder(View itemView, MessagingChatMessage.MessageType messageType) {
        super(itemView);
        this.mMessageType = messageType;
        this.mMessageImageView = (ImageView)itemView.findViewById(R.id.lpui_message_image);
        this.mFileStatusView = (ImageView)itemView.findViewById(R.id.lpui_message_status_image);
        AccessbilityUtilsKt.setAccessibilityClickAction((View)this.mMessageImageView, R.string.lp_accessibility_action_download);
        AccessbilityUtilsKt.clearAccessibilityClass((View)this.mMessageImageView);
        this.mDownloadableFileViewProcessor = new AmsDownloadableFileViewProcessor(itemView, messageType){

            @Override
            protected void onNotStartedAction() {
                this.stopAnimation();
                this.mFileStatusView.setVisibility(0);
                this.mFileStatusView.setImageResource(R.drawable.lpmessaging_ui_image_download);
                AccessbilityUtilsKt.setAccessibilityClickAction((View)AmsAgentFileViewHolder.this.mMessageImageView, R.string.lp_accessibility_action_download);
            }

            @Override
            protected void onCompletedAction() {
                this.stopAnimation();
                this.mFileStatusView.setVisibility(4);
                AccessbilityUtilsKt.setAccessibilityClickAction((View)AmsAgentFileViewHolder.this.mMessageImageView, R.string.lp_accessibility_action_open);
            }

            @Override
            protected void onRequestingUrlAction() {
                this.mFileStatusView.setVisibility(0);
                this.startProgressBar();
                AccessbilityUtilsKt.setAccessibilityClickAction((View)AmsAgentFileViewHolder.this.mMessageImageView, R.string.lp_accessibility_action_download);
            }
        };
    }

    @Override
    public void applyChanges(Bundle changes, Message message) {
        super.applyChanges(changes, message);
        this.mDownloadableFileViewProcessor.applyChanges(changes);
        String preview = this.mDownloadableFileViewProcessor.mPreviewImage;
        String fullFile = this.mDownloadableFileViewProcessor.mFullFile;
        FilesTable.LoadStatus loadStatus = this.mDownloadableFileViewProcessor.getLoadStatus();
        if (this.mMessageType != MessagingChatMessage.MessageType.AGENT_DOCUMENT) {
            this.setupAsImage(fullFile, preview, loadStatus);
        }
        this.updateContentDescription();
    }

    @Override
    public void setMessageText(String text) {
        super.setMessageText(text);
        if (TextUtils.isEmpty((CharSequence)text)) {
            this.mMessageTextView.setVisibility(8);
        } else {
            this.mMessageTextView.setVisibility(0);
        }
    }

    @Override
    public void updateContentDescription() {
        if (this.mMessageType == MessagingChatMessage.MessageType.AGENT_DOCUMENT) {
            String extension = this.mDownloadableFileViewProcessor.mFileType;
            if (!TextUtils.isEmpty((CharSequence)extension)) {
                FileSharingType type = FileSharingType.getFileTypeFromExtension((String)extension.toLowerCase());
                this.updateContentDescriptionForDocument(type);
            }
        } else {
            this.updateContentDescriptionForImage();
        }
    }

    public AmsDownloadableFileViewProcessor getAmsDownloadableFileViewProcessor() {
        return this.mDownloadableFileViewProcessor;
    }

    public void recycle() {
        super.recycle();
        this.mMessageImageView.setImageDrawable(null);
        this.setOnImageClickListener(null);
        this.setOnImageLongClickListener(null);
    }

    @Override
    public void setOnImageClickListener(@Nullable View.OnClickListener listener) {
        if (this.mMessageImageView != null) {
            this.mMessageImageView.setOnClickListener(listener);
        }
    }

    @Override
    public void setOnImageLongClickListener(@Nullable View.OnLongClickListener listener) {
        if (this.mMessageImageView != null) {
            this.mMessageImageView.setOnLongClickListener(listener);
        }
    }

    @Override
    @NonNull
    public AmsDownloadableFileViewProcessor getFileProcessor() {
        return this.mDownloadableFileViewProcessor;
    }

    @Override
    public void setMessageContent(String fullImagePath, String previewUri, FilesTable.LoadStatus loadStatus, String fileType) {
        if (this.mMessageType == MessagingChatMessage.MessageType.AGENT_DOCUMENT) {
            this.setupAsDocument(fullImagePath, previewUri, loadStatus, fileType);
        } else {
            this.setupAsImage(fullImagePath, previewUri, loadStatus);
        }
    }

    private void setupAsImage(String fullImagePath, String previewUri, FilesTable.LoadStatus loadStatus) {
        if (!TextUtils.isEmpty((CharSequence)previewUri)) {
            this.setImageContent(Uri.parse((String)previewUri));
            this.mDownloadableFileViewProcessor.applyLoadStatusForDownloadFlow(loadStatus);
        } else if (!TextUtils.isEmpty((CharSequence)fullImagePath)) {
            this.setImageContent(Uri.parse((String)fullImagePath));
            this.mDownloadableFileViewProcessor.applyLoadStatusForUploadFlow(loadStatus);
        } else {
            this.mDownloadableFileViewProcessor.applyLoadStatusForDownloadFlow(FilesTable.LoadStatus.PREVIEW_ERROR);
            this.mMessageImageView.setImageResource(R.drawable.lp_messaging_ui_icon_image_broken);
        }
    }

    private void setImageContent(Uri imageUri) {
        Context context = this.itemView.getContext();
        RequestCreator creator = PicassoUtils.get((Context)context).load(new File(imageUri.getPath()));
        Drawable placeHolder = ImageUtils.getImagePlaceHolder(context);
        if (placeHolder != null) {
            creator.placeholder(placeHolder);
        }
        creator.error(R.drawable.lp_messaging_ui_icon_image_broken).centerCrop().fit().into(this.mMessageImageView);
    }

    public void updateContentDescriptionForImage() {
        Context context = this.getContext();
        if (context != null) {
            String agent = context.getString(R.string.lp_accessibility_agent);
            String image = context.getString(R.string.lp_accessibility_image);
            StringBuilder contentDescription = new StringBuilder();
            contentDescription.append(agent + " ").append(this.getNickName() + ": ").append(image + ", ");
            String caption = this.mMessageTextView.getText().toString();
            if (!TextUtils.isEmpty((CharSequence)caption)) {
                contentDescription.append(caption + ", ");
            }
            contentDescription.append(this.getContentDescriptionEnding());
            this.mMessageImageView.setContentDescription((CharSequence)contentDescription.toString());
        }
    }

    private void setupAsDocument(String fullImagePath, String previewUri, FilesTable.LoadStatus loadStatus, String extension) {
        FileSharingType fileSharingType = FileSharingType.getFileTypeFromExtension((String)extension.toLowerCase());
        this.setFileIcon(fileSharingType);
        this.updateContentDescriptionForDocument(fileSharingType);
        if (!TextUtils.isEmpty((CharSequence)previewUri)) {
            this.mDownloadableFileViewProcessor.applyLoadStatusForDownloadFlow(loadStatus);
        } else if (!TextUtils.isEmpty((CharSequence)fullImagePath)) {
            this.mDownloadableFileViewProcessor.applyLoadStatusForUploadFlow(loadStatus);
        } else {
            this.mDownloadableFileViewProcessor.applyLoadStatusForDownloadFlow(FilesTable.LoadStatus.PREVIEW_ERROR);
        }
    }

    public void updateContentDescriptionForDocument(FileSharingType fileSharingType) {
        Context context = this.getContext();
        if (context != null) {
            String agent = context.getString(R.string.lp_accessibility_agent);
            String document = context.getString(R.string.lp_accessibility_document);
            String documentType = AccessbilityUtilsKt.getAccessibilityNameForFileType(context, fileSharingType);
            StringBuilder contentDescription = new StringBuilder();
            contentDescription.append(agent + " ").append(this.getNickName() + ": ").append(documentType + ", ").append(document + ", ");
            String caption = this.mMessageTextView.getText().toString();
            if (!TextUtils.isEmpty((CharSequence)caption)) {
                contentDescription.append(caption + ", ");
            }
            contentDescription.append(this.getContentDescriptionEnding());
            this.mMessageImageView.setContentDescription((CharSequence)contentDescription.toString());
        }
    }

    public void setFileIcon(FileSharingType fileSharingType) {
        this.mMessageImageView.setImageResource(switch (fileSharingType) {
            case FileSharingType.PDF -> R.drawable.lp_pdf_thumbnail;
            case FileSharingType.DOCX -> R.drawable.lp_docx_thumbnail;
            case FileSharingType.XLSX -> R.drawable.lp_xlsx_thumbnail;
            case FileSharingType.PPTX -> R.drawable.lp_pptx_thumbnail;
            default -> R.drawable.lp_messaging_ui_icon_image_broken;
        });
    }
}

