/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent;

import android.content.Context;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.liveperson.infra.analytics.LPAnalytics;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.ContextualMovementMethod;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent.AmsAgentViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.base.ParticipantSCViewHolder;
import com.liveperson.infra.ui.view.resources.ResourceHelper;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.lp_structured_content.LPStructuredContent;
import com.liveperson.lp_structured_content.ui.OnSCActionClickListener;
import com.liveperson.lp_structured_content.ui.QRActionClickListener;
import com.liveperson.lp_structured_content.ui.visitor.StructuredContentContainerOperations;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.FullMessageRow;
import com.squareup.picasso.Callback;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

public class AmsAgentStructuredContentViewHolder
extends AmsAgentViewHolder
implements StructuredContentContainerOperations,
ParticipantSCViewHolder {
    private static final String TAG = "AmsAgentStructuredContentViewHolder";
    private ConstraintLayout mStructuredContentContainer;
    private ConstraintLayout mStructuredContentFrame;
    private LPStructuredContent lpStructuredContent;
    private boolean mIsQuickReply;
    private String mBrandId;

    public AmsAgentStructuredContentViewHolder(View itemView, String brandId) {
        super(itemView);
        this.mStructuredContentContainer = (ConstraintLayout)itemView.findViewById(R.id.lpui_agent_structured_content_container);
        this.mStructuredContentFrame = (ConstraintLayout)itemView.findViewById(R.id.lpui_structure_content_frame);
        this.mBrandId = brandId;
    }

    @Override
    public void applyColors() {
        ResourceHelper.updateBackgroundStrokeColor((View)this.mMessageTextView, (int)R.color.agent_bubble_stroke_color, (int)R.dimen.agent_bubble_stroke_width);
        ResourceHelper.updateBackgroundSolidColor((View)this.mMessageTextView, (int)R.color.agent_bubble_background_color);
    }

    @Override
    public void updateContentDescription() {
        String agentWord = this.itemView.getContext().getString(R.string.lp_accessibility_agent);
        CharSequence contentDescription = this.mStructuredContentContainer.getContentDescription();
        StringBuilder descriptionBuilder = new StringBuilder(contentDescription == null ? "" : contentDescription);
        if (this.mIsQuickReply) {
            View view = this.mStructuredContentContainer.getChildAt(0);
            if (view != null) {
                view.setContentDescription((CharSequence)descriptionBuilder.toString());
                ViewCompat.setImportantForAccessibility((View)this.itemView, (int)2);
                ViewCompat.setImportantForAccessibility((View)this.mStructuredContentContainer, (int)2);
            }
        } else {
            descriptionBuilder.insert(0, this.getNickName() + " ");
            descriptionBuilder.insert(0, agentWord + " ");
            descriptionBuilder.append(", ").append(this.getContentDescriptionEnding());
            this.setContentDescription(descriptionBuilder.toString());
        }
    }

    public void moveFocusToItself(long delay) {
        if (this.mIsQuickReply) {
            View internalView = this.mStructuredContentContainer.getChildAt(0);
            if (internalView != null) {
                internalView.postDelayed(() -> {
                    internalView.performAccessibilityAction(64, null);
                    LPLog.INSTANCE.d(TAG, "moveFocusToLast. isFocused = " + this.itemView.isAccessibilityFocused());
                }, delay);
            }
        } else {
            super.moveFocusToItself(delay);
        }
    }

    @Override
    public void setMessageText(String text) {
        this.mMessageTextView.setLinksClickable(true);
        ContextualMovementMethod method = new ContextualMovementMethod(this.mContextualActionBehavior, this.mOnLinkMovementListener);
        this.mMessageTextView.setMovementMethod((MovementMethod)method);
        this.setMessageTextView(text);
        URLSpan[] spans = this.mMessageTextView.getUrls();
        if (spans != null && spans.length > 0) {
            this.mMessageTextView.setImportantForAccessibility(1);
        } else {
            this.mMessageTextView.setImportantForAccessibility(2);
        }
    }

    @Override
    public void loadContent(FullMessageRow messageRow, OnSCActionClickListener globalListener, QRActionClickListener quickRepliesCloseAction, boolean isLastMessage, boolean isEnabledBySettings) {
        this.mTimestampTextView.setPadding(this.getTimeStampPadding(), 0, 0, 0);
        try {
            this.lpStructuredContent = new LPStructuredContent(this.itemView.getContext(), globalListener, quickRepliesCloseAction, (StructuredContentContainerOperations)this);
            this.subscribeToSCLogger();
            JSONObject root = new JSONObject(messageRow.getMessagingChatMessage().getMessage());
            boolean bl = this.mIsQuickReply = quickRepliesCloseAction != null;
            if (Boolean.TRUE.equals(this.lpStructuredContent.isStructuredContentEmpty(root))) {
                this.setVisibility(false);
            } else {
                for (int index = 0; index < this.mStructuredContentContainer.getChildCount(); ++index) {
                    this.mStructuredContentContainer.removeViewAt(index);
                }
                this.lpStructuredContent.setContainer(this.mStructuredContentContainer);
                this.lpStructuredContent.load(root, isLastMessage, isEnabledBySettings);
                this.updateContentDescription();
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000015D, "Failed to load Structure Content: ", (Throwable)e);
            this.failedToDisplayStructuredContent();
        }
    }

    private void failedToDisplayStructuredContent() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.mStructuredContentContainer.getContext());
        TextView textView = (TextView)layoutInflater.inflate(R.layout.lpmessaging_ui_chat_bubble_sc_element_text_view, (ViewGroup)this.mStructuredContentContainer, false);
        textView.setText(R.string.lp_structured_content_display_failed);
        this.mStructuredContentContainer.setContentDescription((CharSequence)textView.getContext().getString(R.string.lp_structured_content_display_failed));
        this.mStructuredContentContainer.addView((View)textView);
        textView.setBackground(ContextCompat.getDrawable((Context)this.itemView.getContext(), (int)R.drawable.vertical_border_line));
    }

    public void recycle() {
        super.recycle();
        this.mStructuredContentContainer.removeAllViews();
    }

    public void onStructuredContentLoaded() {
    }

    public void onQuickRepliesLoaded() {
        this.mTimestampTextView.setVisibility(4);
        this.mAgentAvatar.setVisibility(4);
    }

    public void startImageLoading(@NotNull ImageView imageView, final @NotNull String imageUrl) {
        PicassoUtils.get((Context)imageView.getContext()).load(imageUrl).error(R.drawable.lp_messaging_ui_icon_image_broken).into(imageView, new Callback(){

            public void onSuccess() {
            }

            public void onError(Exception e) {
                LPAuthenticationParams params = MessagingFactory.getInstance().getController().mAccountsController.getLPAuthenticationParams(AmsAgentStructuredContentViewHolder.this.mBrandId);
                if (params != null) {
                    LPAnalytics.ConsumerAction.INSTANCE.trackLoadSCImageFailed(params.getAuthType(), LocaleUtils.getInstance().getLocaleCode(), imageUrl, e != null ? e.getMessage() : "");
                } else {
                    LPLog.INSTANCE.d(AmsAgentStructuredContentViewHolder.TAG, "getLPAuthenticationParams: getLPAuthenticationParams returns null for brand with id: " + AmsAgentStructuredContentViewHolder.this.mBrandId);
                }
            }
        });
    }

    public void onCarouselScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    private int getTimeStampPadding() {
        return this.mAgentAvatar.getLayoutParams().width + ((ConstraintLayout.LayoutParams)this.mAgentAvatar.getLayoutParams()).rightMargin + ((ConstraintLayout.LayoutParams)this.mAgentAvatar.getLayoutParams()).leftMargin;
    }

    private void showTimestamp(boolean show) {
        int timeStampVisibility = show && this.isTimestampEnabled() ? 0 : 8;
        this.mTimestampTextView.setVisibility(timeStampVisibility);
    }

    public void setVisibility(boolean visible) {
        this.mStructuredContentFrame.setVisibility(visible ? 0 : 8);
        this.showTimestamp(visible);
        this.itemView.setVisibility(visible ? 0 : 8);
    }

    private void subscribeToSCLogger() {
        this.lpStructuredContent.subscribeToLogs((level, message) -> {
            switch (level) {
                case VERBOSE: {
                    LPLog.INSTANCE.v(TAG, message);
                    break;
                }
                case INFO: {
                    LPLog.INSTANCE.i(TAG, message);
                    break;
                }
                case WARNING: {
                    LPLog.INSTANCE.w(TAG, message);
                    break;
                }
                case ERROR: {
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000015C, message);
                    break;
                }
                default: {
                    LPLog.INSTANCE.d(TAG, message);
                }
            }
        });
    }
}

