/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent;

import android.content.Context;
import android.content.res.Resources;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.core.content.res.ResourcesCompat;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent.AmsAgentViewHolder;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.infra.ui.view.resources.ResourceHelper;
import com.liveperson.infra.ui.view.utils.ImageUrlUtil;
import com.liveperson.infra.utils.LinkPreviewCallback;
import com.liveperson.infra.utils.LinkPreviewLruCache;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.infra.utils.SourceContent;
import com.liveperson.infra.utils.TextCrawler;
import com.liveperson.messaging.MessagingFactory;
import com.squareup.picasso.Callback;
import org.json.JSONException;
import org.json.JSONObject;

public class AmsAgentURLViewHolder
extends AmsAgentViewHolder {
    private static final String TAG = "AmsAgentURLViewHolder";
    private static final String KEY_JSON_TAG_TITLE = "title";
    private static final String KEY_JSON_TAG_DESCRIPTION = "description";
    private static final String KEY_JSON_HEADER = "message_with_url";
    private static final String KEY_JSON_TAG_IMAGE_URL = "image_url";
    private static final String KEY_JSON_TAG_URL = "original_url_to_parse";
    private static final String KEY_JSON_TAG_SITE_NAME = "site_name_url_to_parse";
    private static final String KEY_JSON_TAG_MESSAGE = "original_message";
    private ImageView mMessageImageView;
    private TextView mDescription;
    private TextView mTitleMsg;
    private TextView mSiteName;
    private String mCurrentImageURL;
    private String mOriginalMessage;
    private String mCurrentUrl;
    private ProgressBar mGeneralProgressBarView;
    private LinearLayout mLayout;
    private boolean mIsLinkPreviewEnabled = true;
    private LinkPreviewCallback callback = new MyLinkPreviewCallback();

    public AmsAgentURLViewHolder(View itemView, ContextualActionBehavior contextualActionBehavior) {
        super(itemView);
        this.mMessageImageView = (ImageView)itemView.findViewById(R.id.lpui_message_image);
        this.mGeneralProgressBarView = (ProgressBar)itemView.findViewById(R.id.lpui_message_progress_bar_general);
        this.mDescription = (TextView)itemView.findViewById(R.id.lpui_message_description);
        this.mTitleMsg = (TextView)itemView.findViewById(R.id.lpui_title_message);
        this.mLayout = (LinearLayout)itemView.findViewById(R.id.lpui_image_message_view);
        this.mSiteName = (TextView)itemView.findViewById(R.id.lpui_message_site_name);
        this.mGeneralProgressBarView.setVisibility(0);
        this.mContextualActionBehavior = contextualActionBehavior;
        this.mLayout.setOnClickListener(v -> this.onLinkClick());
        this.mLayout.setOnLongClickListener(v -> this.onLinkLongClick());
        this.setMessageTextOnClickListener(view -> this.onTextClick());
        this.mIsLinkPreviewEnabled = Configuration.getBoolean((int)R.bool.link_preview_enable_feature);
    }

    private void onParsingErrorOccurred(String str) {
        super.setMessageText(str);
        this.mGeneralProgressBarView.setVisibility(8);
        this.mLayout.setVisibility(8);
        this.mMessageTextView.setBackground(ResourcesCompat.getDrawable((Resources)this.mLayout.getResources(), (int)R.drawable.lpinfra_ui_chat_bubble_start, null));
    }

    @Override
    public void setMessageText(String text) {
        if (!this.mIsLinkPreviewEnabled) {
            this.onLinkPreviewStatus();
        }
        if (!TextUtils.isEmpty((CharSequence)text)) {
            try {
                this.parseDataFromJson(text);
            }
            catch (JSONException exception) {
                super.setMessageText(text);
                if (this.mIsLinkPreviewEnabled) {
                    SourceContent sc = LinkPreviewLruCache.getInstance().getSourceContentFromCache(TextCrawler.prepareLink((String)text));
                    if (sc != null) {
                        if (sc.isSuccess()) {
                            this.parseDataFromCache(sc);
                        } else {
                            this.onParsingErrorOccurred(text);
                        }
                    } else {
                        this.parseDataFromHistory(text);
                    }
                }
            }
            catch (Throwable t) {
                super.setMessageText(text);
                this.parseDataFromHistory(text);
            }
            this.mMessageTextView.setVisibility(0);
        } else {
            this.mMessageTextView.setVisibility(8);
        }
    }

    private void parseDataFromHistory(String text) {
        TextCrawler mTextCrawler = new TextCrawler();
        this.callback = new MyLinkPreviewCallback();
        ((MyLinkPreviewCallback)this.callback).setText(text);
        mTextCrawler.makePreview(this.callback, text);
    }

    private void parseDataFromJson(String text) throws JSONException {
        JSONObject object = new JSONObject(text);
        JSONObject messageWithUrl = object.getJSONObject(KEY_JSON_HEADER);
        String title = messageWithUrl.getString(KEY_JSON_TAG_TITLE);
        String description = messageWithUrl.getString(KEY_JSON_TAG_DESCRIPTION);
        this.mCurrentImageURL = messageWithUrl.getString(KEY_JSON_TAG_IMAGE_URL);
        this.mCurrentUrl = messageWithUrl.getString(KEY_JSON_TAG_URL);
        this.mOriginalMessage = messageWithUrl.getString(KEY_JSON_TAG_MESSAGE);
        String siteName = messageWithUrl.getString(KEY_JSON_TAG_SITE_NAME);
        if (this.mGeneralProgressBarView != null) {
            this.mGeneralProgressBarView.setVisibility(8);
        }
        if (!this.mCurrentImageURL.isEmpty()) {
            this.setMessageImage();
        } else {
            this.clearImage();
        }
        this.mDescription.setText((CharSequence)Html.fromHtml((String)description));
        this.mDescription.setVisibility(this.mDescription.getText().length() > 0 ? 0 : 8);
        this.mTitleMsg.setText((CharSequence)Html.fromHtml((String)title));
        this.mTitleMsg.setVisibility(this.mTitleMsg.getText().length() > 0 ? 0 : 8);
        this.mSiteName.setText((CharSequence)Html.fromHtml((String)siteName));
        this.mSiteName.setVisibility(this.mSiteName.getText().length() > 0 ? 0 : 8);
        this.setMessageTextAfter();
    }

    private void parseDataFromCache(SourceContent sc) {
        this.mTitleMsg.setText((CharSequence)Html.fromHtml((String)sc.getTitle()));
        this.mTitleMsg.setVisibility(this.mTitleMsg.getText().length() > 0 ? 0 : 8);
        if (this.mIsLinkPreviewEnabled) {
            this.mDescription.setText((CharSequence)Html.fromHtml((String)sc.getDescription()));
            this.mDescription.setVisibility(this.mDescription.getText().length() > 0 ? 0 : 8);
            this.mSiteName.setText((CharSequence)Html.fromHtml((String)sc.getSiteName()));
            this.mSiteName.setVisibility(this.mSiteName.getText().length() > 0 ? 0 : 8);
            this.mLayout.setVisibility(0);
            if (this.mGeneralProgressBarView != null) {
                this.mGeneralProgressBarView.setVisibility(8);
            }
            this.mCurrentUrl = sc.getUrl();
            this.mCurrentImageURL = sc.getImages();
            if (!this.mCurrentImageURL.isEmpty()) {
                this.setMessageImage();
            } else {
                this.clearImage();
            }
        }
    }

    private void clearImage() {
        this.mMessageImageView.setVisibility(8);
        this.mMessageImageView.setImageDrawable(null);
        if (this.mGeneralProgressBarView != null) {
            this.mGeneralProgressBarView.setVisibility(8);
        }
    }

    private void setMessageImage() {
        if (this.mCurrentImageURL.isEmpty()) {
            this.mMessageImageView.post(this::clearImage);
            return;
        }
        this.mMessageImageView.post(() -> {
            this.mCurrentImageURL = ImageUrlUtil.completeToValidImageUrl((String)this.mCurrentUrl, (String)this.mCurrentImageURL);
            if (!this.mCurrentImageURL.isEmpty()) {
                PicassoUtils.get((Context)this.mMessageImageView.getContext()).load(this.mCurrentImageURL).resize(250, 250).onlyScaleDown().centerCrop().into(this.mMessageImageView, new Callback(){

                    public void onSuccess() {
                        AmsAgentURLViewHolder.this.mMessageImageView.setVisibility(0);
                    }

                    public void onError(Exception e) {
                        AmsAgentURLViewHolder.this.mMessageImageView.setVisibility(8);
                    }
                });
            }
        });
    }

    @Override
    public void updateContentDescription() {
        Context context = this.getContext();
        if (context != null) {
            String agentWord = context.getResources().getString(R.string.lp_accessibility_agent);
            String linkWord = context.getResources().getString(R.string.lp_accessibility_link);
            this.setContentDescription(agentWord + " " + this.getNickName() + ": " + this.getTextToCopy() + ", " + linkWord + ", " + this.getContentDescriptionEnding());
            this.mMessageTextView.setContentDescription((CharSequence)(this.getTextToCopy() + ", " + linkWord + " " + this.getContentDescriptionEnding()));
        }
    }

    @Override
    public void applyColors() {
        ResourceHelper.updateTextColor((TextView)this.mDescription, (int)R.color.agent_bubble_link_preview_description_text_color);
        ResourceHelper.updateTextColor((TextView)this.mTitleMsg, (int)R.color.agent_bubble_link_preview_title_text_color);
        ResourceHelper.updateBackgroundStrokeColor((View)this.mLayout, (int)R.color.agent_bubble_link_preview_background_stroke_color, (int)R.dimen.agent_bubble_link_preview_background_stroke_width);
        ResourceHelper.updateBackgroundSolidColor((View)this.mLayout, (int)R.color.agent_bubble_link_preview_background_color);
    }

    public void recycle() {
        super.recycle();
        if (this.callback != null) {
            ((MyLinkPreviewCallback)this.callback).setCancelled(true);
        }
        this.mMessageImageView.setImageDrawable(null);
        this.mMessageImageView.setVisibility(8);
        this.mGeneralProgressBarView.setVisibility(0);
        this.mMessageTextView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        this.mMessageTextView.setBackground(ResourcesCompat.getDrawable((Resources)this.mLayout.getResources(), (int)R.drawable.lpinfra_ui_chat_url_bubble_top_start, null));
        this.mLayout.setVisibility(0);
        this.mTitleMsg.setText((CharSequence)"");
        this.mTitleMsg.setVisibility(this.mTitleMsg.getText().length() > 0 ? 0 : 8);
        this.mDescription.setText((CharSequence)"");
        this.mDescription.setVisibility(this.mDescription.getText().length() > 0 ? 0 : 8);
        this.mSiteName.setText((CharSequence)"");
        this.mSiteName.setVisibility(this.mSiteName.getText().length() > 0 ? 0 : 8);
    }

    private void onLinkClick() {
        if (this.mContextualActionBehavior.isSelectable()) {
            View.OnClickListener listener = this.mContextualActionBehavior.getOnClickListener(this.getTimestampAsInteger(), (BaseViewHolder)this, null);
            this.setContextualBehaviorOnClick(listener);
        } else {
            String link = this.mCurrentUrl;
            if (link != null) {
                if (Configuration.getBoolean((int)R.bool.lp_message_link_as_callback)) {
                    MessagingFactory.getInstance().getController().mEventsProxy.onLinkClicked(link);
                } else {
                    this.mContextualActionBehavior.getContextualItemAction().performOpenLink(link, false, this.getLinkType());
                }
            }
        }
    }

    private void setMessageTextAfter() {
        super.setMessageText(this.mOriginalMessage);
    }

    private void onLinkPreviewStatus() {
        if (!this.mIsLinkPreviewEnabled) {
            this.mGeneralProgressBarView.setVisibility(8);
            this.mLayout.setVisibility(8);
            this.mMessageTextView.setBackground(ResourcesCompat.getDrawable((Resources)this.mLayout.getResources(), (int)R.drawable.lpinfra_ui_chat_bubble_start, null));
        }
    }

    private class MyLinkPreviewCallback
    implements LinkPreviewCallback {
        boolean isCancelled = false;
        private String text;

        private MyLinkPreviewCallback() {
        }

        void setCancelled(boolean cancelled) {
            this.isCancelled = cancelled;
        }

        private boolean validateSufficientConditionsToDisplayPreview(SourceContent sourceContent) {
            int counter = 0;
            counter = sourceContent.getSiteName().isEmpty() ? --counter : ++counter;
            counter = sourceContent.getDescription().isEmpty() ? --counter : ++counter;
            counter = sourceContent.getTitle().isEmpty() ? --counter : ++counter;
            counter = sourceContent.getImages().isEmpty() ? --counter : ++counter;
            return counter >= 0;
        }

        public void onPos(SourceContent sourceContent, boolean isNull) {
            if (this.isCancelled) {
                return;
            }
            if (isNull || sourceContent.getFinalUrl().equals("")) {
                LPLog.INSTANCE.e(AmsAgentURLViewHolder.TAG, ErrorCode.ERR_0000010E, "Could not parse malformed JSON nor from history");
                AmsAgentURLViewHolder.this.onParsingErrorOccurred(this.text);
            } else if (this.validateSufficientConditionsToDisplayPreview(sourceContent)) {
                if (AmsAgentURLViewHolder.this.mGeneralProgressBarView != null) {
                    AmsAgentURLViewHolder.this.mGeneralProgressBarView.setVisibility(8);
                }
                AmsAgentURLViewHolder.this.mCurrentImageURL = sourceContent.getImages();
                AmsAgentURLViewHolder.this.mTitleMsg.setText((CharSequence)Html.fromHtml((String)sourceContent.getTitle()));
                AmsAgentURLViewHolder.this.mTitleMsg.setVisibility(AmsAgentURLViewHolder.this.mTitleMsg.getText().length() > 0 ? 0 : 8);
                AmsAgentURLViewHolder.this.mDescription.setText((CharSequence)Html.fromHtml((String)sourceContent.getDescription()));
                AmsAgentURLViewHolder.this.mDescription.setVisibility(AmsAgentURLViewHolder.this.mDescription.getText().length() > 0 ? 0 : 8);
                AmsAgentURLViewHolder.this.mSiteName.setText((CharSequence)Html.fromHtml((String)sourceContent.getSiteName()));
                AmsAgentURLViewHolder.this.mSiteName.setVisibility(AmsAgentURLViewHolder.this.mSiteName.getText().length() > 0 ? 0 : 8);
                AmsAgentURLViewHolder.this.mOriginalMessage = AmsAgentURLViewHolder.this.mCurrentUrl = sourceContent.getUrl();
                if (AmsAgentURLViewHolder.this.mCurrentImageURL.isEmpty()) {
                    AmsAgentURLViewHolder.this.clearImage();
                } else {
                    AmsAgentURLViewHolder.this.setMessageImage();
                }
                LinkPreviewLruCache.getInstance().addSourceContentToCache(sourceContent);
            } else {
                LPLog.INSTANCE.e(AmsAgentURLViewHolder.TAG, ErrorCode.ERR_0000010F, "not null but insufficient to parse");
                sourceContent.setSuccess(false);
                LinkPreviewLruCache.getInstance().addSourceContentToCache(sourceContent);
                AmsAgentURLViewHolder.this.onParsingErrorOccurred(this.text);
            }
        }

        public void clean() {
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

