/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder.base;

import android.view.View;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.fragment.ConversationViewCallback;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.base.ParticipantFileViewHolder;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.base.ParticipantViewHolderUtils;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.base.utils.QueryDialogCallbackImpl;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.FullMessageRow;
import com.liveperson.messaging.model.MessagingChatMessage;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a?\u0010\u0002\u001a\u00020\u0003\"\f\b\u0000\u0010\u0004*\u00020\u0005*\u00020\u0006*\u0002H\u00042\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a/\u0010\u000f\u001a\u00020\u0010\"\f\b\u0000\u0010\u0004*\u00020\u0005*\u00020\u0006*\u0002H\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a2\u0006\u0002\u0010\u0011\u001a?\u0010\u0012\u001a\u00020\u0003\"\f\b\u0000\u0010\u0004*\u00020\u0005*\u00020\u0006*\u0002H\u00042\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000e\u001a)\u0010\u0013\u001a\u00020\u0003\"\f\b\u0000\u0010\u0004*\u00020\u0005*\u00020\u0006*\u0002H\u00042\u0006\u0010\u0014\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"TAG", "", "performDownloadRequestClick", "", "T", "Lcom/liveperson/infra/messaging_ui/view/adapter/viewholder/base/ParticipantFileViewHolder;", "Lcom/liveperson/infra/ui/view/adapter/viewholder/BaseViewHolder;", "brandId", "row", "Lcom/liveperson/messaging/model/FullMessageRow;", "behavior", "Lcom/liveperson/infra/messaging_ui/view/adapter/copybehavior/ContextualActionBehavior;", "conversationViewCallback", "Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;", "(Lcom/liveperson/infra/ui/view/adapter/viewholder/BaseViewHolder;Ljava/lang/String;Lcom/liveperson/messaging/model/FullMessageRow;Lcom/liveperson/infra/messaging_ui/view/adapter/copybehavior/ContextualActionBehavior;Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;)V", "performImageLongClick", "", "(Lcom/liveperson/infra/ui/view/adapter/viewholder/BaseViewHolder;Lcom/liveperson/messaging/model/FullMessageRow;Lcom/liveperson/infra/messaging_ui/view/adapter/copybehavior/ContextualActionBehavior;)Z", "registerListeners", "setFileData", "message", "setData", "(Lcom/liveperson/infra/ui/view/adapter/viewholder/BaseViewHolder;Lcom/liveperson/messaging/model/FullMessageRow;)V", "messaging_ui_release"})
@JvmName(name="ParticipantFileViewHolderUtils")
public final class ParticipantFileViewHolderUtils {
    @NotNull
    private static final String TAG = "ParticipantFileViewHolderUtils";

    @JvmName(name="setData")
    public static final <T extends BaseViewHolder> void setData(@NotNull T $this$setFileData, @NotNull FullMessageRow message) {
        block0: {
            Intrinsics.checkNotNullParameter($this$setFileData, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            ((ParticipantFileViewHolder)$this$setFileData).setParticipantAvatar(message.getAgentAvatar());
            ((ParticipantFileViewHolder)$this$setFileData).setParticipantNickName(message.getAgentNickName());
            MessagingChatMessage messagingChatMessage = message.getMessagingChatMessage();
            Intrinsics.checkNotNullExpressionValue((Object)messagingChatMessage, (String)"message.messagingChatMessage");
            ParticipantViewHolderUtils.setData($this$setFileData, messagingChatMessage);
            FileMessage fileMessage = message.getFileMessage();
            if (fileMessage == null) break block0;
            FileMessage $this$setFileData_u24lambda_u240 = fileMessage;
            boolean bl = false;
            ((ParticipantFileViewHolder)$this$setFileData).getFileProcessor().setFileRowId($this$setFileData_u24lambda_u240.getFileRowId());
            ((ParticipantFileViewHolder)$this$setFileData).setMessageContent($this$setFileData_u24lambda_u240.getLocalUrl(), $this$setFileData_u24lambda_u240.getPreview(), $this$setFileData_u24lambda_u240.getLoadStatus(), $this$setFileData_u24lambda_u240.getFileType());
        }
    }

    public static final <T extends BaseViewHolder> void registerListeners(@NotNull T $this$registerListeners, @NotNull String brandId, @NotNull FullMessageRow row, @NotNull ContextualActionBehavior behavior, @Nullable ConversationViewCallback conversationViewCallback) {
        Intrinsics.checkNotNullParameter($this$registerListeners, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)brandId, (String)"brandId");
        Intrinsics.checkNotNullParameter((Object)row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)behavior, (String)"behavior");
        if (conversationViewCallback != null) {
            ((ParticipantFileViewHolder)$this$registerListeners).setContextualActionBehavior(behavior);
            ((ParticipantFileViewHolder)$this$registerListeners).setOnImageClickListener(arg_0 -> ParticipantFileViewHolderUtils.registerListeners$lambda$1($this$registerListeners, brandId, row, behavior, conversationViewCallback, arg_0));
            ((ParticipantFileViewHolder)$this$registerListeners).setOnImageLongClickListener(arg_0 -> ParticipantFileViewHolderUtils.registerListeners$lambda$2($this$registerListeners, row, behavior, arg_0));
        }
    }

    private static final <T extends BaseViewHolder> boolean performImageLongClick(T $this$performImageLongClick, FullMessageRow row, ContextualActionBehavior behavior) {
        FileMessage fileMessage = row.getFileMessage();
        Intrinsics.checkNotNullExpressionValue((Object)fileMessage, (String)"row.fileMessage");
        FileMessage onClickFileMessage = fileMessage;
        MessagingChatMessage messagingChatMessage = row.getMessagingChatMessage();
        if (messagingChatMessage == null) {
            return false;
        }
        MessagingChatMessage messagingChatMessage2 = messagingChatMessage;
        View.OnLongClickListener longClickListener = behavior.getOnLongClickListener((int)messagingChatMessage2.getTimeStamp(), $this$performImageLongClick, onClickFileMessage);
        return $this$performImageLongClick.setContextualBehaviorOnLongClick(longClickListener);
    }

    private static final <T extends BaseViewHolder> void performDownloadRequestClick(T $this$performDownloadRequestClick, String brandId, FullMessageRow row, ContextualActionBehavior behavior, ConversationViewCallback conversationViewCallback) {
        CharSequence listener2;
        MessagingChatMessage messagingChatMessage = row.getMessagingChatMessage();
        if (messagingChatMessage == null) {
            return;
        }
        MessagingChatMessage chatMessage = messagingChatMessage;
        FileMessage file = row.getFileMessage();
        if (file == null) {
            LPLog.INSTANCE.d(TAG, "file message is null, cannot download or open file");
            return;
        }
        FileMessage mostUpdatedFileMessage = file;
        if (behavior.isSelectable()) {
            int timestamp = (int)chatMessage.getTimeStamp();
            View.OnClickListener listener2 = behavior.getOnClickListener(timestamp, $this$performDownloadRequestClick, mostUpdatedFileMessage);
            $this$performDownloadRequestClick.setContextualBehaviorOnClick(listener2);
            return;
        }
        boolean isConnected = MessagingFactory.getInstance().getController().mConnectionController.isSocketReady(brandId);
        if (!isConnected && ((listener2 = (CharSequence)mostUpdatedFileMessage.getLocalUrl()) == null || listener2.length() == 0)) {
            ((ParticipantFileViewHolder)$this$performDownloadRequestClick).getFileProcessor().startFailedAnimation();
        } else {
            QueryDialogCallbackImpl callback2 = new QueryDialogCallbackImpl(conversationViewCallback, row);
            MessagingFactory.getInstance().getController().amsDialogs.getDialogByIdAsync(chatMessage.getDialogId(), (ICallback)callback2);
        }
    }

    private static final void registerListeners$lambda$1(BaseViewHolder $this_registerListeners, String $brandId, FullMessageRow $row, ContextualActionBehavior $behavior, ConversationViewCallback $conversationViewCallback, View it) {
        Intrinsics.checkNotNullParameter((Object)$this_registerListeners, (String)"$this_registerListeners");
        Intrinsics.checkNotNullParameter((Object)$brandId, (String)"$brandId");
        Intrinsics.checkNotNullParameter((Object)$row, (String)"$row");
        Intrinsics.checkNotNullParameter((Object)$behavior, (String)"$behavior");
        ParticipantFileViewHolderUtils.performDownloadRequestClick($this_registerListeners, $brandId, $row, $behavior, $conversationViewCallback);
    }

    private static final boolean registerListeners$lambda$2(BaseViewHolder $this_registerListeners, FullMessageRow $row, ContextualActionBehavior $behavior, View it) {
        Intrinsics.checkNotNullParameter((Object)$this_registerListeners, (String)"$this_registerListeners");
        Intrinsics.checkNotNullParameter((Object)$row, (String)"$row");
        Intrinsics.checkNotNullParameter((Object)$behavior, (String)"$behavior");
        return ParticipantFileViewHolderUtils.performImageLongClick($this_registerListeners, $row, $behavior);
    }
}

