/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder.base.utils;

import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.fragment.ConversationViewCallback;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.FileMessage;
import com.liveperson.messaging.model.FullMessageRow;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u00122\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003j\u0002`\u00040\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u000b2\u000e\u0010\u000f\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u0016J\u0012\u0010\u0010\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/liveperson/infra/messaging_ui/view/adapter/viewholder/base/utils/QueryDialogCallbackImpl;", "Lcom/liveperson/infra/ICallback;", "Lcom/liveperson/messaging/model/Dialog;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "conversationViewCallback", "Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;", "fullMessageRow", "Lcom/liveperson/messaging/model/FullMessageRow;", "(Lcom/liveperson/infra/messaging_ui/fragment/ConversationViewCallback;Lcom/liveperson/messaging/model/FullMessageRow;)V", "handleOnClick", "", "conversationId", "", "onError", "exception", "onSuccess", "value", "Companion", "messaging_ui_release"})
public final class QueryDialogCallbackImpl
implements ICallback<Dialog, Exception> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConversationViewCallback conversationViewCallback;
    @NotNull
    private final FullMessageRow fullMessageRow;
    @NotNull
    private static final String TAG = "QueryDialogCallbackImpl";

    public QueryDialogCallbackImpl(@NotNull ConversationViewCallback conversationViewCallback, @NotNull FullMessageRow fullMessageRow) {
        Intrinsics.checkNotNullParameter((Object)conversationViewCallback, (String)"conversationViewCallback");
        Intrinsics.checkNotNullParameter((Object)fullMessageRow, (String)"fullMessageRow");
        this.conversationViewCallback = conversationViewCallback;
        this.fullMessageRow = fullMessageRow;
    }

    public void onSuccess(@Nullable Dialog value) {
        Dialog dialog = value;
        this.handleOnClick(dialog != null ? dialog.getDialogId() : null);
    }

    public void onError(@Nullable Exception exception) {
        this.handleOnClick(this.fullMessageRow.getMessagingChatMessage().getDialogId());
    }

    private final void handleOnClick(String conversationId) {
        FileSharingType fileSharingType;
        FileMessage mostUpdatedFileMessage = this.fullMessageRow.getFileMessage();
        try {
            String string2 = mostUpdatedFileMessage.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mostUpdatedFileMessage.fileType");
            fileSharingType = FileSharingType.valueOf((String)string2);
        }
        catch (IllegalArgumentException e) {
            String message = "Unknown file sharing type: " + mostUpdatedFileMessage.getFileType();
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F3, message, (Throwable)e);
            fileSharingType = FileSharingType.UNKNOWN;
        }
        FileSharingType fileSharingType2 = fileSharingType;
        try {
            this.conversationViewCallback.onFileClicked(fileSharingType2, mostUpdatedFileMessage.getLocalUrl(), mostUpdatedFileMessage.getSwiftPath(), this.fullMessageRow.getMessagingChatMessage().getLocalId(), mostUpdatedFileMessage.getFileRowId(), conversationId);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000F4, "Failed to perform file action.", (Throwable)e);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/liveperson/infra/messaging_ui/view/adapter/viewholder/base/utils/QueryDialogCallbackImpl$Companion;", "", "()V", "TAG", "", "messaging_ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

