/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder.bot;

import android.text.style.URLSpan;
import android.view.View;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.bot.AmsBotViewHolder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/liveperson/infra/messaging_ui/view/adapter/viewholder/bot/AmsBotMarkdownHyperlinkViewHolder;", "Lcom/liveperson/infra/messaging_ui/view/adapter/viewholder/bot/AmsBotViewHolder;", "itemView", "Landroid/view/View;", "(Landroid/view/View;)V", "markdownFormatText", "", "getTextToCopy", "setMessageText", "", "text", "updateContentDescription", "messaging_ui_release"})
public final class AmsBotMarkdownHyperlinkViewHolder
extends AmsBotViewHolder {
    @NotNull
    private String markdownFormatText;

    public AmsBotMarkdownHyperlinkViewHolder(@NotNull View itemView) {
        Intrinsics.checkNotNullParameter((Object)itemView, (String)"itemView");
        super(itemView);
        this.markdownFormatText = "";
    }

    @Override
    public void setMessageText(@Nullable String text) {
        String string2 = text;
        if (string2 == null) {
            string2 = "";
        }
        this.markdownFormatText = string2;
        super.setMessageText(text);
    }

    @NotNull
    public String getTextToCopy() {
        if (Configuration.getBoolean((int)R.bool.lp_markdown_hyperlink_copy_text_only)) {
            String string2 = super.getTextToCopy();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"super.getTextToCopy()");
            return string2;
        }
        return this.markdownFormatText;
    }

    @Override
    public void updateContentDescription() {
        URLSpan[] uRLSpanArray = this.mMessageTextView.getUrls();
        int urlsCount = uRLSpanArray != null ? uRLSpanArray.length : 0;
        String string2 = this.getContext().getResources().getString(R.string.lp_accessibility_bot);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"context.resources.getStr\u2026ing.lp_accessibility_bot)");
        String beginning = string2;
        Object[] objectArray = new Object[]{urlsCount};
        String string3 = this.getContext().getResources().getQuantityString(R.plurals.lp_accessibility_links, urlsCount, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"context.resources.getQua\u2026ks, urlsCount, urlsCount)");
        String linkWord = string3;
        this.mMessageTextView.setContentDescription((CharSequence)(this.mMessageTextView.getText() + ", " + linkWord + ", " + this.getContentDescriptionEnding()));
        this.setContentDescription(beginning + " " + this.getNickName() + " : " + this.mMessageTextView.getText() + ", " + linkWord + " " + this.getContentDescriptionEnding());
    }
}

