/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder.brand;

import android.content.Context;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.ContextualMovementMethod;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.ui.view.adapter.viewholder.StartViewHolder;
import com.liveperson.infra.ui.view.resources.ResourceHelper;

public class AmsBrandMsgViewHolder
extends StartViewHolder {
    private ImageView mAgentAvatar;
    protected ContextualActionBehavior mContextualActionBehavior;
    protected ContextualMovementMethod.OnLinkMovementListener mOnLinkMovementListener;

    public AmsBrandMsgViewHolder(View itemView, ContextualActionBehavior contextualActionBehavior) {
        super(itemView);
        this.mContextualActionBehavior = contextualActionBehavior;
        this.mAgentAvatar = (ImageView)itemView.findViewById(R.id.lpui_brand_bubbleAvatar);
        this.applyColors();
    }

    public void applyColors() {
        ResourceHelper.updateBackgroundStrokeColor((View)this.mMessageTextView, (int)R.color.brand_bubble_stroke_color, (int)R.dimen.brand_bubble_stroke_width);
        ResourceHelper.updateBackgroundSolidColor((View)this.mMessageTextView, (int)R.color.brand_bubble_background_color);
        ResourceHelper.updateTextColor((TextView)this.mMessageTextView, (int)R.color.brand_bubble_message_text_color);
        ResourceHelper.updateTextColor((TextView)this.mTimestampTextView, (int)R.color.brand_bubble_timestamp_text_color);
        ResourceHelper.updateTextColorLink((TextView)this.mMessageTextView, (int)R.color.brand_bubble_message_link_text_color);
        this.mAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_brand_logo);
    }

    public void updateContentDescription() {
        Context context = this.getContext();
        if (context != null) {
            String agentWord = context.getResources().getString(R.string.lp_accessibility_agent);
            this.setContentDescription(agentWord + ": " + this.mMessageTextView.getText().toString() + ", " + this.getContentDescriptionEnding());
        }
    }

    public void setOnLinkMovementListener(@Nullable ContextualMovementMethod.OnLinkMovementListener onLinkMovementListener) {
        this.mOnLinkMovementListener = onLinkMovementListener;
    }

    public void setMessageText(String text) {
        this.mMessageTextView.setAutoLinkMask(0);
        this.mMessageTextView.setLinksClickable(true);
        ContextualMovementMethod method = new ContextualMovementMethod(this.mContextualActionBehavior, this.mOnLinkMovementListener);
        this.mMessageTextView.setMovementMethod((MovementMethod)method);
        this.setMessageTextView(text);
        URLSpan[] spans = this.mMessageTextView.getUrls();
        if (spans != null && spans.length > 0) {
            ViewCompat.enableAccessibleClickableSpanSupport((View)this.mMessageTextView);
            this.mMessageTextView.setImportantForAccessibility(1);
        }
    }

    protected String getContentDescriptionEnding() {
        String receivedWord = Configuration.getString((int)R.string.lp_accessibility_received);
        String descriptionEnding = Configuration.getBoolean((int)R.bool.lp_announce_message_status_first) ? receivedWord + " " + this.mTimestampAccessibilityString : this.mTimestampAccessibilityString + " " + receivedWord;
        return descriptionEnding;
    }

    protected int getMarkdownLinkColor() {
        return ContextCompat.getColor((Context)this.getContext(), (int)R.color.brand_bubble_message_link_text_color);
    }
}

