/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder.consumer;

import android.content.Context;
import android.os.Handler;
import android.text.Html;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.consumer.AmsConsumerViewHolder;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.infra.ui.view.resources.ResourceHelper;
import com.liveperson.infra.ui.view.utils.ImageUrlUtil;
import com.liveperson.infra.utils.LinkPreviewCallback;
import com.liveperson.infra.utils.LinkPreviewLruCache;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.infra.utils.SourceContent;
import com.liveperson.infra.utils.TextCrawler;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.squareup.picasso.Callback;
import org.json.JSONException;
import org.json.JSONObject;

public class AmsConsumerURLViewHolder
extends AmsConsumerViewHolder {
    private static final String TAG = "AmsConsumerURLViewHolder";
    private static final String KEY_JSON_TAG_TITLE = "title";
    private static final String KEY_JSON_TAG_DESCRIPTION = "description";
    private static final String KEY_JSON_HEADER = "message_with_url";
    private static final String KEY_JSON_TAG_IMAGE_URL = "image_url";
    private static final String KEY_JSON_TAG_MESSAGE = "original_message";
    private static final String KEY_JSON_TAG_URL = "original_url_to_parse";
    private static final String KEY_JSON_TAG_SITE_NAME = "site_name_url_to_parse";
    private ImageView mMessageImageView;
    private LinearLayout mLayout;
    private TextView mDescription;
    private TextView mTitleMsg;
    private TextView mSiteName;
    private String mCurrentImageURL;
    private ProgressBar mGeneralProgressBarView;
    private String mOriginalMessage;
    private String mCurrentUrl;
    private boolean mIsLinkPreviewEnabled = true;
    private LinkPreviewCallback callback = new MyLinkPreviewCallback();

    public AmsConsumerURLViewHolder(View itemView, MessagingChatMessage.MessageType messageType, ContextualActionBehavior contextualActionBehavior) {
        super(itemView, messageType);
        this.mMessageImageView = (ImageView)itemView.findViewById(R.id.lpui_message_image);
        this.mGeneralProgressBarView = (ProgressBar)itemView.findViewById(R.id.lpui_message_progress_bar_general);
        this.mDescription = (TextView)itemView.findViewById(R.id.lpui_message_description);
        this.mTitleMsg = (TextView)itemView.findViewById(R.id.lpui_title_message);
        this.mSiteName = (TextView)itemView.findViewById(R.id.lpui_message_site_name);
        this.mLayout = (LinearLayout)itemView.findViewById(R.id.lpui_image_message_view);
        this.mGeneralProgressBarView.setVisibility(0);
        this.mContextualActionBehavior = contextualActionBehavior;
        this.mLayout.setOnClickListener(view -> this.onLinkClick());
        this.mLayout.setOnLongClickListener(view -> this.onLinkLongClick());
        this.setMessageTextOnClickListener(view -> this.onTextClick());
        this.mIsLinkPreviewEnabled = Configuration.getBoolean((int)R.bool.link_preview_enable_feature);
    }

    private void onParsingErrorOccurred(String str) {
        super.setMessageText(str);
        this.mGeneralProgressBarView.setVisibility(8);
        this.mLayout.setVisibility(8);
        this.mMessageTextView.setBackgroundResource(R.drawable.lpmessaging_ui_consumer_bubble_background);
        this.mMessageTextView.invalidate();
    }

    @Override
    public void setMessageText(String text) {
        if (!this.mIsLinkPreviewEnabled) {
            this.onLinkPreviewStatus();
        }
        if (!TextUtils.isEmpty((CharSequence)text)) {
            try {
                this.parseDataFromJson(text);
            }
            catch (JSONException exception) {
                super.setMessageText(text);
                if (this.mIsLinkPreviewEnabled) {
                    SourceContent sc = LinkPreviewLruCache.getInstance().getSourceContentFromCache(TextCrawler.prepareLink((String)text));
                    if (sc != null) {
                        if (sc.isSuccess()) {
                            this.parseDataFromCache(sc);
                        } else {
                            this.onParsingErrorOccurred(text);
                        }
                    } else {
                        this.parseDataFromHistory(text);
                    }
                }
            }
            catch (Throwable t) {
                super.setMessageText(text);
                this.parseDataFromHistory(text);
            }
            this.mMessageTextView.setVisibility(0);
        } else {
            this.mMessageTextView.setVisibility(8);
        }
    }

    private void parseDataFromJson(String text) throws JSONException {
        JSONObject object = new JSONObject(text);
        JSONObject messageWithUrl = object.getJSONObject(KEY_JSON_HEADER);
        String title = messageWithUrl.getString(KEY_JSON_TAG_TITLE);
        String description = messageWithUrl.getString(KEY_JSON_TAG_DESCRIPTION);
        this.mCurrentImageURL = messageWithUrl.getString(KEY_JSON_TAG_IMAGE_URL);
        this.mOriginalMessage = messageWithUrl.getString(KEY_JSON_TAG_MESSAGE);
        this.mCurrentUrl = messageWithUrl.getString(KEY_JSON_TAG_URL);
        String siteName = messageWithUrl.getString(KEY_JSON_TAG_SITE_NAME);
        if (this.mGeneralProgressBarView != null) {
            this.mGeneralProgressBarView.setVisibility(8);
        }
        if (!this.mCurrentImageURL.isEmpty()) {
            this.setMessageImage();
        } else {
            this.clearImage();
        }
        this.mDescription.setText((CharSequence)Html.fromHtml((String)description));
        this.mDescription.setVisibility(this.mDescription.getText().length() > 0 ? 0 : 8);
        this.mTitleMsg.setText((CharSequence)Html.fromHtml((String)title));
        this.mTitleMsg.setVisibility(this.mTitleMsg.getText().length() > 0 ? 0 : 8);
        this.mSiteName.setText((CharSequence)Html.fromHtml((String)siteName));
        this.mSiteName.setVisibility(this.mSiteName.getText().length() > 0 ? 0 : 8);
        if (this.mIsLinkPreviewEnabled) {
            this.mLayout.setVisibility(0);
        }
        this.applyMessageTextWidth();
        this.applyPreviewVisibility();
        super.setMessageText(this.mOriginalMessage);
    }

    private void parseDataFromCache(SourceContent sc) {
        if (!this.validateSufficientConditionsToDisplayPreview(sc)) {
            return;
        }
        this.mTitleMsg.setText((CharSequence)Html.fromHtml((String)sc.getTitle()));
        this.mTitleMsg.setVisibility(this.mTitleMsg.getText().length() > 0 ? 0 : 8);
        if (this.mIsLinkPreviewEnabled) {
            this.mDescription.setText((CharSequence)Html.fromHtml((String)sc.getDescription()));
            this.mDescription.setVisibility(this.mDescription.getText().length() > 0 ? 0 : 8);
            this.mSiteName.setText((CharSequence)Html.fromHtml((String)sc.getSiteName()));
            this.mSiteName.setVisibility(this.mSiteName.getText().length() > 0 ? 0 : 8);
            this.mLayout.setVisibility(0);
            if (this.mGeneralProgressBarView != null) {
                this.mGeneralProgressBarView.setVisibility(8);
            }
            this.mCurrentUrl = sc.getUrl();
            this.mCurrentImageURL = sc.getImages();
            if (!this.mCurrentImageURL.isEmpty()) {
                this.setMessageImage();
            } else {
                this.clearImage();
            }
            this.applyMessageTextWidth();
            this.mLayout.setVisibility(0);
        }
    }

    private void parseDataFromHistory(String text) {
        TextCrawler mTextCrawler = new TextCrawler();
        this.callback = new MyLinkPreviewCallback();
        ((MyLinkPreviewCallback)this.callback).setText(text);
        mTextCrawler.makePreview(this.callback, text);
    }

    private void clearImage() {
        this.mMessageImageView.setVisibility(8);
        this.mMessageImageView.setImageDrawable(null);
        if (this.mGeneralProgressBarView != null) {
            this.mGeneralProgressBarView.setVisibility(8);
        }
    }

    private void setMessageImage() {
        Handler uiHandler = new Handler();
        if (this.mCurrentImageURL.isEmpty()) {
            uiHandler.post(this::clearImage);
            return;
        }
        this.mMessageImageView.post(() -> {
            this.mCurrentImageURL = ImageUrlUtil.completeToValidImageUrl((String)this.mCurrentUrl, (String)this.mCurrentImageURL);
            if (!this.mCurrentImageURL.isEmpty()) {
                PicassoUtils.get((Context)this.mMessageImageView.getContext()).load(this.mCurrentImageURL).error(R.drawable.lp_messaging_ui_icon_image_broken).resize(250, 250).onlyScaleDown().centerCrop().into(this.mMessageImageView, new Callback(){

                    public void onSuccess() {
                        AmsConsumerURLViewHolder.this.mMessageImageView.setVisibility(0);
                    }

                    public void onError(Exception e) {
                        AmsConsumerURLViewHolder.this.mMessageImageView.setVisibility(8);
                    }
                });
            }
        });
    }

    public void recycle() {
        super.recycle();
        if (this.callback != null) {
            ((MyLinkPreviewCallback)this.callback).setCancelled(true);
        }
        this.applyDefault();
        this.mMessageTextView.setBackgroundResource(R.drawable.lpmessaging_ui_consumer_url_bubble_button_background);
        this.mMessageImageView.setImageDrawable(null);
        this.mMessageImageView.setVisibility(8);
        this.mGeneralProgressBarView.setVisibility(0);
        this.mLayout.setVisibility(0);
        this.mTitleMsg.setText((CharSequence)"");
        this.mTitleMsg.setVisibility(this.mTitleMsg.getText().length() > 0 ? 0 : 8);
        this.mDescription.setText((CharSequence)"");
        this.mDescription.setVisibility(this.mDescription.getText().length() > 0 ? 0 : 8);
        this.mSiteName.setText((CharSequence)"");
        this.mSiteName.setVisibility(this.mSiteName.getText().length() > 0 ? 0 : 8);
    }

    @Override
    public void applyColors() {
        ResourceHelper.updateTextColor((TextView)this.mDescription, (int)R.color.consumer_bubble_link_preview_description_text_color);
        ResourceHelper.updateTextColorLink((TextView)this.mMessageTextView, (int)R.color.consumer_bubble_message_link_text_color);
        ResourceHelper.updateTextColor((TextView)this.mTitleMsg, (int)R.color.consumer_bubble_link_preview_title_text_color);
        ResourceHelper.updateBackgroundStrokeColor((View)this.mLayout, (int)R.color.consumer_bubble_link_preview_background_stroke_color, (int)R.dimen.consumer_bubble_link_preview_background_stroke_width);
        ResourceHelper.updateBackgroundSolidColor((View)this.mLayout, (int)R.color.consumer_bubble_link_preview_background_color);
    }

    @Override
    public void updateContentDescription() {
        Context context = this.getContext();
        if (context != null) {
            String youWord = context.getResources().getString(R.string.lp_accessibility_you);
            String linkWord = context.getResources().getString(R.string.lp_accessibility_link);
            String errorMessage = context.getResources().getString(R.string.lp_accessibility_resend) + " " + linkWord;
            this.setContentDescription(youWord + ": " + this.getTextToCopy() + ", " + linkWord + ", " + this.getContentDescriptionEnding());
            this.mMessageTextView.setContentDescription((CharSequence)(this.getTextToCopy() + ", " + linkWord + ", " + this.mTimestampAccessibilityString));
            this.mMessageErrorView.setContentDescription((CharSequence)errorMessage);
        }
    }

    public void onLinkClick() {
        if (this.mContextualActionBehavior.isSelectable()) {
            View.OnClickListener listener = this.mContextualActionBehavior.getOnClickListener(this.getTimestampAsInteger(), (BaseViewHolder)this, null);
            this.setContextualBehaviorOnClick(listener);
        } else {
            String link = this.mCurrentUrl;
            if (link != null) {
                this.mContextualActionBehavior.getContextualItemAction().performOpenLink(link, false, this.getLinkType());
            }
        }
    }

    private void onLinkPreviewStatus() {
        if (!this.mIsLinkPreviewEnabled) {
            this.mLayout.setVisibility(8);
            this.mMessageTextView.setBackgroundResource(R.drawable.lpmessaging_ui_consumer_bubble_background);
            this.mMessageTextView.invalidate();
        }
    }

    private void applyDefault() {
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.mMessageTextView.getLayoutParams();
        params.matchConstraintMaxWidth = -2;
        params.matchConstraintPercentWidth = 0.75f;
        this.mMessageTextView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mMessageTextView.requestLayout();
    }

    private void applyMessageTextWidth() {
        int maxWidth = this.mIsLinkPreviewEnabled ? 0 : -2;
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.mMessageTextView.getLayoutParams();
        params.matchConstraintMaxWidth = maxWidth;
        params.matchConstraintPercentWidth = 0.75f;
        this.mMessageTextView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.mMessageTextView.requestLayout();
    }

    private void applyPreviewVisibility() {
        int visibility = this.mIsLinkPreviewEnabled ? 0 : 8;
        this.mLayout.setVisibility(visibility);
    }

    private boolean validateSufficientConditionsToDisplayPreview(SourceContent sourceContent) {
        LPLog.INSTANCE.d(TAG, "validateSufficientConditionsToDisplayPreview");
        int counter = 0;
        counter = sourceContent.getSiteName().isEmpty() ? --counter : ++counter;
        counter = sourceContent.getDescription().isEmpty() ? --counter : ++counter;
        counter = sourceContent.getTitle().isEmpty() ? --counter : ++counter;
        counter = sourceContent.getImages().isEmpty() ? --counter : ++counter;
        return counter >= 0;
    }

    private class MyLinkPreviewCallback
    implements LinkPreviewCallback {
        boolean isCancelled = false;
        private String text;

        private MyLinkPreviewCallback() {
        }

        void setCancelled(boolean cancelled) {
            this.isCancelled = cancelled;
        }

        public void onPos(SourceContent sourceContent, boolean isNull) {
            if (this.isCancelled) {
                return;
            }
            if (isNull || sourceContent.getFinalUrl().equals("")) {
                LPLog.INSTANCE.e(AmsConsumerURLViewHolder.TAG, ErrorCode.ERR_00000110, "Could not parse malformed JSON nor from history");
                AmsConsumerURLViewHolder.this.onParsingErrorOccurred(this.text);
            } else if (AmsConsumerURLViewHolder.this.validateSufficientConditionsToDisplayPreview(sourceContent)) {
                if (AmsConsumerURLViewHolder.this.mGeneralProgressBarView != null) {
                    AmsConsumerURLViewHolder.this.mGeneralProgressBarView.setVisibility(8);
                }
                AmsConsumerURLViewHolder.this.mCurrentImageURL = sourceContent.getImages();
                AmsConsumerURLViewHolder.this.mTitleMsg.setText((CharSequence)Html.fromHtml((String)sourceContent.getTitle()));
                AmsConsumerURLViewHolder.this.mTitleMsg.setVisibility(AmsConsumerURLViewHolder.this.mTitleMsg.getText().length() > 0 ? 0 : 8);
                AmsConsumerURLViewHolder.this.mDescription.setText((CharSequence)Html.fromHtml((String)sourceContent.getDescription()));
                AmsConsumerURLViewHolder.this.mDescription.setVisibility(AmsConsumerURLViewHolder.this.mDescription.getText().length() > 0 ? 0 : 8);
                AmsConsumerURLViewHolder.this.mSiteName.setText((CharSequence)Html.fromHtml((String)sourceContent.getSiteName()));
                AmsConsumerURLViewHolder.this.mSiteName.setVisibility(AmsConsumerURLViewHolder.this.mSiteName.getText().length() > 0 ? 0 : 8);
                AmsConsumerURLViewHolder.this.mOriginalMessage = AmsConsumerURLViewHolder.this.mCurrentUrl = sourceContent.getUrl();
                if (AmsConsumerURLViewHolder.this.mCurrentImageURL.isEmpty()) {
                    AmsConsumerURLViewHolder.this.clearImage();
                } else {
                    AmsConsumerURLViewHolder.this.setMessageImage();
                }
                LinkPreviewLruCache.getInstance().addSourceContentToCache(sourceContent);
                AmsConsumerURLViewHolder.this.applyMessageTextWidth();
                AmsConsumerURLViewHolder.this.applyPreviewVisibility();
            } else {
                LPLog.INSTANCE.e(AmsConsumerURLViewHolder.TAG, ErrorCode.ERR_00000111, "not null but insufficient to parse");
                sourceContent.setSuccess(false);
                LinkPreviewLruCache.getInstance().addSourceContentToCache(sourceContent);
                AmsConsumerURLViewHolder.this.onParsingErrorOccurred(this.text);
            }
        }

        public void clean() {
        }

        public void setText(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

