/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder.consumer;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.ContextualMovementMethod;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualActionBehavior;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.ui.view.adapter.viewholder.BaseViewHolder;
import com.liveperson.infra.ui.view.adapter.viewholder.EndViewHolder;
import com.liveperson.infra.ui.view.resources.ResourceHelper;
import com.liveperson.infra.ui.view.utils.UIUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.MessagingChatMessage;

public class AmsConsumerViewHolder
extends EndViewHolder {
    private static final long ERROR_ANNOUNCE_DELAY = 50L;
    protected TextView mMessageStateText;
    protected ImageView mMessageStateIcon;
    protected ImageView mMessageErrorView;
    protected static int mSdkMessageState;
    protected static String[] mMessageStateTextArray;
    protected static String[] mMessageStateAccessibilityTextArray;
    protected ViewHolderType mViewHolderType;
    protected MessagingChatMessage.MessageType mMessageType;
    protected ContextualActionBehavior mContextualActionBehavior;
    private boolean isCustomisedLink;
    private String mAccessibilityMessageState;

    public AmsConsumerViewHolder(View itemView, MessagingChatMessage.MessageType messageType) {
        super(itemView);
        this.mMessageType = messageType;
        this.mMessageStateText = (TextView)itemView.findViewById(R.id.lpui_message_state_text);
        this.mMessageStateIcon = (ImageView)itemView.findViewById(R.id.lpui_message_state_icon);
        this.mMessageErrorView = (ImageView)itemView.findViewById(R.id.lpui_message_error);
        mSdkMessageState = Configuration.getInteger((int)R.integer.message_receive_icons);
        this.mViewHolderType = this.isReadReceiptDisabled() ? ViewHolderType.NONE : (mSdkMessageState == 0 ? ViewHolderType.TEXT : ViewHolderType.ICON);
        Resources resources = this.mMessageStateText.getContext().getApplicationContext().getResources();
        mMessageStateTextArray = resources.getStringArray(R.array.message_receive_text);
        mMessageStateAccessibilityTextArray = resources.getStringArray(R.array.lp_message_status_accessibility_text);
        this.setMessageTextListeners();
    }

    public void applyChanges(Bundle changes, Message message) {
        super.applyChanges(changes, message);
        int newStateOrdinal = changes.getInt("EXTRA_MESSAGE_STATE", -1);
        if (newStateOrdinal > -1) {
            this.setViewAppearanceByState(MessagingChatMessage.MessageState.values()[newStateOrdinal], MessagingChatMessage.MessageType.values()[this.mMessageType.ordinal()], message);
        }
        this.updateContentDescription();
    }

    public void onBind() {
        super.onBind();
        this.applyColors();
    }

    public void applyColors() {
        ResourceHelper.updateBackgroundStrokeColor((View)this.mMessageTextView, (int)R.color.consumer_bubble_stroke_color, (int)R.dimen.consumer_bubble_stroke_width);
        ResourceHelper.updateBackgroundSolidColor((View)this.mMessageTextView, (int)R.color.consumer_bubble_background_color);
        ResourceHelper.updateTextColor((TextView)this.mMessageTextView, (int)R.color.consumer_bubble_message_text_color);
        ResourceHelper.updateTextColorLink((TextView)this.mMessageTextView, (int)R.color.consumer_bubble_message_link_text_color);
        ResourceHelper.updateTextColor((TextView)this.mTimestampTextView, (int)R.color.consumer_bubble_timestamp_text_color);
        ResourceHelper.updateTextColor((TextView)this.mMessageStateText, (int)R.color.consumer_bubble_state_text_color);
    }

    public void updateContentDescription() {
        Context context = this.getContext();
        if (context != null) {
            String youWord = context.getResources().getString(R.string.lp_accessibility_you);
            String linkWord = "";
            String errorMessage = context.getResources().getString(R.string.lp_accessibility_resend) + " " + context.getResources().getString(R.string.lp_accessibility_chat_message);
            if (this.isCustomisedLink) {
                linkWord = context.getResources().getString(R.string.lp_accessibility_link);
                this.mMessageTextView.setContentDescription((CharSequence)(this.getTextToCopy() + ", " + linkWord + ", " + this.mTimestampAccessibilityString));
            }
            this.mMessageErrorView.setContentDescription((CharSequence)errorMessage);
            this.setContentDescription(youWord + ": " + this.mMessageTextView.getText().toString() + ", " + linkWord + ", " + this.getContentDescriptionEnding());
        }
    }

    public void setViewAppearanceByState(MessagingChatMessage.MessageState state, MessagingChatMessage.MessageType messageType, Message message) {
        if (state == MessagingChatMessage.MessageState.QUEUED || state == MessagingChatMessage.MessageState.PENDING) {
            this.setStateVisibility(8);
            this.mMessageStateText.postDelayed(() -> this.setStateVisibility(0), 2000L);
        } else {
            this.setStateVisibility(0);
        }
        this.mAccessibilityMessageState = this.getMessageAccessibilityStateText(state);
        switch (this.mViewHolderType) {
            case NONE: {
                this.mMessageStateText.setVisibility(8);
                this.mMessageStateIcon.setVisibility(8);
                break;
            }
            case TEXT: {
                this.mMessageStateText.setText((CharSequence)this.getMessageStateText(state));
                break;
            }
            case ICON: {
                this.mMessageStateIcon.setImageResource(this.getMessageStateIcon(state));
                this.mMessageStateText.setText((CharSequence)this.getMessageStateText(state));
            }
        }
        if (state == MessagingChatMessage.MessageState.ERROR) {
            this.mMessageErrorView.setVisibility(0);
            this.mMessageErrorView.setOnClickListener(v -> {
                int stringErrorId = this.resend(message, messageType);
                if (stringErrorId != -1) {
                    Toast.makeText((Context)this.mMessageErrorView.getContext(), (int)stringErrorId, (int)0).show();
                }
            });
            this.mMessageErrorView.postDelayed(() -> {
                ImageView errorView = this.mMessageErrorView;
                if (errorView != null) {
                    errorView.sendAccessibilityEvent(64);
                    errorView.performAccessibilityAction(64, null);
                }
            }, 50L);
        } else {
            this.mMessageErrorView.setVisibility(8);
        }
        this.updateContentDescription();
    }

    private void setStateVisibility(int visibility) {
        switch (this.mViewHolderType) {
            case NONE: {
                this.mMessageStateText.setVisibility(8);
                break;
            }
            case TEXT: {
                this.mMessageStateText.setVisibility(visibility);
                break;
            }
            case ICON: {
                this.mMessageStateIcon.setVisibility(visibility);
            }
        }
    }

    protected int resend(Message message, MessagingChatMessage.MessageType messageType) {
        return MessagingFactory.getInstance().getController().resendMessage(message.getEventId(), message.getDialogId(), messageType, false);
    }

    private String getMessageStateText(MessagingChatMessage.MessageState messageState) {
        switch (messageState) {
            case SENT: {
                return mMessageStateTextArray[0];
            }
            case RECEIVED: {
                return mMessageStateTextArray[1];
            }
            case READ: {
                return mMessageStateTextArray[2];
            }
            case ERROR: {
                return mMessageStateTextArray[3];
            }
            case QUEUED: 
            case PENDING: 
            case OFFLINE: {
                return mMessageStateTextArray[4];
            }
        }
        return "";
    }

    private String getMessageAccessibilityStateText(MessagingChatMessage.MessageState messageState) {
        try {
            switch (messageState) {
                case SENT: {
                    return mMessageStateAccessibilityTextArray[0];
                }
                case RECEIVED: {
                    return mMessageStateAccessibilityTextArray[1];
                }
                case READ: {
                    return mMessageStateAccessibilityTextArray[2];
                }
                case ERROR: {
                    return mMessageStateAccessibilityTextArray[3];
                }
                case QUEUED: 
                case PENDING: 
                case OFFLINE: {
                    return mMessageStateAccessibilityTextArray[4];
                }
            }
            return "";
        }
        catch (IndexOutOfBoundsException exception) {
            return "";
        }
    }

    private int getMessageStateIcon(MessagingChatMessage.MessageState messageState) {
        switch (messageState) {
            case QUEUED: 
            case PENDING: 
            case OFFLINE: {
                if (mSdkMessageState < 1) break;
                return R.drawable.lpmessaging_ui_ic_state_sending;
            }
            case SENT: {
                if (mSdkMessageState < 1) break;
                return R.drawable.lpmessaging_ui_ic_msg_sent;
            }
            case RECEIVED: {
                if (mSdkMessageState >= 2) {
                    return R.drawable.lpmessaging_ui_ic_msg_received;
                }
                if (mSdkMessageState != 1) break;
                return R.drawable.lpmessaging_ui_ic_msg_sent;
            }
            case READ: {
                if (mSdkMessageState >= 3) {
                    return R.drawable.lpmessaging_ui_ic_msg_read;
                }
                if (mSdkMessageState == 2) {
                    return R.drawable.lpmessaging_ui_ic_msg_received;
                }
                if (mSdkMessageState != 1) break;
                return R.drawable.lpmessaging_ui_ic_msg_sent;
            }
        }
        return 17170445;
    }

    public void setMessageText(String text) {
        int importantForAccessibility;
        this.mMessageTextView.setAutoLinkMask(0);
        this.mMessageTextView.setLinksClickable(true);
        ContextualMovementMethod method = new ContextualMovementMethod(this.mContextualActionBehavior, null);
        this.mMessageTextView.setMovementMethod((MovementMethod)method);
        this.setMessageTextView(text);
        URLSpan[] spans = this.mMessageTextView.getUrls();
        if (spans != null && spans.length > 0) {
            ViewCompat.enableAccessibleClickableSpanSupport((View)this.mMessageTextView);
            this.isCustomisedLink = true;
            importantForAccessibility = 1;
        } else {
            this.isCustomisedLink = false;
            importantForAccessibility = 2;
        }
        this.mMessageTextView.setImportantForAccessibility(importantForAccessibility);
        if (Configuration.getBoolean((int)R.bool.is_enable_enlarge_emojis)) {
            int emojiHelper = UIUtils.detectEmojis((String)text);
            this.mMessageTextView.setTextSize(0, (float)(switch (emojiHelper) {
                case 1 -> (int)this.mMessageTextView.getContext().getResources().getDimension(R.dimen.xxxxlarge_text_size);
                case 2 -> (int)this.mMessageTextView.getContext().getResources().getDimension(R.dimen.xxxlarge_text_size);
                default -> (int)this.mMessageTextView.getContext().getResources().getDimension(R.dimen.regular_text_size);
            }));
        }
    }

    public void setContextualActionBehavior(ContextualActionBehavior contextualActionBehavior) {
        this.mContextualActionBehavior = contextualActionBehavior;
    }

    private void setMessageTextListeners() {
        if (this.mMessageTextView == null) {
            return;
        }
        this.setMessageTextOnClickListener(view -> this.onTextClick());
        this.setMessageTextOnLongClickListener(view -> {
            this.clearSelection();
            return this.onLinkLongClick();
        });
    }

    public boolean onLinkLongClick() {
        ContextualActionBehavior behavior = this.mContextualActionBehavior;
        if (behavior == null) {
            return false;
        }
        View.OnLongClickListener listener = behavior.getOnLongClickListener(this.getTimestampAsInteger(), (BaseViewHolder)this, null);
        return this.setContextualBehaviorOnLongClick(listener);
    }

    @NonNull
    protected String getAccessibilityMessageState() {
        return this.mAccessibilityMessageState == null ? "" : this.mAccessibilityMessageState;
    }

    @NonNull
    protected String getStatusText() {
        return this.isReadReceiptDisabled() ? "" : this.getAccessibilityMessageState();
    }

    protected String getContentDescriptionEnding() {
        String descriptionEnding = Configuration.getBoolean((int)R.bool.lp_announce_message_status_first) ? this.getStatusText() + " " + this.mTimestampAccessibilityString : this.mTimestampAccessibilityString + " " + this.getStatusText();
        return descriptionEnding;
    }

    protected void onTextClick() {
        ContextualActionBehavior behavior = this.mContextualActionBehavior;
        if (behavior != null && behavior.isSelectable()) {
            View.OnClickListener listener = behavior.getOnClickListener(this.getTimestampAsInteger(), (BaseViewHolder)this, null);
            this.setContextualBehaviorOnClick(listener);
        }
    }

    protected int getMarkdownLinkColor() {
        return ContextCompat.getColor((Context)this.getContext(), (int)R.color.consumer_bubble_message_link_text_color);
    }

    private static enum ViewHolderType {
        ICON,
        TEXT,
        NONE;

    }
}

