/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.view.adapter.viewholder.agent.AmsAgentViewHolder;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.ui.view.utils.picasso.CircleTransform;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.messaging.background.CoBrowseManager;
import com.liveperson.messaging.model.CoBrowseMetadata;
import com.squareup.picasso.Transformation;
import org.json.JSONException;
import org.json.JSONObject;

public class AmsCoBrowseViewHolder
extends AmsAgentViewHolder {
    private static final String TAG = "AmsCoBrowseViewHolder";
    private static final int DELAY = 1000;
    private CardView mBubbleCard;
    private CardView mRejectBtnContainer;
    private CardView mJoinBtnContainer;
    private ImageView mJoinBtn;
    private ImageView mRejectBtn;
    private TextView mCustomTextView;
    private ImageView mImageIcon;
    protected ImageView mAgentAvatar;
    private LinearLayout mInvitationLayout;

    public AmsCoBrowseViewHolder(View itemView) {
        super(itemView);
        this.mAgentAvatar = (ImageView)itemView.findViewById(R.id.lpui_agent_bubbleAvatar);
        this.mAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_ic_agent_avatar);
        this.mJoinBtn = (ImageView)itemView.findViewById(R.id.btn_join);
        this.mRejectBtn = (ImageView)itemView.findViewById(R.id.btn_reject);
        this.mRejectBtnContainer = (CardView)itemView.findViewById(R.id.btn_reject_container);
        this.mJoinBtnContainer = (CardView)itemView.findViewById(R.id.btn_join_container);
        this.mCustomTextView = (TextView)itemView.findViewById(R.id.message_text);
        this.mImageIcon = (ImageView)itemView.findViewById(R.id.image_icon);
        this.mBubbleCard = (CardView)itemView.findViewById(R.id.cardview);
        this.mInvitationLayout = (LinearLayout)itemView.findViewById(R.id.initiation_layout);
        this.applyColors();
    }

    @Override
    public void applyChanges(Bundle changes, Message message) {
        super.applyChanges(changes, message);
        String newAvatar = changes.getString("EXTRA_PROFILE_AVATAR", null);
        if (newAvatar != null) {
            this.setParticipantAvatar(newAvatar);
            this.updateContentDescription();
        }
    }

    @Override
    public void onBind() {
        super.onBind();
        this.applyColors();
    }

    @Override
    public void setParticipantAvatar(String avatarUrl) {
        this.setImage(avatarUrl);
    }

    private void setImage(String uriStr) {
        if (TextUtils.isEmpty((CharSequence)uriStr)) {
            this.mAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_ic_agent_avatar);
            this.mAgentAvatar.setColorFilter(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.agent_avatar_icon_color), PorterDuff.Mode.MULTIPLY);
        } else {
            this.mAgentAvatar.setColorFilter(null);
            this.mAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_ic_agent_avatar);
            PicassoUtils.get((Context)this.mAgentAvatar.getContext()).load(uriStr).noPlaceholder().transform((Transformation)new CircleTransform()).into(this.mAgentAvatar);
        }
    }

    @Override
    public void applyColors() {
    }

    @Override
    public void updateContentDescription() {
        String agentWord = this.itemView.getContext().getString(R.string.lp_accessibility_agent);
        String receivedWord = this.getStatusText();
        String contentDescription = agentWord + " " + this.getNickName() + ": " + this.mCustomTextView.getText() + ", " + receivedWord + " " + this.mTimestampAccessibilityString;
        this.setContentDescription(contentDescription);
    }

    private void setMessage(String str) {
        this.mCustomTextView.setText((CharSequence)str);
    }

    public void setMetadata(CoBrowseMetadata metadata, String brandId) {
        Resources resources = this.itemView.getResources();
        this.setupMessageContent(metadata, resources);
        this.updateInvitationContentDescription();
        this.mJoinBtnContainer.setCardBackgroundColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_voice_video_accept_button_background_color));
        this.mRejectBtnContainer.setCardBackgroundColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_voice_video_decline_button_background_color));
        this.mBubbleCard.setCardBackgroundColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_voice_video_invitation_bubble_background_color));
        this.mCustomTextView.setTextColor(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_voice_video_text_color));
        int imageIconRes = metadata.isVideoCall() ? R.drawable.lp_video_call_image_icon : R.drawable.lp_voice_call_image_icon;
        Drawable imageIcon = ContextCompat.getDrawable((Context)this.itemView.getContext(), (int)imageIconRes);
        this.mImageIcon.setImageDrawable(imageIcon);
        if (!Configuration.getBoolean((int)R.bool.lp_voice_video_invite_icon_render_original_image)) {
            this.mImageIcon.setColorFilter(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_voice_video_invite_icon_tint));
        }
        this.mJoinBtn.setOnClickListener(view -> {
            this.mJoinBtn.postDelayed(() -> {
                JSONObject jsonObject = metadata.getJsonObject();
                try {
                    jsonObject.put("notificationKey", (Object)CoBrowseManager.NOTIFICATION_KEY_JOINED);
                    jsonObject.put("sessionState", (Object)CoBrowseManager.STATUS_ACCEPTED);
                }
                catch (JSONException e) {
                    LPLog.INSTANCE.d(TAG, "Failed to set notificationKey", (Throwable)e);
                }
                CoBrowseMetadata coBrowseMetadata = new CoBrowseMetadata(jsonObject);
                this.setupMessageContent(coBrowseMetadata, resources);
                this.updateInvitationContentDescription();
            }, 1000L);
            Bundle args = new Bundle();
            args.putBoolean("is_video", metadata.isVideoCall());
            args.putString("url", metadata.callLink);
            args.putString("dialogId", metadata.dialogId);
            args.putBoolean("join", true);
            LocalBroadcast.sendBroadcast((String)"BROADCAST_COBROWSE_WEBVIEW", (Bundle)args);
        });
        this.mRejectBtn.setOnClickListener(view -> {
            Bundle args = new Bundle();
            args.putBoolean("join", false);
            CoBrowseMetadata updatedMetadata = CoBrowseManager.instance.getMetadata(brandId, metadata.dialogId);
            if (updatedMetadata != null) {
                args.putString("url", updatedMetadata.callLink);
                if (updatedMetadata.isJoined()) {
                    args.putString("action", "endCall");
                } else {
                    args.putString("action", "declineCall");
                }
                args.putString("dialogId", updatedMetadata.dialogId);
                LocalBroadcast.sendBroadcast((String)"BROADCAST_COBROWSE_WEBVIEW", (Bundle)args);
            }
        });
    }

    public void setVisibility(boolean visible) {
        ViewGroup.LayoutParams layoutParams = this.itemView.getLayoutParams();
        layoutParams.height = visible ? -2 : 0;
        this.itemView.setLayoutParams(layoutParams);
    }

    private void setupMessageContent(CoBrowseMetadata metadata, Resources resources) {
        int messageRes;
        int rejectButtonContentRes;
        int joinButtonContentRes;
        int rejectIconButtonRes;
        int joinIconButtonRes;
        if (metadata.isInvite()) {
            joinIconButtonRes = R.drawable.lp_voice_video_accept_call_button_image;
            rejectIconButtonRes = R.drawable.lp_voice_video_decline_call_button_image;
            joinButtonContentRes = R.string.lp_accessibility_accept_call_button;
            rejectButtonContentRes = R.string.lp_accessibility_decline_call_button;
            messageRes = metadata.isVideoCall() ? R.string.video_cobrowseInvitationHeading : R.string.voice_cobrowseInvitationHeading;
        } else if (metadata.isJoinable()) {
            joinButtonContentRes = R.string.lp_accessibility_return_to_call_button;
            rejectButtonContentRes = R.string.lp_accessibility_end_call_button;
            joinIconButtonRes = R.drawable.lp_voice_video_join_call_button_image;
            int endButtonType = resources.getInteger(R.integer.lp_voice_video_end_call_button_type);
            rejectIconButtonRes = endButtonType == 0 ? R.drawable.lp_voice_video_decline_call_button_image : R.drawable.lp_voice_video_end_call_button_image;
            messageRes = metadata.isVideoCall() ? R.string.video_cobrowseActiveCallTooltip : R.string.voice_cobrowseActiveCallTooltip;
        } else {
            return;
        }
        this.mJoinBtn.setImageResource(joinIconButtonRes);
        this.mJoinBtn.setContentDescription((CharSequence)resources.getString(joinButtonContentRes));
        this.mRejectBtn.setImageResource(rejectIconButtonRes);
        this.mRejectBtn.setContentDescription((CharSequence)resources.getString(rejectButtonContentRes));
        if (!Configuration.getBoolean((int)R.bool.lp_voice_video_accept_button_render_original_image)) {
            this.mJoinBtn.setColorFilter(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_voice_video_accept_button_tint));
        }
        if (!Configuration.getBoolean((int)R.bool.lp_voice_video_decline_button_render_original_image)) {
            this.mRejectBtn.setColorFilter(ContextCompat.getColor((Context)this.itemView.getContext(), (int)R.color.lp_voice_video_decline_button_tint));
        }
        this.setMessage(resources.getString(messageRes));
    }

    private void updateInvitationContentDescription() {
        String invitationDescription = this.mCustomTextView.getText() + " " + this.mJoinBtn.getContentDescription() + " " + this.mRejectBtn.getContentDescription();
        this.mInvitationLayout.setContentDescription((CharSequence)invitationDescription);
    }

    private int dpToPx(float dp) {
        DisplayMetrics displayMetrics = Resources.getSystem().getDisplayMetrics();
        float px = TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)displayMetrics);
        return Math.round(px);
    }
}

