/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.view.adapter.viewholder.utils;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.ui.view.utils.UIUtils;
import com.liveperson.messaging.model.MessagingChatMessage;

public abstract class AmsDownloadableFileViewProcessor {
    public static final String TAG = "AmsDownloadableFileViewProcessor";
    protected ImageView mFileStatusView;
    private long mFileRowId = -1L;
    public String mFullFile;
    private MessagingChatMessage.MessageType mMessageType;
    public String mFileType;
    public String mPreviewImage;
    private FilesTable.LoadStatus mLoadStatus;
    private View mItemView;

    protected abstract void onNotStartedAction();

    protected abstract void onCompletedAction();

    protected abstract void onRequestingUrlAction();

    public AmsDownloadableFileViewProcessor(View itemView, MessagingChatMessage.MessageType messageType) {
        this.mItemView = itemView;
        this.mFileStatusView = (ImageView)itemView.findViewById(R.id.lpui_message_status_image);
        this.mMessageType = messageType;
        LPLog.INSTANCE.d(TAG, this.mFileStatusView.hashCode() + " ctor AmsConsumerFileViewHolder. holder hashcode: " + this.hashCode());
    }

    public void applyChanges(Bundle changes) {
        this.mFileRowId = changes.getLong("EXTRA_FILE_ROW_ID", this.mFileRowId);
        this.mFullFile = changes.getString("EXTRA_LOCAL_URL", null);
        this.mPreviewImage = changes.getString("EXTRA_PREVIEW", null);
        this.mFileType = changes.getString("EXTRA_FILE_TYPE", null);
        int loadStatusOrdinal = changes.getInt("EXTRA_LOAD_STATUS", -1);
        if (loadStatusOrdinal > -1) {
            boolean fullImageExists = changes.getBoolean("EXTRA_FULL_IMAGE_EXISTS", false);
            FilesTable.LoadStatus loadStatus = FilesTable.LoadStatus.values()[loadStatusOrdinal];
            if (!TextUtils.isEmpty((CharSequence)this.mFullFile) || fullImageExists) {
                this.applyLoadStatusForUploadFlow(loadStatus);
            } else {
                boolean previewImageExists = changes.getBoolean("EXTRA_PREVIEW_IMAGE_EXISTS", false);
                if (!TextUtils.isEmpty((CharSequence)this.mPreviewImage) || previewImageExists || this.mMessageType == MessagingChatMessage.MessageType.CONSUMER_DOCUMENT || this.mMessageType == MessagingChatMessage.MessageType.CONSUMER_VOICE) {
                    this.applyLoadStatusForDownloadFlow(loadStatus);
                }
            }
        }
    }

    public void startFailedAnimation() {
        LPLog.INSTANCE.d(TAG, this.mFileStatusView.hashCode() + " startFailedAnimation mFileStatusView.getAnimation() = " + this.mFileStatusView.getAnimation());
        if (this.mFileStatusView.getAnimation() == null) {
            Animation a = AnimationUtils.loadAnimation((Context)this.mFileStatusView.getContext(), (int)R.anim.lpmessaging_ui__voice_right_left_bounce);
            this.mFileStatusView.setImageResource(R.drawable.lpmessaging_ui_voice_download);
            this.mFileStatusView.startAnimation(a);
        }
    }

    public void setFileRowId(long fileRowId) {
        this.mFileRowId = fileRowId;
    }

    public void applyLoadStatusForDownloadFlow(FilesTable.LoadStatus loadStatus) {
        LPLog.INSTANCE.d(TAG, this.mFileStatusView.hashCode() + " applyLoadStatusForUploadFlow " + loadStatus);
        this.mLoadStatus = loadStatus;
        switch (loadStatus) {
            case NOT_STARTED: 
            case PREVIEW_ERROR: {
                this.onNotStartedAction();
                break;
            }
            case FAILED: {
                this.stopAnimation();
                this.mFileStatusView.setVisibility(0);
                this.mFileStatusView.setImageResource(this.getFailedDownloadDrawableResourceId());
                this.additionalFailAction();
                break;
            }
            case PROCESSING: 
            case DOWNLOADING: 
            case UPLOADING: 
            case REQUESTING_URL: {
                this.onRequestingUrlAction();
                break;
            }
            case COMPLETED: {
                this.onCompletedAction();
            }
        }
    }

    protected int getFailedDownloadDrawableResourceId() {
        if (this.mMessageType == MessagingChatMessage.MessageType.CONSUMER_VOICE) {
            return R.drawable.lpmessaging_ui_voice_download;
        }
        return R.drawable.lpmessaging_ui_image_error_download;
    }

    protected void additionalFailAction() {
        if (this.mMessageType == MessagingChatMessage.MessageType.CONSUMER_VOICE) {
            this.mItemView.findViewById(R.id.lpui_voice_play_pause_button).setVisibility(4);
        }
    }

    public void applyLoadStatusForUploadFlow(FilesTable.LoadStatus loadStatus) {
        LPLog.INSTANCE.d(TAG, this.mFileStatusView.hashCode() + " applyLoadStatusForUploadFlow " + loadStatus);
        this.mFileStatusView.setVisibility(4);
        this.mLoadStatus = loadStatus;
        switch (loadStatus) {
            case FAILED: {
                this.stopAnimation();
                break;
            }
            case PROCESSING: 
            case DOWNLOADING: 
            case UPLOADING: 
            case REQUESTING_URL: {
                this.onRequestingUrlAction();
                break;
            }
            case NOT_STARTED: 
            case COMPLETED: {
                this.onCompletedAction();
            }
        }
    }

    protected void startProgressBar() {
        LPLog.INSTANCE.d(TAG, this.mFileStatusView.hashCode() + " startProgressBar mFileStatusView.getAnimation() = " + this.mFileStatusView.getAnimation());
        if (this.mFileStatusView.getAnimation() == null) {
            UIUtils.startProgressBarAnimation((ImageView)this.mFileStatusView, (int)R.drawable.lpmessaging_ui_voice_progress_bar);
        }
    }

    protected void stopAnimation() {
        LPLog.INSTANCE.d(TAG, this.mFileStatusView.hashCode() + " startProgressBar mFileStatusView.getAnimation() = " + this.mFileStatusView.getAnimation());
        if (this.mFileStatusView.getAnimation() != null) {
            this.mFileStatusView.clearAnimation();
        }
        if (this.mMessageType == MessagingChatMessage.MessageType.CONSUMER_VOICE) {
            this.mItemView.findViewById(R.id.lpui_voice_play_pause_button).setVisibility(0);
        }
    }

    public long getFileRowId() {
        return this.mFileRowId;
    }

    public FilesTable.LoadStatus getLoadStatus() {
        return this.mLoadStatus;
    }
}

