package com.liveperson.monitoring

import android.content.Context
import com.liveperson.monitoring.model.LPMonitoringIdentity
import com.liveperson.monitoring.sdk.callbacks.SdeCallback
import com.liveperson.sdk.MonitoringParams
import com.liveperson.sdk.callbacks.EngagementCallback
import java.util.ArrayList

/**
 * Created by nirni on 12/6/17.
 */
interface IMonitoring {

    /**
     * Get and engagement from the server and return it using the provided EngagementCallback
     */
    fun  getEngagement(context: Context, identities: List<LPMonitoringIdentity>?, monitoringParams: MonitoringParams?, callback: EngagementCallback)

    /**
     * Send an SDE to the monitoring server
     */
    fun  sendSde(context: Context, identities: List<LPMonitoringIdentity>?, monitoringParams: MonitoringParams?, callback: SdeCallback)

    /**
     * Logout Monitoring SDK
     */
    fun logout(context: Context): Boolean

    /**
     * Indicates whether the Monitoring SDK is initialized
     */
    fun isInitialized() : Boolean

}