package com.liveperson.monitoring.model

import org.json.JSONObject

/**
 * Created by nirni on 12/5/17.
 */
class EngagementDetails(val campaignId: String, val engagementId: String, val engagementRevision: String, val contextId: String, var conversationId: String? = null, var status: String? = null, var connectorId: String) {

    companion object {
        // Create EngagementDetails from json
        operator fun invoke(engagementDetailsJson: JSONObject) : EngagementDetails {

            val campId = engagementDetailsJson.optString(ModelKeyNames.CAMPAIGN_ID)
            val engId = engagementDetailsJson.optString(ModelKeyNames.ENGAGEMENT_ID)
            val engRev = engagementDetailsJson.optString(ModelKeyNames.ENGAGEMENT_REVISION)
            val contextId = engagementDetailsJson.optString(ModelKeyNames.CONTEXT_ID)
            val convId = engagementDetailsJson.optString(ModelKeyNames.CONVERSATION_ID)
            val engStatus = engagementDetailsJson.optString(ModelKeyNames.STATUS)
            val connectorId = engagementDetailsJson.optString(ModelKeyNames.CONNECTOR_ID)
            return EngagementDetails(campId, engId, engRev, contextId, convId, engStatus, connectorId)
        }
    }

    override fun toString(): String =
            "{campainId=$campaignId, engagementId=$engagementId, engagementRevision=$engagementRevision, contextId=$contextId, conversationId=$conversationId, status=$status, connectorId=$connectorId}"
}