package com.liveperson.monitoring.utils;

import android.content.Context;
import android.text.TextUtils;

import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.lp_monitoring_sdk.R;

/**
 * Created by nirni on 12/26/17.
 */

public class DomainBuilder {

	public static final String TAG = "DomainBuilder";


	private static String defaultDoamin = "adminlogin.liveperson.net";

	public static String getCsdsDomain(Context context, String brandId) {

		String domaingToReturn;

		if (context == null || TextUtils.isEmpty(brandId)) {
			LPMobileLog.w(TAG, "getCsdsDomain: context or brandId is empty. Using default domain");
			return defaultDoamin;
		}

		if (brandId.startsWith("qa") || brandId.startsWith("le")) {
			domaingToReturn = context.getResources().getString(R.string.csds_qa_url);
		} else {
			domaingToReturn = context.getResources().getString(R.string.csds_url);
		}

		// If there was a problem getting from resources
		if (TextUtils.isEmpty(domaingToReturn)) {
			LPMobileLog.w(TAG, "getCsdsDomain: could not get domain from resources. Using default domain");
			return defaultDoamin;
		}

		return domaingToReturn;
	}
}
