/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.monitoring.IMonitoring;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.managers.MonitoringRequestManager;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.requests.GetEngagementRequest;
import com.liveperson.monitoring.requests.SendSdeRequest;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.callbacks.SdeCallback;
import com.liveperson.sdk.MonitoringInternalInitParams;
import com.liveperson.sdk.MonitoringParams;
import com.liveperson.sdk.callbacks.EngagementCallback;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\b2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)H\u0016J\u000e\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020\u0013H\u0016J\u0010\u0010.\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\bH\u0016J\u000e\u0010/\u001a\u00020!2\u0006\u00100\u001a\u000201J2\u00102\u001a\u00020!2\u0006\u0010\"\u001a\u00020\b2\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020%\u0018\u00010$2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u000203H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/liveperson/monitoring/Monitoring;", "Lcom/liveperson/monitoring/IMonitoring;", "()V", "TAG", "", "appHandler", "Landroid/os/Handler;", "applicationContext", "Landroid/content/Context;", "getApplicationContext", "()Landroid/content/Context;", "setApplicationContext", "(Landroid/content/Context;)V", "brandId", "getBrandId", "()Ljava/lang/String;", "setBrandId", "(Ljava/lang/String;)V", "initialized", "", "getInitialized", "()Z", "setInitialized", "(Z)V", "paramsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "getParamsCache", "()Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "setParamsCache", "(Lcom/liveperson/monitoring/cache/MonitoringParamsCache;)V", "requestManager", "Lcom/liveperson/monitoring/managers/MonitoringRequestManager;", "getEngagement", "", "context", "identities", "", "Lcom/liveperson/monitoring/model/LPMonitoringIdentity;", "monitoringParams", "Lcom/liveperson/sdk/MonitoringParams;", "callback", "Lcom/liveperson/sdk/callbacks/EngagementCallback;", "init", "monitoringInternalInitParams", "Lcom/liveperson/sdk/MonitoringInternalInitParams;", "isInitialized", "logout", "postOnMainThread", "runnable", "Ljava/lang/Runnable;", "sendSde", "Lcom/liveperson/monitoring/sdk/callbacks/SdeCallback;", "monitoring_release"})
public class Monitoring
implements IMonitoring {
    private final String TAG = "Monitoring";
    private Handler appHandler;
    private MonitoringRequestManager requestManager;
    private boolean initialized;
    @Nullable
    private MonitoringParamsCache paramsCache;
    @Nullable
    private String brandId;
    @Nullable
    private Context applicationContext;

    public final boolean getInitialized() {
        return this.initialized;
    }

    public final void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    @Nullable
    public final MonitoringParamsCache getParamsCache() {
        return this.paramsCache;
    }

    public final void setParamsCache(@Nullable MonitoringParamsCache monitoringParamsCache) {
        this.paramsCache = monitoringParamsCache;
    }

    @Nullable
    public final String getBrandId() {
        return this.brandId;
    }

    public final void setBrandId(@Nullable String string2) {
        this.brandId = string2;
    }

    @Nullable
    public final Context getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(@Nullable Context context) {
        this.applicationContext = context;
    }

    public final boolean init(@NotNull MonitoringInternalInitParams monitoringInternalInitParams) {
        String lBrandId;
        Intrinsics.checkParameterIsNotNull((Object)monitoringInternalInitParams, (String)"monitoringInternalInitParams");
        LPMobileLog.d((String)this.TAG, (String)"init: Monitoring module version = 3.9.0");
        LPMobileLog.d((String)this.TAG, (String)("Initializing Monitoring SDK. MonitoringInternalInitParams: " + monitoringInternalInitParams));
        this.appHandler = new Handler(Looper.getMainLooper());
        this.applicationContext = monitoringInternalInitParams.getApplicationContext();
        this.brandId = monitoringInternalInitParams.getAccountId();
        if (TextUtils.isEmpty((CharSequence)this.brandId)) {
            LPMobileLog.w((String)this.TAG, (String)"BrandId is empty. Aborting");
            return false;
        }
        String string2 = lBrandId = this.brandId;
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            this.paramsCache = new MonitoringParamsCache(lBrandId);
        }
        if (this.paramsCache == null) {
            return false;
        }
        MonitoringParamsCache lParamsCache = this.paramsCache;
        MonitoringParamsCache monitoringParamsCache = this.paramsCache;
        if (monitoringParamsCache != null) {
            monitoringParamsCache.setAppInstallId(monitoringInternalInitParams.getAppInstallId());
        }
        MonitoringParamsCache monitoringParamsCache2 = lParamsCache;
        if (monitoringParamsCache2 != null) {
            MonitoringParamsCache monitoringParamsCache3;
            MonitoringParamsCache it = monitoringParamsCache3 = monitoringParamsCache2;
            boolean bl = false;
            this.requestManager = new MonitoringRequestManager(this.brandId, lParamsCache);
        }
        this.initialized = true;
        return true;
    }

    @Override
    public boolean logout(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        LPMobileLog.d((String)this.TAG, (String)"Logging out...");
        if (!this.initialized) {
            LPMobileLog.w((String)this.TAG, (String)"Not initialized");
            return true;
        }
        MonitoringParamsCache monitoringParamsCache = this.paramsCache;
        if (monitoringParamsCache != null) {
            monitoringParamsCache.clear();
        }
        this.paramsCache = null;
        this.brandId = null;
        this.applicationContext = null;
        this.initialized = false;
        return true;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void getEngagement(@NotNull Context context, @Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams, @NotNull EngagementCallback callback) {
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
            List<LPMonitoringIdentity> list = identities;
            LPMobileLog.d((String)this.TAG, (String)("GetEngagement. LPMonitoringIdentity: " + (list != null ? list.get(0) : null) + ", SDE: " + monitoringParams));
            if (!this.initialized) {
                LPMobileLog.w((String)this.TAG, (String)"Not initialized");
                callback.onError(MonitoringErrorType.NOT_INITIALIZED, null);
                return;
            }
            if (!InternetConnectionService.isNetworkAvailable()) {
                LPMobileLog.d((String)this.TAG, (String)"No network. calling callback.onError");
                callback.onError(MonitoringErrorType.NO_NETWORK, null);
                return;
            }
            GetEngagementRequest getEngagementRequest = new GetEngagementRequest(context, identities, monitoringParams, callback);
            MonitoringRequestManager monitoringRequestManager = this.requestManager;
            if (monitoringRequestManager == null) break block2;
            monitoringRequestManager.csdsDependantRequest(context, getEngagementRequest, callback);
        }
    }

    @Override
    public void sendSde(@NotNull Context context, @Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams, @NotNull SdeCallback callback) {
        block3: {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
            LPMobileLog.d((String)this.TAG, (String)("sendSde. ConsumerId: " + identities + ", SDE: " + monitoringParams));
            if (!this.initialized) {
                LPMobileLog.w((String)this.TAG, (String)"Not initialized");
                callback.onError(MonitoringErrorType.NOT_INITIALIZED, null);
                return;
            }
            if (identities == null || identities.isEmpty()) {
                callback.onError(MonitoringErrorType.PARAMETER_MISSING, new Exception("ConsumerId is mandatory"));
                return;
            }
            if (!InternetConnectionService.isNetworkAvailable()) {
                LPMobileLog.d((String)this.TAG, (String)"No network. calling callback.onError");
                callback.onError(MonitoringErrorType.NO_NETWORK, null);
                return;
            }
            SendSdeRequest sendSdeRequest = new SendSdeRequest(context, identities, monitoringParams, callback);
            MonitoringRequestManager monitoringRequestManager = this.requestManager;
            if (monitoringRequestManager == null) break block3;
            monitoringRequestManager.csdsDependantRequest(context, sendSdeRequest, callback);
        }
    }

    public final void postOnMainThread(@NotNull Runnable runnable) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
            Handler handler = this.appHandler;
            if (handler == null) break block0;
            handler.post(runnable);
        }
    }
}

