/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.cache;

import android.content.Context;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.lp_monitoring_sdk.R;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.ParamsCache;
import com.liveperson.monitoring.utils.Clearable;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b$\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010A\u001a\u00020BH\u0016J\b\u0010C\u001a\u00020BH\u0002J\u0012\u0010D\u001a\u0004\u0018\u00010\u00042\u0006\u0010E\u001a\u00020\u0004H\u0016J\b\u0010F\u001a\u000202H\u0016J\u001c\u0010G\u001a\u0002022\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040IH\u0016J.\u0010J\u001a\u0002022\u0012\u0010H\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040I2\u0006\u0010K\u001a\u00020\u00042\b\u0010L\u001a\u0004\u0018\u00010\u0004H\u0002R\u0014\u0010\u0006\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0014\u0010\u000f\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u000e\u0010\u0013\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u0014\u0010\u0016\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u000e\u0010\u0018\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\bR(\u0010\u001c\u001a\u0004\u0018\u00010\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\b\"\u0004\b\u001e\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\bR(\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\b\"\u0004\b\"\u0010\u0005R\u001c\u0010#\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\b\"\u0004\b%\u0010\u0005R\u001c\u0010&\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\b\"\u0004\b(\u0010\u0005R$\u0010*\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020)@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001c\u0010/\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\b\"\u0004\b1\u0010\u0005R$\u00103\u001a\u0002022\u0006\u0010\u001b\u001a\u000202@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u00105\"\u0004\b6\u00107R(\u00108\u001a\u0004\u0018\u00010\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010\b\"\u0004\b:\u0010\u0005R\u001c\u0010;\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\b\"\u0004\b=\u0010\u0005R(\u0010>\u001a\u0004\u0018\u00010\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\b\"\u0004\b@\u0010\u0005\u00a8\u0006M"}, d2={"Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "Lcom/liveperson/monitoring/cache/ParamsCache;", "Lcom/liveperson/monitoring/utils/Clearable;", "brandId", "", "(Ljava/lang/String;)V", "APP_INSTALL_ID_KEY", "getAPP_INSTALL_ID_KEY", "()Ljava/lang/String;", "CONNECTOR_ID_KEY", "getCONNECTOR_ID_KEY", "CSDS_IDP_DOMAIN_KEY", "getCSDS_IDP_DOMAIN_KEY", "CSDS_LOGGOS_DOMAIN_KEY", "getCSDS_LOGGOS_DOMAIN_KEY", "CSDS_SHARK_DOMAIN_KEY", "getCSDS_SHARK_DOMAIN_KEY", "LAST_CSDS_UPDATE_TIMESTAMP_KEY", "getLAST_CSDS_UPDATE_TIMESTAMP_KEY", "QA_CSDS", "SDK_INFO_SEND_KEY", "getSDK_INFO_SEND_KEY", "SESSION_ID_KEY", "getSESSION_ID_KEY", "TAG", "VISITOR_ID_KEY", "getVISITOR_ID_KEY", "value", "appInstallId", "getAppInstallId", "setAppInstallId", "getBrandId", "connectorId", "getConnectorId", "setConnectorId", "csdsMainDomain", "getCsdsMainDomain", "setCsdsMainDomain", "idpDomain", "getIdpDomain", "setIdpDomain", "", "lastCsdsUpdateTimestamp", "getLastCsdsUpdateTimestamp", "()J", "setLastCsdsUpdateTimestamp", "(J)V", "loggosDomain", "getLoggosDomain", "setLoggosDomain", "", "sdkInfoSent", "getSdkInfoSent", "()Z", "setSdkInfoSent", "(Z)V", "sessionId", "getSessionId", "setSessionId", "sharkDomain", "getSharkDomain", "setSharkDomain", "visitorId", "getVisitorId", "setVisitorId", "clear", "", "clearAllDomains", "getServiceDomain", "serviceName", "isCsdsFilled", "updateCsdsDomains", "csdsDomains", "Ljava/util/HashMap;", "updateDomain", "csdsDomainKey", "oldDomainValue", "monitoring_release"})
public class MonitoringParamsCache
implements ParamsCache,
Clearable {
    private final String TAG = "MonitoringParamsCache";
    private final String QA_CSDS = "hc1n.dev.lprnd.net";
    @NotNull
    private final String CSDS_SHARK_DOMAIN_KEY = "smt";
    @NotNull
    private final String CSDS_LOGGOS_DOMAIN_KEY = "loggos";
    @NotNull
    private final String CSDS_IDP_DOMAIN_KEY = "idp";
    @NotNull
    private final String LAST_CSDS_UPDATE_TIMESTAMP_KEY = "lastCsdsUpdateTimestampKey";
    @NotNull
    private final String SESSION_ID_KEY = "sessionIdKey";
    @NotNull
    private final String VISITOR_ID_KEY = "visitorIdKey";
    @NotNull
    private final String CONNECTOR_ID_KEY = "connectorIdKey";
    @NotNull
    private final String APP_INSTALL_ID_KEY = "appInstallIdKey";
    @NotNull
    private final String SDK_INFO_SEND_KEY = "sdkInfoSendKey";
    @Nullable
    private String csdsMainDomain;
    @Nullable
    private String sharkDomain;
    @Nullable
    private String loggosDomain;
    @Nullable
    private String idpDomain;
    private long lastCsdsUpdateTimestamp;
    @Nullable
    private String sessionId;
    @Nullable
    private String visitorId;
    @Nullable
    private String connectorId;
    @Nullable
    private String appInstallId;
    private boolean sdkInfoSent;
    @NotNull
    private final String brandId;

    @NotNull
    public final String getCSDS_SHARK_DOMAIN_KEY() {
        return this.CSDS_SHARK_DOMAIN_KEY;
    }

    @NotNull
    public final String getCSDS_LOGGOS_DOMAIN_KEY() {
        return this.CSDS_LOGGOS_DOMAIN_KEY;
    }

    @NotNull
    public final String getCSDS_IDP_DOMAIN_KEY() {
        return this.CSDS_IDP_DOMAIN_KEY;
    }

    @NotNull
    public final String getLAST_CSDS_UPDATE_TIMESTAMP_KEY() {
        return this.LAST_CSDS_UPDATE_TIMESTAMP_KEY;
    }

    @NotNull
    public final String getSESSION_ID_KEY() {
        return this.SESSION_ID_KEY;
    }

    @NotNull
    public final String getVISITOR_ID_KEY() {
        return this.VISITOR_ID_KEY;
    }

    @NotNull
    public final String getCONNECTOR_ID_KEY() {
        return this.CONNECTOR_ID_KEY;
    }

    @NotNull
    public final String getAPP_INSTALL_ID_KEY() {
        return this.APP_INSTALL_ID_KEY;
    }

    @NotNull
    public final String getSDK_INFO_SEND_KEY() {
        return this.SDK_INFO_SEND_KEY;
    }

    @Nullable
    public final String getCsdsMainDomain() {
        return this.csdsMainDomain;
    }

    public final void setCsdsMainDomain(@Nullable String string2) {
        this.csdsMainDomain = string2;
    }

    @Nullable
    public final String getSharkDomain() {
        return this.sharkDomain;
    }

    public final void setSharkDomain(@Nullable String string2) {
        this.sharkDomain = string2;
    }

    @Nullable
    public final String getLoggosDomain() {
        return this.loggosDomain;
    }

    public final void setLoggosDomain(@Nullable String string2) {
        this.loggosDomain = string2;
    }

    @Nullable
    public final String getIdpDomain() {
        return this.idpDomain;
    }

    public final void setIdpDomain(@Nullable String string2) {
        this.idpDomain = string2;
    }

    public final long getLastCsdsUpdateTimestamp() {
        return this.lastCsdsUpdateTimestamp;
    }

    public final void setLastCsdsUpdateTimestamp(long value) {
        this.lastCsdsUpdateTimestamp = value;
        PreferenceManager.getInstance().setLongValue(this.LAST_CSDS_UPDATE_TIMESTAMP_KEY, this.brandId, value);
    }

    @Nullable
    public final String getSessionId() {
        return this.sessionId;
    }

    public final void setSessionId(@Nullable String value) {
        this.sessionId = value;
        PreferenceManager.getInstance().setStringValue(this.SESSION_ID_KEY, this.brandId, value);
    }

    @Nullable
    public final String getVisitorId() {
        return this.visitorId;
    }

    public final void setVisitorId(@Nullable String value) {
        this.visitorId = value;
        PreferenceManager.getInstance().setStringValue(this.VISITOR_ID_KEY, this.brandId, value);
    }

    @Nullable
    public final String getConnectorId() {
        return this.connectorId;
    }

    public final void setConnectorId(@Nullable String value) {
        this.connectorId = value;
        PreferenceManager.getInstance().setStringValue(this.CONNECTOR_ID_KEY, this.brandId, value);
    }

    @Nullable
    public final String getAppInstallId() {
        return this.appInstallId;
    }

    public final void setAppInstallId(@Nullable String value) {
        this.appInstallId = value;
        PreferenceManager.getInstance().setStringValue(this.APP_INSTALL_ID_KEY, this.brandId, value);
    }

    public final boolean getSdkInfoSent() {
        return this.sdkInfoSent;
    }

    public final void setSdkInfoSent(boolean value) {
        this.sdkInfoSent = value;
        PreferenceManager.getInstance().setBooleanValue(this.SDK_INFO_SEND_KEY, this.brandId, value);
    }

    @Override
    public boolean updateCsdsDomains(@NotNull HashMap<String, String> csdsDomains) {
        Intrinsics.checkParameterIsNotNull(csdsDomains, (String)"csdsDomains");
        boolean updated = false;
        if (csdsDomains.isEmpty()) {
            LPMobileLog.e((String)this.TAG, (String)"updateCsdsDomains: no domains received");
            return false;
        }
        if (this.updateDomain(csdsDomains, this.CSDS_SHARK_DOMAIN_KEY, this.sharkDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, this.CSDS_LOGGOS_DOMAIN_KEY, this.loggosDomain)) {
            updated = true;
        }
        if (this.updateDomain(csdsDomains, this.CSDS_IDP_DOMAIN_KEY, this.idpDomain)) {
            updated = true;
        }
        this.setLastCsdsUpdateTimestamp(System.currentTimeMillis());
        return updated;
    }

    @Override
    @Nullable
    public String getServiceDomain(@NotNull String serviceName) {
        String domainToReturn;
        block1: {
            String string2;
            block2: {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)serviceName, (String)"serviceName");
                    domainToReturn = null;
                    string2 = serviceName;
                    if (!Intrinsics.areEqual((Object)string2, (Object)this.CSDS_SHARK_DOMAIN_KEY)) break block0;
                    domainToReturn = this.sharkDomain;
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)string2, (Object)this.CSDS_LOGGOS_DOMAIN_KEY)) break block2;
                domainToReturn = this.loggosDomain;
                break block1;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)this.CSDS_IDP_DOMAIN_KEY)) break block1;
            domainToReturn = this.idpDomain;
        }
        return domainToReturn;
    }

    @Override
    public boolean isCsdsFilled() {
        return this.sharkDomain != null;
    }

    @Override
    public void clear() {
        PreferenceManager.getInstance().remove(this.CSDS_SHARK_DOMAIN_KEY, this.brandId);
        PreferenceManager.getInstance().remove(this.CSDS_LOGGOS_DOMAIN_KEY, this.brandId);
        PreferenceManager.getInstance().remove(this.CSDS_IDP_DOMAIN_KEY, this.brandId);
        PreferenceManager.getInstance().remove(this.LAST_CSDS_UPDATE_TIMESTAMP_KEY, this.brandId);
        PreferenceManager.getInstance().remove(this.SESSION_ID_KEY, this.brandId);
        PreferenceManager.getInstance().remove(this.VISITOR_ID_KEY, this.brandId);
        PreferenceManager.getInstance().remove(this.APP_INSTALL_ID_KEY, this.brandId);
        PreferenceManager.getInstance().remove(this.SDK_INFO_SEND_KEY, this.brandId);
        this.csdsMainDomain = null;
        this.clearAllDomains();
        this.setLastCsdsUpdateTimestamp(0L);
        this.setSessionId(null);
        this.setVisitorId(null);
        this.setConnectorId(null);
        this.setAppInstallId(null);
        this.setSdkInfoSent(false);
    }

    private final void clearAllDomains() {
        this.sharkDomain = null;
        this.loggosDomain = null;
    }

    private final boolean updateDomain(HashMap<String, String> csdsDomains, String csdsDomainKey, String oldDomainValue) {
        boolean updated;
        block1: {
            String string2;
            String domain;
            block3: {
                block2: {
                    updated = false;
                    domain = csdsDomains.get(csdsDomainKey);
                    if (domain == null) break block1;
                    PreferenceManager.getInstance().setStringValue(csdsDomainKey, this.brandId, domain);
                    if (oldDomainValue != null && Intrinsics.areEqual((Object)domain, (Object)oldDomainValue) ^ true) {
                        updated = true;
                    }
                    if (!Intrinsics.areEqual((Object)(string2 = csdsDomainKey), (Object)this.CSDS_SHARK_DOMAIN_KEY)) break block2;
                    this.sharkDomain = domain;
                    break block1;
                }
                if (!Intrinsics.areEqual((Object)string2, (Object)this.CSDS_LOGGOS_DOMAIN_KEY)) break block3;
                this.loggosDomain = domain;
                break block1;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)this.CSDS_IDP_DOMAIN_KEY)) break block1;
            this.idpDomain = domain;
        }
        return updated;
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    public MonitoringParamsCache(@NotNull String brandId) {
        Context context;
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        this.brandId = brandId;
        this.TAG = "MonitoringParamsCache";
        this.QA_CSDS = "hc1n.dev.lprnd.net";
        this.CSDS_SHARK_DOMAIN_KEY = "smt";
        this.CSDS_LOGGOS_DOMAIN_KEY = "loggos";
        this.CSDS_IDP_DOMAIN_KEY = "idp";
        this.LAST_CSDS_UPDATE_TIMESTAMP_KEY = "lastCsdsUpdateTimestampKey";
        this.SESSION_ID_KEY = "sessionIdKey";
        this.VISITOR_ID_KEY = "visitorIdKey";
        this.CONNECTOR_ID_KEY = "connectorIdKey";
        this.APP_INSTALL_ID_KEY = "appInstallIdKey";
        this.SDK_INFO_SEND_KEY = "sdkInfoSendKey";
        this.sharkDomain = PreferenceManager.getInstance().getStringValue(this.CSDS_SHARK_DOMAIN_KEY, this.brandId, null);
        this.loggosDomain = PreferenceManager.getInstance().getStringValue(this.CSDS_LOGGOS_DOMAIN_KEY, this.brandId, null);
        this.idpDomain = PreferenceManager.getInstance().getStringValue(this.CSDS_IDP_DOMAIN_KEY, this.brandId, null);
        this.setLastCsdsUpdateTimestamp(PreferenceManager.getInstance().getLongValue(this.LAST_CSDS_UPDATE_TIMESTAMP_KEY, this.brandId, 0L));
        this.setSessionId(PreferenceManager.getInstance().getStringValue(this.SESSION_ID_KEY, this.brandId, null));
        this.setVisitorId(PreferenceManager.getInstance().getStringValue(this.VISITOR_ID_KEY, this.brandId, null));
        this.setConnectorId(PreferenceManager.getInstance().getStringValue(this.CONNECTOR_ID_KEY, this.brandId, null));
        this.setAppInstallId(PreferenceManager.getInstance().getStringValue(this.APP_INSTALL_ID_KEY, this.brandId, null));
        this.setSdkInfoSent(PreferenceManager.getInstance().getBooleanValue(this.SDK_INFO_SEND_KEY, this.brandId, false));
        this.csdsMainDomain = StringsKt.startsWith$default((String)this.brandId, (String)"qa", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)this.brandId, (String)"le", (boolean)false, (int)2, null) ? this.QA_CSDS : ((context = MonitoringFactory.INSTANCE.getMonitoring().getApplicationContext()) != null && (context = context.getResources()) != null ? context.getString(R.string.csds_url) : null);
    }
}

