/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.managers;

import android.content.Context;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.monitoring.Command;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.managers.MonitoringRequestManager;
import com.liveperson.monitoring.requests.CSDSRequest;
import com.liveperson.monitoring.sdk.callbacks.IMonitoringCallback;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.responses.LPSdeResponse;
import com.liveperson.monitoring.utils.DomainBuilder;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0018\u0012\b\u0012\u00060\u0019j\u0002`\u001a0\u0017R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/liveperson/monitoring/managers/MonitoringRequestManager;", "", "brandId", "", "paramsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "(Ljava/lang/String;Lcom/liveperson/monitoring/cache/MonitoringParamsCache;)V", "TAG", "getBrandId", "()Ljava/lang/String;", "getParamsCache", "()Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "twentyFourHoursInMillis", "", "getTwentyFourHoursInMillis", "()I", "csdsDependantRequest", "", "context", "Landroid/content/Context;", "request", "Lcom/liveperson/monitoring/Command;", "callback", "Lcom/liveperson/monitoring/sdk/callbacks/IMonitoringCallback;", "Lcom/liveperson/monitoring/sdk/responses/LPSdeResponse;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "monitoring_release"})
public final class MonitoringRequestManager {
    private final String TAG = "MonitoringRequestManager";
    private final int twentyFourHoursInMillis = 86400000;
    @Nullable
    private final String brandId;
    @NotNull
    private final MonitoringParamsCache paramsCache;

    public final int getTwentyFourHoursInMillis() {
        return this.twentyFourHoursInMillis;
    }

    public final void csdsDependantRequest(@NotNull Context context, @NotNull Command request, @NotNull IMonitoringCallback<? extends LPSdeResponse, Exception> callback) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        long now = System.currentTimeMillis();
        long expireTime = this.paramsCache.getLastCsdsUpdateTimestamp() + (long)this.twentyFourHoursInMillis;
        LPMobileLog.d((String)this.TAG, (String)("Current time: " + now + ", last CSDS update time: " + this.paramsCache.getLastCsdsUpdateTimestamp() + ", expire time: " + expireTime));
        if (!this.paramsCache.isCsdsFilled() || now > expireTime) {
            LPMobileLog.d((String)this.TAG, (String)"CSDS data does not exist or expired. Call CSDS");
            String csdsDomain = DomainBuilder.getCsdsDomain(context, this.brandId);
            new CSDSRequest(csdsDomain, this.brandId, new IMonitoringCallback<HashMap<String, String>, Exception>(this, request, callback){
                final /* synthetic */ MonitoringRequestManager this$0;
                final /* synthetic */ Command $request;
                final /* synthetic */ IMonitoringCallback $callback;

                public void onSuccess(@Nullable HashMap<String, String> csdsDomainMap) {
                    if (csdsDomainMap != null) {
                        LPMobileLog.i((String)MonitoringRequestManager.access$getTAG$p(this.this$0), (String)csdsDomainMap.toString());
                        this.this$0.getParamsCache().updateCsdsDomains(csdsDomainMap);
                        LPMobileLog.d((String)MonitoringRequestManager.access$getTAG$p(this.this$0), (String)"Calling the next request...");
                        this.$request.execute();
                    } else {
                        LPMobileLog.e((String)MonitoringRequestManager.access$getTAG$p(this.this$0), (String)"csdsDependantRequest: Received empty CSDS domain map");
                        MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(new Runnable(this){
                            final /* synthetic */ csdsDependantRequest.1 this$0;

                            public final void run() {
                                this.this$0.$callback.onError(MonitoringErrorType.CSDS_ERROR, null);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                }

                public void onError(@NotNull MonitoringErrorType errorType, @Nullable Exception e) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)errorType), (String)"errorType");
                    LPMobileLog.e((String)MonitoringRequestManager.access$getTAG$p(this.this$0), (Throwable)e);
                    MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(new Runnable(this, e){
                        final /* synthetic */ csdsDependantRequest.1 this$0;
                        final /* synthetic */ Exception $e;

                        public final void run() {
                            this.this$0.$callback.onError(MonitoringErrorType.CSDS_ERROR, (Throwable)this.$e);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$e = exception;
                        }
                    });
                }
                {
                    this.this$0 = $outer;
                    this.$request = $captured_local_variable$1;
                    this.$callback = $captured_local_variable$2;
                }
            }).execute();
        } else {
            LPMobileLog.d((String)this.TAG, (String)"CSDS data exist in cache. Proceed to request");
            request.execute();
        }
    }

    @Nullable
    public final String getBrandId() {
        return this.brandId;
    }

    @NotNull
    public final MonitoringParamsCache getParamsCache() {
        return this.paramsCache;
    }

    public MonitoringRequestManager(@Nullable String brandId, @NotNull MonitoringParamsCache paramsCache) {
        Intrinsics.checkParameterIsNotNull((Object)paramsCache, (String)"paramsCache");
        this.brandId = brandId;
        this.paramsCache = paramsCache;
        this.TAG = "MonitoringRequestManager";
        this.twentyFourHoursInMillis = 86400000;
    }

    public static final /* synthetic */ String access$getTAG$p(MonitoringRequestManager $this) {
        return $this.TAG;
    }
}

