/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.requests;

import android.content.Context;
import android.text.TextUtils;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.controller.DBEncryptionHelper;
import com.liveperson.infra.log.LPMobileLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.body.HttpRequestBody;
import com.liveperson.infra.network.http.body.LPJSONObjectBody;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.monitoring.Command;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.sdk.MonitoringParams;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\"\u0010-\u001a\u00020.2\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J\b\u0010/\u001a\u00020\u000bH\u0014J \u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u000e\u00104\u001a\n\u0018\u000105j\u0004\u0018\u0001`6H$J\b\u00107\u001a\u000201H\u0016J\u0012\u00108\u001a\u0002012\b\u00109\u001a\u0004\u0018\u00010\u000bH\u0004J\b\u0010:\u001a\u00020\u000bH\u0002J\u0014\u0010;\u001a\u0004\u0018\u00010\u000b2\b\u0010<\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010=\u001a\u00020>H$J\b\u0010?\u001a\u00020\u000bH$J \u0010@\u001a\u0002012\u000e\u00104\u001a\n\u0018\u000105j\u0004\u0018\u0001`62\u0006\u0010A\u001a\u00020>H\u0014J\u0010\u0010B\u001a\u0002012\u0006\u0010C\u001a\u00020\u000bH$R\u0014\u0010\n\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0014\u0010\u0010\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0014\u0010\u0012\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u000e\u0010\u0014\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u000e\u0010\u0017\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\rR\u000e\u0010 \u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0019\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\u0004\u0018\u00010)X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/liveperson/monitoring/requests/BaseMonitoringRequest;", "Lcom/liveperson/monitoring/Command;", "context", "Landroid/content/Context;", "identities", "", "Lcom/liveperson/monitoring/model/LPMonitoringIdentity;", "monitoringParams", "Lcom/liveperson/sdk/MonitoringParams;", "(Landroid/content/Context;Ljava/util/List;Lcom/liveperson/sdk/MonitoringParams;)V", "ACR", "", "getACR", "()Ljava/lang/String;", "DEFAULT_AUTH_ACR", "getDEFAULT_AUTH_ACR", "DEFAULT_UNAUTH_ACR", "getDEFAULT_UNAUTH_ACR", "ISSUER", "getISSUER", "KEY_CONSUMER_ID", "KEY_CONSUMER_ID_ENC", "getKEY_CONSUMER_ID_ENC", "KEY_ENGAGEMENT_ATTRIBUTES", "KEY_ENTRY_POINTS", "KEY_IDENTITIES", "NUM_OF_RETRIES", "", "getNUM_OF_RETRIES", "()I", "SUB", "getSUB", "TAG", "baseSessionVisitorString", "getContext", "()Landroid/content/Context;", "getIdentities", "()Ljava/util/List;", "getMonitoringParams", "()Lcom/liveperson/sdk/MonitoringParams;", "paramsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "getParamsCache", "()Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "retryCounter", "buildRequestBody", "Lorg/json/JSONObject;", "buildRequestUrl", "callErrorCallback", "", "monitoringErrorType", "Lcom/liveperson/monitoring/sdk/callbacks/MonitoringErrorType;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "execute", "extractAndSetVid", "message", "getIDPAnonymousUrl", "getOriginalConsumerId", "brandId", "getRequest", "Lcom/liveperson/infra/network/http/request/HttpRequest;", "getRequestUrl", "handleError", "httpRequest", "handleResponse", "response", "monitoring_release"})
public abstract class BaseMonitoringRequest
implements Command {
    private final String TAG = "BaseMonitoringRequest";
    private final int NUM_OF_RETRIES = 4;
    @NotNull
    private final String DEFAULT_AUTH_ACR = "loa1";
    @NotNull
    private final String DEFAULT_UNAUTH_ACR = "0";
    @NotNull
    private final String ISSUER = "iss";
    @NotNull
    private final String ACR = "acr";
    @NotNull
    private final String SUB = "sub";
    @NotNull
    private final String KEY_CONSUMER_ID_ENC = "account_original_consumer_id_enc";
    private final String KEY_CONSUMER_ID = "consumerId";
    private final String KEY_ENTRY_POINTS = "entryPoints";
    private final String KEY_ENGAGEMENT_ATTRIBUTES = "engagementAttributes";
    private final String KEY_IDENTITIES = "identities";
    private final String baseSessionVisitorString = "&vid=%s&sid=%s";
    @Nullable
    private final MonitoringParamsCache paramsCache;
    private int retryCounter;
    @NotNull
    private final Context context;
    @Nullable
    private final List<LPMonitoringIdentity> identities;
    @Nullable
    private final MonitoringParams monitoringParams;

    protected final int getNUM_OF_RETRIES() {
        return this.NUM_OF_RETRIES;
    }

    @NotNull
    public final String getDEFAULT_AUTH_ACR() {
        return this.DEFAULT_AUTH_ACR;
    }

    @NotNull
    public final String getDEFAULT_UNAUTH_ACR() {
        return this.DEFAULT_UNAUTH_ACR;
    }

    @NotNull
    public final String getISSUER() {
        return this.ISSUER;
    }

    @NotNull
    public final String getACR() {
        return this.ACR;
    }

    @NotNull
    public final String getSUB() {
        return this.SUB;
    }

    @NotNull
    public final String getKEY_CONSUMER_ID_ENC() {
        return this.KEY_CONSUMER_ID_ENC;
    }

    @Nullable
    protected final MonitoringParamsCache getParamsCache() {
        return this.paramsCache;
    }

    @NotNull
    protected abstract HttpRequest getRequest();

    protected abstract void handleResponse(@NotNull String var1);

    protected abstract void callErrorCallback(@NotNull MonitoringErrorType var1, @Nullable Exception var2);

    @NotNull
    protected abstract String getRequestUrl();

    @Override
    public void execute() {
        HttpRequest httpRequest = this.getRequest();
        JSONObject body = this.buildRequestBody(this.identities, this.monitoringParams);
        LPJSONObjectBody httpPostBody = new LPJSONObjectBody(body);
        httpRequest.setBody((HttpRequestBody)httpPostBody);
        LPMobileLog.d((String)this.TAG, (String)("Sending body: " + body.toString(4)));
        httpRequest.setCallback((ICallback)new ICallback<String, Exception>(this, httpRequest){
            final /* synthetic */ BaseMonitoringRequest this$0;
            final /* synthetic */ HttpRequest $httpRequest;

            public void onSuccess(@Nullable String value) {
                try {
                    JSONObject messageObject = new JSONObject(value);
                    LPMobileLog.d((String)BaseMonitoringRequest.access$getTAG$p(this.this$0), (String)("Response: " + messageObject.toString(4)));
                }
                catch (JSONException e) {
                    LPMobileLog.w((String)BaseMonitoringRequest.access$getTAG$p(this.this$0), (String)("Error parsing response: " + value));
                }
                if (value != null) {
                    this.this$0.handleResponse(value);
                }
            }

            public void onError(@Nullable Exception exception) {
                String message;
                Exception exception2 = exception;
                String string2 = message = exception2 != null ? exception2.getMessage() : null;
                if (message != null && StringsKt.contains$default((CharSequence)message, (CharSequence)"internalCode\":20", (boolean)false, (int)2, null)) {
                    this.this$0.extractAndSetVid(message);
                    this.$httpRequest.setUrl(this.this$0.buildRequestUrl());
                    LPMobileLog.d((String)BaseMonitoringRequest.access$getTAG$p(this.this$0), (String)"Account is not loaded yet. Retry...");
                } else {
                    LPMobileLog.w((String)"Request error.", (Throwable)exception);
                }
                this.this$0.handleError(exception, this.$httpRequest);
            }
            {
                this.this$0 = $outer;
                this.$httpRequest = $captured_local_variable$1;
            }
        });
        HttpHandler.execute((HttpRequest)httpRequest);
    }

    protected final void extractAndSetVid(@Nullable String message) {
        block0: {
            String mess;
            String string2 = message;
            String temp = string2 != null ? StringsKt.substringAfter$default((String)string2, (String)"body:", null, (int)2, null) : null;
            JSONObject jsonObject = new JSONObject(temp);
            String string3 = mess = jsonObject.getString("message");
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"mess");
            String vid = StringsKt.substringAfter$default((String)string3, (String)"vid: ", null, (int)2, null);
            MonitoringParamsCache monitoringParamsCache = this.paramsCache;
            if (monitoringParamsCache == null) break block0;
            monitoringParamsCache.setVisitorId(vid);
        }
    }

    protected void handleError(@Nullable Exception exception, @NotNull HttpRequest httpRequest) {
        Intrinsics.checkParameterIsNotNull((Object)httpRequest, (String)"httpRequest");
        if (this.retryCounter > this.NUM_OF_RETRIES) {
            LPMobileLog.d((String)this.TAG, (String)("Done with retries (retry number " + this.retryCounter + ")."));
            LPMobileLog.e((String)"Error:", (Throwable)exception);
            this.callErrorCallback(MonitoringErrorType.REQUEST_ERROR, exception);
            return;
        }
        int n = this.retryCounter;
        this.retryCounter = n + 1;
        LPMobileLog.d((String)this.TAG, (String)("Retry No. " + n));
        HttpHandler.executeDelayed((HttpRequest)httpRequest, (long)(this.retryCounter * 1000));
    }

    @NotNull
    protected String buildRequestUrl() {
        String requestUrlString;
        block3: {
            Object[] objectArray;
            String string2;
            StringCompanionObject stringCompanionObject;
            block2: {
                stringCompanionObject = StringCompanionObject.INSTANCE;
                string2 = this.getRequestUrl();
                Object[] objectArray2 = new Object[3];
                MonitoringParamsCache monitoringParamsCache = this.paramsCache;
                objectArray2[0] = monitoringParamsCache != null ? monitoringParamsCache.getSharkDomain() : null;
                MonitoringParamsCache monitoringParamsCache2 = this.paramsCache;
                objectArray2[1] = monitoringParamsCache2 != null ? monitoringParamsCache2.getBrandId() : null;
                MonitoringParamsCache monitoringParamsCache3 = this.paramsCache;
                objectArray2[2] = monitoringParamsCache3 != null ? monitoringParamsCache3.getAppInstallId() : null;
                objectArray = objectArray2;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
                requestUrlString = string3;
                MonitoringParamsCache monitoringParamsCache4 = this.paramsCache;
                if ((monitoringParamsCache4 != null ? monitoringParamsCache4.getSessionId() : null) != null) break block2;
                MonitoringParamsCache monitoringParamsCache5 = this.paramsCache;
                if ((monitoringParamsCache5 != null ? monitoringParamsCache5.getVisitorId() : null) == null) break block3;
            }
            LPMobileLog.d((String)this.TAG, (String)("SessionId and VisitorId exist. Add them as request params (SessionId=" + this.paramsCache.getSessionId() + ", VisitorId=" + this.paramsCache.getVisitorId() + ')'));
            stringCompanionObject = StringCompanionObject.INSTANCE;
            string2 = this.baseSessionVisitorString;
            objectArray = new Object[]{this.paramsCache.getVisitorId(), this.paramsCache.getSessionId()};
            StringBuilder stringBuilder = new StringBuilder().append(requestUrlString);
            String string4 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(format, *args)");
            String string5 = string4;
            requestUrlString = stringBuilder.append(string5).toString();
        }
        return requestUrlString;
    }

    @NotNull
    protected JSONObject buildRequestBody(@Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams) {
        JSONObject getEngagementBody;
        block7: {
            MonitoringParams monitoringParams2;
            MonitoringParams it;
            MonitoringParams monitoringParams3;
            getEngagementBody = new JSONObject();
            JSONArray identitiesBody = new JSONArray();
            List<LPMonitoringIdentity> list = identities;
            if (list != null) {
                Iterable $receiver$iv = list;
                for (Object element$iv : $receiver$iv) {
                    LPMonitoringIdentity it2 = (LPMonitoringIdentity)element$iv;
                    boolean bl = false;
                    JSONObject identity = new JSONObject();
                    if (!TextUtils.isEmpty((CharSequence)it2.getConsumerId())) {
                        if (!TextUtils.isEmpty((CharSequence)it2.getIssuer())) {
                            identity.put(this.ISSUER, (Object)it2.getIssuer());
                        }
                        identity.put(this.ACR, (Object)this.DEFAULT_AUTH_ACR);
                        identity.put(this.SUB, (Object)it2.getConsumerId());
                    } else {
                        identity.put(this.ACR, (Object)this.DEFAULT_UNAUTH_ACR);
                        MonitoringParamsCache monitoringParamsCache = this.paramsCache;
                        String brandId = monitoringParamsCache != null ? monitoringParamsCache.getBrandId() : null;
                        identity.put(this.ISSUER, (Object)this.getIDPAnonymousUrl());
                        String originalConsumerId = this.getOriginalConsumerId(brandId);
                        CharSequence charSequence = originalConsumerId;
                        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                            identity.put(this.SUB, (Object)originalConsumerId);
                        }
                    }
                    identitiesBody.put((Object)identity);
                }
            }
            getEngagementBody.put(this.KEY_IDENTITIES, (Object)identitiesBody);
            MonitoringParams monitoringParams4 = monitoringParams;
            if (monitoringParams4 != null && (monitoringParams4 = monitoringParams4.getEntryPoints()) != null) {
                it = monitoringParams3 = monitoringParams4;
                boolean bl = false;
                getEngagementBody.put(this.KEY_ENTRY_POINTS, (Object)it);
            }
            if ((monitoringParams2 = monitoringParams) == null || (monitoringParams2 = monitoringParams2.getEngagementAttributes()) == null) break block7;
            it = monitoringParams3 = monitoringParams2;
            boolean bl = false;
            getEngagementBody.put(this.KEY_ENGAGEMENT_ATTRIBUTES, (Object)it);
        }
        return getEngagementBody;
    }

    private final String getOriginalConsumerId(String brandId) {
        String decryptedConsumerId;
        String string2 = decryptedConsumerId = PreferenceManager.getInstance().getStringValue(this.KEY_CONSUMER_ID_ENC, brandId, null);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            return DBEncryptionHelper.decrypt((EncryptionVersion)EncryptionVersion.VERSION_1, (String)it);
        }
        return null;
    }

    private final String getIDPAnonymousUrl() {
        MonitoringParamsCache monitoringParamsCache = this.paramsCache;
        String idpDomain = monitoringParamsCache != null ? monitoringParamsCache.getIdpDomain() : null;
        return "https://" + idpDomain;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Nullable
    public final List<LPMonitoringIdentity> getIdentities() {
        return this.identities;
    }

    @Nullable
    public final MonitoringParams getMonitoringParams() {
        return this.monitoringParams;
    }

    public BaseMonitoringRequest(@NotNull Context context, @Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this.context = context;
        this.identities = identities;
        this.monitoringParams = monitoringParams;
        this.TAG = "BaseMonitoringRequest";
        this.NUM_OF_RETRIES = 4;
        this.DEFAULT_AUTH_ACR = "loa1";
        this.DEFAULT_UNAUTH_ACR = "0";
        this.ISSUER = "iss";
        this.ACR = "acr";
        this.SUB = "sub";
        this.KEY_CONSUMER_ID_ENC = "account_original_consumer_id_enc";
        this.KEY_CONSUMER_ID = "consumerId";
        this.KEY_ENTRY_POINTS = "entryPoints";
        this.KEY_ENGAGEMENT_ATTRIBUTES = "engagementAttributes";
        this.KEY_IDENTITIES = "identities";
        this.baseSessionVisitorString = "&vid=%s&sid=%s";
        this.paramsCache = MonitoringFactory.INSTANCE.getMonitoring().getParamsCache();
        this.retryCounter = 1;
    }

    public static final /* synthetic */ String access$getTAG$p(BaseMonitoringRequest $this) {
        return $this.TAG;
    }
}

