/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.requests;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.liveperson.infra.network.http.request.HttpPostRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.lp_monitoring_sdk.R;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.model.EngagementDetails;
import com.liveperson.monitoring.model.EngagementWithSession;
import com.liveperson.monitoring.model.LPMonitoringIdentity;
import com.liveperson.monitoring.requests.BaseMonitoringRequest;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.responses.LPEngagementResponse;
import com.liveperson.sdk.MonitoringParams;
import com.liveperson.sdk.callbacks.EngagementCallback;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0017\u001a\u00020\u0018H\u0002J\"\u0010\u0019\u001a\u00020\u00182\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0014J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0018\u00010\u001fj\u0004\u0018\u0001` H\u0014J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\rH\u0014J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020\rH\u0014R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006&"}, d2={"Lcom/liveperson/monitoring/requests/GetEngagementRequest;", "Lcom/liveperson/monitoring/requests/BaseMonitoringRequest;", "context", "Landroid/content/Context;", "identities", "", "Lcom/liveperson/monitoring/model/LPMonitoringIdentity;", "monitoringParams", "Lcom/liveperson/sdk/MonitoringParams;", "callback", "Lcom/liveperson/sdk/callbacks/EngagementCallback;", "(Landroid/content/Context;Ljava/util/List;Lcom/liveperson/sdk/MonitoringParams;Lcom/liveperson/sdk/callbacks/EngagementCallback;)V", "DEVICE_FAMILY_MOBILE", "", "KEY_APP_VERSION", "KEY_CLIENT_PROPERTIES", "KEY_DEVICE_FAMILY", "KEY_OS", "KEY_OS_VERSION", "OS_ANDROID", "TAG", "getCallback", "()Lcom/liveperson/sdk/callbacks/EngagementCallback;", "buildClientProperties", "Lorg/json/JSONObject;", "buildRequestBody", "callErrorCallback", "", "monitoringErrorType", "Lcom/liveperson/monitoring/sdk/callbacks/MonitoringErrorType;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getRequest", "Lcom/liveperson/infra/network/http/request/HttpRequest;", "getRequestUrl", "handleResponse", "response", "monitoring_release"})
public final class GetEngagementRequest
extends BaseMonitoringRequest {
    private final String TAG = "GetEngagementRequest";
    private final String OS_ANDROID = "ANDROID";
    private final String DEVICE_FAMILY_MOBILE = "MOBILE";
    private final String KEY_OS = "os";
    private final String KEY_OS_VERSION = "osVersion";
    private final String KEY_APP_VERSION = "appVersion";
    private final String KEY_DEVICE_FAMILY = "deviceFamily";
    private final String KEY_CLIENT_PROPERTIES = "clientProperties";
    @NotNull
    private final EngagementCallback callback;

    @Override
    @NotNull
    protected HttpRequest getRequest() {
        return (HttpRequest)new HttpPostRequest(this.buildRequestUrl());
    }

    @Override
    @NotNull
    protected String getRequestUrl() {
        String string2 = this.getContext().getResources().getString(R.string.get_engagement_url);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.resources.getStr\u2026tring.get_engagement_url)");
        return string2;
    }

    @Override
    protected void handleResponse(@NotNull String response) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        EngagementWithSession engagementWithSession = EngagementWithSession.Companion.invoke(response);
        Object it = object = engagementWithSession;
        boolean bl = false;
        MonitoringParamsCache monitoringParamsCache = this.getParamsCache();
        if (monitoringParamsCache != null) {
            EngagementWithSession engagementWithSession2 = it;
            monitoringParamsCache.setSessionId(engagementWithSession2 != null ? engagementWithSession2.getSessionId() : null);
        }
        it = object = engagementWithSession;
        boolean bl2 = false;
        MonitoringParamsCache monitoringParamsCache2 = this.getParamsCache();
        if (monitoringParamsCache2 != null) {
            EngagementWithSession engagementWithSession3 = it;
            monitoringParamsCache2.setVisitorId(engagementWithSession3 != null ? engagementWithSession3.getVisitorId() : null);
        }
        try {
            List<EngagementDetails> list = engagementWithSession.getEngagementDetailsList();
            if (list == null) {
                Intrinsics.throwNpe();
            }
            object = list.get(0);
            it = (EngagementDetails)object;
            boolean bl3 = false;
            MonitoringParamsCache monitoringParamsCache3 = this.getParamsCache();
            if (monitoringParamsCache3 != null) {
                Object object2 = it;
                if (object2 == null) {
                    Intrinsics.throwNpe();
                }
                monitoringParamsCache3.setConnectorId(((EngagementDetails)object2).getConnectorId());
            }
        }
        catch (NullPointerException e) {
            this.callErrorCallback(MonitoringErrorType.PARAMETER_MISSING, new IllegalArgumentException("No connecterid because EngagementDetails is null"));
            return;
        }
        MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(new Runnable(this, engagementWithSession){
            final /* synthetic */ GetEngagementRequest this$0;
            final /* synthetic */ EngagementWithSession $engagementWithSession;

            public final void run() {
                this.this$0.getCallback().onSuccess(new LPEngagementResponse(this.$engagementWithSession));
            }
            {
                this.this$0 = getEngagementRequest;
                this.$engagementWithSession = engagementWithSession;
            }
        });
    }

    @Override
    protected void callErrorCallback(@NotNull MonitoringErrorType monitoringErrorType, @Nullable Exception exception) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)monitoringErrorType), (String)"monitoringErrorType");
        MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(new Runnable(this, monitoringErrorType, exception){
            final /* synthetic */ GetEngagementRequest this$0;
            final /* synthetic */ MonitoringErrorType $monitoringErrorType;
            final /* synthetic */ Exception $exception;

            public final void run() {
                this.this$0.getCallback().onError(this.$monitoringErrorType, this.$exception);
            }
            {
                this.this$0 = getEngagementRequest;
                this.$monitoringErrorType = monitoringErrorType;
                this.$exception = exception;
            }
        });
    }

    @Override
    @NotNull
    protected JSONObject buildRequestBody(@Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams) {
        JSONObject getEngagementBody = super.buildRequestBody(identities, monitoringParams);
        getEngagementBody.put(this.KEY_CLIENT_PROPERTIES, (Object)this.buildClientProperties());
        return getEngagementBody;
    }

    private final JSONObject buildClientProperties() {
        String string2;
        JSONObject clientProperties = new JSONObject();
        clientProperties.put(this.KEY_OS, (Object)this.OS_ANDROID);
        clientProperties.put(this.KEY_OS_VERSION, (Object)Build.VERSION.RELEASE);
        try {
            PackageInfo pInfo = this.getContext().getPackageManager().getPackageInfo(this.getContext().getPackageName(), 0);
            string2 = pInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            string2 = "Unavailable";
        }
        String version = string2;
        clientProperties.put(this.KEY_APP_VERSION, (Object)version);
        clientProperties.put(this.KEY_DEVICE_FAMILY, (Object)this.DEVICE_FAMILY_MOBILE);
        return clientProperties;
    }

    @NotNull
    public final EngagementCallback getCallback() {
        return this.callback;
    }

    public GetEngagementRequest(@NotNull Context context, @Nullable List<LPMonitoringIdentity> identities, @Nullable MonitoringParams monitoringParams, @NotNull EngagementCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        super(context, identities, monitoringParams);
        this.callback = callback;
        this.TAG = "GetEngagementRequest";
        this.OS_ANDROID = "ANDROID";
        this.DEVICE_FAMILY_MOBILE = "MOBILE";
        this.KEY_OS = "os";
        this.KEY_OS_VERSION = "osVersion";
        this.KEY_APP_VERSION = "appVersion";
        this.KEY_DEVICE_FAMILY = "deviceFamily";
        this.KEY_CLIENT_PROPERTIES = "clientProperties";
    }
}

