/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.monitoring.managers;

import android.content.Context;
import com.liveperson.infra.log.LPLog;
import com.liveperson.monitoring.Command;
import com.liveperson.monitoring.MonitoringFactory;
import com.liveperson.monitoring.cache.MonitoringParamsCache;
import com.liveperson.monitoring.managers.MonitoringRequestManager;
import com.liveperson.monitoring.requests.CSDSRequest;
import com.liveperson.monitoring.sdk.callbacks.IMonitoringCallback;
import com.liveperson.monitoring.sdk.callbacks.MonitoringErrorType;
import com.liveperson.monitoring.sdk.responses.LPSdeResponse;
import com.liveperson.monitoring.utils.DomainBuilder;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J0\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0018\u0010\u0011\u001a\u0014\u0012\u0006\b\u0001\u0012\u00020\u0013\u0012\b\u0012\u00060\u0014j\u0002`\u00150\u0012R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/liveperson/monitoring/managers/MonitoringRequestManager;", "", "brandId", "", "paramsCache", "Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "(Ljava/lang/String;Lcom/liveperson/monitoring/cache/MonitoringParamsCache;)V", "getBrandId", "()Ljava/lang/String;", "getParamsCache", "()Lcom/liveperson/monitoring/cache/MonitoringParamsCache;", "csdsDependantRequest", "", "context", "Landroid/content/Context;", "request", "Lcom/liveperson/monitoring/Command;", "callback", "Lcom/liveperson/monitoring/sdk/callbacks/IMonitoringCallback;", "Lcom/liveperson/monitoring/sdk/responses/LPSdeResponse;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Companion", "monitoring_release"})
public final class MonitoringRequestManager {
    @Nullable
    private final String brandId;
    @NotNull
    private final MonitoringParamsCache paramsCache;
    private static final String TAG = "MonitoringRequestManager";
    public static final int TIME_24H_IN_MILLIS = 86400000;
    public static final Companion Companion = new Companion(null);

    public final void csdsDependantRequest(@NotNull Context context, @NotNull Command request, @NotNull IMonitoringCallback<? extends LPSdeResponse, Exception> callback) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        long now = System.currentTimeMillis();
        long expireTime = this.paramsCache.getLastCsdsUpdateTimestamp() + (long)86400000;
        LPLog.INSTANCE.d(TAG, "Current time: " + now + ", last CSDS update time: " + this.paramsCache.getLastCsdsUpdateTimestamp() + ", expire time: " + expireTime);
        if (!this.paramsCache.isCsdsFilled() || now > expireTime) {
            LPLog.INSTANCE.d(TAG, "CSDS data does not exist or expired. Call CSDS");
            String csdsDomain = DomainBuilder.getCsdsDomain(context, this.brandId);
            new CSDSRequest(csdsDomain, this.brandId, new IMonitoringCallback<HashMap<String, String>, Exception>(this, request, callback){
                final /* synthetic */ MonitoringRequestManager this$0;
                final /* synthetic */ Command $request;
                final /* synthetic */ IMonitoringCallback $callback;

                public void onSuccess(@Nullable HashMap<String, String> csdsDomainMap) {
                    if (csdsDomainMap != null) {
                        String string2 = csdsDomainMap.toString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"csdsDomainMap.toString()");
                        LPLog.INSTANCE.i("MonitoringRequestManager", string2);
                        this.this$0.getParamsCache().updateCsdsDomains(csdsDomainMap);
                        LPLog.INSTANCE.d("MonitoringRequestManager", "Calling the next request...");
                        this.$request.execute();
                    } else {
                        LPLog.INSTANCE.e("MonitoringRequestManager", "csdsDependantRequest: Received empty CSDS domain map");
                        MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(new Runnable(this){
                            final /* synthetic */ csdsDependantRequest.1 this$0;

                            public final void run() {
                                this.this$0.$callback.onError(MonitoringErrorType.CSDS_ERROR, null);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                }

                public void onError(@NotNull MonitoringErrorType errorType, @Nullable Exception e) {
                    Intrinsics.checkParameterIsNotNull((Object)((Object)errorType), (String)"errorType");
                    if (e != null) {
                        LPLog.INSTANCE.e("MonitoringRequestManager", "onError: " + (Object)((Object)errorType), (Throwable)e);
                    }
                    MonitoringFactory.INSTANCE.getMonitoring().postOnMainThread(new Runnable(this, e){
                        final /* synthetic */ csdsDependantRequest.1 this$0;
                        final /* synthetic */ Exception $e;

                        public final void run() {
                            this.this$0.$callback.onError(MonitoringErrorType.CSDS_ERROR, (Throwable)this.$e);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$e = exception;
                        }
                    });
                }
                {
                    this.this$0 = $outer;
                    this.$request = $captured_local_variable$1;
                    this.$callback = $captured_local_variable$2;
                }
            }).execute();
        } else {
            LPLog.INSTANCE.d(TAG, "CSDS data exist in cache. Proceed to request");
            request.execute();
        }
    }

    @Nullable
    public final String getBrandId() {
        return this.brandId;
    }

    @NotNull
    public final MonitoringParamsCache getParamsCache() {
        return this.paramsCache;
    }

    public MonitoringRequestManager(@Nullable String brandId, @NotNull MonitoringParamsCache paramsCache) {
        Intrinsics.checkParameterIsNotNull((Object)paramsCache, (String)"paramsCache");
        this.brandId = brandId;
        this.paramsCache = paramsCache;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/liveperson/monitoring/managers/MonitoringRequestManager$Companion;", "", "()V", "TAG", "", "TIME_24H_IN_MILLIS", "", "monitoring_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

